/*
 * Decompiled with CFR 0.152.
 */
package one.stayfocused.spring.dotenv.core;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import one.stayfocused.spring.dotenv.core.DotenvParser;
import one.stayfocused.spring.dotenv.core.DotenvUtils;
import one.stayfocused.spring.dotenv.core.EnvParser;
import one.stayfocused.spring.dotenv.exception.DotenvFileNotFoundException;
import one.stayfocused.spring.dotenv.exception.DotenvParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class DotenvLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DotenvLoader.class);

    private DotenvLoader() {
        throw new UnsupportedOperationException("DotenvLoader is a utility class and cannot be instantiated.");
    }

    public static Map<String, String> load(Environment environment) {
        return DotenvLoader.load(environment, new DotenvParser());
    }

    public static Map<String, String> load(Environment environment, EnvParser parser) {
        String dotenvPath = DotenvUtils.getDotenvPath(environment);
        boolean failOnMissing = DotenvUtils.isFailOnMissing(environment);
        return DotenvLoader.loadFromPath(dotenvPath, failOnMissing, parser);
    }

    private static Map<String, String> loadFromPath(String path, boolean failOnMissing, EnvParser parser) {
        Path envPath = Paths.get(path, new String[0]);
        if (!Files.exists(envPath, new LinkOption[0])) {
            log.warn("[Dotenv] .env file not found at: {}", (Object)envPath);
            if (failOnMissing) {
                throw new DotenvFileNotFoundException(path);
            }
            return Collections.emptyMap();
        }
        try {
            List<String> lines = Files.readAllLines(envPath);
            Map<String, String> envVariables = parser.parse(lines);
            log.debug("[Dotenv] Successfully loaded {} variables from {}", (Object)envVariables.size(), (Object)envPath);
            return envVariables;
        }
        catch (IOException e) {
            log.error("[Dotenv] Failed to read .env file from {}: {}", (Object)envPath, (Object)e.getMessage());
            throw new DotenvParseException("Failed to read .env file from " + String.valueOf(envPath), e);
        }
    }
}

