/*
 * Decompiled with CFR 0.152.
 */
package one.stayfocused.spring.dotenv.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import one.stayfocused.spring.dotenv.core.EnvParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DotenvParser
implements EnvParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DotenvParser.class);

    @Override
    public Map<String, String> parse(List<String> lines) {
        HashMap<String, String> envVariables = new HashMap<String, String>();
        for (String line : lines) {
            this.parseLine(line, envVariables);
        }
        return envVariables;
    }

    private void parseLine(String line, Map<String, String> envVariables) {
        if (line.isBlank() || line.startsWith("#")) {
            return;
        }
        String[] parts = line.split("=", 2);
        if (parts.length != 2) {
            return;
        }
        String key = parts[0].trim();
        String value = parts[1].trim();
        if (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
            value = value.substring(1, value.length() - 1);
        }
        envVariables.put(key, value);
        log.debug("[Dotenv] Loaded variable: {}=***", (Object)key);
    }
}

