/*
 * Decompiled with CFR 0.152.
 */
package one.stayfocused.spring.dotenv.core;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public final class DotenvUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DotenvUtils.class);
    public static final String PROPERTY_SOURCE_NAME = "dotenv";
    public static final String DOTENV_PATH_KEY = "dotenv.path";
    public static final String DOTENV_ENABLED_KEY = "dotenv.enabled";
    public static final String DOTENV_FAIL_ON_MISSING_KEY = "dotenv.fail-on-missing";
    public static final String DOTENV_PRIORITY_KEY = "dotenv.priority";
    public static final String DEFAULT_DOTENV_PRIORITY = "low";
    public static final boolean DEFAULT_DOTENV_ENABLED = true;
    public static final boolean DEFAULT_FAIL_ON_MISSING = false;
    public static final String DEFAULT_ENV_PATH = ".env";

    private DotenvUtils() {
        throw new UnsupportedOperationException("DotenvUtils is a utility class and cannot be instantiated.");
    }

    public static String getDotenvPath(Environment environment) {
        return DotenvUtils.getStringProperty(environment, DOTENV_PATH_KEY, DEFAULT_ENV_PATH);
    }

    public static boolean getBooleanProperty(Environment environment, String propertyName, boolean defaultValue) {
        return Boolean.parseBoolean(environment.getProperty(propertyName, String.valueOf(defaultValue)));
    }

    public static String getStringProperty(Environment environment, String propertyName, String defaultValue) {
        return environment.getProperty(propertyName, defaultValue);
    }

    public static boolean isHighPriority(Environment environment) {
        return "high".equals(DotenvUtils.getStringProperty(environment, DOTENV_PRIORITY_KEY, DEFAULT_DOTENV_PRIORITY));
    }

    public static boolean isFailOnMissing(Environment environment) {
        return DotenvUtils.getBooleanProperty(environment, DOTENV_FAIL_ON_MISSING_KEY, false);
    }

    public static boolean isEnable(Environment environment) {
        return DotenvUtils.getBooleanProperty(environment, DOTENV_ENABLED_KEY, true);
    }
}

