/*
 * Decompiled with CFR 0.152.
 */
package one.stayfocused.spring.dotenv.environment;

import java.util.HashMap;
import lombok.Generated;
import one.stayfocused.spring.dotenv.core.DotenvLoader;
import one.stayfocused.spring.dotenv.core.DotenvUtils;
import one.stayfocused.spring.dotenv.environment.DotenvPropertySource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public class DotenvEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DotenvEnvironmentPostProcessor.class);

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (!DotenvUtils.isEnable((Environment)environment)) {
            return;
        }
        HashMap<String, String> envVariableMap = new HashMap<String, String>(DotenvLoader.load((Environment)environment));
        DotenvPropertySource newPropertySource = new DotenvPropertySource("dotenv", envVariableMap);
        if (DotenvUtils.isHighPriority((Environment)environment)) {
            environment.getPropertySources().addFirst((PropertySource)newPropertySource);
        } else {
            environment.getPropertySources().addLast((PropertySource)newPropertySource);
        }
    }

    static {
        String BLUE = "\u001b[34m";
        String RESET = "\u001b[0m";
        System.out.println("\n\u001b[34mstayfocused.one\u001b[0m :: Dotenv for Spring Boot (v1.0.0)\n");
    }
}

