/*
 * Decompiled with CFR 0.152.
 */
package one.util.huntbugs.ant;

import com.strobel.assembler.metadata.ClasspathTypeLoader;
import com.strobel.assembler.metadata.CompositeTypeLoader;
import com.strobel.assembler.metadata.ITypeLoader;
import com.strobel.assembler.metadata.JarTypeLoader;
import com.strobel.assembler.metadata.signatures.Reifier;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import one.util.huntbugs.analysis.AnalysisOptions;
import one.util.huntbugs.analysis.Context;
import one.util.huntbugs.analysis.HuntBugsResult;
import one.util.huntbugs.input.XmlReportReader;
import one.util.huntbugs.output.Reports;
import one.util.huntbugs.repo.AuxRepository;
import one.util.huntbugs.repo.CompositeRepository;
import one.util.huntbugs.repo.DirRepository;
import one.util.huntbugs.repo.JarRepository;
import one.util.huntbugs.repo.Repository;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.xml.sax.SAXException;

public class HuntBugsTask
extends Task {
    private Path classPath;
    private Path auxClassPath;
    private File xml;
    private File html;
    private File diff;
    private LogLevel log = LogLevel.VERBOSE;

    public void execute() throws BuildException {
        Logger.getLogger(Reifier.class.getSimpleName()).setLevel(Level.OFF);
        List<Repository> repos = this.createRepository();
        if (this.xml == null && this.html == null) {
            throw new BuildException("Either xml or html must be specified");
        }
        CompositeRepository repo = new CompositeRepository(repos);
        AnalysisOptions opt = new AnalysisOptions();
        Context ctx = new Context((Repository)repo, opt);
        if (this.log == LogLevel.VERBOSE) {
            this.addListener(ctx);
        }
        ctx.analyzePackage("");
        Context result = ctx;
        if (this.diff != null) {
            try {
                result = Reports.diff((HuntBugsResult)XmlReportReader.read((Context)ctx, (java.nio.file.Path)this.diff.toPath()), (HuntBugsResult)ctx);
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                System.err.println("Unable to read old report " + this.diff + ": " + e);
                System.err.println("Skipping diff generation");
            }
        }
        Reports.write((java.nio.file.Path)(this.xml == null ? null : this.xml.toPath()), (java.nio.file.Path)(this.html == null ? null : this.html.toPath()), (HuntBugsResult)result);
    }

    private void addListener(Context ctx) {
        long[] lastPrint = new long[]{0L};
        ctx.addListener((stepName, className, count, total) -> {
            if (count == total || System.currentTimeMillis() - lastPrint[0] > 2000L) {
                System.err.println("HuntBugs: " + stepName + " [" + count + "/" + total + "]");
                lArray[0] = System.currentTimeMillis();
            }
            return true;
        });
    }

    private List<Repository> createRepository() {
        if (this.classPath == null || this.classPath.size() == 0) {
            throw new BuildException("Please specify classPath!");
        }
        ArrayList<Repository> repos = new ArrayList<Repository>();
        for (String path : this.classPath.list()) {
            File file = new File(path);
            if (file.isDirectory()) {
                repos.add((Repository)new DirRepository(file.toPath()));
                continue;
            }
            if (file.isFile()) {
                try {
                    repos.add((Repository)new JarRepository(new JarFile(file)));
                    continue;
                }
                catch (IOException e) {
                    throw new BuildException((Throwable)e);
                }
            }
            throw new BuildException("Class path element not found: " + path);
        }
        if (this.auxClassPath != null) {
            ArrayList<Object> auxLoaders = new ArrayList<Object>();
            for (String path : this.auxClassPath.list()) {
                File file = new File(path);
                if (file.isDirectory()) {
                    auxLoaders.add(new ClasspathTypeLoader(file.toString()));
                    continue;
                }
                if (file.isFile()) {
                    try {
                        auxLoaders.add(new JarTypeLoader(new JarFile(file)));
                        continue;
                    }
                    catch (IOException e) {
                        throw new BuildException((Throwable)e);
                    }
                }
                throw new BuildException("Aux class path element not found: " + path);
            }
            if (!auxLoaders.isEmpty()) {
                repos.add((Repository)new AuxRepository((ITypeLoader)new CompositeTypeLoader(auxLoaders.toArray(new ITypeLoader[0]))));
            }
        }
        return repos;
    }

    public void setClassPath(Path classPath) {
        if (this.classPath == null) {
            this.classPath = new Path(this.getProject());
        }
        this.classPath.append(classPath);
    }

    public void setAuxClassPath(Path auxClassPath) {
        if (this.auxClassPath == null) {
            this.auxClassPath = new Path(this.getProject());
        }
        this.auxClassPath.append(auxClassPath);
    }

    public void setDiff(File diff) {
        this.diff = diff;
    }

    public void setXml(File xml) {
        this.xml = xml;
    }

    public void setHtml(File html) {
        this.html = html;
    }

    public void setLog(LogLevel log) {
        this.log = log;
    }

    public static enum LogLevel {
        QUIET,
        VERBOSE;

    }
}

