/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.DoubleSummaryStatistics;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Random;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ForkJoinPool;
import java.util.function.BiConsumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import one.util.streamex.ConstSpliterator;
import one.util.streamex.DoubleCollector;
import one.util.streamex.EntryStream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.LongStreamEx;
import one.util.streamex.PairSpliterator;
import one.util.streamex.RangeBasedSpliterator;
import one.util.streamex.StreamEx;
import one.util.streamex.StreamExInternals;
import one.util.streamex.StreamFactory;

public class DoubleStreamEx
implements DoubleStream {
    final DoubleStream stream;

    DoubleStreamEx(DoubleStream stream) {
        this.stream = stream;
    }

    StreamFactory strategy() {
        return StreamFactory.DEFAULT;
    }

    final DoubleStreamEx delegate(Spliterator.OfDouble spliterator) {
        return this.strategy().newDoubleStreamEx((DoubleStream)StreamSupport.doubleStream(spliterator, this.stream.isParallel()).onClose(this.stream::close));
    }

    final DoubleStreamEx callWhile(DoublePredicate predicate, int methodId) {
        try {
            return this.strategy().newDoubleStreamEx(StreamExInternals.JDK9_METHODS[3][methodId].invokeExact(this.stream, predicate));
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InternalError(e);
        }
    }

    @Override
    public boolean isParallel() {
        return this.stream.isParallel();
    }

    @Override
    public DoubleStreamEx unordered() {
        return this.strategy().newDoubleStreamEx((DoubleStream)this.stream.unordered());
    }

    @Override
    public DoubleStreamEx onClose(Runnable closeHandler) {
        return this.strategy().newDoubleStreamEx((DoubleStream)this.stream.onClose(closeHandler));
    }

    @Override
    public void close() {
        this.stream.close();
    }

    @Override
    public DoubleStreamEx filter(DoublePredicate predicate) {
        return this.strategy().newDoubleStreamEx(this.stream.filter(predicate));
    }

    public DoubleStreamEx remove(DoublePredicate predicate) {
        return this.filter(predicate.negate());
    }

    public DoubleStreamEx greater(double value) {
        return this.filter(val -> val > value);
    }

    public DoubleStreamEx less(double value) {
        return this.filter(val -> val < value);
    }

    public DoubleStreamEx atLeast(double value) {
        return this.filter(val -> val >= value);
    }

    public DoubleStreamEx atMost(double value) {
        return this.filter(val -> val <= value);
    }

    @Override
    public DoubleStreamEx map(DoubleUnaryOperator mapper) {
        return this.strategy().newDoubleStreamEx(this.stream.map(mapper));
    }

    public DoubleStreamEx mapFirst(DoubleUnaryOperator mapper) {
        return ((StreamEx)this.boxed()).mapFirst(mapper::applyAsDouble).mapToDouble(Double::doubleValue);
    }

    public DoubleStreamEx mapLast(DoubleUnaryOperator mapper) {
        return ((StreamEx)this.boxed()).mapLast(mapper::applyAsDouble).mapToDouble(Double::doubleValue);
    }

    public <U> StreamEx<U> mapToObj(DoubleFunction<? extends U> mapper) {
        return this.strategy().newStreamEx(this.stream.mapToObj(mapper));
    }

    @Override
    public IntStreamEx mapToInt(DoubleToIntFunction mapper) {
        return this.strategy().newIntStreamEx(this.stream.mapToInt(mapper));
    }

    @Override
    public LongStreamEx mapToLong(DoubleToLongFunction mapper) {
        return this.strategy().newLongStreamEx(this.stream.mapToLong(mapper));
    }

    public <K, V> EntryStream<K, V> mapToEntry(DoubleFunction<? extends K> keyMapper, DoubleFunction<? extends V> valueMapper) {
        return this.strategy().newEntryStream(this.stream.mapToObj((double t) -> new AbstractMap.SimpleImmutableEntry(keyMapper.apply(t), valueMapper.apply(t))));
    }

    @Override
    public DoubleStreamEx flatMap(DoubleFunction<? extends DoubleStream> mapper) {
        return this.strategy().newDoubleStreamEx(this.stream.flatMap(mapper));
    }

    public IntStreamEx flatMapToInt(DoubleFunction<? extends IntStream> mapper) {
        return this.strategy().newIntStreamEx(this.stream.mapToObj(mapper).flatMapToInt(Function.identity()));
    }

    public LongStreamEx flatMapToLong(DoubleFunction<? extends LongStream> mapper) {
        return this.strategy().newLongStreamEx(this.stream.mapToObj(mapper).flatMapToLong(Function.identity()));
    }

    public <R> StreamEx<R> flatMapToObj(DoubleFunction<? extends Stream<R>> mapper) {
        return this.strategy().newStreamEx(this.stream.mapToObj(mapper).flatMap(Function.identity()));
    }

    @Override
    public DoubleStreamEx distinct() {
        return this.strategy().newDoubleStreamEx(this.stream.distinct());
    }

    @Override
    public DoubleStreamEx sorted() {
        return this.strategy().newDoubleStreamEx(this.stream.sorted());
    }

    public DoubleStreamEx sorted(Comparator<Double> comparator) {
        return this.strategy().newDoubleStreamEx(this.stream.boxed().sorted(comparator).mapToDouble(Double::doubleValue));
    }

    public DoubleStreamEx reverseSorted() {
        return this.sorted(Comparator.reverseOrder());
    }

    public <V extends Comparable<? super V>> DoubleStreamEx sortedBy(DoubleFunction<V> keyExtractor) {
        return this.sorted(Comparator.comparing(i -> (Comparable)keyExtractor.apply((double)i)));
    }

    public DoubleStreamEx sortedByInt(DoubleToIntFunction keyExtractor) {
        return this.sorted(Comparator.comparingInt(i -> keyExtractor.applyAsInt((double)i)));
    }

    public DoubleStreamEx sortedByLong(DoubleToLongFunction keyExtractor) {
        return this.sorted(Comparator.comparingLong(i -> keyExtractor.applyAsLong((double)i)));
    }

    public DoubleStreamEx sortedByDouble(DoubleUnaryOperator keyExtractor) {
        return this.sorted(Comparator.comparingDouble(i -> keyExtractor.applyAsDouble((double)i)));
    }

    @Override
    public DoubleStreamEx peek(DoubleConsumer action) {
        return this.strategy().newDoubleStreamEx(this.stream.peek(action));
    }

    @Override
    public DoubleStreamEx limit(long maxSize) {
        return this.strategy().newDoubleStreamEx(this.stream.limit(maxSize));
    }

    @Override
    public DoubleStreamEx skip(long n) {
        return this.strategy().newDoubleStreamEx(this.stream.skip(n));
    }

    public DoubleStreamEx skipOrdered(long n) {
        Spliterator.OfDouble spliterator = (this.stream.isParallel() ? StreamSupport.doubleStream(this.stream.spliterator(), false) : this.stream).skip(n).spliterator();
        return this.delegate(spliterator);
    }

    @Override
    public void forEach(DoubleConsumer action) {
        this.stream.forEach(action);
    }

    @Override
    public void forEachOrdered(DoubleConsumer action) {
        this.stream.forEachOrdered(action);
    }

    @Override
    public double[] toArray() {
        return this.stream.toArray();
    }

    public float[] toFloatArray() {
        StreamExInternals.FloatBuffer buf;
        if (this.isParallel()) {
            return this.collect(DoubleCollector.toFloatArray());
        }
        Spliterator.OfDouble spliterator = this.stream.spliterator();
        long size = spliterator.getExactSizeIfKnown();
        if (size >= 0L && size <= Integer.MAX_VALUE) {
            buf = new StreamExInternals.FloatBuffer((int)size);
            spliterator.forEachRemaining(buf::addUnsafe);
        } else {
            buf = new StreamExInternals.FloatBuffer();
            spliterator.forEachRemaining(buf::add);
        }
        return buf.toArray();
    }

    @Override
    public double reduce(double identity, DoubleBinaryOperator op) {
        return this.stream.reduce(identity, op);
    }

    @Override
    public OptionalDouble reduce(DoubleBinaryOperator op) {
        return this.stream.reduce(op);
    }

    public double foldLeft(double identity, DoubleBinaryOperator accumulator) {
        double[] box = new double[]{identity};
        this.stream.forEachOrdered(t -> {
            dArray[0] = accumulator.applyAsDouble(box[0], t);
        });
        return box[0];
    }

    public OptionalDouble foldLeft(DoubleBinaryOperator accumulator) {
        StreamExInternals.PrimitiveBox b = new StreamExInternals.PrimitiveBox();
        this.stream.forEachOrdered(t -> {
            if (primitiveBox.b) {
                primitiveBox.d = accumulator.applyAsDouble(primitiveBox.d, t);
            } else {
                primitiveBox.d = t;
                primitiveBox.b = true;
            }
        });
        return b.asDouble();
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjDoubleConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        return this.stream.collect(supplier, accumulator, combiner);
    }

    public <A, R> R collect(DoubleCollector<A, R> collector) {
        if (collector.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            return (R)this.collect(collector.supplier(), collector.doubleAccumulator(), collector.merger());
        }
        return collector.finisher().apply(this.collect(collector.supplier(), collector.doubleAccumulator(), collector.merger()));
    }

    @Override
    public double sum() {
        return this.stream.sum();
    }

    @Override
    public OptionalDouble min() {
        return this.reduce(Math::min);
    }

    public OptionalDouble min(Comparator<Double> comparator) {
        return this.reduce((a, b) -> comparator.compare(a, b) > 0 ? b : a);
    }

    public <V extends Comparable<? super V>> OptionalDouble minBy(DoubleFunction<V> keyExtractor) {
        StreamExInternals.ObjDoubleBox result = this.collect(() -> new StreamExInternals.ObjDoubleBox<Object>(null, 0.0), (box, i) -> {
            Comparable val = (Comparable)Objects.requireNonNull(keyExtractor.apply(i));
            if (box.a == null || ((Comparable)box.a).compareTo(val) > 0) {
                box.a = val;
                box.b = i;
            }
        }, (box1, box2) -> {
            if (box2.a != null && (box1.a == null || ((Comparable)box1.a).compareTo(box2.a) > 0)) {
                box1.a = box2.a;
                box1.b = box2.b;
            }
        });
        return result.a == null ? OptionalDouble.empty() : OptionalDouble.of(result.b);
    }

    public OptionalDouble minByInt(DoubleToIntFunction keyExtractor) {
        return this.collect(StreamExInternals.PrimitiveBox::new, (box, d) -> {
            int key = keyExtractor.applyAsInt(d);
            if (!box.b || box.i > key) {
                box.b = true;
                box.i = key;
                box.d = d;
            }
        }, StreamExInternals.PrimitiveBox.MIN_INT).asDouble();
    }

    public OptionalDouble minByLong(DoubleToLongFunction keyExtractor) {
        return this.collect(StreamExInternals.PrimitiveBox::new, (box, d) -> {
            long key = keyExtractor.applyAsLong(d);
            if (!box.b || box.l > key) {
                box.b = true;
                box.l = key;
                box.d = d;
            }
        }, StreamExInternals.PrimitiveBox.MIN_LONG).asDouble();
    }

    public OptionalDouble minByDouble(DoubleUnaryOperator keyExtractor) {
        double[] result = this.collect(() -> new double[3], (acc, d) -> {
            double key = keyExtractor.applyAsDouble(d);
            if (acc[2] == 0.0 || Double.compare(acc[1], key) > 0) {
                acc[0] = d;
                acc[1] = key;
                acc[2] = 1.0;
            }
        }, (acc1, acc2) -> {
            if (acc2[2] == 1.0 && (acc1[2] == 0.0 || Double.compare(acc1[1], acc2[1]) > 0)) {
                System.arraycopy(acc2, 0, acc1, 0, 3);
            }
        });
        return result[2] == 1.0 ? OptionalDouble.of(result[0]) : OptionalDouble.empty();
    }

    @Override
    public OptionalDouble max() {
        return this.reduce(Math::max);
    }

    public OptionalDouble max(Comparator<Double> comparator) {
        return this.reduce((a, b) -> comparator.compare(a, b) >= 0 ? a : b);
    }

    public <V extends Comparable<? super V>> OptionalDouble maxBy(DoubleFunction<V> keyExtractor) {
        StreamExInternals.ObjDoubleBox result = this.collect(() -> new StreamExInternals.ObjDoubleBox<Object>(null, 0.0), (box, i) -> {
            Comparable val = (Comparable)Objects.requireNonNull(keyExtractor.apply(i));
            if (box.a == null || ((Comparable)box.a).compareTo(val) < 0) {
                box.a = val;
                box.b = i;
            }
        }, (box1, box2) -> {
            if (box2.a != null && (box1.a == null || ((Comparable)box1.a).compareTo(box2.a) < 0)) {
                box1.a = box2.a;
                box1.b = box2.b;
            }
        });
        return result.a == null ? OptionalDouble.empty() : OptionalDouble.of(result.b);
    }

    public OptionalDouble maxByInt(DoubleToIntFunction keyExtractor) {
        return this.collect(StreamExInternals.PrimitiveBox::new, (box, d) -> {
            int key = keyExtractor.applyAsInt(d);
            if (!box.b || box.i < key) {
                box.b = true;
                box.i = key;
                box.d = d;
            }
        }, StreamExInternals.PrimitiveBox.MAX_INT).asDouble();
    }

    public OptionalDouble maxByLong(DoubleToLongFunction keyExtractor) {
        return this.collect(StreamExInternals.PrimitiveBox::new, (box, d) -> {
            long key = keyExtractor.applyAsLong(d);
            if (!box.b || box.l < key) {
                box.b = true;
                box.l = key;
                box.d = d;
            }
        }, StreamExInternals.PrimitiveBox.MAX_LONG).asDouble();
    }

    public OptionalDouble maxByDouble(DoubleUnaryOperator keyExtractor) {
        double[] result = this.collect(() -> new double[3], (acc, d) -> {
            double key = keyExtractor.applyAsDouble(d);
            if (acc[2] == 0.0 || Double.compare(acc[1], key) < 0) {
                acc[0] = d;
                acc[1] = key;
                acc[2] = 1.0;
            }
        }, (acc1, acc2) -> {
            if (acc2[2] == 1.0 && (acc1[2] == 0.0 || Double.compare(acc1[1], acc2[1]) < 0)) {
                System.arraycopy(acc2, 0, acc1, 0, 3);
            }
        });
        return result[2] == 1.0 ? OptionalDouble.of(result[0]) : OptionalDouble.empty();
    }

    @Override
    public long count() {
        return this.stream.count();
    }

    @Override
    public OptionalDouble average() {
        return this.stream.average();
    }

    @Override
    public DoubleSummaryStatistics summaryStatistics() {
        return this.collect(DoubleSummaryStatistics::new, DoubleSummaryStatistics::accept, DoubleSummaryStatistics::combine);
    }

    @Override
    public boolean anyMatch(DoublePredicate predicate) {
        return this.stream.anyMatch(predicate);
    }

    @Override
    public boolean allMatch(DoublePredicate predicate) {
        return this.stream.allMatch(predicate);
    }

    @Override
    public boolean noneMatch(DoublePredicate predicate) {
        return !this.anyMatch(predicate);
    }

    @Override
    public OptionalDouble findFirst() {
        return this.stream.findFirst();
    }

    public OptionalDouble findFirst(DoublePredicate predicate) {
        return this.filter(predicate).findFirst();
    }

    @Override
    public OptionalDouble findAny() {
        return this.stream.findAny();
    }

    public OptionalDouble findAny(DoublePredicate predicate) {
        return this.filter(predicate).findAny();
    }

    public OptionalLong indexOf(DoublePredicate predicate) {
        return ((StreamEx)this.boxed()).indexOf(predicate::test);
    }

    public StreamEx<Double> boxed() {
        return this.strategy().newStreamEx(this.stream.boxed());
    }

    @Override
    public DoubleStreamEx sequential() {
        return StreamFactory.DEFAULT.newDoubleStreamEx(this.stream.sequential());
    }

    @Override
    public DoubleStreamEx parallel() {
        return StreamFactory.DEFAULT.newDoubleStreamEx(this.stream.parallel());
    }

    public DoubleStreamEx parallel(ForkJoinPool fjp) {
        return StreamFactory.forCustomPool(fjp).newDoubleStreamEx(this.stream.parallel());
    }

    @Override
    public PrimitiveIterator.OfDouble iterator() {
        return this.stream.iterator();
    }

    @Override
    public Spliterator.OfDouble spliterator() {
        return this.stream.spliterator();
    }

    public DoubleStreamEx append(double ... values) {
        if (values.length == 0) {
            return this;
        }
        return this.strategy().newDoubleStreamEx(DoubleStream.concat(this.stream, DoubleStream.of(values)));
    }

    public DoubleStreamEx append(DoubleStream other) {
        return this.strategy().newDoubleStreamEx(DoubleStream.concat(this.stream, other));
    }

    public DoubleStreamEx prepend(double ... values) {
        if (values.length == 0) {
            return this;
        }
        return this.strategy().newDoubleStreamEx(DoubleStream.concat(DoubleStream.of(values), this.stream));
    }

    public DoubleStreamEx prepend(DoubleStream other) {
        return this.strategy().newDoubleStreamEx(DoubleStream.concat(other, this.stream));
    }

    public DoubleStreamEx pairMap(DoubleBinaryOperator mapper) {
        return this.delegate(new PairSpliterator.PSOfDouble(mapper, this.stream.spliterator()));
    }

    public String joining(CharSequence delimiter) {
        return this.collect(DoubleCollector.joining(delimiter));
    }

    public String joining(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return this.collect(DoubleCollector.joining(delimiter, prefix, suffix));
    }

    @Override
    public DoubleStreamEx takeWhile(DoublePredicate predicate) {
        Objects.requireNonNull(predicate);
        if (StreamExInternals.JDK9_METHODS != null) {
            return this.callWhile(predicate, 0);
        }
        return this.delegate(new TDOfDouble(this.stream.spliterator(), false, predicate));
    }

    @Override
    public DoubleStreamEx dropWhile(DoublePredicate predicate) {
        Objects.requireNonNull(predicate);
        if (StreamExInternals.JDK9_METHODS != null) {
            return this.callWhile(predicate, 1);
        }
        return this.delegate(new TDOfDouble(this.stream.spliterator(), true, predicate));
    }

    public static DoubleStreamEx empty() {
        return DoubleStreamEx.of(DoubleStream.empty());
    }

    public static DoubleStreamEx of(double element) {
        return DoubleStreamEx.of(DoubleStream.of(element));
    }

    public static DoubleStreamEx of(double ... elements) {
        return DoubleStreamEx.of(DoubleStream.of(elements));
    }

    public static DoubleStreamEx of(double[] array, int startInclusive, int endExclusive) {
        return DoubleStreamEx.of(Arrays.stream(array, startInclusive, endExclusive));
    }

    public static DoubleStreamEx of(Double[] array) {
        return DoubleStreamEx.of(Arrays.stream(array).mapToDouble(Double::doubleValue));
    }

    public static DoubleStreamEx of(float ... elements) {
        return DoubleStreamEx.of(elements, 0, elements.length);
    }

    public static DoubleStreamEx of(float[] array, int startInclusive, int endExclusive) {
        StreamExInternals.rangeCheck(array.length, startInclusive, endExclusive);
        return DoubleStreamEx.of(new RangeBasedSpliterator.OfFloat(startInclusive, endExclusive, array));
    }

    public static DoubleStreamEx of(DoubleStream stream) {
        return stream instanceof DoubleStreamEx ? (DoubleStreamEx)stream : new DoubleStreamEx(stream);
    }

    public static DoubleStreamEx of(Spliterator.OfDouble spliterator) {
        return DoubleStreamEx.of(StreamSupport.doubleStream(spliterator, false));
    }

    public static DoubleStreamEx of(OptionalDouble optional) {
        return optional.isPresent() ? DoubleStreamEx.of(optional.getAsDouble()) : DoubleStreamEx.empty();
    }

    public static DoubleStreamEx of(Collection<Double> collection) {
        return DoubleStreamEx.of(collection.stream().mapToDouble(Double::doubleValue));
    }

    public static DoubleStreamEx of(Random random) {
        return DoubleStreamEx.of(random.doubles());
    }

    public static DoubleStreamEx of(Random random, long streamSize) {
        return DoubleStreamEx.of(random.doubles(streamSize));
    }

    public static DoubleStreamEx of(Random random, double randomNumberOrigin, double randomNumberBound) {
        return DoubleStreamEx.of(random.doubles(randomNumberOrigin, randomNumberBound));
    }

    public static DoubleStreamEx of(Random random, long streamSize, double randomNumberOrigin, double randomNumberBound) {
        return DoubleStreamEx.of(random.doubles(streamSize, randomNumberOrigin, randomNumberBound));
    }

    public static DoubleStreamEx iterate(double seed, DoubleUnaryOperator f) {
        return DoubleStreamEx.of(DoubleStream.iterate(seed, f));
    }

    public static DoubleStreamEx generate(DoubleSupplier s) {
        return DoubleStreamEx.of(DoubleStream.generate(s));
    }

    public static DoubleStreamEx constant(double value, long length) {
        return DoubleStreamEx.of(new ConstSpliterator.OfDouble(value, length));
    }

    public static DoubleStreamEx zip(double[] first, double[] second, DoubleBinaryOperator mapper) {
        return DoubleStreamEx.of(new RangeBasedSpliterator.ZipDouble(0, StreamExInternals.checkLength(first.length, second.length), mapper, first, second));
    }

    private static final class TDOfDouble
    extends Spliterators.AbstractDoubleSpliterator
    implements DoubleConsumer {
        private final DoublePredicate predicate;
        private final boolean drop;
        private boolean checked;
        private final Spliterator.OfDouble source;
        private double cur;

        TDOfDouble(Spliterator.OfDouble source, boolean drop, DoublePredicate predicate) {
            super(source.estimateSize(), source.characteristics() & 0x1515);
            this.drop = drop;
            this.predicate = predicate;
            this.source = source;
        }

        @Override
        public Comparator<? super Double> getComparator() {
            return this.source.getComparator();
        }

        @Override
        public boolean tryAdvance(DoubleConsumer action) {
            if (this.drop) {
                if (this.checked) {
                    return this.source.tryAdvance(action);
                }
                while (this.source.tryAdvance(this)) {
                    if (this.predicate.test(this.cur)) continue;
                    this.checked = true;
                    action.accept(this.cur);
                    return true;
                }
                return false;
            }
            if (!this.checked && this.source.tryAdvance(this) && this.predicate.test(this.cur)) {
                action.accept(this.cur);
                return true;
            }
            this.checked = true;
            return false;
        }

        @Override
        public void accept(double t) {
            this.cur = t;
        }
    }
}

