/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.nio.CharBuffer;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Random;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ForkJoinPool;
import java.util.function.BiConsumer;
import java.util.function.DoublePredicate;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongPredicate;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import one.util.streamex.ConstSpliterator;
import one.util.streamex.DoubleStreamEx;
import one.util.streamex.EntryStream;
import one.util.streamex.IntCollector;
import one.util.streamex.LongStreamEx;
import one.util.streamex.PairSpliterator;
import one.util.streamex.RangeBasedSpliterator;
import one.util.streamex.StreamEx;
import one.util.streamex.StreamExInternals;
import one.util.streamex.StreamFactory;

public class IntStreamEx
implements IntStream {
    final IntStream stream;

    IntStreamEx(IntStream stream) {
        this.stream = stream;
    }

    StreamFactory strategy() {
        return StreamFactory.DEFAULT;
    }

    final IntStreamEx delegate(Spliterator.OfInt spliterator) {
        return this.strategy().newIntStreamEx((IntStream)StreamSupport.intStream(spliterator, this.stream.isParallel()).onClose(this.stream::close));
    }

    final IntStreamEx callWhile(IntPredicate predicate, int methodId) {
        try {
            return this.strategy().newIntStreamEx(StreamExInternals.JDK9_METHODS[1][methodId].invokeExact(this.stream, predicate));
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InternalError(e);
        }
    }

    <A> A collectSized(Supplier<A> supplier, ObjIntConsumer<A> accumulator, BiConsumer<A, A> combiner, IntFunction<A> sizedSupplier, ObjIntConsumer<A> sizedAccumulator) {
        Object intermediate;
        if (this.isParallel()) {
            return this.collect(supplier, accumulator, combiner);
        }
        Spliterator.OfInt spliterator = this.stream.spliterator();
        long size = spliterator.getExactSizeIfKnown();
        if (size >= 0L && size <= Integer.MAX_VALUE) {
            intermediate = sizedSupplier.apply((int)size);
            spliterator.forEachRemaining(i -> sizedAccumulator.accept(intermediate, i));
        } else {
            intermediate = supplier.get();
            spliterator.forEachRemaining(i -> accumulator.accept(intermediate, i));
        }
        return intermediate;
    }

    @Override
    public boolean isParallel() {
        return this.stream.isParallel();
    }

    @Override
    public IntStreamEx unordered() {
        return this.strategy().newIntStreamEx((IntStream)this.stream.unordered());
    }

    @Override
    public IntStreamEx onClose(Runnable closeHandler) {
        return this.strategy().newIntStreamEx((IntStream)this.stream.onClose(closeHandler));
    }

    @Override
    public void close() {
        this.stream.close();
    }

    @Override
    public IntStreamEx filter(IntPredicate predicate) {
        return this.strategy().newIntStreamEx(this.stream.filter(predicate));
    }

    public IntStreamEx remove(IntPredicate predicate) {
        return this.filter(predicate.negate());
    }

    public boolean has(int value) {
        return this.anyMatch(x -> x == value);
    }

    public IntStreamEx without(int value) {
        return this.filter(val -> val != value);
    }

    public IntStreamEx greater(int value) {
        return this.filter(val -> val > value);
    }

    public IntStreamEx atLeast(int value) {
        return this.filter(val -> val >= value);
    }

    public IntStreamEx less(int value) {
        return this.filter(val -> val < value);
    }

    public IntStreamEx atMost(int value) {
        return this.filter(val -> val <= value);
    }

    @Override
    public IntStreamEx map(IntUnaryOperator mapper) {
        return this.strategy().newIntStreamEx(this.stream.map(mapper));
    }

    public <U> StreamEx<U> mapToObj(IntFunction<? extends U> mapper) {
        return this.strategy().newStreamEx(this.stream.mapToObj(mapper));
    }

    @Override
    public LongStreamEx mapToLong(IntToLongFunction mapper) {
        return this.strategy().newLongStreamEx(this.stream.mapToLong(mapper));
    }

    @Override
    public DoubleStreamEx mapToDouble(IntToDoubleFunction mapper) {
        return this.strategy().newDoubleStreamEx(this.stream.mapToDouble(mapper));
    }

    public <K, V> EntryStream<K, V> mapToEntry(IntFunction<? extends K> keyMapper, IntFunction<? extends V> valueMapper) {
        return this.strategy().newEntryStream(this.stream.mapToObj((int t) -> new AbstractMap.SimpleImmutableEntry(keyMapper.apply(t), valueMapper.apply(t))));
    }

    @Override
    public IntStreamEx flatMap(IntFunction<? extends IntStream> mapper) {
        return this.strategy().newIntStreamEx(this.stream.flatMap(mapper));
    }

    public LongStreamEx flatMapToLong(IntFunction<? extends LongStream> mapper) {
        return this.strategy().newLongStreamEx(this.stream.mapToObj(mapper).flatMapToLong(Function.identity()));
    }

    public DoubleStreamEx flatMapToDouble(IntFunction<? extends DoubleStream> mapper) {
        return this.strategy().newDoubleStreamEx(this.stream.mapToObj(mapper).flatMapToDouble(Function.identity()));
    }

    public <R> StreamEx<R> flatMapToObj(IntFunction<? extends Stream<R>> mapper) {
        return this.strategy().newStreamEx(this.stream.mapToObj(mapper).flatMap(Function.identity()));
    }

    @Override
    public IntStreamEx distinct() {
        return this.strategy().newIntStreamEx(this.stream.distinct());
    }

    @Override
    public IntStreamEx sorted() {
        return this.strategy().newIntStreamEx(this.stream.sorted());
    }

    public IntStreamEx sorted(Comparator<Integer> comparator) {
        return this.strategy().newIntStreamEx(this.stream.boxed().sorted(comparator).mapToInt(Integer::intValue));
    }

    public IntStreamEx reverseSorted() {
        return this.sorted(Comparator.reverseOrder());
    }

    public <V extends Comparable<? super V>> IntStreamEx sortedBy(IntFunction<V> keyExtractor) {
        return this.sorted(Comparator.comparing(i -> (Comparable)keyExtractor.apply((int)i)));
    }

    public IntStreamEx sortedByInt(IntUnaryOperator keyExtractor) {
        return this.sorted(Comparator.comparingInt(i -> keyExtractor.applyAsInt((int)i)));
    }

    public IntStreamEx sortedByLong(IntToLongFunction keyExtractor) {
        return this.sorted(Comparator.comparingLong(i -> keyExtractor.applyAsLong((int)i)));
    }

    public IntStreamEx sortedByDouble(IntToDoubleFunction keyExtractor) {
        return this.sorted(Comparator.comparingDouble(i -> keyExtractor.applyAsDouble((int)i)));
    }

    @Override
    public IntStreamEx peek(IntConsumer action) {
        return this.strategy().newIntStreamEx(this.stream.peek(action));
    }

    @Override
    public IntStreamEx limit(long maxSize) {
        return this.strategy().newIntStreamEx(this.stream.limit(maxSize));
    }

    @Override
    public IntStreamEx skip(long n) {
        return this.strategy().newIntStreamEx(this.stream.skip(n));
    }

    public IntStreamEx skipOrdered(long n) {
        Spliterator.OfInt spliterator = (this.stream.isParallel() ? StreamSupport.intStream(this.stream.spliterator(), false) : this.stream).skip(n).spliterator();
        return this.delegate(spliterator);
    }

    @Override
    public void forEach(IntConsumer action) {
        this.stream.forEach(action);
    }

    @Override
    public void forEachOrdered(IntConsumer action) {
        this.stream.forEachOrdered(action);
    }

    @Override
    public int[] toArray() {
        return this.stream.toArray();
    }

    public byte[] toByteArray() {
        return this.collectSized(StreamExInternals.ByteBuffer::new, StreamExInternals.ByteBuffer::add, StreamExInternals.ByteBuffer::addAll, StreamExInternals.ByteBuffer::new, StreamExInternals.ByteBuffer::addUnsafe).toArray();
    }

    public char[] toCharArray() {
        return this.collectSized(StreamExInternals.CharBuffer::new, StreamExInternals.CharBuffer::add, StreamExInternals.CharBuffer::addAll, StreamExInternals.CharBuffer::new, StreamExInternals.CharBuffer::addUnsafe).toArray();
    }

    public short[] toShortArray() {
        return this.collectSized(StreamExInternals.ShortBuffer::new, StreamExInternals.ShortBuffer::add, StreamExInternals.ShortBuffer::addAll, StreamExInternals.ShortBuffer::new, StreamExInternals.ShortBuffer::addUnsafe).toArray();
    }

    public BitSet toBitSet() {
        return this.collect(BitSet::new, BitSet::set, BitSet::or);
    }

    @Override
    public int reduce(int identity, IntBinaryOperator op) {
        return this.stream.reduce(identity, op);
    }

    @Override
    public OptionalInt reduce(IntBinaryOperator op) {
        return this.stream.reduce(op);
    }

    public int foldLeft(int identity, IntBinaryOperator accumulator) {
        int[] box = new int[]{identity};
        this.stream.forEachOrdered(t -> {
            nArray[0] = accumulator.applyAsInt(box[0], t);
        });
        return box[0];
    }

    public OptionalInt foldLeft(IntBinaryOperator accumulator) {
        StreamExInternals.PrimitiveBox b = new StreamExInternals.PrimitiveBox();
        this.stream.forEachOrdered(t -> {
            if (primitiveBox.b) {
                primitiveBox.i = accumulator.applyAsInt(primitiveBox.i, t);
            } else {
                primitiveBox.i = t;
                primitiveBox.b = true;
            }
        });
        return b.asInt();
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjIntConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        return this.stream.collect(supplier, accumulator, combiner);
    }

    public <A, R> R collect(IntCollector<A, R> collector) {
        if (collector.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            return (R)this.collect(collector.supplier(), collector.intAccumulator(), collector.merger());
        }
        return collector.finisher().apply(this.collect(collector.supplier(), collector.intAccumulator(), collector.merger()));
    }

    @Override
    public int sum() {
        return this.reduce(0, Integer::sum);
    }

    @Override
    public OptionalInt min() {
        return this.reduce(Integer::min);
    }

    public OptionalInt min(Comparator<Integer> comparator) {
        return this.reduce((a, b) -> comparator.compare(a, b) > 0 ? b : a);
    }

    public <V extends Comparable<? super V>> OptionalInt minBy(IntFunction<V> keyExtractor) {
        StreamExInternals.ObjIntBox result = this.collect(() -> new StreamExInternals.ObjIntBox<Object>(null, 0), (box, i) -> {
            Comparable val = (Comparable)Objects.requireNonNull(keyExtractor.apply(i));
            if (box.a == null || ((Comparable)box.a).compareTo(val) > 0) {
                box.a = val;
                box.b = i;
            }
        }, (box1, box2) -> {
            if (box2.a != null && (box1.a == null || ((Comparable)box1.a).compareTo(box2.a) > 0)) {
                box1.a = box2.a;
                box1.b = box2.b;
            }
        });
        return result.a == null ? OptionalInt.empty() : OptionalInt.of(result.b);
    }

    public OptionalInt minByInt(IntUnaryOperator keyExtractor) {
        int[] result = this.collect(() -> new int[3], (acc, i) -> {
            int key = keyExtractor.applyAsInt(i);
            if (acc[2] == 0 || acc[1] > key) {
                acc[0] = i;
                acc[1] = key;
                acc[2] = 1;
            }
        }, (acc1, acc2) -> {
            if (acc2[2] == 1 && (acc1[2] == 0 || acc1[1] > acc2[1])) {
                System.arraycopy(acc2, 0, acc1, 0, 3);
            }
        });
        return result[2] == 1 ? OptionalInt.of(result[0]) : OptionalInt.empty();
    }

    public OptionalInt minByLong(IntToLongFunction keyExtractor) {
        return this.collect(StreamExInternals.PrimitiveBox::new, (box, i) -> {
            long key = keyExtractor.applyAsLong(i);
            if (!box.b || box.l > key) {
                box.b = true;
                box.l = key;
                box.i = i;
            }
        }, StreamExInternals.PrimitiveBox.MIN_LONG).asInt();
    }

    public OptionalInt minByDouble(IntToDoubleFunction keyExtractor) {
        return this.collect(StreamExInternals.PrimitiveBox::new, (box, i) -> {
            double key = keyExtractor.applyAsDouble(i);
            if (!box.b || Double.compare(box.d, key) > 0) {
                box.b = true;
                box.d = key;
                box.i = i;
            }
        }, StreamExInternals.PrimitiveBox.MIN_DOUBLE).asInt();
    }

    @Override
    public OptionalInt max() {
        return this.reduce(Integer::max);
    }

    public OptionalInt max(Comparator<Integer> comparator) {
        return this.reduce((a, b) -> comparator.compare(a, b) >= 0 ? a : b);
    }

    public <V extends Comparable<? super V>> OptionalInt maxBy(IntFunction<V> keyExtractor) {
        StreamExInternals.ObjIntBox result = this.collect(() -> new StreamExInternals.ObjIntBox<Object>(null, 0), (box, i) -> {
            Comparable val = (Comparable)Objects.requireNonNull(keyExtractor.apply(i));
            if (box.a == null || ((Comparable)box.a).compareTo(val) < 0) {
                box.a = val;
                box.b = i;
            }
        }, (box1, box2) -> {
            if (box2.a != null && (box1.a == null || ((Comparable)box1.a).compareTo(box2.a) < 0)) {
                box1.a = box2.a;
                box1.b = box2.b;
            }
        });
        return result.a == null ? OptionalInt.empty() : OptionalInt.of(result.b);
    }

    public OptionalInt maxByInt(IntUnaryOperator keyExtractor) {
        int[] result = this.collect(() -> new int[3], (acc, i) -> {
            int key = keyExtractor.applyAsInt(i);
            if (acc[2] == 0 || acc[1] < key) {
                acc[0] = i;
                acc[1] = key;
                acc[2] = 1;
            }
        }, (acc1, acc2) -> {
            if (acc2[2] == 1 && (acc1[2] == 0 || acc1[1] < acc2[1])) {
                System.arraycopy(acc2, 0, acc1, 0, 3);
            }
        });
        return result[2] == 1 ? OptionalInt.of(result[0]) : OptionalInt.empty();
    }

    public OptionalInt maxByLong(IntToLongFunction keyExtractor) {
        return this.collect(StreamExInternals.PrimitiveBox::new, (box, i) -> {
            long key = keyExtractor.applyAsLong(i);
            if (!box.b || box.l < key) {
                box.b = true;
                box.l = key;
                box.i = i;
            }
        }, StreamExInternals.PrimitiveBox.MAX_LONG).asInt();
    }

    public OptionalInt maxByDouble(IntToDoubleFunction keyExtractor) {
        return this.collect(StreamExInternals.PrimitiveBox::new, (box, i) -> {
            double key = keyExtractor.applyAsDouble(i);
            if (!box.b || Double.compare(box.d, key) < 0) {
                box.b = true;
                box.d = key;
                box.i = i;
            }
        }, StreamExInternals.PrimitiveBox.MAX_DOUBLE).asInt();
    }

    @Override
    public long count() {
        return this.stream.count();
    }

    @Override
    public OptionalDouble average() {
        return this.stream.average();
    }

    @Override
    public IntSummaryStatistics summaryStatistics() {
        return this.collect(IntSummaryStatistics::new, IntSummaryStatistics::accept, IntSummaryStatistics::combine);
    }

    @Override
    public boolean anyMatch(IntPredicate predicate) {
        return this.stream.anyMatch(predicate);
    }

    @Override
    public boolean allMatch(IntPredicate predicate) {
        return this.stream.allMatch(predicate);
    }

    @Override
    public boolean noneMatch(IntPredicate predicate) {
        return !this.anyMatch(predicate);
    }

    @Override
    public OptionalInt findFirst() {
        return this.stream.findFirst();
    }

    public OptionalInt findFirst(IntPredicate predicate) {
        return this.filter(predicate).findFirst();
    }

    @Override
    public OptionalInt findAny() {
        return this.stream.findAny();
    }

    public OptionalInt findAny(IntPredicate predicate) {
        return this.filter(predicate).findAny();
    }

    public OptionalLong indexOf(int value) {
        return ((StreamEx)this.boxed()).indexOf((T i) -> i == value);
    }

    public OptionalLong indexOf(IntPredicate predicate) {
        return ((StreamEx)this.boxed()).indexOf(predicate::test);
    }

    @Override
    public LongStreamEx asLongStream() {
        return this.strategy().newLongStreamEx(this.stream.asLongStream());
    }

    @Override
    public DoubleStreamEx asDoubleStream() {
        return this.strategy().newDoubleStreamEx(this.stream.asDoubleStream());
    }

    public StreamEx<Integer> boxed() {
        return this.strategy().newStreamEx(this.stream.boxed());
    }

    @Override
    public IntStreamEx sequential() {
        return StreamFactory.DEFAULT.newIntStreamEx(this.stream.sequential());
    }

    @Override
    public IntStreamEx parallel() {
        return StreamFactory.DEFAULT.newIntStreamEx(this.stream.parallel());
    }

    public IntStreamEx parallel(ForkJoinPool fjp) {
        return StreamFactory.forCustomPool(fjp).newIntStreamEx(this.stream.parallel());
    }

    @Override
    public PrimitiveIterator.OfInt iterator() {
        return this.stream.iterator();
    }

    @Override
    public Spliterator.OfInt spliterator() {
        return this.stream.spliterator();
    }

    public IntStreamEx append(int ... values) {
        if (values.length == 0) {
            return this;
        }
        return this.strategy().newIntStreamEx(IntStream.concat(this.stream, IntStream.of(values)));
    }

    public IntStreamEx append(IntStream other) {
        return this.strategy().newIntStreamEx(IntStream.concat(this.stream, other));
    }

    public IntStreamEx prepend(int ... values) {
        if (values.length == 0) {
            return this;
        }
        return this.strategy().newIntStreamEx(IntStream.concat(IntStream.of(values), this.stream));
    }

    public IntStreamEx prepend(IntStream other) {
        return this.strategy().newIntStreamEx(IntStream.concat(other, this.stream));
    }

    public <U> StreamEx<U> elements(U[] array) {
        return this.mapToObj((int idx) -> array[idx]);
    }

    public <U> StreamEx<U> elements(List<U> list) {
        return this.mapToObj(list::get);
    }

    public IntStreamEx elements(int[] array) {
        return this.map(idx -> array[idx]);
    }

    public LongStreamEx elements(long[] array) {
        return this.mapToLong(idx -> array[idx]);
    }

    public DoubleStreamEx elements(double[] array) {
        return this.mapToDouble(idx -> array[idx]);
    }

    public String charsToString() {
        return this.collect(StringBuilder::new, (sb, c) -> sb.append((char)c), StringBuilder::append).toString();
    }

    public String codePointsToString() {
        return this.collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    public IntStreamEx pairMap(IntBinaryOperator mapper) {
        return this.delegate(new PairSpliterator.PSOfInt(mapper, this.stream.spliterator()));
    }

    public String joining(CharSequence delimiter) {
        return this.collect(IntCollector.joining(delimiter));
    }

    public String joining(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return this.collect(IntCollector.joining(delimiter, prefix, suffix));
    }

    @Override
    public IntStreamEx takeWhile(IntPredicate predicate) {
        Objects.requireNonNull(predicate);
        if (StreamExInternals.JDK9_METHODS != null) {
            return this.callWhile(predicate, 0);
        }
        return this.delegate(new TDOfInt(this.stream.spliterator(), false, predicate));
    }

    @Override
    public IntStreamEx dropWhile(IntPredicate predicate) {
        Objects.requireNonNull(predicate);
        if (StreamExInternals.JDK9_METHODS != null) {
            return this.callWhile(predicate, 1);
        }
        return this.delegate(new TDOfInt(this.stream.spliterator(), true, predicate));
    }

    public IntStreamEx mapFirst(IntUnaryOperator mapper) {
        return ((StreamEx)this.mapToObj(Integer::new)).mapFirst(mapper::applyAsInt).mapToInt(Integer::intValue);
    }

    public IntStreamEx mapLast(IntUnaryOperator mapper) {
        return ((StreamEx)this.mapToObj(Integer::new)).mapLast(mapper::applyAsInt).mapToInt(Integer::intValue);
    }

    public static IntStreamEx empty() {
        return IntStreamEx.of(IntStream.empty());
    }

    public static IntStreamEx of(int element) {
        return IntStreamEx.of(IntStream.of(element));
    }

    public static IntStreamEx of(int ... elements) {
        return IntStreamEx.of(IntStream.of(elements));
    }

    public static IntStreamEx of(int[] array, int startInclusive, int endExclusive) {
        return IntStreamEx.of(Arrays.stream(array, startInclusive, endExclusive));
    }

    public static IntStreamEx of(byte ... elements) {
        return IntStreamEx.of(elements, 0, elements.length);
    }

    public static IntStreamEx of(byte[] array, int startInclusive, int endExclusive) {
        StreamExInternals.rangeCheck(array.length, startInclusive, endExclusive);
        return IntStreamEx.of(new RangeBasedSpliterator.OfByte(startInclusive, endExclusive, array));
    }

    public static IntStreamEx of(char ... elements) {
        return IntStreamEx.of(elements, 0, elements.length);
    }

    public static IntStreamEx of(char[] array, int startInclusive, int endExclusive) {
        StreamExInternals.rangeCheck(array.length, startInclusive, endExclusive);
        return IntStreamEx.of(new RangeBasedSpliterator.OfChar(startInclusive, endExclusive, array));
    }

    public static IntStreamEx of(short ... elements) {
        return IntStreamEx.of(elements, 0, elements.length);
    }

    public static IntStreamEx of(short[] array, int startInclusive, int endExclusive) {
        StreamExInternals.rangeCheck(array.length, startInclusive, endExclusive);
        return IntStreamEx.of(new RangeBasedSpliterator.OfShort(startInclusive, endExclusive, array));
    }

    public static IntStreamEx of(Integer[] array) {
        return IntStreamEx.of(Arrays.stream(array).mapToInt(Integer::intValue));
    }

    public static <T> IntStreamEx ofIndices(List<T> list) {
        return IntStreamEx.range(list.size());
    }

    public static <T> IntStreamEx ofIndices(List<T> list, Predicate<T> predicate) {
        return IntStreamEx.of(IntStream.range(0, list.size()).filter(i -> predicate.test(list.get(i))));
    }

    public static <T> IntStreamEx ofIndices(T[] array) {
        return IntStreamEx.range(array.length);
    }

    public static <T> IntStreamEx ofIndices(T[] array, Predicate<T> predicate) {
        return IntStreamEx.of(IntStream.range(0, array.length).filter(i -> predicate.test(array[i])));
    }

    public static IntStreamEx ofIndices(int[] array) {
        return IntStreamEx.range(array.length);
    }

    public static IntStreamEx ofIndices(int[] array, IntPredicate predicate) {
        return IntStreamEx.of(IntStream.range(0, array.length).filter(i -> predicate.test(array[i])));
    }

    public static IntStreamEx ofIndices(long[] array) {
        return IntStreamEx.range(array.length);
    }

    public static IntStreamEx ofIndices(long[] array, LongPredicate predicate) {
        return IntStreamEx.of(IntStream.range(0, array.length).filter(i -> predicate.test(array[i])));
    }

    public static IntStreamEx ofIndices(double[] array) {
        return IntStreamEx.range(array.length);
    }

    public static IntStreamEx ofIndices(double[] array, DoublePredicate predicate) {
        return IntStreamEx.of(IntStream.range(0, array.length).filter(i -> predicate.test(array[i])));
    }

    public static IntStreamEx of(IntStream stream) {
        return stream instanceof IntStreamEx ? (IntStreamEx)stream : new IntStreamEx(stream);
    }

    public static IntStreamEx of(Spliterator.OfInt spliterator) {
        return IntStreamEx.of(StreamSupport.intStream(spliterator, false));
    }

    public static IntStreamEx of(OptionalInt optional) {
        return optional.isPresent() ? IntStreamEx.of(optional.getAsInt()) : IntStreamEx.empty();
    }

    public static IntStreamEx of(BitSet bitSet) {
        return IntStreamEx.of(bitSet.stream());
    }

    public static IntStreamEx of(Collection<Integer> collection) {
        return IntStreamEx.of(collection.stream().mapToInt(Integer::intValue));
    }

    public static IntStreamEx of(Random random) {
        return IntStreamEx.of(random.ints());
    }

    public static IntStreamEx of(Random random, long streamSize) {
        return IntStreamEx.of(random.ints(streamSize));
    }

    public static IntStreamEx of(Random random, int randomNumberOrigin, int randomNumberBound) {
        return IntStreamEx.of(random.ints(randomNumberOrigin, randomNumberBound));
    }

    public static IntStreamEx of(Random random, long streamSize, int randomNumberOrigin, int randomNumberBound) {
        return IntStreamEx.of(random.ints(streamSize, randomNumberOrigin, randomNumberBound));
    }

    public static IntStreamEx ofChars(CharSequence seq) {
        return IntStreamEx.of(StreamExInternals.IS_JDK9 ? seq.chars() : CharBuffer.wrap(seq).chars());
    }

    public static IntStreamEx ofCodePoints(CharSequence seq) {
        return IntStreamEx.of(seq.codePoints());
    }

    public static IntStreamEx iterate(int seed, IntUnaryOperator f) {
        return IntStreamEx.of(IntStream.iterate(seed, f));
    }

    public static IntStreamEx generate(IntSupplier s) {
        return IntStreamEx.of(IntStream.generate(s));
    }

    public static IntStreamEx range(int endExclusive) {
        return IntStreamEx.of(IntStream.range(0, endExclusive));
    }

    public static IntStreamEx range(int startInclusive, int endExclusive) {
        return IntStreamEx.of(IntStream.range(startInclusive, endExclusive));
    }

    public static IntStreamEx range(int startInclusive, int endExclusive, int step) {
        int endInclusive = endExclusive - Integer.signum(step);
        if (endInclusive > endExclusive && step > 0 || endInclusive < endExclusive && step < 0) {
            return IntStreamEx.empty();
        }
        return IntStreamEx.rangeClosed(startInclusive, endInclusive, step);
    }

    public static IntStreamEx rangeClosed(int startInclusive, int endInclusive) {
        return IntStreamEx.of(IntStream.rangeClosed(startInclusive, endInclusive));
    }

    public static IntStreamEx rangeClosed(int startInclusive, int endInclusive, int step) {
        if (step == 0) {
            throw new IllegalArgumentException("step = 0");
        }
        if (step == 1) {
            return IntStreamEx.of(IntStream.rangeClosed(startInclusive, endInclusive));
        }
        if (step == -1) {
            int sum = endInclusive + startInclusive;
            return IntStreamEx.of(IntStream.rangeClosed(endInclusive, startInclusive).map(x -> sum - x));
        }
        if (endInclusive > startInclusive ^ step > 0) {
            return IntStreamEx.empty();
        }
        int limit = (endInclusive - startInclusive) * Integer.signum(step);
        limit = Integer.divideUnsigned(limit, Math.abs(step));
        return IntStreamEx.of(IntStream.rangeClosed(0, limit).map(x -> x * step + startInclusive));
    }

    public static IntStreamEx constant(int value, long length) {
        return IntStreamEx.of(new ConstSpliterator.OfInt(value, length));
    }

    public static IntStreamEx zip(int[] first, int[] second, IntBinaryOperator mapper) {
        return IntStreamEx.of(new RangeBasedSpliterator.ZipInt(0, StreamExInternals.checkLength(first.length, second.length), mapper, first, second));
    }

    private static final class TDOfInt
    extends Spliterators.AbstractIntSpliterator
    implements IntConsumer {
        private final IntPredicate predicate;
        private final boolean drop;
        private boolean checked;
        private final Spliterator.OfInt source;
        private int cur;

        TDOfInt(Spliterator.OfInt source, boolean drop, IntPredicate predicate) {
            super(source.estimateSize(), source.characteristics() & 0x1515);
            this.drop = drop;
            this.predicate = predicate;
            this.source = source;
        }

        @Override
        public Comparator<? super Integer> getComparator() {
            return this.source.getComparator();
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            if (this.drop) {
                if (this.checked) {
                    return this.source.tryAdvance(action);
                }
                while (this.source.tryAdvance(this)) {
                    if (this.predicate.test(this.cur)) continue;
                    this.checked = true;
                    action.accept(this.cur);
                    return true;
                }
                return false;
            }
            if (!this.checked && this.source.tryAdvance(this) && this.predicate.test(this.cur)) {
                action.accept(this.cur);
                return true;
            }
            this.checked = true;
            return false;
        }

        @Override
        public void accept(int t) {
            this.cur = t;
        }
    }
}

