/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.ArrayDeque;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import one.util.streamex.StreamExInternals;

final class OrderedCancellableSpliterator<T, A>
implements Spliterator<A>,
Cloneable {
    private Spliterator<T> source;
    private final Object lock = new Object();
    private final BiConsumer<A, ? super T> accumulator;
    private final Predicate<A> cancelPredicate;
    private final BinaryOperator<A> combiner;
    private final Supplier<A> supplier;
    private volatile boolean localCancelled;
    private OrderedCancellableSpliterator<T, A> prefix;
    private OrderedCancellableSpliterator<T, A> suffix;
    private A payload;

    OrderedCancellableSpliterator(Spliterator<T> source, Supplier<A> supplier, BiConsumer<A, ? super T> accumulator, BinaryOperator<A> combiner, Predicate<A> cancelPredicate) {
        this.source = source;
        this.supplier = supplier;
        this.accumulator = accumulator;
        this.combiner = combiner;
        this.cancelPredicate = cancelPredicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryAdvance(Consumer<? super A> action) {
        A acc;
        block16: {
            Spliterator<Object> source = this.source;
            if (source == null || this.localCancelled) {
                this.source = null;
                return false;
            }
            acc = this.supplier.get();
            try {
                source.forEachRemaining((? super T t) -> {
                    this.accumulator.accept(acc, t);
                    if (this.cancelPredicate.test(acc)) {
                        this.cancelSuffix();
                        throw new StreamExInternals.CancelException();
                    }
                    if (this.localCancelled) {
                        throw new StreamExInternals.CancelException();
                    }
                });
            }
            catch (StreamExInternals.CancelException ex) {
                if (!this.localCancelled) break block16;
                return false;
            }
        }
        this.source = null;
        Object result = acc;
        block5: while (true) {
            if (this.prefix == null && this.suffix == null) {
                action.accept(result);
                return true;
            }
            ArrayDeque<A> res = new ArrayDeque<A>();
            res.offer(result);
            Object object = this.lock;
            synchronized (object) {
                if (this.localCancelled) {
                    return false;
                }
                OrderedCancellableSpliterator<T, A> s = this.prefix;
                while (s != null && s.payload != null) {
                    res.offerFirst(s.payload);
                    s = s.prefix;
                }
                this.prefix = s;
                if (s != null) {
                    s.suffix = this;
                }
                s = this.suffix;
                while (s != null && s.payload != null) {
                    res.offerLast(s.payload);
                    s = s.suffix;
                }
                this.suffix = s;
                if (s != null) {
                    s.prefix = this;
                }
                if (res.size() == 1) {
                    if (this.prefix == null && this.suffix == null) {
                        action.accept(result);
                        return true;
                    }
                    this.payload = result;
                    break;
                }
            }
            result = res.pollFirst();
            while (true) {
                if (res.isEmpty()) continue block5;
                if (!this.cancelPredicate.test(result = this.combiner.apply(result, res.pollFirst()))) continue;
                this.cancelSuffix();
            }
            break;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelSuffix() {
        if (this.suffix == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            OrderedCancellableSpliterator<T, A> suffix = this.suffix;
            while (suffix != null && !suffix.localCancelled) {
                suffix.prefix = null;
                suffix.localCancelled = true;
                suffix = suffix.suffix;
            }
            this.suffix = null;
        }
    }

    @Override
    public void forEachRemaining(Consumer<? super A> action) {
        this.tryAdvance(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Spliterator<A> trySplit() {
        if (this.source == null || this.localCancelled) {
            this.source = null;
            return null;
        }
        Spliterator<T> prefix = this.source.trySplit();
        if (prefix == null) {
            return null;
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                OrderedCancellableSpliterator result = (OrderedCancellableSpliterator)this.clone();
                result.source = prefix;
                this.prefix = result;
                result.suffix = this;
                OrderedCancellableSpliterator<T, A> prefixPrefix = result.prefix;
                if (prefixPrefix != null) {
                    prefixPrefix.suffix = result;
                }
                return result;
            }
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public long estimateSize() {
        return this.source == null ? 0L : this.source.estimateSize();
    }

    @Override
    public int characteristics() {
        return this.source == null ? 64 : 16;
    }
}

