/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ForkJoinPool;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.CharSpliterator;
import one.util.streamex.CollapseSpliterator;
import one.util.streamex.ConstSpliterator;
import one.util.streamex.CrossSpliterator;
import one.util.streamex.DistinctSpliterator;
import one.util.streamex.EntryStream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.MoreCollectors;
import one.util.streamex.PairPermutationSpliterator;
import one.util.streamex.PairSpliterator;
import one.util.streamex.PermutationSpliterator;
import one.util.streamex.RangeBasedSpliterator;
import one.util.streamex.StreamExInternals;
import one.util.streamex.StreamFactory;
import one.util.streamex.UnknownSizeSpliterator;

public class StreamEx<T>
extends AbstractStreamEx<T, StreamEx<T>> {
    StreamEx(Stream<T> stream) {
        super(stream);
    }

    @Override
    StreamEx<T> supply(Stream<T> stream) {
        return this.strategy().newStreamEx(stream);
    }

    final <R> StreamEx<R> collapseInternal(BiPredicate<? super T, ? super T> collapsible, Function<T, R> mapper, BiFunction<R, T, R> accumulator, BinaryOperator<R> combiner) {
        return this.strategy().newStreamEx(this.delegate(new CollapseSpliterator<T, R>(collapsible, mapper, accumulator, combiner, this.stream.spliterator())));
    }

    @Override
    public StreamEx<T> sequential() {
        return StreamFactory.DEFAULT.newStreamEx((Stream)this.stream.sequential());
    }

    @Override
    public StreamEx<T> parallel() {
        return StreamFactory.DEFAULT.newStreamEx((Stream)this.stream.parallel());
    }

    public StreamEx<T> parallel(ForkJoinPool fjp) {
        return StreamFactory.forCustomPool(fjp).newStreamEx((Stream)this.stream.parallel());
    }

    public <TT> StreamEx<TT> select(Class<TT> clazz) {
        return (StreamEx)this.filter(clazz::isInstance);
    }

    public <V> EntryStream<T, V> mapToEntry(Function<? super T, ? extends V> valueMapper) {
        return this.strategy().newEntryStream(this.stream.map((? super T e) -> new AbstractMap.SimpleImmutableEntry(e, valueMapper.apply(e))));
    }

    public <K, V> EntryStream<K, V> mapToEntry(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return this.strategy().newEntryStream(this.stream.map((? super T e) -> new AbstractMap.SimpleImmutableEntry(keyMapper.apply(e), valueMapper.apply(e))));
    }

    public StreamEx<T> mapFirst(Function<? super T, ? extends T> mapper) {
        Object first = new Object();
        Stream<Object> none = Stream.of(first);
        return this.strategy().newStreamEx(this.delegate(new PairSpliterator.PSOfRef<Object, Object>((a, b) -> a == first ? mapper.apply(b) : b, Stream.concat(none, this.stream).spliterator())));
    }

    public StreamEx<T> mapLast(Function<? super T, ? extends T> mapper) {
        Object last = new Object();
        Stream<Object> none = Stream.of(last);
        return this.strategy().newStreamEx(this.delegate(new PairSpliterator.PSOfRef<Object, Object>((a, b) -> b == last ? mapper.apply(a) : a, Stream.concat(this.stream, none).spliterator())));
    }

    public <K, V> EntryStream<K, V> flatMapToEntry(Function<? super T, ? extends Map<K, V>> mapper) {
        return this.strategy().newEntryStream(this.stream.flatMap((? super T e) -> {
            Map s = (Map)mapper.apply(e);
            return s == null ? null : s.entrySet().stream();
        }));
    }

    public <V> EntryStream<T, V> cross(V ... other) {
        if (other.length == 0) {
            return this.strategy().newEntryStream(this.delegate(Spliterators.emptySpliterator()));
        }
        if (other.length == 1) {
            return this.mapToEntry(e -> other[0]);
        }
        return this.strategy().newEntryStream(this.stream.flatMap((? super T a) -> Arrays.stream(other).map((? super T b) -> new AbstractMap.SimpleImmutableEntry<Object, Object>(a, b))));
    }

    public <V> EntryStream<T, V> cross(Collection<? extends V> other) {
        if (other.isEmpty()) {
            return this.strategy().newEntryStream(this.delegate(Spliterators.emptySpliterator()));
        }
        return this.strategy().newEntryStream(this.stream.flatMap((? super T a) -> other.stream().map((? super T b) -> new AbstractMap.SimpleImmutableEntry<Object, Object>(a, b))));
    }

    public <V> EntryStream<T, V> cross(Function<? super T, ? extends Stream<? extends V>> mapper) {
        return this.strategy().newEntryStream(this.stream.flatMap((? super T a) -> {
            Stream s = (Stream)mapper.apply(a);
            return s == null ? null : s.map((? super T b) -> new AbstractMap.SimpleImmutableEntry<Object, Object>(a, b));
        }));
    }

    public <K> Map<K, List<T>> groupingBy(Function<? super T, ? extends K> classifier) {
        return this.groupingBy(classifier, Collectors.toList());
    }

    public <K, D> Map<K, D> groupingBy(Function<? super T, ? extends K> classifier, Collector<? super T, ?, D> downstream) {
        if (this.stream.isParallel() && downstream.characteristics().contains((Object)Collector.Characteristics.UNORDERED)) {
            return this.rawCollect(Collectors.groupingByConcurrent(classifier, downstream));
        }
        return this.rawCollect(Collectors.groupingBy(classifier, downstream));
    }

    public <K, D, M extends Map<K, D>> M groupingBy(Function<? super T, ? extends K> classifier, Supplier<M> mapFactory, Collector<? super T, ?, D> downstream) {
        if (this.stream.isParallel() && downstream.characteristics().contains((Object)Collector.Characteristics.UNORDERED) && mapFactory.get() instanceof ConcurrentMap) {
            return (M)((Map)this.rawCollect(Collectors.groupingByConcurrent(classifier, mapFactory, downstream)));
        }
        return (M)((Map)this.rawCollect(Collectors.groupingBy(classifier, mapFactory, downstream)));
    }

    public <K, C extends Collection<T>> Map<K, C> groupingTo(Function<? super T, ? extends K> classifier, Supplier<C> collectionFactory) {
        return this.groupingBy(classifier, Collectors.toCollection(collectionFactory));
    }

    public <K, C extends Collection<T>, M extends Map<K, C>> M groupingTo(Function<? super T, ? extends K> classifier, Supplier<M> mapFactory, Supplier<C> collectionFactory) {
        return this.groupingBy(classifier, mapFactory, Collectors.toCollection(collectionFactory));
    }

    public Map<Boolean, List<T>> partitioningBy(Predicate<? super T> predicate) {
        return (Map)this.collect(Collectors.partitioningBy(predicate));
    }

    public <D> Map<Boolean, D> partitioningBy(Predicate<? super T> predicate, Collector<? super T, ?, D> downstream) {
        return (Map)this.collect(MoreCollectors.partitioningBy(predicate, downstream));
    }

    public <C extends Collection<T>> Map<Boolean, C> partitioningTo(Predicate<? super T> predicate, Supplier<C> collectionFactory) {
        return (Map)this.collect(Collectors.partitioningBy(predicate, Collectors.toCollection(collectionFactory)));
    }

    public String joining() {
        return this.map(String::valueOf).rawCollect(Collectors.joining());
    }

    public String joining(CharSequence delimiter) {
        return this.map(String::valueOf).rawCollect(Collectors.joining(delimiter));
    }

    public String joining(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return this.map(String::valueOf).rawCollect(Collectors.joining(delimiter, prefix, suffix));
    }

    public <U, C extends Collection<U>> C toFlatCollection(Function<? super T, ? extends Collection<U>> mapper, Supplier<C> supplier) {
        return (C)((Collection)this.map(mapper).collect(supplier, Collection::addAll, Collection::addAll));
    }

    public <U> List<U> toFlatList(Function<? super T, ? extends Collection<U>> mapper) {
        return this.toFlatCollection(mapper, ArrayList::new);
    }

    public <V> Map<T, V> toMap(Function<? super T, ? extends V> valMapper) {
        return this.toMap(Function.identity(), valMapper);
    }

    public <K, V> Map<K, V> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valMapper) {
        AbstractMap map = this.stream.isParallel() ? new ConcurrentHashMap() : new HashMap();
        return this.toMapThrowing(keyMapper, valMapper, map);
    }

    public <K, V> Map<K, V> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valMapper, BinaryOperator<V> mergeFunction) {
        return this.rawCollect(Collectors.toMap(keyMapper, valMapper, mergeFunction, HashMap::new));
    }

    public <V> SortedMap<T, V> toSortedMap(Function<? super T, ? extends V> valMapper) {
        return this.toSortedMap(Function.identity(), valMapper);
    }

    public <K, V> SortedMap<K, V> toSortedMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valMapper) {
        AbstractMap map = this.stream.isParallel() ? new ConcurrentSkipListMap() : new TreeMap();
        return this.toMapThrowing(keyMapper, valMapper, map);
    }

    public <K, V> SortedMap<K, V> toSortedMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valMapper, BinaryOperator<V> mergeFunction) {
        return this.rawCollect(Collectors.toMap(keyMapper, valMapper, mergeFunction, TreeMap::new));
    }

    public StreamEx<T> append(T ... values) {
        if (values.length == 0) {
            return this;
        }
        return (StreamEx)this.append(Stream.of(values));
    }

    @Override
    public StreamEx<T> append(Collection<? extends T> collection) {
        if (collection.isEmpty()) {
            return this;
        }
        return (StreamEx)this.append(collection.stream());
    }

    public StreamEx<T> prepend(T ... values) {
        if (values.length == 0) {
            return this;
        }
        return (StreamEx)this.prepend(Stream.of(values));
    }

    @Override
    public StreamEx<T> prepend(Collection<? extends T> collection) {
        if (collection.isEmpty()) {
            return this;
        }
        return (StreamEx)this.prepend(collection.stream());
    }

    public boolean has(T value) {
        return this.anyMatch(Predicate.isEqual(value));
    }

    public StreamEx<T> without(T value) {
        if (value == null) {
            return (StreamEx)this.filter(Objects::nonNull);
        }
        return (StreamEx)this.remove(value::equals);
    }

    public StreamEx<T> reverseSorted() {
        return (StreamEx)this.sorted(Comparator.reverseOrder());
    }

    public StreamEx<T> distinct(long atLeast) {
        if (atLeast <= 1L) {
            return (StreamEx)this.distinct();
        }
        Spliterator spliterator = this.stream.spliterator();
        Spliterator result = spliterator.hasCharacteristics(1) ? Spliterators.emptySpliterator() : new DistinctSpliterator(spliterator, atLeast);
        return this.strategy().newStreamEx(this.delegate(result));
    }

    public <R> StreamEx<R> pairMap(BiFunction<? super T, ? super T, ? extends R> mapper) {
        return this.strategy().newStreamEx(this.delegate(new PairSpliterator.PSOfRef<T, R>(mapper, this.stream.spliterator())));
    }

    public void forPairs(BiConsumer<? super T, ? super T> action) {
        this.pairMap((a, b) -> {
            action.accept(a, b);
            return null;
        }).reduce((Object)null, StreamExInternals.selectFirst());
    }

    public StreamEx<T> collapse(BiPredicate<? super T, ? super T> collapsible, BinaryOperator<T> merger) {
        return this.collapseInternal(collapsible, Function.identity(), merger, merger);
    }

    public <R, A> StreamEx<R> collapse(BiPredicate<? super T, ? super T> collapsible, Collector<? super T, A, R> collector) {
        Supplier supplier = collector.supplier();
        BiConsumer accumulator = collector.accumulator();
        StreamEx<Object> stream = this.collapseInternal(collapsible, t -> {
            Object acc = supplier.get();
            accumulator.accept((Object)acc, (Object)t);
            return acc;
        }, (acc, t) -> {
            accumulator.accept(acc, t);
            return acc;
        }, collector.combiner());
        if (collector.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            StreamEx<Object> result = stream;
            return result;
        }
        return stream.map(collector.finisher());
    }

    public StreamEx<T> collapse(BiPredicate<? super T, ? super T> collapsible) {
        return this.collapse(collapsible, StreamExInternals.selectFirst());
    }

    public EntryStream<T, Long> runLengths() {
        return EntryStream.of(this.collapseInternal(Objects::equals, t -> new StreamExInternals.ObjLongBox<Object>(t, 1L), (acc, t) -> {
            ++acc.b;
            return acc;
        }, (e1, e2) -> {
            e1.b += e2.b;
            return e1;
        }));
    }

    public StreamEx<List<T>> groupRuns(BiPredicate<? super T, ? super T> sameGroup) {
        return this.collapseInternal(sameGroup, Collections::singletonList, (acc, t) -> {
            if (!(acc instanceof ArrayList)) {
                Object old = acc.get(0);
                acc = new ArrayList<Object>();
                acc.add(old);
            }
            acc.add(t);
            return acc;
        }, (acc1, acc2) -> {
            if (!(acc1 instanceof ArrayList)) {
                Object old = acc1.get(0);
                acc1 = new ArrayList();
                acc1.add(old);
            }
            acc1.addAll(acc2);
            return acc1;
        });
    }

    public <U> StreamEx<U> intervalMap(BiPredicate<? super T, ? super T> sameInterval, BiFunction<? super T, ? super T, ? extends U> mapper) {
        return this.collapseInternal(sameInterval, StreamExInternals.PairBox::single, (box, t) -> {
            box.b = t;
            return box;
        }, (left, right) -> {
            left.b = right.b;
            return left;
        }).map((T pair) -> mapper.apply(pair.a, pair.b));
    }

    public static <T> StreamEx<T> empty() {
        return StreamEx.of(Stream.empty());
    }

    public static <T> StreamEx<T> of(T element) {
        return StreamEx.of(Stream.of(element));
    }

    @SafeVarargs
    public static <T> StreamEx<T> of(T ... elements) {
        return StreamEx.of(Stream.of(elements));
    }

    public static <T> StreamEx<T> of(T[] array, int startInclusive, int endExclusive) {
        return StreamEx.of(Arrays.stream(array, startInclusive, endExclusive));
    }

    public static <T> StreamEx<T> of(Collection<T> collection) {
        return StreamEx.of(collection.stream());
    }

    public static <T> StreamEx<T> of(Stream<T> stream) {
        return new StreamEx<T>(StreamExInternals.unwrap(stream));
    }

    public static <T> StreamEx<T> of(Spliterator<T> spliterator) {
        return StreamEx.of(StreamSupport.stream(spliterator, false));
    }

    public static <T> StreamEx<T> of(Iterator<T> iterator) {
        return StreamEx.of(new UnknownSizeSpliterator.USOfRef<T>(iterator));
    }

    public static <T> StreamEx<T> of(final Enumeration<T> enumeration) {
        return StreamEx.of(new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }
        });
    }

    public static <T> StreamEx<T> of(Optional<T> optional) {
        return optional.isPresent() ? StreamEx.of(optional.get()) : StreamEx.empty();
    }

    public static <T> StreamEx<T> ofNullable(T element) {
        return element == null ? StreamEx.empty() : StreamEx.of(element);
    }

    public static StreamEx<String> ofLines(BufferedReader reader) {
        return StreamEx.of(reader.lines());
    }

    public static StreamEx<String> ofLines(Reader reader) {
        if (reader instanceof BufferedReader) {
            return StreamEx.of(((BufferedReader)reader).lines());
        }
        return StreamEx.of(new BufferedReader(reader).lines());
    }

    public static StreamEx<String> ofLines(Path path) throws IOException {
        return StreamEx.of(Files.lines(path));
    }

    public static StreamEx<String> ofLines(Path path, Charset charset) throws IOException {
        return StreamEx.of(Files.lines(path, charset));
    }

    public static <T> StreamEx<T> ofKeys(Map<T, ?> map) {
        return StreamEx.of(map.keySet().stream());
    }

    public static <T, V> StreamEx<T> ofKeys(Map<T, V> map, Predicate<V> valueFilter) {
        return EntryStream.of(map).filterValues(valueFilter).keys();
    }

    public static <T> StreamEx<T> ofValues(Map<?, T> map) {
        return StreamEx.of(map.values().stream());
    }

    public static <K, T> StreamEx<T> ofValues(Map<K, T> map, Predicate<K> keyFilter) {
        return EntryStream.of(map).filterKeys(keyFilter).values();
    }

    public static StreamEx<int[]> ofPermutations(int length) {
        return StreamEx.of(new PermutationSpliterator(length));
    }

    public static StreamEx<String> split(CharSequence str, Pattern pattern) {
        if (str.length() == 0) {
            return StreamEx.of("");
        }
        return StreamEx.of(pattern.splitAsStream(str));
    }

    public static StreamEx<String> split(CharSequence str, String regex) {
        if (str.length() == 0) {
            return StreamEx.of("");
        }
        if (regex.isEmpty()) {
            return IntStreamEx.ofChars(str).mapToObj(ch -> new String(new char[]{(char)ch}));
        }
        char ch2 = regex.charAt(0);
        if (regex.length() == 1 && ".$|()[{^?*+\\".indexOf(ch2) == -1) {
            return StreamEx.split(str, ch2);
        }
        if (!(regex.length() != 2 || ch2 != '\\' || (ch2 = regex.charAt(1)) >= '0' && ch2 <= '9' || ch2 >= 'A' && ch2 <= 'Z' || ch2 >= 'a' && ch2 <= 'z' || ch2 >= '\ud800' && ch2 <= '\udfff')) {
            return StreamEx.split(str, ch2);
        }
        return StreamEx.of(Pattern.compile(regex).splitAsStream(str));
    }

    public static StreamEx<String> split(CharSequence str, char delimiter) {
        return StreamEx.split(str, delimiter, true);
    }

    public static StreamEx<String> split(CharSequence str, char delimiter, boolean trimEmpty) {
        if (str.length() == 0) {
            return StreamEx.of("");
        }
        return StreamEx.of(new CharSpliterator(str, delimiter, trimEmpty));
    }

    public static <T> StreamEx<T> iterate(T seed, UnaryOperator<T> f) {
        return StreamEx.of(Stream.iterate(seed, f));
    }

    public static <T> StreamEx<T> generate(Supplier<T> s) {
        return StreamEx.of(Stream.generate(s));
    }

    public static <T> StreamEx<T> constant(T value, long length) {
        return StreamEx.of(new ConstSpliterator.OfRef<T>(value, length));
    }

    public static <U, T> StreamEx<T> ofPairs(List<U> list, BiFunction<? super U, ? super U, ? extends T> mapper) {
        return StreamEx.of(new PairPermutationSpliterator<U, T>(list, mapper));
    }

    public static <U, T> StreamEx<T> ofPairs(U[] array, BiFunction<? super U, ? super U, ? extends T> mapper) {
        return StreamEx.ofPairs(Arrays.asList(array), mapper);
    }

    public static <U, V, T> StreamEx<T> zip(List<U> first, List<V> second, BiFunction<? super U, ? super V, ? extends T> mapper) {
        return StreamEx.of(new RangeBasedSpliterator.ZipRef<U, V, T>(0, StreamExInternals.checkLength(first.size(), second.size()), mapper, first, second));
    }

    public static <U, V, T> StreamEx<T> zip(U[] first, V[] second, BiFunction<? super U, ? super V, ? extends T> mapper) {
        return StreamEx.zip(Arrays.asList(first), Arrays.asList(second), mapper);
    }

    public static <T> StreamEx<T> ofTree(T root, Function<T, Stream<T>> mapper) {
        Stream<T> rootStream = mapper.apply(root);
        return rootStream == null ? StreamEx.of(root) : (StreamEx)StreamEx.of(StreamExInternals.flatTraverse(rootStream, mapper)).prepend(Stream.of(root));
    }

    public static <T, TT extends T> StreamEx<T> ofTree(T root, Class<TT> collectionClass, Function<TT, Stream<T>> mapper) {
        return StreamEx.ofTree(root, t -> collectionClass.isInstance(t) ? (Stream)mapper.apply(t) : null);
    }

    public static <T> StreamEx<List<T>> ofSubLists(List<T> source, int length) {
        return StreamEx.ofSubLists(source, length, length);
    }

    public static <T> StreamEx<List<T>> ofSubLists(List<T> source, int length, int shift) {
        if (length <= 0) {
            throw new IllegalArgumentException("length = " + length);
        }
        if (shift <= 0) {
            throw new IllegalArgumentException("shift = " + shift);
        }
        if (source.isEmpty()) {
            return StreamEx.empty();
        }
        return StreamEx.of(new RangeBasedSpliterator.OfSubLists<T>(source, length, shift));
    }

    public static <T> StreamEx<List<T>> cartesianProduct(Collection<? extends Collection<T>> source) {
        if (source.isEmpty()) {
            return StreamEx.of(Stream.of(Collections.emptyList()));
        }
        return StreamEx.of(new CrossSpliterator.ToList(source));
    }

    public static <T, U> StreamEx<U> cartesianProduct(Collection<? extends Collection<T>> source, U identity, BiFunction<U, ? super T, U> accumulator) {
        if (source.isEmpty()) {
            return StreamEx.of(identity);
        }
        return StreamEx.of(new CrossSpliterator.Reducing<T, U>(source, identity, accumulator));
    }

    public static <T> StreamEx<List<T>> cartesianPower(int n, Collection<T> source) {
        if (n == 0) {
            return StreamEx.of(Stream.of(Collections.emptyList()));
        }
        return StreamEx.of(new CrossSpliterator.ToList<T>(Collections.nCopies(n, source)));
    }

    public static <T, U> StreamEx<U> cartesianPower(int n, Collection<T> source, U identity, BiFunction<U, ? super T, U> accumulator) {
        if (n == 0) {
            return StreamEx.of(identity);
        }
        return StreamEx.of(new CrossSpliterator.Reducing<T, U>(Collections.nCopies(n, source), identity, accumulator));
    }
}

