/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.Iterator;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;

abstract class UnknownSizeSpliterator<T, I extends Iterator<? extends T>>
implements Spliterator<T> {
    static final int BATCH_UNIT = 1024;
    static final int MAX_BATCH = 0x2000000;
    I it;
    int index;
    int fence;

    public UnknownSizeSpliterator(I iterator) {
        this.it = iterator;
    }

    UnknownSizeSpliterator(int index, int fence) {
        this.index = index;
        this.fence = fence;
    }

    int getN() {
        int n = this.fence + 1024;
        return n > 0x2000000 ? 0x2000000 : n;
    }

    @Override
    public long estimateSize() {
        return this.it == null ? (long)(this.fence - this.index) : Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return this.it == null ? 16464 : 16;
    }

    static class USOfDouble
    extends UnknownSizeSpliterator<Double, PrimitiveIterator.OfDouble>
    implements Spliterator.OfDouble {
        double[] array;

        USOfDouble(PrimitiveIterator.OfDouble iterator) {
            super(iterator);
        }

        USOfDouble(double[] array, int index, int fence) {
            super(index, fence);
            this.array = array;
        }

        @Override
        public Spliterator.OfDouble trySplit() {
            USOfDouble uSOfDouble;
            int mid;
            int lo;
            PrimitiveIterator.OfDouble i = (PrimitiveIterator.OfDouble)this.it;
            if (i != null) {
                int n = this.getN();
                double[] a = new double[n];
                int j = 0;
                do {
                    a[j] = i.next();
                } while (++j < n && i.hasNext());
                this.fence = j;
                if (i.hasNext()) {
                    return new USOfDouble(a, 0, j);
                }
                this.it = null;
                this.array = a;
            }
            if ((lo = this.index) >= (mid = lo + this.fence >>> 1)) {
                uSOfDouble = null;
            } else {
                this.index = mid;
                USOfDouble uSOfDouble2 = new USOfDouble(this.array, lo, this.index);
                uSOfDouble = uSOfDouble2;
            }
            return uSOfDouble;
        }

        @Override
        public void forEachRemaining(DoubleConsumer action) {
            if (this.it != null) {
                ((PrimitiveIterator.OfDouble)this.it).forEachRemaining(action);
            } else {
                double[] a = this.array;
                int i = this.index;
                int hi = this.fence;
                if (i < hi && a.length >= hi) {
                    do {
                        action.accept(a[i]);
                    } while (++i < hi);
                }
            }
            this.index = this.fence;
        }

        @Override
        public boolean tryAdvance(DoubleConsumer action) {
            if (this.it != null) {
                if (((PrimitiveIterator.OfDouble)this.it).hasNext()) {
                    action.accept(((PrimitiveIterator.OfDouble)this.it).nextDouble());
                    return true;
                }
                this.it = null;
                this.index = this.fence;
            } else if (this.index < this.fence) {
                action.accept(this.array[this.index++]);
                return true;
            }
            return false;
        }
    }

    static class USOfLong
    extends UnknownSizeSpliterator<Long, PrimitiveIterator.OfLong>
    implements Spliterator.OfLong {
        long[] array;

        USOfLong(PrimitiveIterator.OfLong iterator) {
            super(iterator);
        }

        USOfLong(long[] array, int index, int fence) {
            super(index, fence);
            this.array = array;
        }

        @Override
        public Spliterator.OfLong trySplit() {
            USOfLong uSOfLong;
            int mid;
            int lo;
            PrimitiveIterator.OfLong i = (PrimitiveIterator.OfLong)this.it;
            if (i != null) {
                int n = this.getN();
                long[] a = new long[n];
                int j = 0;
                do {
                    a[j] = i.next();
                } while (++j < n && i.hasNext());
                this.fence = j;
                if (i.hasNext()) {
                    return new USOfLong(a, 0, j);
                }
                this.it = null;
                this.array = a;
            }
            if ((lo = this.index) >= (mid = lo + this.fence >>> 1)) {
                uSOfLong = null;
            } else {
                this.index = mid;
                USOfLong uSOfLong2 = new USOfLong(this.array, lo, this.index);
                uSOfLong = uSOfLong2;
            }
            return uSOfLong;
        }

        @Override
        public void forEachRemaining(LongConsumer action) {
            if (this.it != null) {
                ((PrimitiveIterator.OfLong)this.it).forEachRemaining(action);
            } else {
                long[] a = this.array;
                int i = this.index;
                int hi = this.fence;
                if (i < hi && a.length >= hi) {
                    do {
                        action.accept(a[i]);
                    } while (++i < hi);
                }
            }
            this.index = this.fence;
        }

        @Override
        public boolean tryAdvance(LongConsumer action) {
            if (this.it != null) {
                if (((PrimitiveIterator.OfLong)this.it).hasNext()) {
                    action.accept(((PrimitiveIterator.OfLong)this.it).nextLong());
                    return true;
                }
                this.it = null;
                this.index = this.fence;
            } else if (this.index < this.fence) {
                action.accept(this.array[this.index++]);
                return true;
            }
            return false;
        }
    }

    static class USOfInt
    extends UnknownSizeSpliterator<Integer, PrimitiveIterator.OfInt>
    implements Spliterator.OfInt {
        int[] array;

        USOfInt(PrimitiveIterator.OfInt iterator) {
            super(iterator);
        }

        USOfInt(int[] array, int index, int fence) {
            super(index, fence);
            this.array = array;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            USOfInt uSOfInt;
            int mid;
            int lo;
            PrimitiveIterator.OfInt i = (PrimitiveIterator.OfInt)this.it;
            if (i != null) {
                int n = this.getN();
                int[] a = new int[n];
                int j = 0;
                do {
                    a[j] = i.next();
                } while (++j < n && i.hasNext());
                this.fence = j;
                if (i.hasNext()) {
                    return new USOfInt(a, 0, j);
                }
                this.it = null;
                this.array = a;
            }
            if ((lo = this.index) >= (mid = lo + this.fence >>> 1)) {
                uSOfInt = null;
            } else {
                this.index = mid;
                USOfInt uSOfInt2 = new USOfInt(this.array, lo, this.index);
                uSOfInt = uSOfInt2;
            }
            return uSOfInt;
        }

        @Override
        public void forEachRemaining(IntConsumer action) {
            if (this.it != null) {
                ((PrimitiveIterator.OfInt)this.it).forEachRemaining(action);
            } else {
                int[] a = this.array;
                int i = this.index;
                int hi = this.fence;
                if (i < hi && a.length >= hi) {
                    do {
                        action.accept(a[i]);
                    } while (++i < hi);
                }
            }
            this.index = this.fence;
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            if (this.it != null) {
                if (((PrimitiveIterator.OfInt)this.it).hasNext()) {
                    action.accept(((PrimitiveIterator.OfInt)this.it).nextInt());
                    return true;
                }
                this.it = null;
                this.index = this.fence;
            } else if (this.index < this.fence) {
                action.accept(this.array[this.index++]);
                return true;
            }
            return false;
        }
    }

    static class USOfRef<T>
    extends UnknownSizeSpliterator<T, Iterator<? extends T>> {
        Object[] array;

        USOfRef(Iterator<? extends T> iterator) {
            super(iterator);
        }

        USOfRef(Object[] array, int index, int fence) {
            super(index, fence);
            this.array = array;
        }

        @Override
        public Spliterator<T> trySplit() {
            USOfRef<T> uSOfRef;
            int mid;
            int lo;
            Iterator i = this.it;
            if (i != null) {
                int n = this.getN();
                Object[] a = new Object[n];
                int j = 0;
                do {
                    a[j] = i.next();
                } while (++j < n && i.hasNext());
                this.fence = j;
                if (i.hasNext()) {
                    return new USOfRef<T>(a, 0, j);
                }
                this.it = null;
                this.array = a;
            }
            if ((lo = this.index) >= (mid = lo + this.fence >>> 1)) {
                uSOfRef = null;
            } else {
                this.index = mid;
                USOfRef<T> uSOfRef2 = new USOfRef<T>(this.array, lo, this.index);
                uSOfRef = uSOfRef2;
            }
            return uSOfRef;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            if (this.it != null) {
                this.it.forEachRemaining(action);
            } else {
                Object[] a = this.array;
                int i = this.index;
                int hi = this.fence;
                if (i < hi && a.length >= hi) {
                    do {
                        Object t = a[i];
                        action.accept(t);
                    } while (++i < hi);
                }
            }
            this.index = this.fence;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if (this.it != null) {
                if (this.it.hasNext()) {
                    action.accept(this.it.next());
                    return true;
                }
                this.it = null;
                this.index = this.fence;
            } else if (this.index < this.fence) {
                Object t = this.array[this.index++];
                action.accept(t);
                return true;
            }
            return false;
        }
    }
}

