/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import one.util.streamex.DoubleStreamEx;
import one.util.streamex.IntStreamEx;
import one.util.streamex.LongStreamEx;
import one.util.streamex.OrderedCancellableSpliterator;
import one.util.streamex.StreamEx;
import one.util.streamex.StreamExInternals;
import one.util.streamex.StreamFactory;
import one.util.streamex.UnorderedCancellableSpliterator;

abstract class AbstractStreamEx<T, S extends AbstractStreamEx<T, S>>
implements Stream<T>,
Iterable<T> {
    final Stream<T> stream;

    AbstractStreamEx(Stream<T> stream) {
        this.stream = stream;
    }

    StreamFactory strategy() {
        return StreamFactory.DEFAULT;
    }

    final <R> Stream<R> delegate(Spliterator<R> spliterator) {
        return (Stream)StreamSupport.stream(spliterator, this.stream.isParallel()).onClose(this.stream::close);
    }

    final S callWhile(Predicate<? super T> predicate, int methodId) {
        try {
            return this.supply(StreamExInternals.JDK9_METHODS[0][methodId].invokeExact(this.stream, predicate));
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InternalError(e);
        }
    }

    final <K, V, M extends Map<K, V>> M toMapThrowing(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valMapper, M map) {
        this.forEach(t -> this.addToMap(map, keyMapper.apply(t), Objects.requireNonNull(valMapper.apply(t))));
        return map;
    }

    final <K, V, M extends Map<K, V>> void addToMap(M map, K key, V val) {
        V oldVal = map.putIfAbsent(key, val);
        if (oldVal != null) {
            throw new IllegalStateException("Duplicate entry for key '" + key + "' (attempt to merge values '" + oldVal + "' and '" + val + "')");
        }
    }

    <R, A> R rawCollect(Collector<? super T, A, R> collector) {
        return this.stream.collect(collector);
    }

    abstract S supply(Stream<T> var1);

    @Override
    public Iterator<T> iterator() {
        return this.stream.iterator();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.stream.spliterator();
    }

    @Override
    public boolean isParallel() {
        return this.stream.isParallel();
    }

    @Override
    public S unordered() {
        return this.supply((Stream)this.stream.unordered());
    }

    @Override
    public S onClose(Runnable closeHandler) {
        return this.supply((Stream)this.stream.onClose(closeHandler));
    }

    @Override
    public void close() {
        this.stream.close();
    }

    public S filter(Predicate<? super T> predicate) {
        return this.supply(this.stream.filter(predicate));
    }

    @Override
    public <R> StreamEx<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        return this.strategy().newStreamEx(this.stream.flatMap(mapper));
    }

    @Override
    public <R> StreamEx<R> map(Function<? super T, ? extends R> mapper) {
        return this.strategy().newStreamEx(this.stream.map(mapper));
    }

    @Override
    public IntStreamEx mapToInt(ToIntFunction<? super T> mapper) {
        return this.strategy().newIntStreamEx(this.stream.mapToInt(mapper));
    }

    @Override
    public LongStreamEx mapToLong(ToLongFunction<? super T> mapper) {
        return this.strategy().newLongStreamEx(this.stream.mapToLong(mapper));
    }

    @Override
    public DoubleStreamEx mapToDouble(ToDoubleFunction<? super T> mapper) {
        return this.strategy().newDoubleStreamEx(this.stream.mapToDouble(mapper));
    }

    @Override
    public IntStreamEx flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        return this.strategy().newIntStreamEx(this.stream.flatMapToInt(mapper));
    }

    @Override
    public LongStreamEx flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        return this.strategy().newLongStreamEx(this.stream.flatMapToLong(mapper));
    }

    @Override
    public DoubleStreamEx flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        return this.strategy().newDoubleStreamEx(this.stream.flatMapToDouble(mapper));
    }

    public S distinct() {
        return this.supply(this.stream.distinct());
    }

    public S distinct(Function<? super T, ?> keyExtractor) {
        return this.supply(this.stream.map((? super T t) -> new StreamExInternals.PairBox(t, keyExtractor.apply(t))).distinct().map((? super T box) -> box.a));
    }

    public S sorted() {
        return this.supply(this.stream.sorted());
    }

    public S sorted(Comparator<? super T> comparator) {
        return this.supply(this.stream.sorted(comparator));
    }

    public S peek(Consumer<? super T> action) {
        return this.supply(this.stream.peek(action));
    }

    public S limit(long maxSize) {
        return this.supply(this.stream.limit(maxSize));
    }

    public S skip(long n) {
        return this.supply(this.stream.skip(n));
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.stream.forEach(action);
    }

    @Override
    public void forEachOrdered(Consumer<? super T> action) {
        this.stream.forEachOrdered(action);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(Object[]::new);
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.stream.toArray(generator);
    }

    @Override
    public T reduce(T identity, BinaryOperator<T> accumulator) {
        return this.stream.reduce(identity, accumulator);
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> accumulator) {
        return this.stream.reduce(accumulator);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        return this.stream.reduce(identity, accumulator, combiner);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        return this.stream.collect(supplier, accumulator, combiner);
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        Predicate finished = StreamExInternals.finished(collector);
        if (finished != null) {
            BiConsumer acc = collector.accumulator();
            BinaryOperator<A> combiner = collector.combiner();
            Spliterator<Object> spliterator = this.stream.spliterator();
            if (!this.isParallel()) {
                Object a = collector.supplier().get();
                if (!finished.test(a)) {
                    try {
                        spliterator.forEachRemaining(e -> {
                            acc.accept(a, (Object)e);
                            if (finished.test(a)) {
                                throw new StreamExInternals.CancelException();
                            }
                        });
                    }
                    catch (StreamExInternals.CancelException ex) {
                        // empty catch block
                    }
                }
                return collector.finisher().apply(a);
            }
            Cloneable spltr = !spliterator.hasCharacteristics(16) || collector.characteristics().contains((Object)Collector.Characteristics.UNORDERED) ? new UnorderedCancellableSpliterator<T, A>(spliterator, collector.supplier(), acc, combiner, finished) : new OrderedCancellableSpliterator<T, A>(spliterator, collector.supplier(), acc, combiner, finished);
            return collector.finisher().apply(this.strategy().newStreamEx(StreamSupport.stream(spltr, true)).findFirst().get());
        }
        return this.rawCollect(collector);
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) {
        return this.reduce(BinaryOperator.minBy(comparator));
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) {
        return this.reduce(BinaryOperator.maxBy(comparator));
    }

    @Override
    public long count() {
        return this.stream.count();
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        return this.stream.anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        return this.stream.allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        return !this.anyMatch(predicate);
    }

    @Override
    public Optional<T> findFirst() {
        return this.stream.findFirst();
    }

    @Override
    public Optional<T> findAny() {
        return this.stream.findAny();
    }

    public OptionalLong indexOf(T element) {
        return this.indexOf(Predicate.isEqual(element));
    }

    public OptionalLong indexOf(Predicate<? super T> predicate) {
        return this.collect(new StreamExInternals.CancellableCollectorImpl<Object, long[], OptionalLong>(() -> new long[]{-1L}, (acc, t) -> {
            if (acc[0] < 0L) {
                acc[0] = predicate.test(t) ? -acc[0] - 1L : acc[0] - 1L;
            }
        }, (acc1, acc2) -> {
            if (acc1[0] < 0L) {
                acc1[0] = acc2[0] < 0L ? acc1[0] + acc2[0] + 1L : acc2[0] - acc1[0] - 1L;
            }
            return acc1;
        }, acc -> acc[0] < 0L ? OptionalLong.empty() : OptionalLong.of(acc[0]), acc -> acc[0] >= 0L, StreamExInternals.NO_CHARACTERISTICS));
    }

    public <R> StreamEx<R> flatCollection(Function<? super T, ? extends Collection<? extends R>> mapper) {
        return this.flatMap((T t) -> {
            Collection c = (Collection)mapper.apply(t);
            return c == null ? null : c.stream();
        });
    }

    public S remove(Predicate<? super T> predicate) {
        return (S)this.filter((Predicate)predicate.negate());
    }

    public S nonNull() {
        return (S)this.filter(Objects::nonNull);
    }

    public Optional<T> findAny(Predicate<? super T> predicate) {
        return ((AbstractStreamEx)this.filter((Predicate)predicate)).findAny();
    }

    public Optional<T> findFirst(Predicate<? super T> predicate) {
        return ((AbstractStreamEx)this.filter((Predicate)predicate)).findFirst();
    }

    public S reverseSorted(Comparator<? super T> comparator) {
        return (S)this.sorted((Comparator)comparator.reversed());
    }

    public <V extends Comparable<? super V>> S sortedBy(Function<? super T, ? extends V> keyExtractor) {
        return (S)this.sorted((Comparator)Comparator.comparing(keyExtractor));
    }

    public S sortedByInt(ToIntFunction<? super T> keyExtractor) {
        return (S)this.sorted((Comparator)Comparator.comparingInt(keyExtractor));
    }

    public S sortedByLong(ToLongFunction<? super T> keyExtractor) {
        return (S)this.sorted((Comparator)Comparator.comparingLong(keyExtractor));
    }

    public S sortedByDouble(ToDoubleFunction<? super T> keyExtractor) {
        return (S)this.sorted((Comparator)Comparator.comparingDouble(keyExtractor));
    }

    public <V extends Comparable<? super V>> Optional<T> minBy(Function<? super T, ? extends V> keyExtractor) {
        return StreamExInternals.Box.asOptional(this.reduce(null, (acc, t) -> {
            Comparable val = (Comparable)keyExtractor.apply(t);
            if (acc == null) {
                return new StreamExInternals.PairBox<Object, Comparable>(t, val);
            }
            if (val.compareTo(acc.b) < 0) {
                acc.b = val;
                acc.a = t;
            }
            return acc;
        }, (acc1, acc2) -> acc1 == null || acc2 != null && ((Comparable)acc1.b).compareTo(acc2.b) > 0 ? acc2 : acc1));
    }

    public Optional<T> minByInt(ToIntFunction<? super T> keyExtractor) {
        return StreamExInternals.Box.asOptional(this.reduce(null, (acc, t) -> {
            int val = keyExtractor.applyAsInt(t);
            if (acc == null) {
                return new StreamExInternals.ObjIntBox<Object>(t, val);
            }
            if (val < acc.b) {
                acc.b = val;
                acc.a = t;
            }
            return acc;
        }, (acc1, acc2) -> acc1 == null || acc2 != null && acc1.b > acc2.b ? acc2 : acc1));
    }

    public Optional<T> minByLong(ToLongFunction<? super T> keyExtractor) {
        return StreamExInternals.Box.asOptional(this.reduce(null, (acc, t) -> {
            long val = keyExtractor.applyAsLong(t);
            if (acc == null) {
                return new StreamExInternals.ObjLongBox<Object>(t, val);
            }
            if (val < acc.b) {
                acc.b = val;
                acc.a = t;
            }
            return acc;
        }, (acc1, acc2) -> acc1 == null || acc2 != null && acc1.b > acc2.b ? acc2 : acc1));
    }

    public Optional<T> minByDouble(ToDoubleFunction<? super T> keyExtractor) {
        return StreamExInternals.Box.asOptional(this.reduce(null, (acc, t) -> {
            double val = keyExtractor.applyAsDouble(t);
            if (acc == null) {
                return new StreamExInternals.ObjDoubleBox<Object>(t, val);
            }
            if (Double.compare(val, acc.b) < 0) {
                acc.b = val;
                acc.a = t;
            }
            return acc;
        }, (acc1, acc2) -> acc1 == null || acc2 != null && Double.compare(acc1.b, acc2.b) > 0 ? acc2 : acc1));
    }

    public <V extends Comparable<? super V>> Optional<T> maxBy(Function<? super T, ? extends V> keyExtractor) {
        return StreamExInternals.Box.asOptional(this.reduce(null, (acc, t) -> {
            Comparable val = (Comparable)keyExtractor.apply(t);
            if (acc == null) {
                return new StreamExInternals.PairBox<Object, Comparable>(t, val);
            }
            if (val.compareTo(acc.b) > 0) {
                acc.b = val;
                acc.a = t;
            }
            return acc;
        }, (acc1, acc2) -> acc1 == null || acc2 != null && ((Comparable)acc1.b).compareTo(acc2.b) < 0 ? acc2 : acc1));
    }

    public Optional<T> maxByInt(ToIntFunction<? super T> keyExtractor) {
        return StreamExInternals.Box.asOptional(this.reduce(null, (acc, t) -> {
            int val = keyExtractor.applyAsInt(t);
            if (acc == null) {
                return new StreamExInternals.ObjIntBox<Object>(t, val);
            }
            if (val > acc.b) {
                acc.b = val;
                acc.a = t;
            }
            return acc;
        }, (acc1, acc2) -> acc1 == null || acc2 != null && acc1.b < acc2.b ? acc2 : acc1));
    }

    public Optional<T> maxByLong(ToLongFunction<? super T> keyExtractor) {
        return StreamExInternals.Box.asOptional(this.reduce(null, (acc, t) -> {
            long val = keyExtractor.applyAsLong(t);
            if (acc == null) {
                return new StreamExInternals.ObjLongBox<Object>(t, val);
            }
            if (val > acc.b) {
                acc.b = val;
                acc.a = t;
            }
            return acc;
        }, (acc1, acc2) -> acc1 == null || acc2 != null && acc1.b < acc2.b ? acc2 : acc1));
    }

    public Optional<T> maxByDouble(ToDoubleFunction<? super T> keyExtractor) {
        return StreamExInternals.Box.asOptional(this.reduce(null, (acc, t) -> {
            double val = keyExtractor.applyAsDouble(t);
            if (acc == null) {
                return new StreamExInternals.ObjDoubleBox<Object>(t, val);
            }
            if (Double.compare(val, acc.b) > 0) {
                acc.b = val;
                acc.a = t;
            }
            return acc;
        }, (acc1, acc2) -> acc1 == null || acc2 != null && Double.compare(acc1.b, acc2.b) < 0 ? acc2 : acc1));
    }

    public S append(Stream<? extends T> other) {
        return this.supply(Stream.concat(this.stream, StreamExInternals.unwrap(other)));
    }

    public S prepend(Stream<? extends T> other) {
        return this.supply(Stream.concat(StreamExInternals.unwrap(other), this.stream));
    }

    @Override
    public List<T> toList() {
        return new ArrayList<Object>(new StreamExInternals.ArrayCollection(this.toArray(Object[]::new)));
    }

    public <R> R toListAndThen(Function<List<T>, R> finisher) {
        return finisher.apply(this.toList());
    }

    public Set<T> toSet() {
        return this.rawCollect(Collectors.toSet());
    }

    public <R> R toSetAndThen(Function<Set<T>, R> finisher) {
        return this.rawCollect(Collectors.collectingAndThen(Collectors.toSet(), finisher));
    }

    public <C extends Collection<T>> C toCollection(Supplier<C> collectionFactory) {
        return (C)((Collection)this.rawCollect(Collectors.toCollection(collectionFactory)));
    }

    public <U> U foldLeft(U seed, BiFunction<U, ? super T, U> accumulator) {
        StreamExInternals.Box<U> result = new StreamExInternals.Box<U>(seed);
        this.forEachOrdered(t -> {
            box.a = accumulator.apply((Object)box.a, (Object)t);
        });
        return (U)result.a;
    }

    public Optional<T> foldLeft(BinaryOperator<T> accumulator) {
        StreamExInternals.Box result = new StreamExInternals.Box(StreamExInternals.none());
        this.forEachOrdered(t -> {
            box.a = box.a == StreamExInternals.NONE ? t : accumulator.apply(box.a, t);
        });
        return result.a == StreamExInternals.NONE ? Optional.empty() : Optional.of(result.a);
    }

    public <U> U foldRight(U seed, BiFunction<? super T, U, U> accumulator) {
        return (U)this.toListAndThen(list -> {
            Object result = seed;
            for (int i = list.size() - 1; i >= 0; --i) {
                result = accumulator.apply((Object)list.get(i), (Object)result);
            }
            return result;
        });
    }

    public Optional<T> foldRight(BinaryOperator<T> accumulator) {
        return this.toListAndThen(list -> {
            if (list.isEmpty()) {
                return Optional.empty();
            }
            int i = list.size() - 1;
            Object result = list.get(i--);
            while (i >= 0) {
                result = accumulator.apply(list.get(i), result);
                --i;
            }
            return Optional.of(result);
        });
    }

    public <U> List<U> scanLeft(U seed, BiFunction<U, ? super T, U> accumulator) {
        ArrayList result = new ArrayList();
        result.add(seed);
        this.forEachOrdered(t -> result.add(accumulator.apply((Object)result.get(result.size() - 1), (Object)t)));
        return result;
    }

    public List<T> scanLeft(BinaryOperator<T> accumulator) {
        ArrayList result = new ArrayList();
        this.forEachOrdered(t -> {
            if (result.isEmpty()) {
                result.add(t);
            } else {
                result.add(accumulator.apply(result.get(result.size() - 1), t));
            }
        });
        return result;
    }

    public <U> List<U> scanRight(U seed, BiFunction<? super T, U, U> accumulator) {
        return this.toListAndThen(list -> {
            List result = list;
            result.add(seed);
            for (int i = result.size() - 2; i >= 0; --i) {
                result.set(i, accumulator.apply((Object)result.get(i), (Object)result.get(i + 1)));
            }
            return result;
        });
    }

    public List<T> scanRight(BinaryOperator<T> accumulator) {
        return this.toListAndThen(list -> {
            for (int i = list.size() - 2; i >= 0; --i) {
                list.set(i, accumulator.apply(list.get(i), list.get(i + 1)));
            }
            return list;
        });
    }

    public S skipOrdered(long n) {
        return this.supply(this.delegate((this.stream.isParallel() ? StreamSupport.stream(this.stream.spliterator(), false) : this.stream).skip(n).spliterator()));
    }

    public S takeWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (StreamExInternals.JDK9_METHODS != null) {
            return this.callWhile(predicate, 0);
        }
        return this.supply(this.delegate(new TDOfRef<T>(this.stream.spliterator(), false, predicate)));
    }

    public S dropWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (StreamExInternals.JDK9_METHODS != null) {
            return this.callWhile(predicate, 1);
        }
        return this.supply(this.delegate(new TDOfRef<T>(this.stream.spliterator(), true, predicate)));
    }

    private static final class TDOfRef<T>
    extends Spliterators.AbstractSpliterator<T>
    implements Consumer<T> {
        private final Predicate<? super T> predicate;
        private final boolean drop;
        private boolean checked;
        private final Spliterator<T> source;
        private T cur;

        TDOfRef(Spliterator<T> source, boolean drop, Predicate<? super T> predicate) {
            super(source.estimateSize(), source.characteristics() & 0x1515);
            this.drop = drop;
            this.predicate = predicate;
            this.source = source;
        }

        @Override
        public Comparator<? super T> getComparator() {
            return this.source.getComparator();
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if (this.drop) {
                if (this.checked) {
                    return this.source.tryAdvance(action);
                }
                while (this.source.tryAdvance(this)) {
                    if (this.predicate.test(this.cur)) continue;
                    this.checked = true;
                    action.accept(this.cur);
                    return true;
                }
                return false;
            }
            if (!this.checked && this.source.tryAdvance(this) && this.predicate.test(this.cur)) {
                action.accept(this.cur);
                return true;
            }
            this.checked = true;
            return false;
        }

        @Override
        public void accept(T t) {
            this.cur = t;
        }
    }
}

