/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LongSummaryStatistics;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Random;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ForkJoinPool;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongSupplier;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import one.util.streamex.ConstSpliterator;
import one.util.streamex.DoubleStreamEx;
import one.util.streamex.EntryStream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.LongCollector;
import one.util.streamex.PairSpliterator;
import one.util.streamex.RangeBasedSpliterator;
import one.util.streamex.StreamEx;
import one.util.streamex.StreamExInternals;
import one.util.streamex.StreamFactory;
import one.util.streamex.UnknownSizeSpliterator;

public class LongStreamEx
implements LongStream {
    final LongStream stream;

    LongStreamEx(LongStream stream) {
        this.stream = stream;
    }

    StreamFactory strategy() {
        return StreamFactory.DEFAULT;
    }

    final LongStreamEx delegate(Spliterator.OfLong spliterator) {
        return this.strategy().newLongStreamEx(StreamExInternals.delegateClose(StreamSupport.longStream(spliterator, this.stream.isParallel()), this.stream));
    }

    final LongStreamEx callWhile(LongPredicate predicate, int methodId) {
        try {
            return this.strategy().newLongStreamEx(StreamExInternals.JDK9_METHODS[2][methodId].invokeExact(this.stream, predicate));
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InternalError(e);
        }
    }

    @Override
    public boolean isParallel() {
        return this.stream.isParallel();
    }

    @Override
    public LongStreamEx unordered() {
        return this.strategy().newLongStreamEx((LongStream)this.stream.unordered());
    }

    @Override
    public LongStreamEx onClose(Runnable closeHandler) {
        return this.strategy().newLongStreamEx((LongStream)this.stream.onClose(closeHandler));
    }

    @Override
    public void close() {
        this.stream.close();
    }

    @Override
    public LongStreamEx filter(LongPredicate predicate) {
        return this.strategy().newLongStreamEx(this.stream.filter(predicate));
    }

    public LongStreamEx remove(LongPredicate predicate) {
        return this.filter(predicate.negate());
    }

    public boolean has(long value) {
        return this.anyMatch(x -> x == value);
    }

    public LongStreamEx without(long value) {
        return this.filter(val -> val != value);
    }

    public LongStreamEx greater(long value) {
        return this.filter(val -> val > value);
    }

    public LongStreamEx atLeast(long value) {
        return this.filter(val -> val >= value);
    }

    public LongStreamEx less(long value) {
        return this.filter(val -> val < value);
    }

    public LongStreamEx atMost(long value) {
        return this.filter(val -> val <= value);
    }

    @Override
    public LongStreamEx map(LongUnaryOperator mapper) {
        return this.strategy().newLongStreamEx(this.stream.map(mapper));
    }

    public LongStreamEx mapFirst(LongUnaryOperator mapper) {
        return this.delegate(new PairSpliterator.PSOfLong((a, b) -> b, mapper, this.stream.spliterator(), 1));
    }

    public LongStreamEx mapLast(LongUnaryOperator mapper) {
        return this.delegate(new PairSpliterator.PSOfLong((a, b) -> a, mapper, this.stream.spliterator(), 2));
    }

    public <U> StreamEx<U> mapToObj(LongFunction<? extends U> mapper) {
        return this.strategy().newStreamEx(this.stream.mapToObj(mapper));
    }

    @Override
    public IntStreamEx mapToInt(LongToIntFunction mapper) {
        return this.strategy().newIntStreamEx(this.stream.mapToInt(mapper));
    }

    @Override
    public DoubleStreamEx mapToDouble(LongToDoubleFunction mapper) {
        return this.strategy().newDoubleStreamEx(this.stream.mapToDouble(mapper));
    }

    public <K, V> EntryStream<K, V> mapToEntry(LongFunction<? extends K> keyMapper, LongFunction<? extends V> valueMapper) {
        return this.strategy().newEntryStream(this.stream.mapToObj((long t) -> new AbstractMap.SimpleImmutableEntry(keyMapper.apply(t), valueMapper.apply(t))));
    }

    @Override
    public LongStreamEx flatMap(LongFunction<? extends LongStream> mapper) {
        return this.strategy().newLongStreamEx(this.stream.flatMap(mapper));
    }

    public IntStreamEx flatMapToInt(LongFunction<? extends IntStream> mapper) {
        return this.strategy().newIntStreamEx(this.stream.mapToObj(mapper).flatMapToInt(Function.identity()));
    }

    public DoubleStreamEx flatMapToDouble(LongFunction<? extends DoubleStream> mapper) {
        return this.strategy().newDoubleStreamEx(this.stream.mapToObj(mapper).flatMapToDouble(Function.identity()));
    }

    public <R> StreamEx<R> flatMapToObj(LongFunction<? extends Stream<R>> mapper) {
        return this.strategy().newStreamEx(this.stream.mapToObj(mapper).flatMap(Function.identity()));
    }

    @Override
    public LongStreamEx distinct() {
        return this.strategy().newLongStreamEx(this.stream.distinct());
    }

    @Override
    public LongStreamEx sorted() {
        return this.strategy().newLongStreamEx(this.stream.sorted());
    }

    public LongStreamEx sorted(Comparator<Long> comparator) {
        return this.strategy().newLongStreamEx(this.stream.boxed().sorted(comparator).mapToLong(Long::longValue));
    }

    public LongStreamEx reverseSorted() {
        return this.sorted(Comparator.reverseOrder());
    }

    public <V extends Comparable<? super V>> LongStreamEx sortedBy(LongFunction<V> keyExtractor) {
        return this.sorted(Comparator.comparing(i -> (Comparable)keyExtractor.apply((long)i)));
    }

    public LongStreamEx sortedByInt(LongToIntFunction keyExtractor) {
        return this.sorted(Comparator.comparingInt(i -> keyExtractor.applyAsInt((long)i)));
    }

    public LongStreamEx sortedByLong(LongUnaryOperator keyExtractor) {
        return this.sorted(Comparator.comparingLong(i -> keyExtractor.applyAsLong((long)i)));
    }

    public LongStreamEx sortedByDouble(LongToDoubleFunction keyExtractor) {
        return this.sorted(Comparator.comparingDouble(i -> keyExtractor.applyAsDouble((long)i)));
    }

    @Override
    public LongStreamEx peek(LongConsumer action) {
        return this.strategy().newLongStreamEx(this.stream.peek(action));
    }

    @Override
    public LongStreamEx limit(long maxSize) {
        return this.strategy().newLongStreamEx(this.stream.limit(maxSize));
    }

    @Override
    public LongStreamEx skip(long n) {
        return this.strategy().newLongStreamEx(this.stream.skip(n));
    }

    public LongStreamEx skipOrdered(long n) {
        Spliterator.OfLong spliterator = (this.stream.isParallel() ? StreamSupport.longStream(this.stream.spliterator(), false) : this.stream).skip(n).spliterator();
        return this.delegate(spliterator);
    }

    @Override
    public void forEach(LongConsumer action) {
        this.stream.forEach(action);
    }

    @Override
    public void forEachOrdered(LongConsumer action) {
        this.stream.forEachOrdered(action);
    }

    @Override
    public long[] toArray() {
        return this.stream.toArray();
    }

    @Override
    public long reduce(long identity, LongBinaryOperator op) {
        return this.stream.reduce(identity, op);
    }

    @Override
    public OptionalLong reduce(LongBinaryOperator op) {
        return this.stream.reduce(op);
    }

    public OptionalLong foldLeft(LongBinaryOperator accumulator) {
        StreamExInternals.PrimitiveBox b = new StreamExInternals.PrimitiveBox();
        this.stream.forEachOrdered(t -> {
            if (primitiveBox.b) {
                primitiveBox.l = accumulator.applyAsLong(primitiveBox.l, t);
            } else {
                primitiveBox.l = t;
                primitiveBox.b = true;
            }
        });
        return b.asLong();
    }

    public long foldLeft(long seed, LongBinaryOperator accumulator) {
        long[] box = new long[]{seed};
        this.stream.forEachOrdered(t -> {
            lArray[0] = accumulator.applyAsLong(box[0], t);
        });
        return box[0];
    }

    public long[] scanLeft(LongBinaryOperator accumulator) {
        Spliterator.OfLong spliterator = this.stream.spliterator();
        long size = spliterator.getExactSizeIfKnown();
        StreamExInternals.LongBuffer buf = new StreamExInternals.LongBuffer(size >= 0L && size <= Integer.MAX_VALUE ? (int)size : 128);
        this.delegate(spliterator).forEachOrdered(i -> buf.add(longBuffer.size == 0 ? i : accumulator.applyAsLong(longBuffer.data[longBuffer.size - 1], i)));
        return buf.toArray();
    }

    public long[] scanLeft(long seed, LongBinaryOperator accumulator) {
        return this.prepend(seed).scanLeft(accumulator);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjLongConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        return this.stream.collect(supplier, accumulator, combiner);
    }

    public <A, R> R collect(LongCollector<A, R> collector) {
        if (collector.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            return (R)this.collect(collector.supplier(), collector.longAccumulator(), collector.merger());
        }
        return collector.finisher().apply(this.collect(collector.supplier(), collector.longAccumulator(), collector.merger()));
    }

    @Override
    public long sum() {
        return this.reduce(0L, Long::sum);
    }

    @Override
    public OptionalLong min() {
        return this.reduce(Long::min);
    }

    public OptionalLong min(Comparator<Long> comparator) {
        return this.reduce((a, b) -> comparator.compare(a, b) > 0 ? b : a);
    }

    public <V extends Comparable<? super V>> OptionalLong minBy(LongFunction<V> keyExtractor) {
        StreamExInternals.ObjLongBox result = this.collect(() -> new StreamExInternals.ObjLongBox<Object>(null, 0L), (box, i) -> {
            Comparable val = (Comparable)Objects.requireNonNull(keyExtractor.apply(i));
            if (box.a == null || ((Comparable)box.a).compareTo(val) > 0) {
                box.a = val;
                box.b = i;
            }
        }, (box1, box2) -> {
            if (box2.a != null && (box1.a == null || ((Comparable)box1.a).compareTo(box2.a) > 0)) {
                box1.a = box2.a;
                box1.b = box2.b;
            }
        });
        return result.a == null ? OptionalLong.empty() : OptionalLong.of(result.b);
    }

    public OptionalLong minByInt(LongToIntFunction keyExtractor) {
        return this.collect(StreamExInternals.PrimitiveBox::new, (box, l) -> {
            int key = keyExtractor.applyAsInt(l);
            if (!box.b || box.i > key) {
                box.b = true;
                box.i = key;
                box.l = l;
            }
        }, StreamExInternals.PrimitiveBox.MIN_INT).asLong();
    }

    public OptionalLong minByLong(LongUnaryOperator keyExtractor) {
        long[] result = this.collect(() -> new long[3], (acc, l) -> {
            long key = keyExtractor.applyAsLong(l);
            if (acc[2] == 0L || acc[1] > key) {
                acc[0] = l;
                acc[1] = key;
                acc[2] = 1L;
            }
        }, (acc1, acc2) -> {
            if (acc2[2] == 1L && (acc1[2] == 0L || acc1[1] > acc2[1])) {
                System.arraycopy(acc2, 0, acc1, 0, 3);
            }
        });
        return result[2] == 1L ? OptionalLong.of(result[0]) : OptionalLong.empty();
    }

    public OptionalLong minByDouble(LongToDoubleFunction keyExtractor) {
        return this.collect(StreamExInternals.PrimitiveBox::new, (box, l) -> {
            double key = keyExtractor.applyAsDouble(l);
            if (!box.b || Double.compare(box.d, key) > 0) {
                box.b = true;
                box.d = key;
                box.l = l;
            }
        }, StreamExInternals.PrimitiveBox.MIN_DOUBLE).asLong();
    }

    @Override
    public OptionalLong max() {
        return this.reduce(Long::max);
    }

    public OptionalLong max(Comparator<Long> comparator) {
        return this.reduce((a, b) -> comparator.compare(a, b) >= 0 ? a : b);
    }

    public <V extends Comparable<? super V>> OptionalLong maxBy(LongFunction<V> keyExtractor) {
        StreamExInternals.ObjLongBox result = this.collect(() -> new StreamExInternals.ObjLongBox<Object>(null, 0L), (box, i) -> {
            Comparable val = (Comparable)Objects.requireNonNull(keyExtractor.apply(i));
            if (box.a == null || ((Comparable)box.a).compareTo(val) < 0) {
                box.a = val;
                box.b = i;
            }
        }, (box1, box2) -> {
            if (box2.a != null && (box1.a == null || ((Comparable)box1.a).compareTo(box2.a) < 0)) {
                box1.a = box2.a;
                box1.b = box2.b;
            }
        });
        return result.a == null ? OptionalLong.empty() : OptionalLong.of(result.b);
    }

    public OptionalLong maxByInt(LongToIntFunction keyExtractor) {
        return this.collect(StreamExInternals.PrimitiveBox::new, (box, l) -> {
            int key = keyExtractor.applyAsInt(l);
            if (!box.b || box.i < key) {
                box.b = true;
                box.i = key;
                box.l = l;
            }
        }, StreamExInternals.PrimitiveBox.MAX_INT).asLong();
    }

    public OptionalLong maxByLong(LongUnaryOperator keyExtractor) {
        long[] result = this.collect(() -> new long[3], (acc, l) -> {
            long key = keyExtractor.applyAsLong(l);
            if (acc[2] == 0L || acc[1] < key) {
                acc[0] = l;
                acc[1] = key;
                acc[2] = 1L;
            }
        }, (acc1, acc2) -> {
            if (acc2[2] == 1L && (acc1[2] == 0L || acc1[1] < acc2[1])) {
                System.arraycopy(acc2, 0, acc1, 0, 3);
            }
        });
        return result[2] == 1L ? OptionalLong.of(result[0]) : OptionalLong.empty();
    }

    public OptionalLong maxByDouble(LongToDoubleFunction keyExtractor) {
        return this.collect(StreamExInternals.PrimitiveBox::new, (box, l) -> {
            double key = keyExtractor.applyAsDouble(l);
            if (!box.b || Double.compare(box.d, key) < 0) {
                box.b = true;
                box.d = key;
                box.l = l;
            }
        }, StreamExInternals.PrimitiveBox.MAX_DOUBLE).asLong();
    }

    @Override
    public long count() {
        return this.stream.count();
    }

    @Override
    public OptionalDouble average() {
        return this.stream.average();
    }

    @Override
    public LongSummaryStatistics summaryStatistics() {
        return this.collect(LongSummaryStatistics::new, LongSummaryStatistics::accept, LongSummaryStatistics::combine);
    }

    @Override
    public boolean anyMatch(LongPredicate predicate) {
        return this.stream.anyMatch(predicate);
    }

    @Override
    public boolean allMatch(LongPredicate predicate) {
        return this.stream.allMatch(predicate);
    }

    @Override
    public boolean noneMatch(LongPredicate predicate) {
        return !this.anyMatch(predicate);
    }

    @Override
    public OptionalLong findFirst() {
        return this.stream.findFirst();
    }

    public OptionalLong findFirst(LongPredicate predicate) {
        return this.filter(predicate).findFirst();
    }

    @Override
    public OptionalLong findAny() {
        return this.stream.findAny();
    }

    public OptionalLong findAny(LongPredicate predicate) {
        return this.filter(predicate).findAny();
    }

    public OptionalLong indexOf(long value) {
        return ((StreamEx)this.boxed()).indexOf((T i) -> i == value);
    }

    public OptionalLong indexOf(LongPredicate predicate) {
        return ((StreamEx)this.boxed()).indexOf(predicate::test);
    }

    @Override
    public DoubleStreamEx asDoubleStream() {
        return this.strategy().newDoubleStreamEx(this.stream.asDoubleStream());
    }

    public StreamEx<Long> boxed() {
        return this.strategy().newStreamEx(this.stream.boxed());
    }

    @Override
    public LongStreamEx sequential() {
        return StreamFactory.DEFAULT.newLongStreamEx(this.stream.sequential());
    }

    @Override
    public LongStreamEx parallel() {
        return StreamFactory.DEFAULT.newLongStreamEx(this.stream.parallel());
    }

    public LongStreamEx parallel(ForkJoinPool fjp) {
        return StreamFactory.forCustomPool(fjp).newLongStreamEx(this.stream.parallel());
    }

    @Override
    public PrimitiveIterator.OfLong iterator() {
        return this.stream.iterator();
    }

    @Override
    public Spliterator.OfLong spliterator() {
        return this.stream.spliterator();
    }

    public LongStreamEx append(long ... values) {
        if (values.length == 0) {
            return this;
        }
        return this.strategy().newLongStreamEx(LongStream.concat(this.stream, LongStream.of(values)));
    }

    public LongStreamEx append(LongStream other) {
        return this.strategy().newLongStreamEx(LongStream.concat(this.stream, other));
    }

    public LongStreamEx prepend(long ... values) {
        if (values.length == 0) {
            return this;
        }
        return this.strategy().newLongStreamEx(LongStream.concat(LongStream.of(values), this.stream));
    }

    public LongStreamEx prepend(LongStream other) {
        return this.strategy().newLongStreamEx(LongStream.concat(other, this.stream));
    }

    public LongStreamEx pairMap(LongBinaryOperator mapper) {
        return this.delegate(new PairSpliterator.PSOfLong(mapper, null, this.stream.spliterator(), 0));
    }

    public String joining(CharSequence delimiter) {
        return this.collect(LongCollector.joining(delimiter));
    }

    public String joining(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return this.collect(LongCollector.joining(delimiter, prefix, suffix));
    }

    @Override
    public LongStreamEx takeWhile(LongPredicate predicate) {
        Objects.requireNonNull(predicate);
        if (StreamExInternals.JDK9_METHODS != null) {
            return this.callWhile(predicate, 0);
        }
        return this.delegate(new TDOfLong(this.stream.spliterator(), false, predicate));
    }

    @Override
    public LongStreamEx dropWhile(LongPredicate predicate) {
        Objects.requireNonNull(predicate);
        if (StreamExInternals.JDK9_METHODS != null) {
            return this.callWhile(predicate, 1);
        }
        return this.delegate(new TDOfLong(this.stream.spliterator(), true, predicate));
    }

    public static LongStreamEx empty() {
        return LongStreamEx.of(LongStream.empty());
    }

    public static LongStreamEx of(long element) {
        return LongStreamEx.of(LongStream.of(element));
    }

    public static LongStreamEx of(long ... elements) {
        return LongStreamEx.of(LongStream.of(elements));
    }

    public static LongStreamEx of(long[] array, int startInclusive, int endExclusive) {
        return LongStreamEx.of(Arrays.stream(array, startInclusive, endExclusive));
    }

    public static LongStreamEx of(Long[] array) {
        return LongStreamEx.of(Arrays.stream(array).mapToLong(Long::longValue));
    }

    public static LongStreamEx of(LongStream stream) {
        return stream instanceof LongStreamEx ? (LongStreamEx)stream : new LongStreamEx(stream);
    }

    public static LongStreamEx of(Spliterator.OfLong spliterator) {
        return LongStreamEx.of(StreamSupport.longStream(spliterator, false));
    }

    public static LongStreamEx of(PrimitiveIterator.OfLong iterator) {
        return LongStreamEx.of(new UnknownSizeSpliterator.USOfLong(iterator));
    }

    public static LongStreamEx of(OptionalLong optional) {
        return optional.isPresent() ? LongStreamEx.of(optional.getAsLong()) : LongStreamEx.empty();
    }

    public static LongStreamEx of(Collection<Long> collection) {
        return LongStreamEx.of(collection.stream().mapToLong(Long::longValue));
    }

    public static LongStreamEx of(Random random) {
        return LongStreamEx.of(random.longs());
    }

    public static LongStreamEx of(Random random, long streamSize) {
        return LongStreamEx.of(random.longs(streamSize));
    }

    public static LongStreamEx of(Random random, long randomNumberOrigin, long randomNumberBound) {
        return LongStreamEx.of(random.longs(randomNumberOrigin, randomNumberBound));
    }

    public static LongStreamEx of(Random random, long streamSize, long randomNumberOrigin, long randomNumberBound) {
        return LongStreamEx.of(random.longs(streamSize, randomNumberOrigin, randomNumberBound));
    }

    public static LongStreamEx iterate(long seed, LongUnaryOperator f) {
        return LongStreamEx.of(LongStream.iterate(seed, f));
    }

    public static LongStreamEx generate(LongSupplier s) {
        return LongStreamEx.of(LongStream.generate(s));
    }

    public static LongStreamEx range(long endExclusive) {
        return LongStreamEx.of(LongStream.range(0L, endExclusive));
    }

    public static LongStreamEx range(long startInclusive, long endExclusive) {
        return LongStreamEx.of(LongStream.range(startInclusive, endExclusive));
    }

    public static LongStreamEx range(long startInclusive, long endExclusive, long step) {
        long endInclusive = endExclusive - (long)Long.signum(step);
        if (endInclusive > endExclusive && step > 0L || endInclusive < endExclusive && step < 0L) {
            return LongStreamEx.empty();
        }
        return LongStreamEx.rangeClosed(startInclusive, endInclusive, step);
    }

    public static LongStreamEx rangeClosed(long startInclusive, long endInclusive) {
        return LongStreamEx.of(LongStream.rangeClosed(startInclusive, endInclusive));
    }

    public static LongStreamEx rangeClosed(long startInclusive, long endInclusive, long step) {
        if (step == 0L) {
            throw new IllegalArgumentException("step = 0");
        }
        if (step == 1L) {
            return LongStreamEx.of(LongStream.rangeClosed(startInclusive, endInclusive));
        }
        if (step == -1L) {
            long sum = endInclusive + startInclusive;
            return LongStreamEx.of(LongStream.rangeClosed(endInclusive, startInclusive).map(x -> sum - x));
        }
        if (endInclusive > startInclusive ^ step > 0L || endInclusive == startInclusive) {
            return LongStreamEx.empty();
        }
        long limit = (endInclusive - startInclusive) * (long)Long.signum(step);
        limit = Long.divideUnsigned(limit, Math.abs(step));
        return LongStreamEx.of(LongStream.rangeClosed(0L, limit).map(x -> x * step + startInclusive));
    }

    public static LongStreamEx constant(long value, long length) {
        return LongStreamEx.of(new ConstSpliterator.OfLong(value, length));
    }

    public static LongStreamEx zip(long[] first, long[] second, LongBinaryOperator mapper) {
        return LongStreamEx.of(new RangeBasedSpliterator.ZipLong(0, StreamExInternals.checkLength(first.length, second.length), mapper, first, second));
    }

    private static final class TDOfLong
    extends Spliterators.AbstractLongSpliterator
    implements LongConsumer {
        private final LongPredicate predicate;
        private final boolean drop;
        private boolean checked;
        private final Spliterator.OfLong source;
        private long cur;

        TDOfLong(Spliterator.OfLong source, boolean drop, LongPredicate predicate) {
            super(source.estimateSize(), source.characteristics() & 0x1515);
            this.drop = drop;
            this.predicate = predicate;
            this.source = source;
        }

        @Override
        public Comparator<? super Long> getComparator() {
            return this.source.getComparator();
        }

        @Override
        public boolean tryAdvance(LongConsumer action) {
            if (this.drop) {
                if (this.checked) {
                    return this.source.tryAdvance(action);
                }
                while (this.source.tryAdvance(this)) {
                    if (this.predicate.test(this.cur)) continue;
                    this.checked = true;
                    action.accept(this.cur);
                    return true;
                }
                return false;
            }
            if (!this.checked && this.source.tryAdvance(this) && this.predicate.test(this.cur)) {
                action.accept(this.cur);
                return true;
            }
            this.checked = true;
            return false;
        }

        @Override
        public void accept(long t) {
            this.cur = t;
        }
    }
}

