/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.Spliterator;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import one.util.streamex.StreamExInternals;

final class WithFirstSpliterator<T, R>
extends StreamExInternals.CloneableSpliterator<R, WithFirstSpliterator<T, R>> {
    private static final int STATE_NONE = 0;
    private static final int STATE_INIT = 1;
    private static final int STATE_EMPTY = 2;
    private ReentrantLock lock;
    private Spliterator<T> source;
    private WithFirstSpliterator<T, R> prefix;
    private volatile T first;
    private volatile int state = 0;
    private final BiFunction<? super T, ? super T, ? extends R> mapper;

    WithFirstSpliterator(Spliterator<T> source, BiFunction<? super T, ? super T, ? extends R> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    private void acquire() {
        if (this.lock != null && this.state == 0) {
            this.lock.lock();
        }
    }

    private void release() {
        if (this.lock != null && this.lock.isHeldByCurrentThread()) {
            this.lock.unlock();
        }
    }

    @Override
    public boolean tryAdvance(Consumer<? super R> action) {
        if (this.state == 0) {
            this.acquire();
            try {
                this.doInit();
            }
            finally {
                this.release();
            }
        }
        if (this.state != 1) {
            return false;
        }
        return this.source.tryAdvance((? super T x) -> action.accept((R)this.mapper.apply(this.first, x)));
    }

    private void doInit() {
        int prefixState = this.state;
        if (prefixState != 0) {
            return;
        }
        if (this.prefix != null) {
            super.doInit();
            prefixState = this.prefix.state;
        }
        if (prefixState == 1) {
            this.first = this.prefix.first;
            this.state = 1;
            return;
        }
        this.state = this.source.tryAdvance((? super T x) -> {
            this.first = x;
        }) ? 1 : 2;
    }

    private boolean initForEach(T x) {
        int prefixState = 0;
        if (this.prefix != null) {
            super.doInit();
            prefixState = this.prefix.state;
        }
        this.state = 1;
        if (prefixState == 1) {
            this.first = this.prefix.first;
            return false;
        }
        this.first = x;
        return true;
    }

    @Override
    public void forEachRemaining(Consumer<? super R> action) {
        this.acquire();
        try {
            this.source.forEachRemaining((? super T x) -> {
                if (this.state == 0 && this.initForEach(x)) {
                    this.release();
                    return;
                }
                this.release();
                action.accept((R)this.mapper.apply(this.first, x));
            });
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Spliterator<R> trySplit() {
        if (this.lock == null) {
            this.lock = new ReentrantLock();
        }
        this.acquire();
        try {
            Spliterator<T> prefix = this.source.trySplit();
            if (prefix == null) {
                Spliterator<R> spliterator = null;
                return spliterator;
            }
            WithFirstSpliterator result = (WithFirstSpliterator)this.doClone();
            result.source = prefix;
            WithFirstSpliterator withFirstSpliterator = this.prefix = result;
            return withFirstSpliterator;
        }
        finally {
            this.release();
        }
    }

    @Override
    public long estimateSize() {
        long size = this.source.estimateSize();
        if (size > 0L && size < Long.MAX_VALUE && this.lock == null && this.state == 0) {
            --size;
        }
        return size;
    }

    @Override
    public int characteristics() {
        return 0x100 | this.source.characteristics() & (0x1411 | (this.lock == null ? 64 : 0));
    }
}

