/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import one.xingyi.core.client.IResourceList;
import one.xingyi.core.client.ISimpleList;
import one.xingyi.core.marshelling.JsonParserAndWriter;
import one.xingyi.core.optics.Getter;
import one.xingyi.core.optics.Lens;
import one.xingyi.core.optics.Setter;
import one.xingyi.json.JsonResourceList1;
import org.json.JSONArray;
import org.json.JSONObject;

public class Json
implements JsonParserAndWriter<Object> {
    public static Json simple = new Json();

    public Object makeObject(Object ... namesAndValues) {
        JSONObject result = new JSONObject();
        for (int i = 0; i < namesAndValues.length; i += 2) {
            result.put((String)namesAndValues[i + 0], namesAndValues[i + 1]);
        }
        return result;
    }

    public <T> Object makeList(IResourceList<T> items) {
        return items.toList();
    }

    public <T> Object makeSimpleList(ISimpleList<T> items) {
        return items.toList();
    }

    public Object liftString(String string) {
        return new JSONObject(string);
    }

    public String fromJ(Object o) {
        return o.toString();
    }

    public Object parse(String jsonString) {
        return new JSONObject(jsonString);
    }

    public String asString(Object o) {
        return o.toString();
    }

    public int asInt(Object o) {
        return (Integer)o;
    }

    public boolean asBoolean(Object o) {
        return (Boolean)o;
    }

    public Double asDouble(Object o) {
        return (Double)o;
    }

    public Double asDouble(Object o, String childName) {
        if (o instanceof Map) {
            return (Double)((Map)o).get(childName);
        }
        return ((JSONObject)o).getDouble(childName);
    }

    public Object child(Object o, String name) {
        if (o instanceof Map) {
            return ((Map)o).get(name);
        }
        return ((JSONObject)o).get(name);
    }

    public List<Object> asList(Object o) {
        return ((JSONArray)o).toList();
    }

    public IResourceList<Object> asResourceList(Object o) {
        return new JsonResourceList1((JSONArray)o);
    }

    public static <T> ISimpleList<T> mapFromJsonArray(Object o, BiFunction<JSONArray, Integer, T> fn) {
        ArrayList<T> result = new ArrayList<T>();
        JSONArray array = (JSONArray)o;
        for (int i = 0; i < array.length(); ++i) {
            result.add(fn.apply(array, i));
        }
        return ISimpleList.fromList(result);
    }

    public ISimpleList<String> asSimpleStringList(Object o) {
        return Json.mapFromJsonArray(o, JSONArray::getString);
    }

    public ISimpleList<Integer> asSimpleIntegerList(Object o) {
        return Json.mapFromJsonArray(o, JSONArray::getInt);
    }

    public ISimpleList<Double> asSimpleDoubleList(Object o) {
        return Json.mapFromJsonArray(o, JSONArray::getDouble);
    }

    public ISimpleList<Boolean> asSimpleBooleanList(Object o) {
        return Json.mapFromJsonArray(o, JSONArray::getBoolean);
    }

    JSONObject copyOf(Object j) {
        return new JSONObject(new HashMap<String, Object>(((JSONObject)j).map));
    }

    public Lens<Object, Object> lensToChild(String childname) {
        Getter getter = j -> ((JSONObject)j).get(childname);
        Setter setter = (j, t) -> this.copyOf(j).put(childname, t);
        return Lens.create((Getter)getter, (Setter)setter);
    }

    public Lens<Object, String> lensToString(String name) {
        Getter getter = j -> ((JSONObject)j).getString(name);
        Setter setter = (j, t) -> this.copyOf(j).put(name, t);
        return Lens.create((Getter)getter, (Setter)setter);
    }

    public Lens<Object, Double> lensToDouble(String name) {
        Getter getter = j -> ((JSONObject)j).getDouble(name);
        Setter setter = (j, t) -> this.copyOf(j).put(name, t);
        return Lens.create((Getter)getter, (Setter)setter);
    }

    public Lens<Object, Integer> lensToInteger(String name) {
        Getter getter = j -> ((JSONObject)j).getInt(name);
        Setter setter = (j, t) -> this.copyOf(j).put(name, t);
        return Lens.create((Getter)getter, (Setter)setter);
    }

    <T> ISimpleList<T> simpleList(Object j, String name, String primitiveClassName) {
        switch (primitiveClassName.toLowerCase()) {
            case "string": {
                return this.asSimpleStringList(j, name);
            }
            case "integer": {
                return this.asSimpleIntegerList(j, name);
            }
            case "double": {
                return this.asSimpleDoubleList(j, name);
            }
            case "boolean": {
                return this.asSimpleBooleanList(j, name);
            }
        }
        throw new IllegalArgumentException("Don't know how to make a simple list of " + primitiveClassName + " legal values are string,integer,boolean,double");
    }

    public <T> Lens<Object, ISimpleList<T>> lensToSimpleList(String name, String primitiveClassName) {
        Getter getter = j -> this.simpleList(j, name, primitiveClassName);
        Setter setter = (j, rl) -> this.copyOf(j).put(name, rl.toList());
        return Lens.create((Getter)getter, (Setter)setter);
    }

    public Lens<Object, IResourceList<Object>> lensToSimpleList(String name) {
        Getter getter = j -> this.asResourceList(j, name);
        Setter setter = (j, rl) -> this.copyOf(j).put(name, rl.toList());
        return Lens.create((Getter)getter, (Setter)setter);
    }
}

