package one.xingyi.reference3.person.server.companion;
//Made by one.xingyi.core.filemaker.ServerCompanionFileMaker
//Defn one.xingyi.reference3.person.IPersonDefn
import one.xingyi.core.sdk.IXingYiServerCompanion;
import one.xingyi.core.marshelling.JsonParser;
import java.util.Map;
import one.xingyi.core.state.StateData;
import java.util.List;
import one.xingyi.core.client.IResourceList;
import one.xingyi.core.utils.Lists;
import one.xingyi.core.sdk.IXingYiServesResourceCompanion;
import one.xingyi.core.annotations.XingYiGenerated;
import one.xingyi.core.endpoints.EndPoint;
import one.xingyi.core.endpoints.EndpointContext;
import java.util.Optional;
import one.xingyi.core.endpoints.BookmarkCodeAndUrlPattern;
import one.xingyi.core.endpoints.HasBookmarkAndUrl;
import one.xingyi.core.mediatype.ServerMediaTypeContext;
import one.xingyi.core.mediatype.JsonAndLensDefnServerMediaTypeDefn;
import one.xingyi.core.optics.lensLanguage.LensLine;
import one.xingyi.core.optics.lensLanguage.StringLensDefn;
import one.xingyi.core.optics.lensLanguage.ViewLensDefn;
import one.xingyi.core.optics.lensLanguage.ListLensDefn;
import one.xingyi.core.mediatype.IXingYiServerMediaTypeDefn;
import one.xingyi.core.mediatype.IResourceEndpoints;
import java.util.function.Function;
import one.xingyi.reference3.person.server.domain.Person;
import one.xingyi.reference3.person.server.controller.IPersonController;
import one.xingyi.core.EndPointFactorys;
import one.xingyi.core.httpClient.server.controller.IResourceDetailsController;
public class PersonCompanion  implements IXingYiServesResourceCompanion<one.xingyi.reference3.person.IPersonDefn,one.xingyi.reference3.person.server.domain.Person>{
    @Override public BookmarkCodeAndUrlPattern bookmarkAndUrl(){return new BookmarkCodeAndUrlPattern("/person","{host}/person/{id}","{host}/person/code");}
    public <J> IResourceEndpoints<Person> endpoints(ServerMediaTypeContext<J> context, Function<Person, String> stateFn) {
        return lensMediaDefn(context).endpoints(context.protocol(), bookmarkAndUrl(), stateFn);
    }
    public <J> EndPoint PersoncodeEndpoint(EndpointContext<J> context) {return EndPoint.javascript(context, "{host}/person/code");}
    public <J>EndPoint entityEndpoint(EndpointContext<J> context,List<HasBookmarkAndUrl> companions){ return EndPointFactorys.<J>entityEndpointFromContext(context,companions);}
    public  <J>EndPoint entityCodeEndpoint(EndpointContext<J> context){ return  EndPoint.javascript(context, "{host}/resource/code");}
    public static one.xingyi.reference3.person.server.companion.PersonCompanion companion  =new PersonCompanion();
    public String javascript(){return javascript;}
    final public String javascript = ""
        + "function lens_Person_name(){return lens('name');};\n"
        + "function lens_Person_age(){return lens('age');};\n"
        + "function lens_Person_addresses(){return lens('addresses');};\n"
        + "function lens_Person_telephone(){return lens('telephone');};\n"
        + "function lens_Person_address(){return compose(lens_Person_addresses(), lensForFirstItemInList());};\n"
        + "function lens_Person_line1(){return compose(lens_Person_address(), lens('line1'));};\n"
        + "function lens_Person_line2(){return compose(lens_Person_address(), lens('line2'));};\n"
    ;
    public List<String> lens(){return List.of(
    "lens_Person_name","lens_Person_age","lens_Person_addresses","lens_Person_telephone","lens_Person_address","lens_Person_line1","lens_Person_line2"
    );}
     public <J>IXingYiServerMediaTypeDefn<Person> lensMediaDefn(ServerMediaTypeContext<J> context) {
        return new JsonAndLensDefnServerMediaTypeDefn<>("Person", this, context, lensLines());
     }
    public List<String> lensLines(){return List.of(
        "lens_Person_name=name/String",
        "lens_Person_age=age/Integer",
        "lens_Person_addresses=addresses/*Address",
        "lens_Person_telephone=telephone/TelephoneNumber",
        "lens_Person_address=addresses/*address,{firstItem}",
        "lens_Person_line1=addresses/*address,{firstItem},line1/string",
        "lens_Person_line2=addresses/*address,{firstItem},line2/string"
    );}
    @XingYiGenerated
    public <J> Person fromJson(JsonParser<J> jsonParser, J j){
        return new Person(jsonParser.asString(j, "name"),
        jsonParser.asInt(j, "age"),
        IResourceList.fromList(Lists.map(jsonParser.asList(j, "addresses"), child ->one.xingyi.reference3.address.server.companion.AddressCompanion.companion.fromJson(jsonParser, child))),
        one.xingyi.reference3.telephone.server.companion.TelephoneNumberCompanion.companion.fromJson(jsonParser, jsonParser.child(j, "telephone")));
    };
    public final Map<String,List<StateData>> stateMap=Map.of(
        
    );
}