/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.httpClient;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import one.xingyi.core.client.IXingYiFactory;
import one.xingyi.core.http.ServiceRequest;
import one.xingyi.core.http.ServiceResponse;
import one.xingyi.core.httpClient.HttpServiceCompletableFuture;
import one.xingyi.core.marshelling.IXingYiResponseSplitter;
import one.xingyi.core.sdk.IXingYiClientFactory;
import one.xingyi.core.sdk.IXingYiClientResource;
import one.xingyi.core.sdk.IXingYiRemoteAccessDetails;
import one.xingyi.core.sdk.IXingYiView;
import one.xingyi.core.utils.IdAndValue;
import one.xingyi.core.utils.StateFn;

class DefaultHttpServiceCompletableFuture
implements HttpServiceCompletableFuture {
    final String protocolAndHost;
    final Function<ServiceRequest, CompletableFuture<ServiceResponse>> service;
    final IXingYiFactory factory;
    final IXingYiResponseSplitter splitter;

    <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>> Function<ServiceResponse, CompletableFuture<View>> makeEntity(IXingYiRemoteAccessDetails<Entity, View> clientMaker, ServiceRequest serviceRequest) {
        return serviceResponse -> IXingYiResponseSplitter.fromServiceResponse((IXingYiFactory)this.factory, (IXingYiResponseSplitter)this.splitter, (IXingYiRemoteAccessDetails)clientMaker, (ServiceRequest)serviceRequest, (ServiceResponse)serviceResponse, Function.identity());
    }

    <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>> Function<ServiceResponse, CompletableFuture<Optional<View>>> makeOptionalEntity(IXingYiRemoteAccessDetails<Entity, View> clientMaker, ServiceRequest serviceRequest) {
        return serviceResponse -> {
            if (serviceResponse.statusCode == 404) {
                return CompletableFuture.completedFuture(Optional.empty());
            }
            return IXingYiResponseSplitter.fromServiceResponse((IXingYiFactory)this.factory, (IXingYiResponseSplitter)this.splitter, (IXingYiRemoteAccessDetails)clientMaker, (ServiceRequest)serviceRequest, (ServiceResponse)serviceResponse, Optional::of);
        };
    }

    <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>> Function<ServiceResponse, CompletableFuture<IdAndValue<View>>> makeIdAndValue(IXingYiRemoteAccessDetails<Entity, View> clientMaker, ServiceRequest serviceRequest) {
        return serviceResponse -> IXingYiResponseSplitter.fromServiceResponse((IXingYiFactory)this.factory, (IXingYiResponseSplitter)this.splitter, (IXingYiRemoteAccessDetails)clientMaker, (ServiceRequest)serviceRequest, (ServiceResponse)serviceResponse, view -> view.xingYi().getIdAndValue(view.mirror(), (IXingYiClientFactory)clientMaker));
    }

    Function<ServiceResponse, Boolean> makeBoolean(ServiceRequest serviceRequest) {
        return serviceResponse -> {
            try {
                return Boolean.parseBoolean(serviceResponse.body);
            }
            catch (Exception e) {
                throw new RuntimeException("Have thrown unexpected exception.\n" + serviceRequest + "\n" + serviceResponse, e);
            }
        };
    }

    @Override
    public <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>, Result> CompletableFuture<Result> primitive(IXingYiRemoteAccessDetails<Entity, View> clientMaker, String method, String url, Function<View, Result> fn) {
        ServiceRequest serviceRequest = new ServiceRequest(method, (String)(url.startsWith("/") ? this.protocolAndHost + url : url), List.of(), "");
        return this.service.apply(serviceRequest).thenCompose(sr -> this.makeEntity(clientMaker, serviceRequest).apply((ServiceResponse)sr).thenApply(fn));
    }

    @Override
    public <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>, Result> CompletableFuture<Optional<Result>> primitiveForOptional(IXingYiRemoteAccessDetails<Entity, View> clientMaker, String method, String url, Function<View, Result> fn) {
        ServiceRequest serviceRequest = new ServiceRequest(method, (String)(url.startsWith("/") ? this.protocolAndHost + url : url), List.of(), "");
        return this.service.apply(serviceRequest).thenCompose(sr -> this.makeOptionalEntity(clientMaker, serviceRequest).apply((ServiceResponse)sr).thenApply(optView -> optView.map(fn)));
    }

    @Override
    public <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>, Result> CompletableFuture<Boolean> primitiveForBoolean(String method, String url) {
        ServiceRequest serviceRequest = new ServiceRequest(method, (String)(url.startsWith("/") ? this.protocolAndHost + url : url), List.of(), "");
        return this.service.apply(serviceRequest).thenApply(this.makeBoolean(serviceRequest));
    }

    @Override
    public <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>, Result> CompletableFuture<IdAndValue<View>> primitiveForIdAndValue(IXingYiRemoteAccessDetails<Entity, View> clientMaker, String method, String url, View view) {
        ServiceRequest serviceRequest = new ServiceRequest(method, (String)(url.startsWith("/") ? this.protocolAndHost + url : url), List.of(), view.xingYi().render("json", view));
        return this.service.apply(serviceRequest).thenCompose(this.makeIdAndValue(clientMaker, serviceRequest));
    }

    @Override
    public <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>, Result> CompletableFuture<Result> get(IXingYiRemoteAccessDetails<Entity, View> clientMaker, String id, Function<View, Result> fn) {
        return this.getUrlPattern(clientMaker.bookmark()).thenCompose(urlPattern -> this.primitive(clientMaker, "get", urlPattern.replace("{id}", id), fn));
    }

    @Override
    public <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>, Result> CompletableFuture<Optional<Result>> getOptional(IXingYiRemoteAccessDetails<Entity, View> clientMaker, String id, Function<View, Result> fn) {
        return this.getUrlPattern(clientMaker.bookmark()).thenCompose(urlPattern -> this.primitiveForOptional(clientMaker, "get", urlPattern.replace("{id}", id), fn));
    }

    @Override
    public <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>> CompletableFuture<View> create(IXingYiRemoteAccessDetails<Entity, View> clientMaker, String id) {
        return this.getUrlPattern(clientMaker.bookmark()).thenCompose(urlPattern -> this.primitive(clientMaker, "post", urlPattern.replace("{id}", id), v -> v));
    }

    @Override
    public <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>> CompletableFuture<IdAndValue<View>> createWithoutId(IXingYiRemoteAccessDetails<Entity, View> clientMaker, View view) {
        return this.getUrlPattern(clientMaker.bookmark()).thenCompose(urlPattern -> this.primitiveForIdAndValue(clientMaker, "post", urlPattern.replace("/{id}", ""), view));
    }

    @Override
    public <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>> CompletableFuture<Boolean> delete(IXingYiRemoteAccessDetails<Entity, View> clientMaker, String id) {
        return this.getUrlPattern(clientMaker.bookmark()).thenCompose(urlPattern -> this.primitiveForBoolean("delete", urlPattern.replace("{id}", id)));
    }

    @Override
    public <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>> CompletableFuture<View> edit(IXingYiRemoteAccessDetails<Entity, View> clientMaker, String id, Function<View, View> fn) {
        return this.getUrlPattern(clientMaker.bookmark()).thenCompose(urlPattern -> {
            String url = urlPattern.replace("{id}", id);
            CompletableFuture original = this.primitive(clientMaker, "get", url, fn);
            return original.thenCompose(o -> {
                String json = o.xingYi().render("json", o);
                ServiceRequest serviceRequest = new ServiceRequest("put", (String)(url.startsWith("/") ? this.protocolAndHost + url : url), List.of(), json);
                return this.service.apply(serviceRequest).thenCompose(this.makeEntity(clientMaker, serviceRequest));
            });
        });
    }

    @Override
    public <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>> CompletableFuture<IdAndValue<View>> prototypeNoId(IXingYiRemoteAccessDetails<Entity, View> clientMaker, String prototypeId, Function<View, View> fn) {
        return this.getUrlPattern(clientMaker.bookmark()).thenCompose(urlPattern -> {
            String prototypeUrl = urlPattern.replace("{id}", prototypeId);
            String finalUrl = urlPattern.replace("/{id}", "");
            CompletableFuture original = this.primitive(clientMaker, "get", prototypeUrl, fn);
            return original.thenCompose(o -> {
                String json = o.xingYi().render("json", o);
                ServiceRequest serviceRequest = new ServiceRequest("post", (String)(finalUrl.startsWith("/") ? this.protocolAndHost + finalUrl : finalUrl), List.of(), json);
                return this.service.apply(serviceRequest).thenCompose(this.makeIdAndValue(clientMaker, serviceRequest));
            });
        });
    }

    @Override
    public <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>> CompletableFuture<View> prototype(IXingYiRemoteAccessDetails<Entity, View> clientMaker, String prototypeId, String id, Function<View, View> fn) {
        return this.getUrlPattern(clientMaker.bookmark()).thenCompose(urlPattern -> {
            String prototypeUrl = urlPattern.replace("{id}", prototypeId);
            String finalUrl = urlPattern.replace("{id}", id);
            CompletableFuture original = this.primitive(clientMaker, "get", prototypeUrl, fn);
            return original.thenCompose(o -> {
                String json = o.xingYi().render("json", o);
                ServiceRequest serviceRequest = new ServiceRequest("put", (String)(finalUrl.startsWith("/") ? this.protocolAndHost + finalUrl : finalUrl), List.of(), json);
                return this.service.apply(serviceRequest).thenCompose(this.makeEntity(clientMaker, serviceRequest));
            });
        });
    }

    @Override
    public <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>, Result> CompletableFuture<Result> process(IXingYiRemoteAccessDetails<Entity, View> clientMaker, String action, String id, StateFn<View, Result> stateFn) {
        throw new RuntimeException("not implemented yet");
    }

    public DefaultHttpServiceCompletableFuture(String protocolAndHost, Function<ServiceRequest, CompletableFuture<ServiceResponse>> service, IXingYiFactory factory, IXingYiResponseSplitter splitter) {
        this.protocolAndHost = protocolAndHost;
        this.service = service;
        this.factory = factory;
        this.splitter = splitter;
    }
}

