/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.reference3.person.server.domain;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import one.xingyi.core.annotations.XingYiGenerated;
import one.xingyi.core.client.IResourceList;
import one.xingyi.core.marshelling.ContextForJson;
import one.xingyi.core.marshelling.HasJson;
import one.xingyi.core.marshelling.HasJsonWithLinks;
import one.xingyi.core.marshelling.JsonWriter;
import one.xingyi.core.utils.Lists;
import one.xingyi.reference3.address.server.domain.IAddress;
import one.xingyi.reference3.person.server.companion.PersonCompanion;
import one.xingyi.reference3.person.server.domain.IPerson;
import one.xingyi.reference3.telephone.server.domain.ITelephoneNumber;

public class Person
implements HasJson<ContextForJson>,
IPerson,
HasJsonWithLinks<ContextForJson, Person> {
    final String name;
    final Integer age;
    final IResourceList<IAddress> addresses;
    final ITelephoneNumber telephone;

    @XingYiGenerated
    public Person(String name, Integer age, IResourceList<IAddress> addresses, ITelephoneNumber telephone) {
        this.name = name;
        this.age = age;
        this.addresses = addresses;
        this.telephone = telephone;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Person withname(String name) {
        return new Person(name, this.age, this.addresses, this.telephone);
    }

    @Override
    public Integer age() {
        return this.age;
    }

    @Override
    public Person withage(Integer age) {
        return new Person(this.name, age, this.addresses, this.telephone);
    }

    @Override
    public IResourceList<IAddress> addresses() {
        return this.addresses;
    }

    @Override
    public Person withaddresses(IResourceList<IAddress> addresses) {
        return new Person(this.name, this.age, addresses, this.telephone);
    }

    @Override
    public ITelephoneNumber telephone() {
        return this.telephone;
    }

    @Override
    public Person withtelephone(ITelephoneNumber telephone) {
        return new Person(this.name, this.age, this.addresses, telephone);
    }

    @XingYiGenerated
    public <J> J toJson(JsonWriter<J> jsonWriter, ContextForJson context) {
        return (J)jsonWriter.makeObject(new Object[]{"name", this.name, "age", this.age, "addresses", jsonWriter.makeList(Lists.map((List)this.addresses.toList(), a -> a.toJson(jsonWriter, context))), "telephone", this.telephone.toJson(jsonWriter, context)});
    }

    @XingYiGenerated
    public <J> J toJsonWithLinks(JsonWriter<J> jsonWriter, ContextForJson context, Function<Person, String> stateFn) {
        return (J)jsonWriter.makeObject(new Object[]{"name", this.name, "age", this.age, "addresses", jsonWriter.makeList(Lists.map((List)this.addresses.toList(), a -> a.toJson(jsonWriter, context))), "telephone", this.telephone.toJson(jsonWriter, context), "_links", context.links(jsonWriter, (Object)this, stateFn, PersonCompanion.companion.stateMap)});
    }

    @XingYiGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Person other = (Person)o;
        return Objects.equals(this.name, other.name) && Objects.equals(this.age, other.age) && Objects.equals(this.addresses, other.addresses) && Objects.equals(this.telephone, other.telephone);
    }

    @XingYiGenerated
    public int hashCode() {
        return Objects.hash(this.name, this.age, this.addresses, this.telephone);
    }

    @XingYiGenerated
    public String toString() {
        return "Person(" + this.name + "," + this.age + "," + this.addresses + "," + this.telephone + ")";
    }
}

