/*
 * Copyright 2004 Carlos Sanchez.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sf.oness.common.model.bo;

import java.lang.reflect.Field;
import java.util.Collection;

import net.sf.oness.common.all.ReflectionToStringBuilder;

/**
 * Customized ReflectionToStringBuilder ignoring fields that can't be accessed
 * 
 * @todo optimize this
 * 
 * @see org.apache.commons.lang.builder.ReflectionToStringBuilder
 * 
 * @author Carlos Sanchez
 * @version $Revision: 1.1 $
 */
public class ExceptionSafeReflectionToStringBuilder extends
        ReflectionToStringBuilder {

    public ExceptionSafeReflectionToStringBuilder(Object object) {
        super(object);
    }

    /**
     * Check if the field is a collection and try to fetch the size. If there is
     * an error (as it happens with lazy initialized collections) the field is
     * not accepted.
     * 
     * @see org.apache.commons.lang.builder.ReflectionToStringBuilder#accept(java.lang.reflect.Field)
     */
    protected boolean accept(Field field) {
        boolean isCollection = Collection.class.isAssignableFrom(field
                .getType());
        if (isCollection) {
            try {
                Collection value = (Collection) super.getValue(field);
                if (value != null)
                    value.size();
            } catch (Exception e) {
                this.append(field.getName(), "<can't be accessed>");
                return false;
            }
        }
        return super.accept(field);
    }
}