/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oness.common.webapp.controller.listener;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import net.sf.oness.common.model.util.dbunit.DatabasePopulator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringContextLoaderListener
extends ContextLoaderListener {
    private static Log log = LogFactory.getLog((Class)SpringContextLoaderListener.class);

    public void contextInitialized(ServletContextEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"initializing context...");
        }
        super.contextInitialized(event);
        ServletContext servletContext = event.getServletContext();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting application-wide values");
        }
        try {
            WebApplicationContext applicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
            this.initialize((ApplicationContext)applicationContext, servletContext);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Finished setting application-wide values");
            }
        }
        catch (Exception e) {
            log.error((Object)("Error setting application-wide values!" + e.getMessage()));
            e.printStackTrace();
        }
    }

    protected void initialize(ApplicationContext applicationContext, ServletContext servletContext) throws Exception {
        DatabasePopulator databasePopulator = (DatabasePopulator)applicationContext.getBean("databasePopulator");
        if (databasePopulator != null) {
            databasePopulator.execute();
        }
    }
}

