/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oness.party.model.facade;

import java.io.Serializable;
import net.sf.oness.common.model.bo.AuditableBusinessObject;
import net.sf.oness.common.model.dao.Dao;
import net.sf.oness.common.model.exceptions.ExistingInstanceException;
import net.sf.oness.common.model.util.PaginatedList;
import net.sf.oness.party.model.contact.bo.ContactInfo;
import net.sf.oness.party.model.contact.bo.PhoneNumber;
import net.sf.oness.party.model.contact.dao.CountryDao;
import net.sf.oness.party.model.facade.PartyFacadeDelegate;
import net.sf.oness.party.model.facade.action.CreatePartyAction;
import net.sf.oness.party.model.party.bo.Party;

public class PartySpringFacadeDelegate
implements PartyFacadeDelegate {
    private Dao partyDao;
    private Dao contactInfoDao;
    private CountryDao countryDao;

    public void setPartyDao(Dao partyDao) {
        this.partyDao = partyDao;
    }

    public Dao getPartyDao() {
        return this.partyDao;
    }

    public void setContactInfoDao(Dao contactInfoDao) {
        this.contactInfoDao = contactInfoDao;
    }

    public Dao getContactInfoDao() {
        return this.contactInfoDao;
    }

    public void setCountryDao(CountryDao countryDao) {
        this.countryDao = countryDao;
    }

    public CountryDao getCountryDao() {
        return this.countryDao;
    }

    public Party createParty(Party party) throws ExistingInstanceException {
        return this.createParty(party, true);
    }

    public Party createParty(Party party, boolean ignoreExisting) throws ExistingInstanceException {
        CreatePartyAction action = new CreatePartyAction(this.getPartyDao(), party, ignoreExisting);
        return action.execute();
    }

    public Party updateParty(Party party) {
        return (Party)this.getPartyDao().update((AuditableBusinessObject)party);
    }

    public PaginatedList findParty(Party party, int firstElement, int maxElements) {
        return this.getPartyDao().find((AuditableBusinessObject)party, firstElement, maxElements);
    }

    public Party findParty(Long id) {
        return (Party)this.getPartyDao().findById((Serializable)id);
    }

    public Party findPartyWithDetails(Long id) {
        return (Party)this.getPartyDao().findWithDetails((Serializable)id);
    }

    public void deleteParty(Long id) {
        this.getPartyDao().delete((Serializable)id);
    }

    public ContactInfo createContactInfo(ContactInfo contactInfo) {
        if (contactInfo instanceof PhoneNumber) {
            PhoneNumber phoneNumber = (PhoneNumber)contactInfo;
            phoneNumber.setCountry(this.getCountryDao().findById((Serializable)((Object)phoneNumber.getCountry().getIsoCode())));
        }
        return (ContactInfo)this.getContactInfoDao().create((AuditableBusinessObject)contactInfo);
    }

    public ContactInfo updateContactInfo(ContactInfo contactInfo) {
        return (ContactInfo)this.getContactInfoDao().update((AuditableBusinessObject)contactInfo);
    }

    public PaginatedList findContactInfo(ContactInfo contactInfo, int firstElement, int maxElements) {
        return this.getContactInfoDao().find((AuditableBusinessObject)contactInfo, firstElement, maxElements);
    }

    public ContactInfo findContactInfo(Long id) {
        return (ContactInfo)this.getContactInfoDao().findById((Serializable)id);
    }

    public void deleteContactInfo(Long id) {
        this.getContactInfoDao().delete((Serializable)id);
    }
}

