/*
 * Decompiled with CFR 0.152.
 */
package online.citizenshipverification.turkish.advice;

import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import online.citizenshipverification.turkish.advice.ValidationErrorResponse;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class ValidationAdvice {
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public final ResponseEntity<ValidationErrorResponse> handleMethodArgumentNotValidException(MethodArgumentNotValidException exception) {
        List fieldErrors = exception.getBindingResult().getFieldErrors();
        List errorList = fieldErrors.stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.toList());
        ValidationErrorResponse validationErrorResponse = new ValidationErrorResponse(HttpStatus.BAD_REQUEST, LocalDateTime.now(), errorList);
        return ResponseEntity.status((HttpStatus)validationErrorResponse.getStatus()).body((Object)validationErrorResponse);
    }
}

