/*
 * Decompiled with CFR 0.152.
 */
package org.openejb;

import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.transaction.TransactionManager;
import org.openejb.Container;
import org.openejb.DeploymentInfo;
import org.openejb.OpenEJBException;
import org.openejb.spi.ApplicationServer;
import org.openejb.spi.Assembler;
import org.openejb.spi.ContainerSystem;
import org.openejb.spi.SecurityService;
import org.openejb.util.JarUtils;
import org.openejb.util.Logger;
import org.openejb.util.Messages;
import org.openejb.util.SafeToolkit;

public final class OpenEJB {
    private static ContainerSystem containerSystem;
    private static SecurityService securityService;
    private static ApplicationServer applicationServer;
    private static TransactionManager transactionManager;
    private static Properties props;
    private static boolean initialized;
    private static Logger logger;
    private static Messages messages;

    public static void init(Properties props) throws OpenEJBException {
        OpenEJB.init(props, null);
    }

    public static void init(Properties initProps, ApplicationServer appServer) throws OpenEJBException {
        String msg;
        if (initialized) {
            String msg2 = messages.message("startup.alreadyInitialzied");
            OpenEJB.logger.i18n.error(msg2);
            throw new OpenEJBException(msg2);
        }
        JarUtils.setHandlerSystemProperty();
        Logger.initialize(initProps);
        logger = Logger.getInstance("OpenEJB.startup", "org.openejb.util.resources");
        Properties versionInfo = new Properties();
        try {
            versionInfo.load(new URL("resource:/openejb-version.properties").openConnection().getInputStream());
        }
        catch (IOException e) {
            // empty catch block
        }
        if (initProps.getProperty("openejb.nobanner") == null) {
            System.out.println("OpenEJB " + versionInfo.get("version") + "    build: " + versionInfo.get("date") + "-" + versionInfo.get("time"));
            System.out.println("" + versionInfo.get("url"));
        }
        OpenEJB.logger.i18n.info("startup.banner", versionInfo.get("url"), (Object)new Date(), versionInfo.get("copyright"), versionInfo.get("version"), versionInfo.get("date"), versionInfo.get("time"));
        props = new Properties(System.getProperties());
        if (initProps == null) {
            OpenEJB.logger.i18n.debug("startup.noInitializationProperties");
        } else {
            props.putAll((Map<?, ?>)initProps);
        }
        if (appServer == null) {
            OpenEJB.logger.i18n.warning("startup.noApplicationServerSpecified");
        }
        applicationServer = appServer;
        SafeToolkit toolkit = SafeToolkit.getToolkit("OpenEJB");
        String className = props.getProperty("org/openejb/assembler_class");
        if (className == null) {
            className = props.getProperty("openejb.assembler", "org.openejb.alt.assembler.classic.Assembler");
        } else {
            OpenEJB.logger.i18n.warning("startup.deprecatedPropertyName", "org/openejb/assembler_class");
        }
        OpenEJB.logger.i18n.debug("startup.instantiatingAssemberClass", className);
        Assembler assembler = null;
        try {
            assembler = (Assembler)toolkit.newInstance(className);
        }
        catch (OpenEJBException oe) {
            OpenEJB.logger.i18n.fatal("startup.assemblerCannotBeInstanitated", oe);
            throw oe;
        }
        catch (Throwable t) {
            String msg3 = messages.message("startup.openEjbEncounterUnexpectedError");
            OpenEJB.logger.i18n.fatal(msg3, t);
            throw new OpenEJBException(msg3, t);
        }
        try {
            assembler.init(props);
        }
        catch (OpenEJBException oe) {
            OpenEJB.logger.i18n.fatal("startup.assemblerFailedToInitialize", oe);
            throw oe;
        }
        catch (Throwable t) {
            String msg4 = messages.message("startup.assemblerEncounterUnexpectedError");
            OpenEJB.logger.i18n.fatal(msg4, t);
            throw new OpenEJBException(msg4, t);
        }
        try {
            assembler.build();
        }
        catch (OpenEJBException oe) {
            OpenEJB.logger.i18n.fatal("startup.assemblerFailedToBuild", oe);
            throw oe;
        }
        catch (Throwable t) {
            String msg5 = messages.message("startup.assemblerEncounterUnexpectedBuildError");
            OpenEJB.logger.i18n.fatal(msg5, t);
            throw new OpenEJBException(msg5, t);
        }
        containerSystem = assembler.getContainerSystem();
        if (containerSystem == null) {
            String msg6 = messages.message("startup.assemblerReturnedNullContainer");
            OpenEJB.logger.i18n.fatal(msg6);
            throw new OpenEJBException(msg6);
        }
        if (logger.isDebugEnabled()) {
            String entry;
            int i;
            OpenEJB.logger.i18n.debug("startup.debugContainers", new Integer(containerSystem.containers().length));
            if (containerSystem.containers().length > 0) {
                Container[] c = containerSystem.containers();
                OpenEJB.logger.i18n.debug("startup.debugContainersType");
                for (i = 0; i < c.length; ++i) {
                    entry = "   ";
                    switch (c[i].getContainerType()) {
                        case 3: {
                            entry = entry + "ENTITY      ";
                            break;
                        }
                        case 2: {
                            entry = entry + "STATEFUL    ";
                            break;
                        }
                        case 1: {
                            entry = entry + "STATELESS   ";
                        }
                    }
                    entry = entry + c[i].getContainerID();
                    OpenEJB.logger.i18n.debug("startup.debugEntry", entry);
                }
            }
            OpenEJB.logger.i18n.debug("startup.debugDeployments", new Integer(containerSystem.deployments().length));
            if (containerSystem.deployments().length > 0) {
                OpenEJB.logger.i18n.debug("startup.debugDeploymentsType");
                DeploymentInfo[] d = containerSystem.deployments();
                for (i = 0; i < d.length; ++i) {
                    entry = "   ";
                    switch (d[i].getComponentType()) {
                        case 8: {
                            entry = entry + "BMP_ENTITY  ";
                            break;
                        }
                        case 9: {
                            entry = entry + "CMP_ENTITY  ";
                            break;
                        }
                        case 6: {
                            entry = entry + "STATEFUL    ";
                            break;
                        }
                        case 7: {
                            entry = entry + "STATELESS   ";
                        }
                    }
                    entry = entry + d[i].getDeploymentID();
                    OpenEJB.logger.i18n.debug("startup.debugEntry", entry);
                }
            }
        }
        if ((securityService = assembler.getSecurityService()) == null) {
            msg = messages.message("startup.assemblerReturnedNullSecurityService");
            OpenEJB.logger.i18n.fatal(msg);
            throw new OpenEJBException(msg);
        }
        OpenEJB.logger.i18n.debug("startup.securityService", securityService.getClass().getName());
        transactionManager = assembler.getTransactionManager();
        if (transactionManager == null) {
            msg = messages.message("startup.assemblerReturnedNullTransactionManager");
            OpenEJB.logger.i18n.fatal(msg);
            throw new OpenEJBException(msg);
        }
        OpenEJB.logger.i18n.debug("startup.transactionManager", transactionManager.getClass().getName());
        initialized = true;
        OpenEJB.logger.i18n.info("startup.ready");
        String loader = initProps.getProperty("openejb.loader");
        String nobanner = initProps.getProperty("openejb.nobanner");
        if (nobanner == null && (loader == null || loader != null && loader.startsWith("tomcat"))) {
            System.out.println(messages.message("startup.ready"));
        }
    }

    public static TransactionManager getTransactionManager() {
        return transactionManager;
    }

    public static SecurityService getSecurityService() {
        return securityService;
    }

    public static ApplicationServer getApplicationServer() {
        return applicationServer;
    }

    public static DeploymentInfo getDeploymentInfo(Object id) {
        return containerSystem.getDeploymentInfo(id);
    }

    public static DeploymentInfo[] deployments() {
        return containerSystem.deployments();
    }

    public static Container getContainer(Object id) {
        return containerSystem.getContainer(id);
    }

    public static Container[] containers() {
        if (containerSystem == null) {
            OpenEJB.logger.i18n.warning("startup.noContainersConfigured");
            return null;
        }
        return containerSystem.containers();
    }

    public static Context getJNDIContext() {
        return containerSystem.getJNDIContext();
    }

    public static Properties getInitProps() {
        return (Properties)props.clone();
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static String getProperty(String property) {
        return props.getProperty(property);
    }

    static {
        messages = new Messages("org.openejb.util.resources");
    }
}

