/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.alt.assembler.classic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import javax.transaction.TransactionManager;
import org.openejb.DeploymentInfo;
import org.openejb.OpenEJBException;
import org.openejb.alt.assembler.classic.AssemblerTool;
import org.openejb.alt.assembler.classic.ConnectionManagerInfo;
import org.openejb.alt.assembler.classic.ConnectorInfo;
import org.openejb.alt.assembler.classic.ContainerInfo;
import org.openejb.alt.assembler.classic.ContainerSystemInfo;
import org.openejb.alt.assembler.classic.OpenEjbConfiguration;
import org.openejb.alt.assembler.classic.OpenEjbConfigurationFactory;
import org.openejb.core.ConnectorReference;
import org.openejb.spi.ContainerSystem;
import org.openejb.spi.SecurityService;
import org.openejb.util.OpenEJBErrorHandler;
import org.openejb.util.SafeToolkit;

public class Assembler
extends AssemblerTool
implements org.openejb.spi.Assembler {
    private org.openejb.core.ContainerSystem containerSystem;
    private TransactionManager transactionManager;
    private SecurityService securityService;
    private HashMap remoteJndiContexts = null;
    protected SafeToolkit toolkit = SafeToolkit.getToolkit("Assembler");
    protected OpenEjbConfiguration config;
    private String INVALID_CONNECTION_MANAGER_ERROR = "Invalid connection manager specified for connector identity = ";

    public ContainerSystem getContainerSystem() {
        return this.containerSystem;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void init(Properties props) throws OpenEJBException {
        this.props = props;
        String className = props.getProperty("org/openejb/configuration_factory");
        if (className == null) {
            className = props.getProperty("openejb.configurator", "org.openejb.alt.config.ConfigurationFactory");
        }
        OpenEjbConfigurationFactory configFactory = (OpenEjbConfigurationFactory)this.toolkit.newInstance(className);
        configFactory.init(props);
        this.config = configFactory.getOpenEjbConfiguration();
        String str = System.getProperty("java.naming.factory.url.pkgs");
        str = str == null ? ":org.openejb.core.ivm.naming" : str + ":org.openejb.core.ivm.naming";
        System.setProperty("java.naming.factory.url.pkgs", str);
    }

    public void build() throws OpenEJBException {
        try {
            this.containerSystem = this.buildContainerSystem(this.config);
        }
        catch (OpenEJBException ae) {
            throw ae;
        }
        catch (Exception e) {
            OpenEJBErrorHandler.handleUnknownError(e, "Assembler");
            throw new OpenEJBException(e);
        }
    }

    public org.openejb.core.ContainerSystem buildContainerSystem(OpenEjbConfiguration configInfo) throws Exception {
        ConnectionManager connectionManager;
        int i;
        this.applyProxyFactory(configInfo.facilities.intraVmServer);
        ContainerSystemInfo containerSystemInfo = configInfo.containerSystem;
        org.openejb.core.ContainerSystem containerSystem = new org.openejb.core.ContainerSystem();
        this.assembleContainers(containerSystem, containerSystemInfo);
        this.securityService = this.assembleSecurityService(configInfo.facilities.securityService);
        containerSystem.getJNDIContext().bind("java:openejb/SecurityService", (Object)this.securityService);
        AssemblerTool.RoleMapping roleMapping = new AssemblerTool.RoleMapping(configInfo.facilities.securityService.roleMappings);
        DeploymentInfo[] deployments = containerSystem.deployments();
        for (int i2 = 0; i2 < deployments.length; ++i2) {
            this.applyMethodPermissions((org.openejb.core.DeploymentInfo)deployments[i2], containerSystemInfo.methodPermissions, roleMapping);
            this.applyTransactionAttributes((org.openejb.core.DeploymentInfo)deployments[i2], containerSystemInfo.methodTransactions);
        }
        ArrayList<ContainerInfo> list = new ArrayList<ContainerInfo>();
        if (containerSystemInfo.entityContainers != null) {
            list.addAll(Arrays.asList(containerSystemInfo.entityContainers));
        }
        if (containerSystemInfo.statefulContainers != null) {
            list.addAll(Arrays.asList(containerSystemInfo.statefulContainers));
        }
        if (containerSystemInfo.statelessContainers != null) {
            list.addAll(Arrays.asList(containerSystemInfo.statelessContainers));
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ContainerInfo container = (ContainerInfo)iterator.next();
            for (int z = 0; z < container.ejbeans.length; ++z) {
                org.openejb.core.DeploymentInfo deployment = (org.openejb.core.DeploymentInfo)containerSystem.getDeploymentInfo(container.ejbeans[z].ejbDeploymentId);
                this.applySecurityRoleReference(deployment, container.ejbeans[z], roleMapping);
            }
        }
        if (configInfo.facilities.remoteJndiContexts != null) {
            for (int i3 = 0; i3 < configInfo.facilities.remoteJndiContexts.length; ++i3) {
                InitialContext cntx = this.assembleRemoteJndiContext(configInfo.facilities.remoteJndiContexts[i3]);
                containerSystem.getJNDIContext().bind("java:openejb/remote_jndi_contexts/" + configInfo.facilities.remoteJndiContexts[i3].jndiContextId, (Object)cntx);
            }
        }
        this.transactionManager = this.assembleTransactionManager(configInfo.facilities.transactionService);
        containerSystem.getJNDIContext().bind("java:openejb/TransactionManager", (Object)this.transactionManager);
        HashMap<String, ConnectionManager> connectionManagerMap = new HashMap<String, ConnectionManager>();
        if (configInfo.facilities.connectionManagers != null) {
            for (i = 0; i < configInfo.facilities.connectionManagers.length; ++i) {
                ConnectionManagerInfo cmInfo = configInfo.facilities.connectionManagers[i];
                connectionManager = this.assembleConnectionManager(cmInfo);
                connectionManagerMap.put(cmInfo.connectionManagerId, connectionManager);
            }
        }
        if (configInfo.facilities.connectors != null) {
            for (i = 0; i < configInfo.facilities.connectors.length; ++i) {
                ConnectorInfo conInfo = configInfo.facilities.connectors[i];
                connectionManager = (ConnectionManager)connectionManagerMap.get(conInfo.connectionManagerId);
                if (connectionManager == null) {
                    throw new RuntimeException(this.INVALID_CONNECTION_MANAGER_ERROR + conInfo.connectorId);
                }
                ManagedConnectionFactory managedConnectionFactory = this.assembleManagedConnectionFactory(conInfo.managedConnectionFactory);
                ConnectorReference reference = new ConnectorReference(connectionManager, managedConnectionFactory);
                containerSystem.getJNDIContext().bind("java:openejb/connector/" + conInfo.connectorId, (Object)reference);
            }
        }
        return containerSystem;
    }
}

