/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.alt.assembler.classic;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import javax.transaction.TransactionManager;
import org.openejb.Container;
import org.openejb.DeploymentInfo;
import org.openejb.OpenEJBException;
import org.openejb.SystemException;
import org.openejb.alt.assembler.classic.ConnectionManagerInfo;
import org.openejb.alt.assembler.classic.ContainerInfo;
import org.openejb.alt.assembler.classic.ContainerSystemInfo;
import org.openejb.alt.assembler.classic.EjbLocalReferenceInfo;
import org.openejb.alt.assembler.classic.EjbReferenceInfo;
import org.openejb.alt.assembler.classic.EnterpriseBeanInfo;
import org.openejb.alt.assembler.classic.EntityBeanInfo;
import org.openejb.alt.assembler.classic.EnvEntryInfo;
import org.openejb.alt.assembler.classic.IntraVmServerInfo;
import org.openejb.alt.assembler.classic.JndiContextInfo;
import org.openejb.alt.assembler.classic.ManagedConnectionFactoryInfo;
import org.openejb.alt.assembler.classic.MethodInfo;
import org.openejb.alt.assembler.classic.MethodPermissionInfo;
import org.openejb.alt.assembler.classic.MethodTransactionInfo;
import org.openejb.alt.assembler.classic.ResourceReferenceInfo;
import org.openejb.alt.assembler.classic.RoleMappingInfo;
import org.openejb.alt.assembler.classic.SecurityRoleReferenceInfo;
import org.openejb.alt.assembler.classic.SecurityServiceInfo;
import org.openejb.alt.assembler.classic.StatefulBeanInfo;
import org.openejb.alt.assembler.classic.TransactionServiceInfo;
import org.openejb.core.ContainerSystem;
import org.openejb.core.CoreUserTransaction;
import org.openejb.core.TransactionManagerWrapper;
import org.openejb.core.entity.EntityContainer;
import org.openejb.core.ivm.naming.ENCReference;
import org.openejb.core.ivm.naming.IntraVmJndiReference;
import org.openejb.core.ivm.naming.IvmContext;
import org.openejb.core.ivm.naming.JndiReference;
import org.openejb.core.ivm.naming.NameNode;
import org.openejb.core.ivm.naming.ParsedName;
import org.openejb.core.stateful.EncReference;
import org.openejb.core.stateful.EncUserTransaction;
import org.openejb.core.stateful.StatefulContainer;
import org.openejb.core.stateless.StatelessContainer;
import org.openejb.spi.SecurityService;
import org.openejb.spi.TransactionService;
import org.openejb.util.Messages;
import org.openejb.util.SafeToolkit;
import org.openejb.util.proxy.ProxyFactory;
import org.openejb.util.proxy.ProxyManager;

public class AssemblerTool {
    public static final Class PROXY_FACTORY = ProxyFactory.class;
    public static final Class SECURITY_SERVICE = SecurityService.class;
    public static final Class TRANSACTION_SERVICE = TransactionService.class;
    public static final Class CONTAINER = Container.class;
    public static final Class CONNECTION_MANAGER = ConnectionManager.class;
    public static final Class CONNECTOR = ManagedConnectionFactory.class;
    protected static Messages messages = new Messages("org.openejb.util.resources");
    protected static SafeToolkit toolkit = SafeToolkit.getToolkit("AssemblerTool");
    protected static HashMap codebases = new HashMap();
    protected Properties props;
    static /* synthetic */ Class class$javax$ejb$EJBObject;
    static /* synthetic */ Class class$javax$ejb$EJBHome;
    static /* synthetic */ Class class$org$openejb$alt$assembler$classic$EntityBeanInfo;
    static /* synthetic */ Class class$org$openejb$alt$assembler$classic$StatefulBeanInfo;
    static /* synthetic */ Class class$org$openejb$alt$assembler$classic$StatelessBeanInfo;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;

    public void assembleContainers(ContainerSystem containerSystem, ContainerSystemInfo containerSystemInfo) throws Exception {
        ArrayList<ContainerInfo> list = new ArrayList<ContainerInfo>();
        if (containerSystemInfo.entityContainers != null) {
            list.addAll(Arrays.asList(containerSystemInfo.entityContainers));
        }
        if (containerSystemInfo.statefulContainers != null) {
            list.addAll(Arrays.asList(containerSystemInfo.statefulContainers));
        }
        if (containerSystemInfo.statelessContainers != null) {
            list.addAll(Arrays.asList(containerSystemInfo.statelessContainers));
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ContainerInfo containerInfo = (ContainerInfo)iterator.next();
            Container container = this.assembleContainer(containerInfo);
            containerSystem.addContainer(container.getContainerID(), container);
        }
        Container[] containers = containerSystem.containers();
        for (int i = 0; i < containers.length; ++i) {
            DeploymentInfo[] deployments = containers[i].deployments();
            for (int x = 0; x < deployments.length; ++x) {
                containerSystem.addDeployment((org.openejb.core.DeploymentInfo)deployments[x]);
            }
        }
    }

    public Container assembleContainer(ContainerInfo containerInfo) throws OpenEJBException {
        HashMap<String, org.openejb.core.DeploymentInfo> deployments = new HashMap<String, org.openejb.core.DeploymentInfo>();
        for (int z = 0; z < containerInfo.ejbeans.length; ++z) {
            org.openejb.core.DeploymentInfo deployment = this.assembleDeploymentInfo(containerInfo.ejbeans[z]);
            deployments.put(containerInfo.ejbeans[z].ejbDeploymentId, deployment);
        }
        Container container = null;
        if (containerInfo.className != null || "org.openejb.alt.containers.castor_cmp11.CastorCMP11_EntityContainer".equals(containerInfo.codebase)) {
            if (containerInfo.className == null) {
                containerInfo.className = containerInfo.codebase;
            }
            try {
                Class factory = SafeToolkit.loadClass(containerInfo.className, containerInfo.codebase);
                this.checkImplementation(CONTAINER, factory, "Container", containerInfo.containerName);
                container = (Container)factory.newInstance();
            }
            catch (OpenEJBException oee) {
                throw new OpenEJBException(messages.format("as0002", containerInfo, oee.getMessage()));
            }
            catch (InstantiationException ie) {
                throw new OpenEJBException(messages.format("as0003", containerInfo, ie.getMessage()));
            }
            catch (IllegalAccessException iae) {
                throw new OpenEJBException(messages.format("as0003", containerInfo, iae.getMessage()));
            }
        } else {
            switch (containerInfo.containerType) {
                case 2: {
                    container = new StatefulContainer();
                    break;
                }
                case 0: {
                    container = new EntityContainer();
                    break;
                }
                case 3: {
                    container = new StatelessContainer();
                }
            }
        }
        try {
            Properties clonedProps = (Properties)this.props.clone();
            clonedProps.putAll((Map<?, ?>)containerInfo.properties);
            container.init(containerInfo.containerName, deployments, clonedProps);
        }
        catch (OpenEJBException e) {
            throw new OpenEJBException(messages.format("as0003", containerInfo.containerName, e.getMessage()));
        }
        return container;
    }

    public InitialContext assembleRemoteJndiContext(JndiContextInfo context) throws OpenEJBException {
        try {
            InitialContext ic = new InitialContext(context.properties);
            return ic;
        }
        catch (NamingException ne) {
            throw new OpenEJBException("The remote JNDI EJB references for remote-jndi-contexts = " + context.jndiContextId + "+ could not be resolved.", ne);
        }
    }

    public org.openejb.core.DeploymentInfo assembleDeploymentInfo(EnterpriseBeanInfo beanInfo) throws SystemException, OpenEJBException {
        byte componentType;
        boolean isEntity = false;
        EntityBeanInfo ebi = null;
        if (beanInfo instanceof EntityBeanInfo) {
            isEntity = true;
            ebi = (EntityBeanInfo)beanInfo;
            componentType = ebi.persistenceType.equals("Container") ? (byte)9 : 8;
        } else {
            componentType = beanInfo instanceof StatefulBeanInfo ? (byte)6 : 7;
        }
        Class ejbClass = null;
        Class home = null;
        Class remote = null;
        Class localhome = null;
        Class local = null;
        Class ejbPk = null;
        try {
            ejbClass = SafeToolkit.loadClass(beanInfo.ejbClass, beanInfo.codebase);
        }
        catch (OpenEJBException e) {
            throw new OpenEJBException(messages.format("cl0005", beanInfo.ejbClass, beanInfo.ejbDeploymentId, e.getMessage()));
        }
        if (beanInfo.home != null) {
            try {
                home = SafeToolkit.loadClass(beanInfo.home, beanInfo.codebase);
            }
            catch (OpenEJBException e) {
                throw new OpenEJBException(messages.format("cl0004", beanInfo.home, beanInfo.ejbDeploymentId, e.getMessage()));
            }
            try {
                remote = SafeToolkit.loadClass(beanInfo.remote, beanInfo.codebase);
            }
            catch (OpenEJBException e) {
                throw new OpenEJBException(messages.format("cl0003", beanInfo.remote, beanInfo.ejbDeploymentId, e.getMessage()));
            }
        }
        if (beanInfo.localHome != null) {
            try {
                localhome = SafeToolkit.loadClass(beanInfo.localHome, beanInfo.codebase);
            }
            catch (OpenEJBException e) {
                throw new OpenEJBException(messages.format("cl0004", beanInfo.localHome, beanInfo.ejbDeploymentId, e.getMessage()));
            }
            try {
                local = SafeToolkit.loadClass(beanInfo.local, beanInfo.codebase);
            }
            catch (OpenEJBException e) {
                throw new OpenEJBException(messages.format("cl0003", beanInfo.local, beanInfo.ejbDeploymentId, e.getMessage()));
            }
        }
        if (isEntity && ebi.primKeyClass != null) {
            try {
                ejbPk = SafeToolkit.loadClass(ebi.primKeyClass, beanInfo.codebase);
            }
            catch (OpenEJBException e) {
                throw new OpenEJBException(messages.format("cl0006", ebi.primKeyClass, beanInfo.ejbDeploymentId, e.getMessage()));
            }
        }
        IvmContext root = new IvmContext(new NameNode(null, new ParsedName("comp"), null));
        org.openejb.core.DeploymentInfo deployment = this.createDeploymentInfoObject(root, beanInfo.ejbDeploymentId, home, remote, localhome, local, ejbClass, ejbPk, componentType);
        if (isEntity) {
            deployment.setIsReentrant(ebi.reentrant.equalsIgnoreCase("true"));
            if (ebi.persistenceType.equals("Container")) {
                deployment.setCmrFields(ebi.cmpFieldNames);
                try {
                    if (ebi.primKeyField != null) {
                        deployment.setPrimKeyField(ebi.primKeyField);
                    }
                }
                catch (NoSuchFieldException ne) {
                    throw new SystemException("Can not set prim-key-field on deployment " + deployment.getDeploymentID(), ne);
                }
                if (ebi.queries != null) {
                    for (int i = 0; i < ebi.queries.length; ++i) {
                        Vector finderMethods = new Vector();
                        this.resolveMethods(finderMethods, deployment.getHomeInterface(), ebi.queries[i].method);
                        for (int j = 0; j < finderMethods.size(); ++j) {
                            deployment.addQuery((Method)finderMethods.elementAt(j), ebi.queries[i].queryStatement);
                        }
                    }
                }
            }
        }
        if (beanInfo.transactionType == null) {
            deployment.setBeanManagedTransaction(false);
        } else if (beanInfo.transactionType.equals("Bean")) {
            deployment.setBeanManagedTransaction(true);
        } else {
            deployment.setBeanManagedTransaction(false);
        }
        try {
            if (beanInfo.transactionType != null && beanInfo.transactionType.equalsIgnoreCase("Bean")) {
                if (componentType == 6) {
                    root.bind("java:comp/UserTransaction", (Object)new EncUserTransaction(new CoreUserTransaction()));
                } else if (componentType == 7) {
                    root.bind("java:comp/UserTransaction", (Object)new org.openejb.core.stateless.EncUserTransaction(new CoreUserTransaction()));
                }
            }
        }
        catch (NamingException ne) {
            throw new SystemException("Can't bind UserTransaction to bean deployment JNDI ENC", ne);
        }
        this.bindJndiBeanRefs(beanInfo, root);
        this.bindJndiLocalBeanRefs(beanInfo, root);
        this.bindJndiEnvEntries(beanInfo, root);
        this.bindJndiResourceRefs(beanInfo, root);
        return deployment;
    }

    protected org.openejb.core.DeploymentInfo createDeploymentInfoObject(Context root, Object did, Class homeClass, Class remoteClass, Class localHomeClass, Class localClass, Class beanClass, Class pkClass, byte componentType) throws SystemException {
        org.openejb.core.DeploymentInfo info = new org.openejb.core.DeploymentInfo(did, homeClass, remoteClass, localHomeClass, localClass, beanClass, pkClass, componentType);
        info.setJndiEnc(root);
        return info;
    }

    public ConnectionManager assembleConnectionManager(ConnectionManagerInfo cmInfo) throws OpenEJBException, Exception {
        Class managerClass = SafeToolkit.loadClass(cmInfo.className, cmInfo.codebase);
        this.checkImplementation(CONNECTION_MANAGER, managerClass, "ConnectionManager", cmInfo.connectionManagerId);
        ConnectionManager connectionManager = (ConnectionManager)toolkit.newInstance(managerClass);
        if (cmInfo.properties != null) {
            Properties clonedProps = (Properties)this.props.clone();
            clonedProps.putAll((Map<?, ?>)cmInfo.properties);
            this.applyProperties(connectionManager, clonedProps);
        }
        return connectionManager;
    }

    public ManagedConnectionFactory assembleManagedConnectionFactory(ManagedConnectionFactoryInfo mngedConFactInfo) throws OpenEJBException, Exception {
        ManagedConnectionFactory managedConnectionFactory = null;
        try {
            Class factoryClass = SafeToolkit.loadClass(mngedConFactInfo.className, mngedConFactInfo.codebase);
            this.checkImplementation(CONNECTOR, factoryClass, "Connector", mngedConFactInfo.id);
            managedConnectionFactory = (ManagedConnectionFactory)toolkit.newInstance(factoryClass);
        }
        catch (Exception e) {
            throw new OpenEJBException("Could not instantiate Connector '" + mngedConFactInfo.id + "'.", e);
        }
        try {
            if (mngedConFactInfo.properties != null) {
                Properties clonedProps = (Properties)this.props.clone();
                clonedProps.putAll((Map<?, ?>)mngedConFactInfo.properties);
                this.applyProperties(managedConnectionFactory, clonedProps);
            }
        }
        catch (InvocationTargetException ite) {
            throw new OpenEJBException("Could not initialize Connector '" + mngedConFactInfo.id + "'.", ite.getTargetException());
        }
        catch (Exception e) {
            throw new OpenEJBException("Could not initialize Connector '" + mngedConFactInfo.id + "'.", e);
        }
        return managedConnectionFactory;
    }

    public SecurityService assembleSecurityService(SecurityServiceInfo securityInfo) throws OpenEJBException, Exception {
        Class serviceClass = SafeToolkit.loadClass(securityInfo.factoryClassName, securityInfo.codebase);
        this.checkImplementation(SECURITY_SERVICE, serviceClass, "SecurityService", securityInfo.serviceName);
        SecurityService securityService = (SecurityService)toolkit.newInstance(serviceClass);
        if (securityInfo.properties != null) {
            this.applyProperties(securityService, securityInfo.properties);
        }
        return securityService;
    }

    public TransactionManager assembleTransactionManager(TransactionServiceInfo txInfo) throws OpenEJBException, Exception {
        Class serviceClass = SafeToolkit.loadClass(txInfo.factoryClassName, txInfo.codebase);
        this.checkImplementation(TRANSACTION_SERVICE, serviceClass, "TransactionService", txInfo.serviceName);
        TransactionService txService = (TransactionService)toolkit.newInstance(serviceClass);
        if (txInfo.properties != null) {
            this.applyProperties(txService, txInfo.properties);
        }
        return new TransactionManagerWrapper(txService.getTransactionManager());
    }

    public void applyProxyFactory(IntraVmServerInfo ivmInfo) throws OpenEJBException {
        Class factoryClass = SafeToolkit.loadClass(ivmInfo.proxyFactoryClassName, ivmInfo.codebase);
        this.checkImplementation(PROXY_FACTORY, factoryClass, "ProxyFactory", ivmInfo.factoryName);
        ProxyFactory factory = (ProxyFactory)toolkit.newInstance(factoryClass);
        factory.init(ivmInfo.properties);
        ProxyManager.registerFactory("ivm_server", factory);
        ProxyManager.setDefaultFactory("ivm_server");
    }

    public void applyProperties(Object target, Properties props) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        if (props != null) {
            Method method = target.getClass().getMethod("init", Properties.class);
            method.invoke(target, props);
        }
    }

    public void applyTransactionAttributes(org.openejb.core.DeploymentInfo deploymentInfo, MethodTransactionInfo[] mtis) {
        for (int i = 0; i < mtis.length; ++i) {
            MethodTransactionInfo transInfo = mtis[i];
            MethodInfo[] mis = transInfo.methods;
            for (int z = 0; z < mis.length; ++z) {
                MethodInfo methodInfo = mis[z];
                if (mis[z].ejbDeploymentId != null && !mis[z].ejbDeploymentId.equals(deploymentInfo.getDeploymentID()) || deploymentInfo.isBeanManagedTransaction()) continue;
                Vector methodVect = new Vector();
                if (methodInfo.methodIntf == null) {
                    this.resolveMethods(methodVect, deploymentInfo.getRemoteInterface(), methodInfo);
                    this.resolveMethods(methodVect, deploymentInfo.getHomeInterface(), methodInfo);
                } else if (methodInfo.methodIntf.equals("Home")) {
                    this.resolveMethods(methodVect, deploymentInfo.getHomeInterface(), methodInfo);
                } else if (methodInfo.methodIntf.equals("Remote")) {
                    this.resolveMethods(methodVect, deploymentInfo.getRemoteInterface(), methodInfo);
                }
                for (int x = 0; x < methodVect.size(); ++x) {
                    Method method = (Method)methodVect.elementAt(x);
                    if ((method.getDeclaringClass() == (class$javax$ejb$EJBObject == null ? AssemblerTool.class$("javax.ejb.EJBObject") : class$javax$ejb$EJBObject) || method.getDeclaringClass() == (class$javax$ejb$EJBHome == null ? AssemblerTool.class$("javax.ejb.EJBHome") : class$javax$ejb$EJBHome)) && !method.getName().equals("remove")) continue;
                    deploymentInfo.setMethodTransactionAttribute(method, transInfo.transAttribute);
                }
            }
        }
    }

    public void applySecurityRoleReference(org.openejb.core.DeploymentInfo deployment, EnterpriseBeanInfo beanInfo, RoleMapping roleMapping) {
        if (beanInfo.securityRoleReferences != null) {
            for (int l = 0; l < beanInfo.securityRoleReferences.length; ++l) {
                SecurityRoleReferenceInfo roleRef = beanInfo.securityRoleReferences[l];
                String[] physicalRoles = roleMapping.getPhysicalRoles(roleRef.roleLink);
                deployment.addSecurityRoleReference(roleRef.roleName, physicalRoles);
            }
        }
    }

    public void applyMethodPermissions(org.openejb.core.DeploymentInfo deployment, MethodPermissionInfo[] permissions) {
        for (int a = 0; a < permissions.length; ++a) {
            MethodPermissionInfo methodPermission = permissions[a];
            for (int b = 0; b < methodPermission.methods.length; ++b) {
                MethodInfo methodInfo = methodPermission.methods[b];
                if (methodInfo.ejbDeploymentId != null && !methodInfo.ejbDeploymentId.equals(deployment.getDeploymentID())) continue;
                Method[] methods = this.resolveMethodInfo(methodInfo, deployment);
                for (int c = 0; c < methods.length; ++c) {
                    deployment.appendMethodPermissions(methods[c], methodPermission.roleNames);
                }
            }
        }
    }

    public void applyMethodPermissions(org.openejb.core.DeploymentInfo deployment, MethodPermissionInfo[] permissions, RoleMapping roleMapping) {
        for (int i = 0; i < permissions.length; ++i) {
            permissions[i] = this.applyRoleMappings(permissions[i], roleMapping);
        }
        this.applyMethodPermissions(deployment, permissions);
    }

    public MethodPermissionInfo applyRoleMappings(MethodPermissionInfo methodPermission, RoleMapping roleMapping) {
        HashSet<String> physicalRoles = new HashSet<String>();
        for (int z = 0; z < methodPermission.roleNames.length; ++z) {
            String[] physicals = roleMapping.getPhysicalRoles(methodPermission.roleNames[z]);
            if (physicals != null) {
                for (int x = 0; x < physicals.length; ++x) {
                    physicalRoles.add(physicals[x]);
                }
                continue;
            }
            physicalRoles.add(methodPermission.roleNames[z]);
        }
        methodPermission.roleNames = new String[physicalRoles.size()];
        physicalRoles.toArray(methodPermission.roleNames);
        return methodPermission;
    }

    protected Method[] resolveMethodInfo(MethodInfo methodInfo, org.openejb.core.DeploymentInfo di) {
        Vector methodVect = new Vector();
        Class remote = di.getRemoteInterface();
        Class home = di.getHomeInterface();
        if (methodInfo.methodIntf == null) {
            this.resolveMethods(methodVect, remote, methodInfo);
            this.resolveMethods(methodVect, home, methodInfo);
        } else if (methodInfo.methodIntf.equals("Remote")) {
            this.resolveMethods(methodVect, remote, methodInfo);
        } else {
            this.resolveMethods(methodVect, home, methodInfo);
        }
        return methodVect.toArray(new Method[methodVect.size()]);
    }

    protected void resolveMethods(Vector methods, Class intrface, MethodInfo mi) throws SecurityException {
        if (mi.methodName.equals("*")) {
            Method[] mthds = intrface.getMethods();
            for (int i = 0; i < mthds.length; ++i) {
                methods.add(mthds[i]);
            }
        } else if (mi.methodParams != null) {
            try {
                Class[] params = new Class[mi.methodParams.length];
                ClassLoader cl = intrface.getClassLoader();
                for (int i = 0; i < params.length; ++i) {
                    try {
                        params[i] = this.getClassForParam(mi.methodParams[i], cl);
                        continue;
                    }
                    catch (ClassNotFoundException cnfe) {
                        // empty catch block
                    }
                }
                Method m = intrface.getMethod(mi.methodName, params);
                methods.add(m);
            }
            catch (NoSuchMethodException nsme) {}
        } else {
            Method[] ms = intrface.getMethods();
            for (int i = 0; i < ms.length; ++i) {
                if (!ms[i].getName().equals(mi.methodName)) continue;
                methods.add(ms[i]);
            }
        }
    }

    protected void bindJndiResourceRefs(EnterpriseBeanInfo bean, IvmContext root) throws OpenEJBException {
        if (bean.jndiEnc == null || bean.jndiEnc.ejbReferences == null) {
            return;
        }
        ResourceReferenceInfo reference = null;
        for (int i = 0; i < bean.jndiEnc.resourceRefs.length; ++i) {
            reference = bean.jndiEnc.resourceRefs[i];
            ENCReference ref = null;
            if (reference.resourceID != null) {
                try {
                    String jndiName = "java:openejb/connector/" + reference.resourceID;
                    IntraVmJndiReference ref2 = new IntraVmJndiReference(jndiName);
                    if ((class$org$openejb$alt$assembler$classic$EntityBeanInfo == null ? AssemblerTool.class$("org.openejb.alt.assembler.classic.EntityBeanInfo") : class$org$openejb$alt$assembler$classic$EntityBeanInfo).isAssignableFrom(bean.getClass())) {
                        ref = new org.openejb.core.entity.EncReference(ref2);
                    }
                    if ((class$org$openejb$alt$assembler$classic$StatefulBeanInfo == null ? AssemblerTool.class$("org.openejb.alt.assembler.classic.StatefulBeanInfo") : class$org$openejb$alt$assembler$classic$StatefulBeanInfo).isAssignableFrom(bean.getClass())) {
                        ref = new EncReference(ref2);
                    }
                    if ((class$org$openejb$alt$assembler$classic$StatelessBeanInfo == null ? AssemblerTool.class$("org.openejb.alt.assembler.classic.StatelessBeanInfo") : class$org$openejb$alt$assembler$classic$StatelessBeanInfo).isAssignableFrom(bean.getClass())) {
                        ref = new org.openejb.core.stateless.EncReference(ref2);
                    }
                    throw new SystemException("This can't happen");
                }
                catch (Exception e) {
                    throw new OpenEJBException("Something went wrong here" + e);
                }
            } else {
                String openEjbSubContextName = "java:openejb/remote_jndi_contexts/" + reference.location.jndiContextId;
                String jndiName = reference.location.remoteRefName;
                JndiReference ref2 = new JndiReference(openEjbSubContextName, jndiName);
                if ((class$org$openejb$alt$assembler$classic$StatefulBeanInfo == null ? AssemblerTool.class$("org.openejb.alt.assembler.classic.StatefulBeanInfo") : class$org$openejb$alt$assembler$classic$StatefulBeanInfo).isAssignableFrom(bean.getClass())) {
                    ref = new EncReference(ref2);
                } else if ((class$org$openejb$alt$assembler$classic$StatelessBeanInfo == null ? AssemblerTool.class$("org.openejb.alt.assembler.classic.StatelessBeanInfo") : class$org$openejb$alt$assembler$classic$StatelessBeanInfo).isAssignableFrom(bean.getClass())) {
                    ref = new org.openejb.core.stateless.EncReference(ref2);
                } else if ((class$org$openejb$alt$assembler$classic$EntityBeanInfo == null ? AssemblerTool.class$("org.openejb.alt.assembler.classic.EntityBeanInfo") : class$org$openejb$alt$assembler$classic$EntityBeanInfo).isAssignableFrom(bean.getClass())) {
                    ref = new org.openejb.core.entity.EncReference(ref2);
                } else {
                    throw new SystemException("This can't happen");
                }
            }
            if (ref == null) continue;
            try {
                root.bind(this.prefixForBinding(reference.referenceName), (Object)ref);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException();
            }
        }
    }

    protected void bindJndiLocalBeanRefs(EnterpriseBeanInfo bean, IvmContext root) {
        if (bean.jndiEnc == null || bean.jndiEnc.ejbLocalReferences == null) {
            return;
        }
        EjbLocalReferenceInfo reference = null;
        for (int i = 0; i < bean.jndiEnc.ejbLocalReferences.length; ++i) {
            reference = bean.jndiEnc.ejbLocalReferences[i];
            ENCReference ref = null;
            if (reference.location != null && !reference.location.remote) {
                String jndiName = "java:openejb/ejb/" + reference.location.ejbDeploymentId + "Local";
                IntraVmJndiReference ref2 = new IntraVmJndiReference(jndiName);
                ref = (class$org$openejb$alt$assembler$classic$StatefulBeanInfo == null ? AssemblerTool.class$("org.openejb.alt.assembler.classic.StatefulBeanInfo") : class$org$openejb$alt$assembler$classic$StatefulBeanInfo).isAssignableFrom(bean.getClass()) ? new EncReference(ref2) : ((class$org$openejb$alt$assembler$classic$StatelessBeanInfo == null ? AssemblerTool.class$("org.openejb.alt.assembler.classic.StatelessBeanInfo") : class$org$openejb$alt$assembler$classic$StatelessBeanInfo).isAssignableFrom(bean.getClass()) ? new org.openejb.core.stateless.EncReference(ref2) : new org.openejb.core.entity.EncReference(ref2));
            }
            if (ref == null) continue;
            try {
                root.bind(this.prefixForBinding(reference.referenceName), ref);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException();
            }
        }
    }

    protected void bindJndiBeanRefs(EnterpriseBeanInfo bean, IvmContext root) {
        if (bean.jndiEnc == null || bean.jndiEnc.ejbReferences == null) {
            return;
        }
        EjbReferenceInfo reference = null;
        for (int i = 0; i < bean.jndiEnc.ejbReferences.length; ++i) {
            reference = bean.jndiEnc.ejbReferences[i];
            ENCReference ref = null;
            if (!reference.location.remote) {
                String jndiName = "java:openejb/ejb/" + reference.location.ejbDeploymentId;
                IntraVmJndiReference ref2 = new IntraVmJndiReference(jndiName);
                ref = (class$org$openejb$alt$assembler$classic$StatefulBeanInfo == null ? AssemblerTool.class$("org.openejb.alt.assembler.classic.StatefulBeanInfo") : class$org$openejb$alt$assembler$classic$StatefulBeanInfo).isAssignableFrom(bean.getClass()) ? new EncReference(ref2) : ((class$org$openejb$alt$assembler$classic$StatelessBeanInfo == null ? AssemblerTool.class$("org.openejb.alt.assembler.classic.StatelessBeanInfo") : class$org$openejb$alt$assembler$classic$StatelessBeanInfo).isAssignableFrom(bean.getClass()) ? new org.openejb.core.stateless.EncReference(ref2) : new org.openejb.core.entity.EncReference(ref2));
            } else {
                String openEjbSubContextName = "java:openejb/remote_jndi_contexts/" + reference.location.jndiContextId;
                String jndiName = reference.location.remoteRefName;
                JndiReference ref2 = new JndiReference(openEjbSubContextName, jndiName);
                ref = (class$org$openejb$alt$assembler$classic$StatefulBeanInfo == null ? AssemblerTool.class$("org.openejb.alt.assembler.classic.StatefulBeanInfo") : class$org$openejb$alt$assembler$classic$StatefulBeanInfo).isAssignableFrom(bean.getClass()) ? new EncReference(ref2) : ((class$org$openejb$alt$assembler$classic$StatelessBeanInfo == null ? AssemblerTool.class$("org.openejb.alt.assembler.classic.StatelessBeanInfo") : class$org$openejb$alt$assembler$classic$StatelessBeanInfo).isAssignableFrom(bean.getClass()) ? new org.openejb.core.stateless.EncReference(ref2) : new org.openejb.core.entity.EncReference(ref2));
            }
            if (ref == null) continue;
            try {
                root.bind(this.prefixForBinding(reference.referenceName), (Object)ref);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException();
            }
        }
    }

    protected void bindJndiEnvEntries(EnterpriseBeanInfo bean, IvmContext root) {
        if (bean.jndiEnc == null || bean.jndiEnc.envEntries == null) {
            return;
        }
        EnvEntryInfo entry = null;
        for (int i = 0; i < bean.jndiEnc.envEntries.length; ++i) {
            entry = bean.jndiEnc.envEntries[i];
            Class<?> type = null;
            try {
                type = Class.forName(entry.type.trim());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Invalid environment entry type: " + entry.type.trim() + " for entry: " + entry.name);
            }
            Object obj = null;
            try {
                if (type == (class$java$lang$String == null ? AssemblerTool.class$("java.lang.String") : class$java$lang$String)) {
                    obj = new String(entry.value);
                } else if (type == (class$java$lang$Double == null ? AssemblerTool.class$("java.lang.Double") : class$java$lang$Double)) {
                    obj = new Double(entry.value);
                } else if (type == (class$java$lang$Integer == null ? AssemblerTool.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    obj = new Integer(entry.value);
                } else if (type == (class$java$lang$Long == null ? AssemblerTool.class$("java.lang.Long") : class$java$lang$Long)) {
                    obj = new Long(entry.value);
                } else if (type == (class$java$lang$Float == null ? AssemblerTool.class$("java.lang.Float") : class$java$lang$Float)) {
                    obj = new Float(entry.value);
                } else if (type == (class$java$lang$Short == null ? AssemblerTool.class$("java.lang.Short") : class$java$lang$Short)) {
                    obj = new Short(entry.value);
                } else if (type == (class$java$lang$Boolean == null ? AssemblerTool.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                    obj = new Boolean(entry.value);
                } else if (type == (class$java$lang$Byte == null ? AssemblerTool.class$("java.lang.Byte") : class$java$lang$Byte)) {
                    obj = new Byte(entry.value);
                }
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
            if (obj == null) continue;
            try {
                root.bind(this.prefixForBinding(entry.name), obj);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException();
            }
        }
    }

    protected String prefixForBinding(String name) {
        if (name.charAt(0) == '/') {
            name = name.substring(1);
        }
        if (!name.startsWith("java:comp/env") && !name.startsWith("comp/env")) {
            name = name.startsWith("env/") ? "comp/" + name : "comp/env/" + name;
        }
        return name;
    }

    protected void checkImplementation(Class intrfce, Class factory, String serviceType, String serviceName) throws OpenEJBException {
        if (!intrfce.isAssignableFrom(factory)) {
            this.handleException("init.0100", serviceType, serviceName, factory.getName(), intrfce.getName());
        }
    }

    private Class getClassForParam(String className, ClassLoader cl) throws ClassNotFoundException {
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if (className.equals("int")) {
            return Integer.TYPE;
        }
        if (className.equals("double")) {
            return Double.TYPE;
        }
        if (className.equals("long")) {
            return Long.TYPE;
        }
        if (className.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (className.equals("float")) {
            return Float.TYPE;
        }
        if (className.equals("char")) {
            return Character.TYPE;
        }
        if (className.equals("short")) {
            return Short.TYPE;
        }
        if (className.equals("byte")) {
            return Byte.TYPE;
        }
        return cl.loadClass(className);
    }

    public void handleException(String errorCode, Object arg0, Object arg1, Object arg2, Object arg3) throws OpenEJBException {
        throw new OpenEJBException(messages.format(errorCode, arg0, arg1, arg2, arg3));
    }

    public void handleException(String errorCode, Object arg0, Object arg1, Object arg2) throws OpenEJBException {
        throw new OpenEJBException(messages.format(errorCode, arg0, arg1, arg2));
    }

    public void handleException(String errorCode, Object arg0, Object arg1) throws OpenEJBException {
        throw new OpenEJBException(messages.format(errorCode, arg0, arg1));
    }

    public void handleException(String errorCode, Object arg0) throws OpenEJBException {
        throw new OpenEJBException(messages.format(errorCode, arg0));
    }

    public void handleException(String errorCode) throws OpenEJBException {
        throw new OpenEJBException(messages.format(errorCode));
    }

    public void logWarning(String errorCode, Object arg0, Object arg1, Object arg2, Object arg3) {
        System.out.println("Warning: " + messages.format(errorCode, arg0, arg1, arg2, arg3));
    }

    public void logWarning(String errorCode, Object arg0, Object arg1, Object arg2) {
        System.out.println("Warning: " + messages.format(errorCode, arg0, arg1, arg2));
    }

    public void logWarning(String errorCode, Object arg0, Object arg1) {
        System.out.println("Warning: " + messages.format(errorCode, arg0, arg1));
    }

    public void logWarning(String errorCode, Object arg0) {
        System.out.println("Warning: " + messages.format(errorCode, arg0));
    }

    public void logWarning(String errorCode) {
        System.out.println("Warning: " + messages.format(errorCode));
    }

    static {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        codebases.put("CLASSPATH", cl);
        System.setProperty("noBanner", "true");
    }

    public static class RoleMapping {
        private HashMap map = new HashMap();

        public RoleMapping(RoleMappingInfo[] roleMappingInfos) {
            for (int i = 0; i < roleMappingInfos.length; ++i) {
                RoleMappingInfo mapping = roleMappingInfos[i];
                for (int z = 0; z < mapping.logicalRoleNames.length; ++z) {
                    this.map.put(mapping.logicalRoleNames[z], mapping.physicalRoleNames);
                }
            }
        }

        public String[] logicalRoles() {
            return (String[])this.map.keySet().toArray();
        }

        public String[] getPhysicalRoles(String logicalRole) {
            String[] roles = (String[])this.map.get(logicalRole);
            return roles != null ? (String[])roles.clone() : null;
        }
    }
}

