/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.alt.assembler.classic.xml;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.xerces.parsers.DOMParser;
import org.openejb.OpenEJBException;
import org.openejb.alt.assembler.classic.OpenEjbConfiguration;
import org.openejb.alt.assembler.classic.OpenEjbConfigurationFactory;
import org.openejb.alt.assembler.classic.xml.XMLErrorHandler;
import org.openejb.alt.assembler.classic.xml.XmlOpenEJBConfiguration;
import org.openejb.util.SafeProperties;
import org.openejb.util.SafeToolkit;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class DomOpenEjbConfigurationFactory
implements OpenEjbConfigurationFactory {
    private SafeToolkit toolkit = SafeToolkit.getToolkit("DomConfig");
    private XmlOpenEJBConfiguration config;
    private String configXml;

    public void init(Properties props) throws OpenEJBException {
        SafeProperties safeProps = this.toolkit.getSafeProperties(props);
        this.configXml = safeProps.getProperty("org/openejb/configuration_source");
        File tmp = new File(this.configXml);
    }

    public OpenEjbConfiguration getOpenEjbConfiguration() throws OpenEJBException {
        try {
            if (this.config == null) {
                this.config = new XmlOpenEJBConfiguration();
                DOMParser parser = new DOMParser();
                parser.setErrorHandler((ErrorHandler)new XMLErrorHandler());
                parser.setFeature("http://xml.org/sax/features/validation", true);
                parser.setFeature("http://apache.org/xml/features/validation/warn-on-undeclared-elemdef", true);
                parser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
                parser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
                parser.parse(this.configXml);
                Document document = parser.getDocument();
                this.config.initializeFromDOM(document);
            }
            return this.config;
        }
        catch (IOException e) {
            throw new OpenEJBException("Problem creating the OpenEjbConfiguration structure from file " + this.configXml, e);
        }
        catch (SAXNotSupportedException e) {
            throw new OpenEJBException("Problem creating the OpenEjbConfiguration structure from file " + this.configXml, e);
        }
        catch (SAXNotRecognizedException e) {
            throw new OpenEJBException("Problem creating the OpenEjbConfiguration structure from file " + this.configXml, e);
        }
        catch (SAXException e) {
            throw new OpenEJBException("Problem creating the OpenEjbConfiguration structure from file " + this.configXml, e);
        }
    }
}

