/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.alt.assembler.classic.xml;

import java.util.Properties;
import java.util.Vector;
import org.openejb.OpenEJBException;
import org.openejb.alt.assembler.classic.xml.DomObject;
import org.openejb.util.SafeToolkit;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DomTools {
    public static SafeToolkit toolkit = SafeToolkit.getToolkit("XML configuration loader");
    public static final String PROPERTIES = "properties";
    public static final String PROPERTY = "property";
    public static final String PROPERTY_NAME = "property-name";
    public static final String PROPERTY_VALUE = "property-value";
    public static final boolean debug = false;
    public static int debugRecursionDepth = 0;

    public static Properties readProperties(Node node) throws OpenEJBException {
        Node propertiesElement = DomTools.getChildElement(node, PROPERTIES);
        if (propertiesElement == null) {
            return new Properties();
        }
        Node[] property = DomTools.getChildElements(propertiesElement, PROPERTY);
        Properties properties = new Properties();
        String name = null;
        String value = null;
        for (int i = 0; i < property.length; ++i) {
            name = DomTools.getChildElementPCData(property[i], PROPERTY_NAME);
            value = DomTools.getChildElementPCData(property[i], PROPERTY_VALUE);
            if (name == null || value == null) continue;
            properties.setProperty(name, value);
        }
        return properties;
    }

    protected static DomObject[] collectChildElementsByType(Node node, Class classType, String elementType) throws OpenEJBException {
        if (node == null) {
            return null;
        }
        NodeList list = node.getChildNodes();
        Vector<DomObject> tmp = new Vector<DomObject>();
        Node child = null;
        for (int i = 0; i < list.getLength(); ++i) {
            Element element;
            child = list.item(i);
            if (child.getNodeType() != 1 || !(element = (Element)child).getTagName().equals(elementType)) continue;
            DomObject info = (DomObject)toolkit.newInstance(classType);
            tmp.addElement(info);
            info.initializeFromDOM(element);
        }
        Object[] domObjects = new DomObject[tmp.size()];
        tmp.copyInto(domObjects);
        return domObjects;
    }

    protected static DomObject collectChildElementByType(Node node, Class classType, String elementType) throws OpenEJBException {
        try {
            NodeList list = node.getChildNodes();
            Node child = null;
            DomObject domObject = null;
            for (int i = 0; i < list.getLength(); ++i) {
                Element element;
                child = list.item(i);
                if (child.getNodeType() != 1 || !(element = (Element)child).getTagName().equals(elementType)) continue;
                domObject = (DomObject)toolkit.newInstance(classType);
                domObject.initializeFromDOM(element);
                break;
            }
            return domObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OpenEJBException(e);
        }
    }

    protected static String[] getChildElementsPCData(Node node, String elementType) throws OpenEJBException {
        NodeList list = node.getChildNodes();
        Node child = null;
        Vector<String> tmp = new Vector<String>();
        for (int i = 0; i < list.getLength(); ++i) {
            Element element;
            child = list.item(i);
            if (child.getNodeType() != 1 || !(element = (Element)child).getTagName().equals(elementType)) continue;
            tmp.addElement(DomTools.getElementPCData(element));
        }
        Object[] pcdata = new String[tmp.size()];
        tmp.copyInto(pcdata);
        return pcdata;
    }

    protected static String getChildElementPCData(Node node, String elementType) throws OpenEJBException {
        NodeList list = node.getChildNodes();
        Node child = null;
        String pcdata = null;
        for (int i = 0; i < list.getLength(); ++i) {
            Element element;
            child = list.item(i);
            if (child.getNodeType() != 1 || !(element = (Element)child).getTagName().equals(elementType)) continue;
            pcdata = DomTools.getElementPCData(element);
            break;
        }
        return pcdata;
    }

    protected static String getElementPCData(Node node) throws OpenEJBException {
        Node child = node.getFirstChild();
        if (child == null || child.getNodeType() != 3) {
            return null;
        }
        Text text = (Text)child;
        String pcdata = text.getData();
        return pcdata != null ? pcdata.trim() : null;
    }

    protected static Properties getElementAttributes(Node node) {
        NamedNodeMap nodeMap = node.getAttributes();
        int size = nodeMap.getLength();
        Properties attributes = new Properties();
        for (int i = 0; i < size; ++i) {
            node = nodeMap.item(i);
            attributes.setProperty(node.getNodeName(), node.getNodeValue());
        }
        return attributes;
    }

    protected static Node getChildElement(Node node, String childName) throws OpenEJBException {
        NodeList list = node.getChildNodes();
        Node child = null;
        for (int i = 0; i < list.getLength(); ++i) {
            Element element;
            child = list.item(i);
            if (child.getNodeType() != 1 || !(element = (Element)child).getTagName().equals(childName)) continue;
            return child;
        }
        return null;
    }

    protected static Node[] getChildElements(Node node, String childName) throws OpenEJBException {
        NodeList list = node.getChildNodes();
        Node child = null;
        Vector<Element> tmp = new Vector<Element>();
        for (int i = 0; i < list.getLength(); ++i) {
            Element element;
            child = list.item(i);
            if (child.getNodeType() != 1 || !(element = (Element)child).getTagName().equals(childName)) continue;
            tmp.addElement(element);
        }
        Object[] children = new Node[tmp.size()];
        tmp.copyInto(children);
        return children;
    }
}

