/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.alt.config;

import java.lang.reflect.Method;
import org.openejb.OpenEJBException;
import org.openejb.alt.config.Bean;
import org.openejb.alt.config.ConfigUtils;
import org.openejb.alt.config.EjbJarUtils;
import org.openejb.alt.config.ejb11.EjbDeployment;
import org.openejb.alt.config.ejb11.EjbJar;
import org.openejb.alt.config.ejb11.OpenejbJar;
import org.openejb.alt.config.ejb11.ResourceLink;
import org.openejb.alt.config.ejb11.ResourceRef;
import org.openejb.alt.config.sys.Connector;
import org.openejb.alt.config.sys.Container;
import org.openejb.alt.config.sys.Openejb;
import org.openejb.util.SafeToolkit;

public class AutoDeployer {
    private Openejb config;
    private String configFile;
    private Container[] containers;
    private Connector[] resources;

    public AutoDeployer() throws OpenEJBException {
        this(ConfigUtils.readConfig());
    }

    public AutoDeployer(Openejb config) {
        this.config = config;
        this.containers = config.getContainer();
        this.resources = config.getConnector();
        System.out.println("resources " + this.resources.length);
    }

    public void init() throws OpenEJBException {
    }

    public OpenejbJar deploy(String jarLocation) throws OpenEJBException {
        EjbJar jar = EjbJarUtils.readEjbJar(jarLocation);
        return this.deploy(jar, jarLocation);
    }

    public OpenejbJar deploy(EjbJar jar, String jarLocation) throws OpenEJBException {
        OpenejbJar openejbJar = new OpenejbJar();
        Bean[] beans = this.getBeans(jar);
        for (int i = 0; i < beans.length; ++i) {
            openejbJar.addEjbDeployment(this.deployBean(beans[i], jarLocation));
        }
        return openejbJar;
    }

    private EjbDeployment deployBean(Bean bean, String jarLocation) throws OpenEJBException {
        EjbDeployment deployment = new EjbDeployment();
        deployment.setEjbName(bean.getEjbName());
        deployment.setDeploymentId(this.autoAssignDeploymentId(bean));
        deployment.setContainerId(this.autoAssignContainerId(bean));
        ResourceRef[] refs = bean.getResourceRef();
        if (refs.length > 1) {
            throw new OpenEJBException("Beans with more that one resource-ref cannot be autodeployed;  there is no accurate way to determine how the references should be mapped.");
        }
        for (int i = 0; i < refs.length; ++i) {
            deployment.addResourceLink(this.autoAssingResourceRef(refs[i]));
        }
        if (bean.getType().equals("CMP_ENTITY")) {
            Class tempBean;
            if (bean.getHome() != null && this.hasFinderMethods(tempBean = SafeToolkit.loadTempClass(bean.getHome(), jarLocation))) {
                throw new OpenEJBException("CMP 1.1 Beans with finder methods cannot be autodeployed; finder methods require OQL Select statements which cannot be generated accurately.");
            }
            if (bean.getLocalHome() != null && this.hasFinderMethods(tempBean = SafeToolkit.loadTempClass(bean.getHome(), jarLocation))) {
                throw new OpenEJBException("CMP 1.1 Beans with finder methods cannot be autodeployed; finder methods require OQL Select statements which cannot be generated accurately.");
            }
        }
        return deployment;
    }

    private boolean hasFinderMethods(Class bean) throws OpenEJBException {
        Method[] methods = bean.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().startsWith("find") || methods[i].getName().equals("findByPrimaryKey")) continue;
            return true;
        }
        return false;
    }

    private String autoAssignDeploymentId(Bean bean) throws OpenEJBException {
        return bean.getEjbName();
    }

    private String autoAssignContainerId(Bean bean) throws OpenEJBException {
        Object answer = null;
        boolean replied = false;
        Container[] cs = this.getUsableContainers(bean);
        if (cs.length == 0) {
            throw new OpenEJBException("A container of type " + bean.getType() + " must be declared in the configuration file.");
        }
        return cs[0].getId();
    }

    private ResourceLink autoAssingResourceRef(ResourceRef ref) throws OpenEJBException {
        if (this.resources.length == 0) {
            throw new OpenEJBException("A Connector must be declared in the configuration file to satisfy the resource-ref " + ref.getResRefName());
        }
        ResourceLink link = new ResourceLink();
        link.setResRefName(ref.getResRefName());
        link.setResId(this.resources[0].getId());
        return link;
    }

    private Bean[] getBeans(EjbJar jar) {
        return EjbJarUtils.getBeans(jar);
    }

    private Container[] getUsableContainers(Bean bean) {
        return EjbJarUtils.getUsableContainers(this.containers, bean);
    }
}

