/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.alt.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.openejb.OpenEJBException;
import org.openejb.alt.config.ejb11.OpenejbJar;
import org.openejb.alt.config.sys.Deployments;
import org.openejb.alt.config.sys.Openejb;
import org.openejb.util.FileUtils;
import org.openejb.util.JarUtils;
import org.openejb.util.Logger;
import org.openejb.util.Messages;

public class ConfigUtils {
    private static Messages messages = new Messages("org.openejb.util.resources");
    private static Logger _logger = Logger.getInstance("OpenEJB", "org.openejb.util.resources");

    public static Openejb readConfig() throws OpenEJBException {
        return ConfigUtils.readConfig(ConfigUtils.searchForConfiguration());
    }

    public static Openejb readConfig(String confFile) throws OpenEJBException {
        Openejb obj = null;
        FileReader reader = null;
        try {
            reader = new FileReader(confFile);
            Unmarshaller unmarshaller = new Unmarshaller(Openejb.class);
            unmarshaller.setWhitespacePreserve(true);
            obj = (Openejb)unmarshaller.unmarshal((Reader)reader);
        }
        catch (FileNotFoundException e) {
            ConfigUtils.handleException("conf.1900", confFile, e.getLocalizedMessage());
        }
        catch (MarshalException e) {
            if (e.getException() instanceof IOException) {
                ConfigUtils.handleException("conf.1110", confFile, e.getLocalizedMessage());
            } else if (e.getException() instanceof UnknownHostException) {
                ConfigUtils.handleException("conf.1121", confFile, e.getLocalizedMessage());
            } else {
                ConfigUtils.handleException("conf.1120", confFile, e.getLocalizedMessage());
            }
        }
        catch (ValidationException e) {
            ConfigUtils.handleException("conf.1130", confFile, e.getLocalizedMessage());
        }
        try {
            ((Reader)reader).close();
        }
        catch (Exception e) {
            ConfigUtils.handleException("file.0020", confFile, e.getLocalizedMessage());
        }
        return obj;
    }

    public static void writeConfig(String confFile, Openejb confObject) throws OpenEJBException {
        FileWriter writer = null;
        try {
            File file = new File(confFile);
            writer = new FileWriter(file);
            confObject.marshal(writer);
        }
        catch (IOException e) {
            ConfigUtils.handleException("conf.1040", confFile, e.getLocalizedMessage());
        }
        catch (MarshalException e) {
            if (e.getException() instanceof IOException) {
                ConfigUtils.handleException("conf.1040", confFile, e.getLocalizedMessage());
            } else {
                ConfigUtils.handleException("conf.1050", confFile, e.getLocalizedMessage());
            }
        }
        catch (ValidationException e) {
            ConfigUtils.handleException("conf.1060", confFile, e.getLocalizedMessage());
        }
        try {
            ((Writer)writer).close();
        }
        catch (Exception e) {
            ConfigUtils.handleException("file.0020", confFile, e.getLocalizedMessage());
        }
    }

    public static OpenejbJar readOpenejbJar(String jarFile) throws OpenEJBException {
        JarFile jar = JarUtils.getJarFile(jarFile);
        JarEntry entry = jar.getJarEntry("META-INF/openejb-jar.xml");
        if (entry == null) {
            entry = jar.getJarEntry("openejb-jar.xml");
        }
        if (entry == null) {
            return null;
        }
        InputStreamReader reader = null;
        InputStream stream = null;
        try {
            stream = jar.getInputStream(entry);
            reader = new InputStreamReader(stream);
        }
        catch (Exception e) {
            ConfigUtils.handleException("conf.2110", jarFile, e.getLocalizedMessage());
        }
        OpenejbJar obj = null;
        try {
            Unmarshaller unmarshaller = new Unmarshaller(OpenejbJar.class);
            unmarshaller.setWhitespacePreserve(true);
            obj = (OpenejbJar)unmarshaller.unmarshal((Reader)reader);
        }
        catch (MarshalException e) {
            if (e.getException() instanceof IOException) {
                ConfigUtils.handleException("conf.2110", jarFile, e.getLocalizedMessage());
            } else if (e.getException() instanceof UnknownHostException) {
                ConfigUtils.handleException("conf.2121", jarFile, e.getLocalizedMessage());
            } else {
                ConfigUtils.handleException("conf.2120", jarFile, e.getLocalizedMessage());
            }
        }
        catch (ValidationException e) {
            ConfigUtils.handleException("conf.2130", jarFile, e.getLocalizedMessage());
        }
        try {
            stream.close();
            ((Reader)reader).close();
            jar.close();
        }
        catch (Exception e) {
            ConfigUtils.handleException("file.0020", jarFile, e.getLocalizedMessage());
        }
        return obj;
    }

    public static boolean checkForOpenejbJar(String jarFile) throws OpenEJBException {
        JarFile jar = JarUtils.getJarFile(jarFile);
        JarEntry entry = jar.getJarEntry("META-INF/openejb-jar.xml");
        if (entry == null) {
            entry = jar.getJarEntry("openejb-jar.xml");
        }
        return entry != null;
    }

    public static void writeOpenejbJar(String xmlFile, OpenejbJar openejbJarObject) throws OpenEJBException {
        Writer writer = null;
        try {
            File file = new File(xmlFile);
            File dirs = file.getParentFile();
            if (dirs != null) {
                dirs.mkdirs();
            }
            writer = new FileWriter(file);
            openejbJarObject.marshal(writer);
        }
        catch (SecurityException e) {
            ConfigUtils.handleException("conf.2040", xmlFile, e.getLocalizedMessage());
        }
        catch (IOException e) {
            ConfigUtils.handleException("conf.2040", xmlFile, e.getLocalizedMessage());
        }
        catch (MarshalException e) {
            if (e.getException() instanceof IOException) {
                ConfigUtils.handleException("conf.2040", xmlFile, e.getLocalizedMessage());
            } else {
                ConfigUtils.handleException("conf.2050", xmlFile, e.getLocalizedMessage());
            }
        }
        catch (ValidationException e) {
            ConfigUtils.handleException("conf.2060", xmlFile, e.getLocalizedMessage());
        }
        try {
            writer.close();
        }
        catch (Exception e) {
            ConfigUtils.handleException("file.0020", xmlFile, e.getLocalizedMessage());
        }
    }

    public static String searchForConfiguration() throws OpenEJBException {
        return ConfigUtils.searchForConfiguration(System.getProperty("openejb.configuration"));
    }

    public static String searchForConfiguration(String path) throws OpenEJBException {
        return ConfigUtils.searchForConfiguration(path, System.getProperties());
    }

    public static String searchForConfiguration(String path, Properties props) throws OpenEJBException {
        File file = null;
        if (path != null) {
            file = new File(path);
            if (file != null && file.exists() && file.isFile()) {
                return file.getAbsolutePath();
            }
            try {
                file = FileUtils.getBase(props).getFile(path);
                if (file != null && file.exists() && file.isFile()) {
                    return file.getAbsolutePath();
                }
            }
            catch (FileNotFoundException ignored) {
            }
            catch (IOException ignored) {
                // empty catch block
            }
            try {
                file = FileUtils.getHome(props).getFile(path);
                if (file != null && file.exists() && file.isFile()) {
                    return file.getAbsolutePath();
                }
            }
            catch (FileNotFoundException ignored) {
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        _logger.warning("Cannot find the configuration file [" + path + "], Trying conf/openejb.conf instead.");
        try {
            try {
                file = FileUtils.getBase(props).getFile("conf/openejb.conf");
                if (file != null && file.exists() && file.isFile()) {
                    return file.getAbsolutePath();
                }
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
            try {
                file = FileUtils.getHome(props).getFile("conf/openejb.conf");
                if (file != null && file.exists() && file.isFile()) {
                    return file.getAbsolutePath();
                }
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
            _logger.warning("Cannot find the configuration file [conf/openejb.conf], Creating one.");
            File confDir = FileUtils.getBase(props).getDirectory("conf", true);
            file = ConfigUtils.createConfig(new File(confDir, "openejb.conf"));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new OpenEJBException("Could not locate config file: ", e);
        }
        return file == null ? null : file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createConfig(File config) throws IOException {
        OutputStream out;
        block6: {
            InputStream in = null;
            out = null;
            try {
                int b;
                URL defaultConfig = new URL("resource:/default.openejb.conf");
                in = defaultConfig.openStream();
                out = new FileOutputStream(config);
                while ((b = in.read()) != -1) {
                    out.write(b);
                }
                Object var6_5 = null;
                if (in == null) break block6;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
                throw throwable;
            }
            in.close();
        }
        if (out != null) {
            out.close();
        }
        return config;
    }

    public static boolean addDeploymentEntryToConfig(String jarLocation, Openejb config) {
        Enumeration enumeration = config.enumerateDeployments();
        File jar = new File(jarLocation);
        while (enumeration.hasMoreElements()) {
            File target;
            Deployments d = (Deployments)enumeration.nextElement();
            if (d.getJar() != null) {
                try {
                    target = FileUtils.getBase().getFile(d.getJar(), false);
                    if (!jar.equals(target)) continue;
                    return false;
                }
                catch (IOException e) {
                    continue;
                }
            }
            if (d.getDir() == null) continue;
            try {
                target = FileUtils.getBase().getFile(d.getDir(), false);
                File jarDir = jar.getAbsoluteFile().getParentFile();
                if (jarDir == null || !jarDir.equals(target)) continue;
                return false;
            }
            catch (IOException e) {
            }
        }
        Deployments dep = new Deployments();
        dep.setJar(jarLocation);
        config.addDeployments(dep);
        return true;
    }

    public static void handleException(String errorCode, Object arg0, Object arg1, Object arg2, Object arg3) throws OpenEJBException {
        throw new OpenEJBException(messages.format(errorCode, arg0, arg1, arg2, arg3));
    }

    public static void handleException(String errorCode, Object arg0, Object arg1, Object arg2) throws OpenEJBException {
        throw new OpenEJBException(messages.format(errorCode, arg0, arg1, arg2));
    }

    public static void handleException(String errorCode, Object arg0, Object arg1) throws OpenEJBException {
        throw new OpenEJBException(messages.format(errorCode, arg0, arg1));
    }

    public static void handleException(String errorCode, Object arg0) throws OpenEJBException {
        throw new OpenEJBException(messages.format(errorCode, arg0));
    }

    public static void handleException(String errorCode) throws OpenEJBException {
        throw new OpenEJBException(messages.message(errorCode));
    }

    public static void logWarning(String errorCode, Object arg0, Object arg1, Object arg2, Object arg3) {
        ConfigUtils._logger.i18n.warning(errorCode, arg0, arg1, arg2, arg3);
    }

    public static void logWarning(String errorCode, Object arg0, Object arg1, Object arg2) {
        ConfigUtils._logger.i18n.warning(errorCode, arg0, arg1, arg2);
    }

    public static void logWarning(String errorCode, Object arg0, Object arg1) {
        ConfigUtils._logger.i18n.warning(errorCode, arg0, arg1);
    }

    public static void logWarning(String errorCode, Object arg0) {
        ConfigUtils._logger.i18n.warning(errorCode, arg0);
    }

    public static void logWarning(String errorCode) {
        ConfigUtils._logger.i18n.warning(errorCode);
    }
}

