/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.alt.config;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.openejb.OpenEJBException;
import org.openejb.alt.assembler.classic.ConnectionManagerInfo;
import org.openejb.alt.assembler.classic.ConnectorInfo;
import org.openejb.alt.assembler.classic.ContainerInfo;
import org.openejb.alt.assembler.classic.ContainerSystemInfo;
import org.openejb.alt.assembler.classic.EjbLocalReferenceInfo;
import org.openejb.alt.assembler.classic.EjbReferenceInfo;
import org.openejb.alt.assembler.classic.EjbReferenceLocationInfo;
import org.openejb.alt.assembler.classic.EnterpriseBeanInfo;
import org.openejb.alt.assembler.classic.EntityBeanInfo;
import org.openejb.alt.assembler.classic.EntityContainerInfo;
import org.openejb.alt.assembler.classic.EnvEntryInfo;
import org.openejb.alt.assembler.classic.FacilitiesInfo;
import org.openejb.alt.assembler.classic.InfoObject;
import org.openejb.alt.assembler.classic.IntraVmServerInfo;
import org.openejb.alt.assembler.classic.JndiContextInfo;
import org.openejb.alt.assembler.classic.JndiEncInfo;
import org.openejb.alt.assembler.classic.ManagedConnectionFactoryInfo;
import org.openejb.alt.assembler.classic.MethodInfo;
import org.openejb.alt.assembler.classic.MethodPermissionInfo;
import org.openejb.alt.assembler.classic.MethodTransactionInfo;
import org.openejb.alt.assembler.classic.OpenEjbConfiguration;
import org.openejb.alt.assembler.classic.OpenEjbConfigurationFactory;
import org.openejb.alt.assembler.classic.QueryInfo;
import org.openejb.alt.assembler.classic.ResourceReferenceInfo;
import org.openejb.alt.assembler.classic.RoleMappingInfo;
import org.openejb.alt.assembler.classic.SecurityRoleInfo;
import org.openejb.alt.assembler.classic.SecurityRoleReferenceInfo;
import org.openejb.alt.assembler.classic.SecurityServiceInfo;
import org.openejb.alt.assembler.classic.StatefulBeanInfo;
import org.openejb.alt.assembler.classic.StatefulSessionContainerInfo;
import org.openejb.alt.assembler.classic.StatelessBeanInfo;
import org.openejb.alt.assembler.classic.StatelessSessionContainerInfo;
import org.openejb.alt.assembler.classic.TransactionServiceInfo;
import org.openejb.alt.config.AutoDeployer;
import org.openejb.alt.config.ConfigUtils;
import org.openejb.alt.config.DeployedJar;
import org.openejb.alt.config.EjbJarUtils;
import org.openejb.alt.config.EjbSet;
import org.openejb.alt.config.EjbValidator;
import org.openejb.alt.config.ProviderDefaults;
import org.openejb.alt.config.Service;
import org.openejb.alt.config.ServiceUtils;
import org.openejb.alt.config.ejb11.ContainerTransaction;
import org.openejb.alt.config.ejb11.EjbDeployment;
import org.openejb.alt.config.ejb11.EjbJar;
import org.openejb.alt.config.ejb11.EjbLocalRef;
import org.openejb.alt.config.ejb11.EjbRef;
import org.openejb.alt.config.ejb11.EnterpriseBeansItem;
import org.openejb.alt.config.ejb11.Entity;
import org.openejb.alt.config.ejb11.EnvEntry;
import org.openejb.alt.config.ejb11.Method;
import org.openejb.alt.config.ejb11.MethodParams;
import org.openejb.alt.config.ejb11.MethodPermission;
import org.openejb.alt.config.ejb11.OpenejbJar;
import org.openejb.alt.config.ejb11.Query;
import org.openejb.alt.config.ejb11.QueryMethod;
import org.openejb.alt.config.ejb11.ResourceLink;
import org.openejb.alt.config.ejb11.ResourceRef;
import org.openejb.alt.config.ejb11.SecurityRole;
import org.openejb.alt.config.ejb11.SecurityRoleRef;
import org.openejb.alt.config.ejb11.Session;
import org.openejb.alt.config.sys.ConnectionManager;
import org.openejb.alt.config.sys.Connector;
import org.openejb.alt.config.sys.Container;
import org.openejb.alt.config.sys.Deployments;
import org.openejb.alt.config.sys.JndiProvider;
import org.openejb.alt.config.sys.Openejb;
import org.openejb.alt.config.sys.ProxyFactory;
import org.openejb.alt.config.sys.SecurityService;
import org.openejb.alt.config.sys.ServiceProvider;
import org.openejb.alt.config.sys.ServicesJar;
import org.openejb.alt.config.sys.TransactionService;
import org.openejb.util.ClasspathUtils;
import org.openejb.util.FileUtils;
import org.openejb.util.Logger;
import org.openejb.util.Messages;

public class ConfigurationFactory
implements OpenEjbConfigurationFactory,
ProviderDefaults {
    public static final String DEFAULT_SECURITY_ROLE = "openejb.default.security.role";
    protected static Logger logger = Logger.getInstance("OpenEJB", "org.openejb.util.resources");
    protected static Messages messages = new Messages("org.openejb.util.resources");
    private AutoDeployer deployer;
    private Openejb openejb;
    private DeployedJar[] jars;
    private ServicesJar openejbDefaults = null;
    private String configLocation = "";
    private Vector deploymentIds = new Vector();
    private Vector securityRoles = new Vector();
    private Vector containerIds = new Vector();
    private Vector mthdPermInfos = new Vector();
    private Vector mthdTranInfos = new Vector();
    private Vector sRoleInfos = new Vector();
    public static OpenEjbConfiguration sys;
    private ContainerInfo[] cntrs;
    private EntityContainerInfo[] entyCntrs;
    private StatefulSessionContainerInfo[] stflCntrs;
    private StatelessSessionContainerInfo[] stlsCntrs;
    private HashMap containerTable = new HashMap();
    private Properties props;
    Vector jndiProviderIds = new Vector();
    Vector connectorIds = new Vector();
    String[] tabs = new String[]{"", " ", "    ", "      ", "        ", "          "};
    static /* synthetic */ Class class$org$openejb$alt$config$sys$Connector;

    public void init(Properties props) throws OpenEJBException {
        this.props = props;
        this.configLocation = props.getProperty("openejb.conf.file");
        if (this.configLocation == null) {
            this.configLocation = props.getProperty("openejb.configuration");
        }
        this.configLocation = ConfigUtils.searchForConfiguration(this.configLocation, props);
        this.props.setProperty("openejb.configuration", this.configLocation);
    }

    public static void main(String[] args) {
        try {
            ConfigurationFactory conf = new ConfigurationFactory();
            conf.configLocation = args[0];
            conf.init(null);
            OpenEjbConfiguration openejb = conf.getOpenEjbConfiguration();
            conf.printConf(openejb);
        }
        catch (Exception e) {
            System.out.println("[OpenEJB] " + e.getMessage());
            e.printStackTrace();
        }
    }

    public OpenEjbConfiguration getOpenEjbConfiguration() throws OpenEJBException {
        this.openejb = ConfigUtils.readConfig(this.configLocation);
        this.deployer = new AutoDeployer(this.openejb);
        this.resolveDependencies(this.openejb);
        this.jars = this.loadDeployments(this.openejb);
        sys = new OpenEjbConfiguration();
        ConfigurationFactory.sys.containerSystem = new ContainerSystemInfo();
        ConfigurationFactory.sys.facilities = new FacilitiesInfo();
        this.initJndiProviders(this.openejb, ConfigurationFactory.sys.facilities);
        this.initTransactionService(this.openejb, ConfigurationFactory.sys.facilities);
        this.initConnectors(this.openejb, ConfigurationFactory.sys.facilities);
        this.initConnectionManagers(this.openejb, ConfigurationFactory.sys.facilities);
        this.initProxyFactory(this.openejb, ConfigurationFactory.sys.facilities);
        this.initContainerInfos(this.openejb);
        ConfigurationFactory.sys.containerSystem.containers = this.cntrs;
        ConfigurationFactory.sys.containerSystem.entityContainers = this.entyCntrs;
        ConfigurationFactory.sys.containerSystem.statefulContainers = this.stflCntrs;
        ConfigurationFactory.sys.containerSystem.statelessContainers = this.stlsCntrs;
        for (int i = 0; i < this.jars.length; ++i) {
            try {
                this.initEnterpriseBeanInfos(this.jars[i]);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                ConfigUtils.logWarning("conf.0004", this.jars[i].jarURI, e.getMessage());
            }
        }
        SecurityRoleInfo defaultRole = new SecurityRoleInfo();
        defaultRole.description = "The role applied to recurity references that are not linked.";
        defaultRole.roleName = DEFAULT_SECURITY_ROLE;
        this.sRoleInfos.add(defaultRole);
        ConfigurationFactory.sys.containerSystem.securityRoles = new SecurityRoleInfo[this.sRoleInfos.size()];
        ConfigurationFactory.sys.containerSystem.methodPermissions = new MethodPermissionInfo[this.mthdPermInfos.size()];
        ConfigurationFactory.sys.containerSystem.methodTransactions = new MethodTransactionInfo[this.mthdTranInfos.size()];
        this.sRoleInfos.copyInto(ConfigurationFactory.sys.containerSystem.securityRoles);
        this.mthdPermInfos.copyInto(ConfigurationFactory.sys.containerSystem.methodPermissions);
        this.mthdTranInfos.copyInto(ConfigurationFactory.sys.containerSystem.methodTransactions);
        this.initSecutityService(this.openejb, ConfigurationFactory.sys.facilities);
        return sys;
    }

    private void initJndiProviders(Openejb openejb, FacilitiesInfo facilities) throws OpenEJBException {
        JndiProvider[] provider = openejb.getJndiProvider();
        if (provider == null || provider.length < 1) {
            return;
        }
        JndiContextInfo[] ctxInfo = new JndiContextInfo[provider.length];
        facilities.remoteJndiContexts = ctxInfo;
        for (int i = 0; i < provider.length; ++i) {
            provider[i] = (JndiProvider)this.initService(provider[i], null);
            ServiceProvider service = ServiceUtils.getServiceProvider(provider[i]);
            this.checkType(service, provider[i], "JndiProvider");
            ctxInfo[i] = new JndiContextInfo();
            ctxInfo[i].jndiContextId = provider[i].getId();
            if (this.jndiProviderIds.contains(provider[i].getId())) {
                ConfigurationFactory.handleException("conf.0103", this.configLocation, provider[i].getId());
            }
            this.jndiProviderIds.add(provider[i].getId());
            ctxInfo[i].properties = ServiceUtils.assemblePropertiesFor("JndiProvider", provider[i].getId(), provider[i].getContent(), this.configLocation, service);
        }
    }

    private void initSecutityService(Openejb openejb, FacilitiesInfo facilities) throws OpenEJBException {
        SecurityService ss = openejb.getSecurityService();
        ss = (SecurityService)this.initService(ss, "Default Security Service", SecurityService.class);
        ServiceProvider ssp = ServiceUtils.getServiceProvider(ss);
        this.checkType(ssp, ss, "Security");
        SecurityServiceInfo ssi = new SecurityServiceInfo();
        ssi.codebase = ss.getJar();
        ssi.description = ssp.getDescription();
        ssi.displayName = ssp.getDisplayName();
        ssi.factoryClassName = ssp.getClassName();
        ssi.serviceName = ss.getId();
        ssi.properties = ServiceUtils.assemblePropertiesFor("Security", ss.getId(), ss.getContent(), this.configLocation, ssp);
        SecurityRoleInfo[] roles = ConfigurationFactory.sys.containerSystem.securityRoles;
        RoleMappingInfo[] r = new RoleMappingInfo[roles.length];
        ssi.roleMappings = r;
        for (int i = 0; i < r.length; ++i) {
            r[i] = new RoleMappingInfo();
            r[i].logicalRoleNames = new String[]{roles[i].roleName};
            r[i].physicalRoleNames = new String[]{roles[i].roleName};
        }
        facilities.securityService = ssi;
    }

    private void initTransactionService(Openejb openejb, FacilitiesInfo facilities) throws OpenEJBException {
        TransactionService ts = openejb.getTransactionService();
        ts = (TransactionService)this.initService(ts, "Default Transaction Manager", TransactionService.class);
        ServiceProvider service = ServiceUtils.getServiceProvider(ts);
        this.checkType(service, ts, "Transaction");
        TransactionServiceInfo tsi = new TransactionServiceInfo();
        tsi.codebase = ts.getJar();
        tsi.description = service.getDescription();
        tsi.displayName = service.getDisplayName();
        tsi.factoryClassName = service.getClassName();
        tsi.serviceName = ts.getId();
        tsi.properties = ServiceUtils.assemblePropertiesFor("Transaction", ts.getId(), ts.getContent(), this.configLocation, service);
        facilities.transactionService = tsi;
    }

    private void initConnectors(Openejb openejb, FacilitiesInfo facilities) throws OpenEJBException {
        Connector[] conn = openejb.getConnector();
        if (conn == null || conn.length < 1) {
            return;
        }
        ConnectorInfo[] info = new ConnectorInfo[conn.length];
        facilities.connectors = info;
        for (int i = 0; i < conn.length; ++i) {
            conn[i] = (Connector)this.initService(conn[i], "Default JDBC Database", class$org$openejb$alt$config$sys$Connector == null ? ConfigurationFactory.class$("org.openejb.alt.config.sys.Connector") : class$org$openejb$alt$config$sys$Connector);
            ServiceProvider service = ServiceUtils.getServiceProvider(conn[i]);
            this.checkType(service, conn[i], "Connector");
            ManagedConnectionFactoryInfo factory = new ManagedConnectionFactoryInfo();
            info[i] = new ConnectorInfo();
            info[i].connectorId = conn[i].getId();
            info[i].connectionManagerId = "Default Local TX ConnectionManager";
            info[i].managedConnectionFactory = factory;
            factory.id = conn[i].getId();
            factory.className = service.getClassName();
            factory.codebase = conn[i].getJar();
            factory.properties = ServiceUtils.assemblePropertiesFor("Connector", conn[i].getId(), conn[i].getContent(), this.configLocation, service);
            if (this.connectorIds.contains(conn[i].getId())) {
                ConfigurationFactory.handleException("conf.0103", this.configLocation, conn[i].getId());
            }
            this.connectorIds.add(conn[i].getId());
        }
    }

    private void initConnectionManagers(Openejb openejb, FacilitiesInfo facilities) throws OpenEJBException {
        ConnectionManagerInfo manager = new ConnectionManagerInfo();
        ConnectionManager cm = openejb.getConnectionManager();
        cm = (ConnectionManager)this.initService(cm, "Default Local TX ConnectionManager", ConnectionManager.class);
        ServiceProvider service = ServiceUtils.getServiceProvider(cm);
        this.checkType(service, cm, "ConnectionManager");
        manager.connectionManagerId = cm.getId();
        manager.className = service.getClassName();
        manager.codebase = cm.getJar();
        manager.properties = ServiceUtils.assemblePropertiesFor("ConnectionManager", cm.getId(), cm.getContent(), this.configLocation, service);
        facilities.connectionManagers = new ConnectionManagerInfo[]{manager};
    }

    private void initProxyFactory(Openejb openejb, FacilitiesInfo facilities) throws OpenEJBException {
        IntraVmServerInfo pfi;
        String defaultFactory = null;
        try {
            String version = System.getProperty("java.vm.version");
            defaultFactory = version.startsWith("1.1") || version.startsWith("1.2") ? "Default JDK 1.2 ProxyFactory" : "Default JDK 1.3 ProxyFactory";
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to determine the version of your VM.  No ProxyFactory Can be installed");
        }
        ProxyFactory pf = openejb.getProxyFactory();
        pf = (ProxyFactory)this.initService(pf, defaultFactory, ProxyFactory.class);
        ServiceProvider pfp = ServiceUtils.getServiceProvider(pf);
        this.checkType(pfp, pf, "Proxy");
        facilities.intraVmServer = pfi = new IntraVmServerInfo();
        pfi.proxyFactoryClassName = pfp.getClassName();
        pfi.factoryName = pf.getId();
        pfi.codebase = pf.getJar();
        pfi.properties = ServiceUtils.assemblePropertiesFor("Proxy", pf.getId(), pf.getContent(), this.configLocation, pfp);
    }

    private void initContainerInfos(Openejb conf) throws OpenEJBException {
        int i;
        Vector<StatelessSessionContainerInfo> e = new Vector<StatelessSessionContainerInfo>();
        Vector<StatelessSessionContainerInfo> sf = new Vector<StatelessSessionContainerInfo>();
        Vector<StatelessSessionContainerInfo> sl = new Vector<StatelessSessionContainerInfo>();
        Container[] containers = conf.getContainer();
        for (i = 0; i < containers.length; ++i) {
            Container c = containers[i];
            ContainerInfo ci = null;
            if (c.getCtype().equals("STATELESS")) {
                c = (Container)this.initService(c, "Default Stateless Container");
                ci = new StatelessSessionContainerInfo();
                sl.add((StatelessSessionContainerInfo)ci);
            } else if (c.getCtype().equals("STATEFUL")) {
                c = (Container)this.initService(c, "Default Stateful Container");
                ci = new StatefulSessionContainerInfo();
                sf.add((StatelessSessionContainerInfo)ci);
            } else if (c.getCtype().equals("BMP_ENTITY")) {
                c = (Container)this.initService(c, "Default BMP Container");
                ci = new EntityContainerInfo();
                e.add((StatelessSessionContainerInfo)ci);
            } else if (c.getCtype().equals("CMP_ENTITY")) {
                c = (Container)this.initService(c, "Default CMP Container");
                ci = new EntityContainerInfo();
                e.add((StatelessSessionContainerInfo)ci);
            } else {
                throw new OpenEJBException("Unrecognized contianer type " + c.getCtype());
            }
            ServiceProvider service = ServiceUtils.getServiceProvider(c);
            this.checkType(service, c, "Container");
            ci.ejbeans = new EnterpriseBeanInfo[0];
            ci.containerName = c.getId();
            ci.className = service.getClassName();
            ci.codebase = c.getJar();
            ci.properties = ServiceUtils.assemblePropertiesFor("Container", c.getId(), c.getContent(), this.configLocation, service);
            if (this.containerIds.contains(c.getId())) {
                ConfigurationFactory.handleException("conf.0101", this.configLocation, c.getId());
            }
            this.containerIds.add(c.getId());
        }
        this.entyCntrs = new EntityContainerInfo[e.size()];
        e.copyInto(this.entyCntrs);
        this.stflCntrs = new StatefulSessionContainerInfo[sf.size()];
        sf.copyInto(this.stflCntrs);
        this.stlsCntrs = new StatelessSessionContainerInfo[sl.size()];
        sl.copyInto(this.stlsCntrs);
        e.addAll(sf);
        e.addAll(sl);
        this.cntrs = new ContainerInfo[e.size()];
        e.copyInto(this.cntrs);
        for (i = 0; i < this.cntrs.length; ++i) {
            this.containerTable.put(this.cntrs[i].containerName, this.cntrs[i]);
        }
    }

    private Map getDeployments(OpenejbJar j) throws OpenEJBException {
        HashMap<String, EjbDeployment> map = new HashMap<String, EjbDeployment>(j.getEjbDeploymentCount());
        Enumeration enumeration = j.enumerateEjbDeployment();
        while (enumeration.hasMoreElements()) {
            EjbDeployment d = (EjbDeployment)enumeration.nextElement();
            map.put(d.getEjbName(), d);
        }
        return map;
    }

    private void initEnterpriseBeanInfos(DeployedJar jar) throws OpenEJBException {
        int beansDeployed = jar.openejbJar.getEjbDeploymentCount();
        int beansInEjbJar = jar.ejbJar.getEnterpriseBeans().getEnterpriseBeansItemCount();
        if (beansInEjbJar != beansDeployed) {
            ConfigUtils.logWarning("conf.0008", jar.jarURI, "" + beansInEjbJar, "" + beansDeployed);
            return;
        }
        Map ejbds = this.getDeployments(jar.openejbJar);
        HashMap<String, EnterpriseBeanInfo> infos = new HashMap<String, EnterpriseBeanInfo>();
        HashMap<String, EnterpriseBeansItem> items = new HashMap<String, EnterpriseBeansItem>();
        EnterpriseBeanInfo[] beans = new EnterpriseBeanInfo[ejbds.size()];
        int i = -1;
        Enumeration bl = jar.ejbJar.getEnterpriseBeans().enumerateEnterpriseBeansItem();
        while (bl.hasMoreElements()) {
            EnterpriseBeansItem item = (EnterpriseBeansItem)bl.nextElement();
            beans[++i] = item.getEntity() == null ? this.initSessionBean(item, ejbds) : this.initEntityBean(item, ejbds);
            if (this.deploymentIds.contains(beans[i].ejbDeploymentId)) {
                ConfigUtils.logWarning("conf.0100", beans[i].ejbDeploymentId, jar.jarURI, beans[i].ejbName);
                return;
            }
            this.deploymentIds.add(beans[i].ejbDeploymentId);
            beans[i].codebase = jar.jarURI;
            infos.put(beans[i].ejbName, beans[i]);
            items.put(beans[i].ejbName, item);
        }
        this.initJndiReferences(ejbds, infos, items);
        if (jar.ejbJar.getAssemblyDescriptor() != null) {
            this.initSecurityRoles(jar, ejbds, infos, items);
            this.initMethodPermissions(jar, ejbds, infos, items);
            this.initMethodTransactions(jar, ejbds, infos, items);
            for (int x = 0; x < beans.length; ++x) {
                this.resolveRoleLinks(jar, beans[x], (EnterpriseBeansItem)items.get(beans[x].ejbName));
            }
        }
        this.assignBeansToContainers(beans, ejbds);
        try {
            ClasspathUtils.addJarToPath(jar.jarURI);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initJndiReferences(Map ejbds, Map infos, Map items) throws OpenEJBException {
        Iterator i = infos.values().iterator();
        while (i.hasNext()) {
            EnterpriseBeanInfo otherBean;
            String ejbLink;
            InfoObject info;
            Serializable ejb;
            EnterpriseBeanInfo bean = (EnterpriseBeanInfo)i.next();
            EnterpriseBeansItem item = (EnterpriseBeansItem)items.get(bean.ejbName);
            Enumeration envEntries = null;
            Enumeration ejbRefs = null;
            Enumeration ejbLocalRefs = null;
            Enumeration resourceRefs = null;
            if (item.getEntity() != null) {
                envEntries = item.getEntity().enumerateEnvEntry();
                ejbRefs = item.getEntity().enumerateEjbRef();
                ejbLocalRefs = item.getEntity().enumerateEjbLocalRef();
                resourceRefs = item.getEntity().enumerateResourceRef();
            } else {
                envEntries = item.getSession().enumerateEnvEntry();
                ejbRefs = item.getSession().enumerateEjbRef();
                ejbLocalRefs = item.getSession().enumerateEjbLocalRef();
                resourceRefs = item.getSession().enumerateResourceRef();
            }
            Vector<EnvEntryInfo> envRef = new Vector<EnvEntryInfo>();
            Vector<EjbReferenceInfo> ejbRef = new Vector<EjbReferenceInfo>();
            Vector<EjbReferenceInfo> ejbLocalRef = new Vector<EjbReferenceInfo>();
            Vector<EjbReferenceInfo> resRef = new Vector<EjbReferenceInfo>();
            while (envEntries.hasMoreElements()) {
                EnvEntry env = (EnvEntry)envEntries.nextElement();
                EnvEntryInfo info2 = new EnvEntryInfo();
                info2.name = env.getEnvEntryName();
                info2.type = env.getEnvEntryType();
                info2.value = env.getEnvEntryValue();
                envRef.add(info2);
            }
            EjbDeployment dep = (EjbDeployment)ejbds.get(bean.ejbName);
            Enumeration rl = dep.enumerateResourceLink();
            HashMap<String, ResourceLink> resLinks = new HashMap<String, ResourceLink>();
            while (rl.hasMoreElements()) {
                ResourceLink link = (ResourceLink)rl.nextElement();
                resLinks.put(link.getResRefName(), link);
            }
            while (ejbRefs.hasMoreElements()) {
                ejb = (EjbRef)ejbRefs.nextElement();
                info = new EjbReferenceInfo();
                info.homeType = ((EjbRef)ejb).getHome();
                info.referenceName = ((EjbRef)ejb).getEjbRefName();
                info.location = new EjbReferenceLocationInfo();
                ejbLink = ((EjbRef)ejb).getEjbLink() == null ? ((ResourceLink)resLinks.get(((EjbRef)ejb).getEjbRefName())).getResId() : ((EjbRef)ejb).getEjbLink();
                otherBean = (EnterpriseBeanInfo)infos.get(ejbLink);
                if (otherBean == null) {
                    String msg = messages.format("config.noBeanFound", ((EjbRef)ejb).getEjbRefName(), bean.ejbName);
                    logger.fatal(msg);
                    throw new OpenEJBException(msg);
                }
                info.location.ejbDeploymentId = otherBean.ejbDeploymentId;
                ejbRef.add((EjbReferenceInfo)info);
            }
            while (ejbLocalRefs.hasMoreElements()) {
                ejb = (EjbLocalRef)ejbLocalRefs.nextElement();
                info = new EjbLocalReferenceInfo();
                ((EjbLocalReferenceInfo)info).homeType = ((EjbLocalRef)ejb).getLocalHome();
                ((EjbLocalReferenceInfo)info).referenceName = ((EjbLocalRef)ejb).getEjbRefName();
                ((EjbLocalReferenceInfo)info).location = new EjbReferenceLocationInfo();
                ejbLink = ((EjbLocalRef)ejb).getEjbLink() == null ? null : ((EjbLocalRef)ejb).getEjbLink();
                otherBean = (EnterpriseBeanInfo)infos.get(ejbLink);
                if (otherBean == null) {
                    String msg = messages.format("config.noBeanFound", ((EjbLocalRef)ejb).getEjbRefName(), bean.ejbName);
                    logger.fatal(msg);
                    throw new OpenEJBException(msg);
                }
                ((EjbLocalReferenceInfo)info).location.ejbDeploymentId = otherBean.ejbDeploymentId;
                ejbLocalRef.add((EjbReferenceInfo)info);
            }
            while (resourceRefs.hasMoreElements()) {
                ResourceRef res = (ResourceRef)resourceRefs.nextElement();
                info = new ResourceReferenceInfo();
                ((ResourceReferenceInfo)info).referenceAuth = res.getResAuth();
                ((ResourceReferenceInfo)info).referenceName = res.getResRefName();
                ((ResourceReferenceInfo)info).referenceType = res.getResType();
                ResourceLink link = (ResourceLink)resLinks.get(res.getResRefName());
                ((ResourceReferenceInfo)info).resourceID = link.getResId();
                resRef.add((EjbReferenceInfo)info);
            }
            JndiEncInfo jndi = new JndiEncInfo();
            jndi.envEntries = new EnvEntryInfo[envRef.size()];
            jndi.ejbReferences = new EjbReferenceInfo[ejbRef.size()];
            jndi.ejbLocalReferences = new EjbLocalReferenceInfo[ejbLocalRef.size()];
            jndi.resourceRefs = new ResourceReferenceInfo[resRef.size()];
            envRef.copyInto(jndi.envEntries);
            ejbRef.copyInto(jndi.ejbReferences);
            resRef.copyInto(jndi.resourceRefs);
            ejbLocalRef.copyInto(jndi.ejbLocalReferences);
            bean.jndiEnc = jndi;
        }
    }

    private void initMethodTransactions(DeployedJar jar, Map ejbds, Map infos, Map items) throws OpenEJBException {
        ContainerTransaction[] cTx = jar.ejbJar.getAssemblyDescriptor().getContainerTransaction();
        if (cTx == null || cTx.length < 1) {
            return;
        }
        MethodTransactionInfo[] mTxs = new MethodTransactionInfo[cTx.length];
        for (int i = 0; i < mTxs.length; ++i) {
            mTxs[i] = new MethodTransactionInfo();
            mTxs[i].description = cTx[i].getDescription();
            mTxs[i].transAttribute = cTx[i].getTransAttribute();
            mTxs[i].methods = this.getMethodInfos(cTx[i].getMethod(), ejbds);
        }
        this.mthdTranInfos.addAll(Arrays.asList(mTxs));
    }

    private void initSecurityRoles(DeployedJar jar, Map ejbds, Map infos, Map items) throws OpenEJBException {
        SecurityRole[] sr = jar.ejbJar.getAssemblyDescriptor().getSecurityRole();
        if (sr == null || sr.length < 1) {
            return;
        }
        SecurityRoleInfo[] roles = new SecurityRoleInfo[sr.length];
        for (int i = 0; i < roles.length; ++i) {
            roles[i] = new SecurityRoleInfo();
            roles[i].description = sr[i].getDescription();
            roles[i].roleName = sr[i].getRoleName();
            if (this.securityRoles.contains(sr[i].getRoleName())) {
                ConfigUtils.logWarning("conf.0102", jar.jarURI, sr[i].getRoleName());
                continue;
            }
            this.securityRoles.add(sr[i].getRoleName());
        }
        this.sRoleInfos.addAll(Arrays.asList(roles));
    }

    private void initMethodPermissions(DeployedJar jar, Map ejbds, Map infos, Map items) throws OpenEJBException {
        MethodPermission[] mp = jar.ejbJar.getAssemblyDescriptor().getMethodPermission();
        if (mp == null || mp.length < 1) {
            return;
        }
        MethodPermissionInfo[] perms = new MethodPermissionInfo[mp.length];
        for (int i = 0; i < perms.length; ++i) {
            perms[i] = new MethodPermissionInfo();
            perms[i].description = mp[i].getDescription();
            perms[i].roleNames = mp[i].getRoleName();
            perms[i].methods = this.getMethodInfos(mp[i].getMethod(), ejbds);
        }
        this.mthdPermInfos.addAll(Arrays.asList(perms));
    }

    private void resolveRoleLinks(DeployedJar jar, EnterpriseBeanInfo bean, EnterpriseBeansItem item) throws OpenEJBException {
        SecurityRoleRef[] refs = null;
        refs = item.getEntity() != null ? item.getEntity().getSecurityRoleRef() : item.getSession().getSecurityRoleRef();
        if (refs == null || refs.length < 1) {
            return;
        }
        SecurityRoleReferenceInfo[] sr = new SecurityRoleReferenceInfo[refs.length];
        bean.securityRoleReferences = sr;
        for (int i = 0; i < sr.length; ++i) {
            sr[i] = new SecurityRoleReferenceInfo();
            sr[i].description = refs[i].getDescription();
            sr[i].roleLink = refs[i].getRoleLink();
            sr[i].roleName = refs[i].getRoleName();
            if (sr[i].roleLink != null) continue;
            ConfigUtils.logWarning("conf.0009", sr[i].roleName, bean.ejbName, jar.jarURI);
            sr[i].roleLink = DEFAULT_SECURITY_ROLE;
        }
    }

    private MethodInfo[] getMethodInfos(Method[] ms, Map ejbds) {
        if (ms == null) {
            return null;
        }
        MethodInfo[] mi = new MethodInfo[ms.length];
        for (int i = 0; i < mi.length; ++i) {
            mi[i] = new MethodInfo();
            EjbDeployment d = (EjbDeployment)ejbds.get(ms[i].getEjbName());
            mi[i].description = ms[i].getDescription();
            mi[i].ejbDeploymentId = d.getDeploymentId();
            mi[i].methodIntf = ms[i].getMethodIntf();
            mi[i].methodName = ms[i].getMethodName();
            MethodParams mp = ms[i].getMethodParams();
            if (mp == null) continue;
            mi[i].methodParams = mp.getMethodParam();
        }
        return mi;
    }

    private EnterpriseBeanInfo initSessionBean(EnterpriseBeansItem item, Map m) throws OpenEJBException {
        Session s = item.getSession();
        EnterpriseBeanInfo bean = null;
        bean = s.getSessionType().equals("Stateful") ? new StatefulBeanInfo() : new StatelessBeanInfo();
        EjbDeployment d = (EjbDeployment)m.get(s.getEjbName());
        if (d == null) {
            throw new OpenEJBException("No deployment information in openejb-jar.xml for bean " + s.getEjbName() + ". Please redeploy the jar");
        }
        bean.ejbDeploymentId = d.getDeploymentId();
        bean.description = s.getDescription();
        bean.largeIcon = s.getLargeIcon();
        bean.smallIcon = s.getSmallIcon();
        bean.displayName = s.getDisplayName();
        bean.ejbClass = s.getEjbClass();
        bean.ejbName = s.getEjbName();
        bean.home = s.getHome();
        bean.remote = s.getRemote();
        bean.localHome = s.getLocalHome();
        bean.local = s.getLocal();
        bean.transactionType = s.getTransactionType();
        return bean;
    }

    private EnterpriseBeanInfo initEntityBean(EnterpriseBeansItem item, Map m) throws OpenEJBException {
        Entity e = item.getEntity();
        EntityBeanInfo bean = new EntityBeanInfo();
        EjbDeployment d = (EjbDeployment)m.get(e.getEjbName());
        if (d == null) {
            throw new OpenEJBException("No deployment information in openejb-jar.xml for bean " + e.getEjbName() + ". Please redeploy the jar");
        }
        bean.ejbDeploymentId = d.getDeploymentId();
        bean.description = e.getDescription();
        bean.largeIcon = e.getLargeIcon();
        bean.smallIcon = e.getSmallIcon();
        bean.displayName = e.getDisplayName();
        bean.ejbClass = e.getEjbClass();
        bean.ejbName = e.getEjbName();
        bean.home = e.getHome();
        bean.remote = e.getRemote();
        bean.localHome = e.getLocalHome();
        bean.local = e.getLocal();
        bean.transactionType = "Container";
        bean.primKeyClass = e.getPrimKeyClass();
        bean.primKeyField = e.getPrimkeyField();
        bean.persistenceType = e.getPersistenceType();
        bean.reentrant = e.getReentrant() + "";
        bean.cmpFieldNames = new String[e.getCmpFieldCount()];
        for (int i = 0; i < bean.cmpFieldNames.length; ++i) {
            bean.cmpFieldNames[i] = e.getCmpField(i).getFieldName();
        }
        if (bean.persistenceType.equals("Container")) {
            Query[] q = d.getQuery();
            QueryInfo[] qi = new QueryInfo[q.length];
            for (int i = 0; i < q.length; ++i) {
                QueryInfo query = new QueryInfo();
                query.description = q[i].getDescription();
                query.queryStatement = q[i].getObjectQl().trim();
                MethodInfo method = new MethodInfo();
                QueryMethod qm = q[i].getQueryMethod();
                method.methodName = qm.getMethodName();
                method.methodParams = qm.getMethodParams().getMethodParam();
                query.method = method;
                qi[i] = query;
            }
            bean.queries = qi;
        }
        return bean;
    }

    private void assignBeansToContainers(EnterpriseBeanInfo[] beans, Map ejbds) throws OpenEJBException {
        int i;
        for (i = 0; i < beans.length; ++i) {
            EjbDeployment d = (EjbDeployment)ejbds.get(beans[i].ejbName);
            ContainerInfo cInfo = (ContainerInfo)this.containerTable.get(d.getContainerId());
            if (cInfo == null) {
                String msg = messages.format("config.noContainerFound", d.getContainerId(), d.getEjbName());
                logger.fatal(msg);
                throw new OpenEJBException(msg);
            }
            EnterpriseBeanInfo[] oldList = cInfo.ejbeans;
            EnterpriseBeanInfo[] newList = new EnterpriseBeanInfo[oldList.length + 1];
            System.arraycopy(oldList, 0, newList, 1, oldList.length);
            newList[0] = beans[i];
            cInfo.ejbeans = newList;
        }
        for (i = 0; i < this.entyCntrs.length; ++i) {
            EnterpriseBeanInfo[] b = this.entyCntrs[i].ejbeans;
            EntityBeanInfo[] eb = new EntityBeanInfo[b.length];
            System.arraycopy(b, 0, eb, 0, b.length);
        }
    }

    private void resolveDependencies(Openejb openejb) {
    }

    private void resolveDependencies(EjbJar[] jars) {
    }

    private String[] getJarLocations(Deployments[] deploy) {
        Vector<String> jarList = new Vector<String>(deploy.length);
        try {
            for (int i = 0; i < deploy.length; ++i) {
                String[] files;
                Deployments d = deploy[i];
                if (d.getDir() == null && d.getJar() != null) {
                    File jar = null;
                    try {
                        jar = FileUtils.getBase(this.props).getFile(d.getJar(), false);
                    }
                    catch (Exception ignored) {
                        try {
                            jar = FileUtils.getHome(this.props).getFile(d.getJar(), false);
                        }
                        catch (Exception ignoredAgain) {
                            // empty catch block
                        }
                    }
                    if (jarList.contains(jar.getAbsolutePath())) continue;
                    jarList.add(jar.getAbsolutePath());
                    continue;
                }
                File dir = null;
                try {
                    dir = FileUtils.getBase(this.props).getFile(d.getDir(), false);
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                if (dir == null || !dir.exists()) {
                    try {
                        dir = FileUtils.getHome(this.props).getFile(d.getDir(), false);
                    }
                    catch (Exception ignoredAgain) {
                        // empty catch block
                    }
                }
                if (dir == null || !dir.isDirectory() || (files = dir.list()) == null) continue;
                for (int x = 0; x < files.length; ++x) {
                    File jar;
                    String f = files[x];
                    if (!f.endsWith(".jar") || jarList.contains((jar = new File(dir, f)).getAbsolutePath())) continue;
                    jarList.add(jar.getAbsolutePath());
                }
            }
        }
        catch (SecurityException se) {
            // empty catch block
        }
        Object[] locations = new String[jarList.size()];
        jarList.copyInto(locations);
        return locations;
    }

    private DeployedJar[] loadDeployments(Openejb openejb) throws OpenEJBException {
        EjbValidator validator = new EjbValidator();
        Vector<DeployedJar> jarsVect = new Vector<DeployedJar>();
        String[] jarsToLoad = this.getJarLocations(openejb.getDeployments());
        for (int i = 0; i < jarsToLoad.length; ++i) {
            String jarLocation = jarsToLoad[i];
            try {
                EjbJar ejbJar = EjbJarUtils.readEjbJar(jarLocation);
                OpenejbJar openejbJar = ConfigUtils.readOpenejbJar(jarLocation);
                if (openejbJar == null) {
                    openejbJar = this.deployer.deploy(ejbJar, jarLocation);
                }
                this.validateJar(ejbJar, jarLocation);
                jarsVect.add(new DeployedJar(jarLocation, ejbJar, openejbJar));
                continue;
            }
            catch (OpenEJBException e) {
                ConfigUtils.logWarning("conf.0004", jarLocation, e.getMessage());
            }
        }
        Object[] jars = new DeployedJar[jarsVect.size()];
        jarsVect.copyInto(jars);
        return jars;
    }

    private void validateJar(EjbJar ejbJar, String jarLocation) throws OpenEJBException {
        EjbValidator validator = new EjbValidator();
        EjbSet set = validator.validateJar(ejbJar, jarLocation);
        if (set.hasErrors() || set.hasFailures()) {
            throw new OpenEJBException("Jar failed validation.  Use the validation tool for more details");
        }
    }

    public Service initService(Service service, String defaultName) throws OpenEJBException {
        return this.initService(service, defaultName, null);
    }

    public Service initService(Service service, String defaultName, Class type) throws OpenEJBException {
        if (service == null) {
            try {
                service = (Service)type.newInstance();
                service.setProvider(defaultName);
                service.setId(defaultName);
            }
            catch (Exception e) {
                throw new OpenEJBException("Cannot instantiate class " + type);
            }
        }
        if (service.getProvider() == null) {
            try {
                ServiceUtils.getServiceProvider(service.getId());
                service.setProvider(service.getId());
            }
            catch (Exception e) {
                service.setProvider(defaultName);
            }
        }
        return service;
    }

    private void checkType(ServiceProvider provider, Service service, String type) throws OpenEJBException {
        if (!provider.getProviderType().equals(type)) {
            ConfigurationFactory.handleException("conf.4902", service, type);
        }
    }

    private void printConf(OpenEjbConfiguration conf) {
        int n;
        int i;
        this.out(0, "CONFIGURATION");
        this.out(1, conf.containerSystem.containers.length);
        for (i = 0; i < conf.containerSystem.containers.length; ++i) {
            this.out(1, "className    ", conf.containerSystem.containers[i].className);
            this.out(1, "codebase     ", conf.containerSystem.containers[i].codebase);
            this.out(1, "containerName", conf.containerSystem.containers[i].containerName);
            this.out(1, "containerType", conf.containerSystem.containers[i].containerType);
            this.out(1, "description  ", conf.containerSystem.containers[i].description);
            this.out(1, "displayName  ", conf.containerSystem.containers[i].displayName);
            this.out(1, "properties   ");
            conf.containerSystem.containers[i].properties.list(System.out);
            this.out(1, "ejbeans      ", conf.containerSystem.containers[i].ejbeans.length);
            for (int j = 0; j < conf.containerSystem.containers[i].ejbeans.length; ++j) {
                EnterpriseBeanInfo bean = conf.containerSystem.containers[i].ejbeans[j];
                this.out(2, "codebase       ", bean.codebase);
                this.out(2, "description    ", bean.description);
                this.out(2, "displayName    ", bean.displayName);
                this.out(2, "ejbClass       ", bean.ejbClass);
                this.out(2, "ejbDeploymentId", bean.ejbDeploymentId);
                this.out(2, "ejbName        ", bean.ejbName);
                this.out(2, "home           ", bean.home);
                this.out(2, "largeIcon      ", bean.largeIcon);
                this.out(2, "remote         ", bean.remote);
                this.out(2, "smallIcon      ", bean.smallIcon);
                this.out(2, "transactionType", bean.transactionType);
                this.out(2, "type           ", bean.type);
                this.out(2, "jndiEnc        ", bean.jndiEnc);
                this.out(2, "envEntries     ", bean.jndiEnc.envEntries.length);
                for (n = 0; n < bean.jndiEnc.envEntries.length; ++n) {
                    this.out(3, "--[" + n + "]----------------------");
                    this.out(3, "name  ", bean.jndiEnc.envEntries[n].name);
                    this.out(3, "type  ", bean.jndiEnc.envEntries[n].type);
                    this.out(3, "value ", bean.jndiEnc.envEntries[n].value);
                }
                this.out(2, "ejbReferences  ", bean.jndiEnc.ejbReferences.length);
                for (n = 0; n < bean.jndiEnc.ejbReferences.length; ++n) {
                    this.out(3, "--[" + n + "]----------------------");
                    this.out(3, "homeType        ", bean.jndiEnc.ejbReferences[n].homeType);
                    this.out(3, "referenceName   ", bean.jndiEnc.ejbReferences[n].referenceName);
                    this.out(3, "location        ", bean.jndiEnc.ejbReferences[n].location);
                    this.out(3, "ejbDeploymentId ", bean.jndiEnc.ejbReferences[n].location.ejbDeploymentId);
                    this.out(3, "jndiContextId   ", bean.jndiEnc.ejbReferences[n].location.jndiContextId);
                    this.out(3, "remote          ", bean.jndiEnc.ejbReferences[n].location.remote);
                    this.out(3, "remoteRefName   ", bean.jndiEnc.ejbReferences[n].location.remoteRefName);
                }
                this.out(2, "resourceRefs   ", bean.jndiEnc.resourceRefs.length);
                for (n = 0; n < bean.jndiEnc.resourceRefs.length; ++n) {
                    this.out(3, "--[" + n + "]----------------------");
                    this.out(3, "referenceAuth   ", bean.jndiEnc.resourceRefs[n].referenceAuth);
                    this.out(3, "referenceName   ", bean.jndiEnc.resourceRefs[n].referenceName);
                    this.out(3, "referenceType   ", bean.jndiEnc.resourceRefs[n].referenceType);
                    if (bean.jndiEnc.resourceRefs[n].location == null) continue;
                    this.out(3, "location        ", bean.jndiEnc.resourceRefs[n].location);
                    this.out(3, "jndiContextId   ", bean.jndiEnc.resourceRefs[n].location.jndiContextId);
                    this.out(3, "remote          ", bean.jndiEnc.resourceRefs[n].location.remote);
                    this.out(3, "remoteRefName   ", bean.jndiEnc.resourceRefs[n].location.remoteRefName);
                }
            }
        }
        if (conf.containerSystem.securityRoles != null) {
            this.out(0, "--Security Roles------------");
            for (i = 0; i < ConfigurationFactory.sys.containerSystem.securityRoles.length; ++i) {
                this.out(1, "--[" + i + "]----------------------");
                this.out(1, "            ", ConfigurationFactory.sys.containerSystem.securityRoles[i]);
                this.out(1, "description ", ConfigurationFactory.sys.containerSystem.securityRoles[i].description);
                this.out(1, "roleName    ", ConfigurationFactory.sys.containerSystem.securityRoles[i].roleName);
            }
        }
        if (conf.containerSystem.methodPermissions != null) {
            this.out(0, "--Method Permissions--------");
            for (i = 0; i < ConfigurationFactory.sys.containerSystem.methodPermissions.length; ++i) {
                this.out(1, "--[" + i + "]----------------------");
                this.out(1, "            ", ConfigurationFactory.sys.containerSystem.methodPermissions[i]);
                this.out(1, "description ", ConfigurationFactory.sys.containerSystem.methodPermissions[i].description);
                this.out(1, "roleNames   ", ConfigurationFactory.sys.containerSystem.methodPermissions[i].roleNames);
                if (ConfigurationFactory.sys.containerSystem.methodPermissions[i].roleNames != null) {
                    String[] roleNames = ConfigurationFactory.sys.containerSystem.methodPermissions[i].roleNames;
                    for (int r = 0; r < roleNames.length; ++r) {
                        this.out(1, "roleName[" + r + "]   ", roleNames[r]);
                    }
                }
                this.out(1, "methods     ", conf.containerSystem.methodPermissions[i].methods);
                if (conf.containerSystem.methodPermissions[i].methods == null) continue;
                MethodInfo[] mthds = conf.containerSystem.methodPermissions[i].methods;
                for (int j = 0; j < mthds.length; ++j) {
                    this.out(2, "description    ", mthds[j].description);
                    this.out(2, "ejbDeploymentId", mthds[j].ejbDeploymentId);
                    this.out(2, "methodIntf     ", mthds[j].methodIntf);
                    this.out(2, "methodName     ", mthds[j].methodName);
                    this.out(2, "methodParams   ", mthds[j].methodParams);
                    if (mthds[j].methodParams == null) continue;
                    for (n = 0; n < mthds[j].methodParams.length; ++n) {
                        this.out(3, "param[" + n + "]", mthds[j].methodParams[n]);
                    }
                }
            }
        }
        if (conf.containerSystem.methodTransactions != null) {
            this.out(0, "--Method Transactions-------");
            for (i = 0; i < conf.containerSystem.methodTransactions.length; ++i) {
                this.out(1, "--[" + i + "]----------------------");
                this.out(1, "               ", conf.containerSystem.methodTransactions[i]);
                this.out(1, "description    ", conf.containerSystem.methodTransactions[i].description);
                this.out(1, "transAttribute ", conf.containerSystem.methodTransactions[i].transAttribute);
                this.out(1, "methods        ", conf.containerSystem.methodTransactions[i].methods);
                if (conf.containerSystem.methodTransactions[i].methods == null) continue;
                MethodInfo[] mthds = conf.containerSystem.methodTransactions[i].methods;
                for (int j = 0; j < mthds.length; ++j) {
                    this.out(2, "description    ", mthds[j].description);
                    this.out(2, "ejbDeploymentId", mthds[j].ejbDeploymentId);
                    this.out(2, "methodIntf     ", mthds[j].methodIntf);
                    this.out(2, "methodName     ", mthds[j].methodName);
                    this.out(2, "methodParams   ", mthds[j].methodParams);
                    if (mthds[j].methodParams == null) continue;
                    for (n = 0; n < mthds[j].methodParams.length; ++n) {
                        this.out(3, "param[" + n + "]", mthds[j].methodParams[n]);
                    }
                }
            }
        }
    }

    private void out(int t, String m) {
        System.out.println(this.tabs[t] + m);
    }

    private void out(int t, String m, String n) {
        System.out.println(this.tabs[t] + m + " = " + n);
    }

    private void out(int t, String m, boolean n) {
        System.out.println(this.tabs[t] + m + " = " + n);
    }

    private void out(int t, String m, int n) {
        System.out.println(this.tabs[t] + m + " = " + n);
    }

    private void out(int t, String m, Object n) {
        System.out.println(this.tabs[t] + m + " = " + n);
    }

    private void out(int t, int m) {
        System.out.println(this.tabs[t] + m);
    }

    public static void handleException(String errorCode, Object arg0, Object arg1, Object arg2, Object arg3) throws OpenEJBException {
        throw new OpenEJBException(messages.format(errorCode, arg0, arg1, arg2, arg3));
    }

    public static void handleException(String errorCode, Object arg0, Object arg1, Object arg2) throws OpenEJBException {
        throw new OpenEJBException(messages.format(errorCode, arg0, arg1, arg2));
    }

    public static void handleException(String errorCode, Object arg0, Object arg1) throws OpenEJBException {
        throw new OpenEJBException(messages.format(errorCode, arg0, arg1));
    }

    public static void handleException(String errorCode, Object arg0) throws OpenEJBException {
        throw new OpenEJBException(messages.format(errorCode, arg0));
    }

    public static void handleException(String errorCode) throws OpenEJBException {
        throw new OpenEJBException(messages.message(errorCode));
    }
}

