/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.alt.config;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Properties;
import org.openejb.OpenEJBException;
import org.openejb.alt.config.Bean;
import org.openejb.alt.config.ConfigUtils;
import org.openejb.alt.config.EjbJarUtils;
import org.openejb.alt.config.EjbSet;
import org.openejb.alt.config.EjbValidator;
import org.openejb.alt.config.ejb11.EjbDeployment;
import org.openejb.alt.config.ejb11.EjbJar;
import org.openejb.alt.config.ejb11.MethodParams;
import org.openejb.alt.config.ejb11.OpenejbJar;
import org.openejb.alt.config.ejb11.Query;
import org.openejb.alt.config.ejb11.QueryMethod;
import org.openejb.alt.config.ejb11.ResourceLink;
import org.openejb.alt.config.ejb11.ResourceRef;
import org.openejb.alt.config.sys.Connector;
import org.openejb.alt.config.sys.Container;
import org.openejb.alt.config.sys.Openejb;
import org.openejb.util.ClasspathUtils;
import org.openejb.util.JarUtils;
import org.openejb.util.Messages;
import org.openejb.util.SafeToolkit;

public class Deploy {
    protected static Messages _messages = new Messages("org.openejb.alt.util.resources");
    private final String DEPLOYMENT_ID_HELP = "\nDeployment ID ----- \n\nA name for the ejb that is unique not only in this jar, but \nin all the jars in the container system.  This name will \nallow OpenEJB to place the bean in a global index and \nreference the bean quickly.  OpenEJB will also use this name \nas the global JNDI name for the Remote Server and the Local \nServer.  Clients of the Remote or Local servers can use this\nname to perform JNDI lookups.\n\nThe other EJB Server's using OpenEJB as the EJB Container \nSystem may also use this name to as part of a global JNDI \nnamespace available to remote application clients.\n\nExample: /my/acme/bugsBunnyBean\n\nSee http://openejb.sf.net/deploymentids.html for details.\n";
    private final String CONTAINER_ID_HELP = "\nContainer ID ----- \n\nThe name of the container where this ejb should run. \nContainers are declared and configured in the openejb.conf\nfile.\n";
    private final String CONNECTOR_ID_HELP = "\nConnector ID ----- \n\nThe name of the connector or JDBC resource this resoure \nreference should be mapped to. Connectors and JDBC resources \nare declared and configured in the openejb.conf file.\n";
    private boolean AUTO_ASSIGN;
    private boolean MOVE_JAR;
    private boolean FORCE_OVERWRITE_JAR;
    private boolean COPY_JAR;
    private boolean AUTO_CONFIG;
    private boolean GENERATE_DEPLOYMENT_ID;
    private boolean GENERATE_STUBS;
    private DataInputStream in;
    private PrintStream out;
    private Openejb config;
    private String configFile;
    private boolean configChanged;
    private boolean autoAssign;
    private Container[] containers;
    private Connector[] resources;

    public void init(String openejbConfigFile) throws OpenEJBException {
        try {
            if (System.getProperty("openejb.nobanner") == null) {
                Deploy.printVersion();
                System.out.println("");
            }
            this.in = new DataInputStream(System.in);
            this.out = System.out;
            this.configFile = openejbConfigFile;
            if (this.configFile == null) {
                try {
                    this.configFile = System.getProperty("openejb.configuration");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.configFile == null) {
                this.configFile = ConfigUtils.searchForConfiguration();
            }
            this.config = ConfigUtils.readConfig(this.configFile);
            this.containers = this.config.getContainer();
            this.resources = this.config.getConnector();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OpenEJBException(e.getMessage());
        }
    }

    private void deploy(String jarLocation) throws OpenEJBException {
        EjbValidator validator = new EjbValidator();
        EjbSet set = validator.validateJar(jarLocation);
        if (set.hasErrors() || set.hasFailures()) {
            validator.printResults(set);
            System.out.println();
            System.out.println("Jar not deployable.");
            System.out.println();
            System.out.println("Use the validator with -vvv option for more details.");
            System.out.println("See http://openejb.sf.net/validate.html for usage.");
            return;
        }
        EjbJar jar = set.getEjbJar();
        OpenejbJar openejbJar = new OpenejbJar();
        Bean[] beans = this.getBeans(jar);
        this.listBeanNames(beans);
        for (int i = 0; i < beans.length; ++i) {
            openejbJar.addEjbDeployment(this.deployBean(beans[i], jarLocation));
        }
        if (this.MOVE_JAR) {
            jarLocation = this.moveJar(jarLocation);
        } else if (this.COPY_JAR) {
            jarLocation = this.copyJar(jarLocation);
        }
        this.addDeploymentEntryToConfig(jarLocation);
        this.saveChanges(jarLocation, openejbJar);
    }

    private EjbDeployment deployBean(Bean bean, String jarLocation) throws OpenEJBException {
        EjbDeployment deployment = new EjbDeployment();
        Class tempBean = SafeToolkit.loadTempClass(bean.getHome(), jarLocation);
        this.out.println("\n-----------------------------------------------------------");
        this.out.println("Deploying bean: " + bean.getEjbName());
        this.out.println("-----------------------------------------------------------");
        deployment.setEjbName(bean.getEjbName());
        if (this.GENERATE_DEPLOYMENT_ID) {
            deployment.setDeploymentId(this.autoAssignDeploymentId(bean));
        } else {
            deployment.setDeploymentId(this.promptForDeploymentId());
        }
        if (this.AUTO_ASSIGN) {
            deployment.setContainerId(this.autoAssignContainerId(bean));
        } else {
            deployment.setContainerId(this.promptForContainerId(bean));
        }
        ResourceRef[] refs = bean.getResourceRef();
        if (refs.length > 0) {
            int i;
            this.out.println("\n==--- Step 3 ---==");
            this.out.println("\nThis bean contains the following references to external \nresources:");
            this.out.println("\nName\t\t\tType\n");
            for (i = 0; i < refs.length; ++i) {
                this.out.print(refs[i].getResRefName() + "\t");
                this.out.println(refs[i].getResType());
            }
            this.out.println("\nThese references must be linked to the available resources\ndeclared in your config file.");
            this.out.println("Available resources are:");
            this.listResources(this.resources);
            for (i = 0; i < refs.length; ++i) {
                deployment.addResourceLink(this.resolveResourceRef(refs[i]));
            }
        }
        if (bean.getType().equals("CMP_ENTITY")) {
            this.promptForOQLForEntityBeans(tempBean, deployment);
        }
        return deployment;
    }

    private void promptForOQLForEntityBeans(Class bean, EjbDeployment deployment) throws OpenEJBException {
        boolean instructionsPrinted = false;
        Method[] methods = bean.getMethods();
        String answer = null;
        for (int i = 0; i < methods.length; ++i) {
            int j;
            if (!methods[i].getName().startsWith("find") || methods[i].getName().equals("findByPrimaryKey")) continue;
            if (!instructionsPrinted) {
                this.out.println("\n==--- Step 4 ---==");
                this.out.println("\nThis part of the application allows you to add OQL (Object\nQuery Language) statements to your CMP Entity find methods.\nBelow is a list of find methods, each of which should get an \nOQL statement.\n\nOQL statements are very similar to SQL statments with the \nexception that they reference class names rather than table\nnames.  Find method parameters can be referenced in OQL \nstatements as $1, $2, $3, and so on.  \n\nIf you had a find method in your home interface like this one:\n\n  public Employee findByLastName( String lName )\n\nThen you could use an OQL method like the following:\n\n  SELECT o FROM org.acme.employee.EmployeeBean o WHERE o.lastname = $1\n\nIn this example, the $1 is referring to the first parameter, \nwhich is the String lName.\n\nFor more information on OQL see:\nhttp://www.openejb.org/cmp_guide.html\n");
                instructionsPrinted = true;
            }
            this.out.print("Method: ");
            Class<?>[] parameterList = methods[i].getParameterTypes();
            this.out.print(methods[i].getName() + "(");
            for (j = 0; j < parameterList.length; ++j) {
                this.out.print(this.parsePartialClassName(parameterList[j].getName()));
                if (j == parameterList.length - 1) continue;
                this.out.print(", ");
            }
            this.out.println(") ");
            try {
                boolean replied = false;
                while (!replied) {
                    this.out.println("Please enter your OQL Statement here.");
                    this.out.print("\nOQL Statement: ");
                    answer = this.in.readLine();
                    if (answer.length() <= 0) continue;
                    replied = true;
                }
            }
            catch (Exception e) {
                throw new OpenEJBException(e.getMessage());
            }
            if (answer == null || answer.equals("")) continue;
            Query query = new Query();
            MethodParams methodParams = new MethodParams();
            QueryMethod queryMethod = new QueryMethod();
            for (j = 0; j < parameterList.length; ++j) {
                methodParams.addMethodParam(parameterList[j].getName());
            }
            queryMethod.setMethodParams(methodParams);
            queryMethod.setMethodName(methods[i].getName());
            query.setQueryMethod(queryMethod);
            query.setObjectQl(answer);
            deployment.addQuery(query);
            this.out.println("\nYour OQL statement was successfully added to the jar.\n");
        }
    }

    private String parsePartialClassName(String className) {
        if (className.indexOf(46) < 1) {
            return className;
        }
        return className.substring(className.lastIndexOf(46) + 1);
    }

    private void listBeanNames(Bean[] beans) {
        this.out.println("This jar contains the following beans:");
        for (int i = 0; i < beans.length; ++i) {
            this.out.println("  " + beans[i].getEjbName());
        }
        this.out.println();
    }

    private String promptForDeploymentId() throws OpenEJBException {
        String answer = null;
        try {
            boolean replied = false;
            this.out.println("\n==--- Step 1 ---==");
            this.out.println("\nPlease specify a deployment id for this bean.");
            while (!replied) {
                this.out.println("Type the id or -help for more information.");
                this.out.print("\nDeployment ID: ");
                answer = this.in.readLine();
                if ("-help".equals(answer)) {
                    this.out.println("\nDeployment ID ----- \n\nA name for the ejb that is unique not only in this jar, but \nin all the jars in the container system.  This name will \nallow OpenEJB to place the bean in a global index and \nreference the bean quickly.  OpenEJB will also use this name \nas the global JNDI name for the Remote Server and the Local \nServer.  Clients of the Remote or Local servers can use this\nname to perform JNDI lookups.\n\nThe other EJB Server's using OpenEJB as the EJB Container \nSystem may also use this name to as part of a global JNDI \nnamespace available to remote application clients.\n\nExample: /my/acme/bugsBunnyBean\n\nSee http://openejb.sf.net/deploymentids.html for details.\n");
                    continue;
                }
                if (answer.length() <= 0) continue;
                replied = true;
            }
        }
        catch (Exception e) {
            throw new OpenEJBException(e.getMessage());
        }
        return answer;
    }

    private String autoAssignDeploymentId(Bean bean) throws OpenEJBException {
        String answer = bean.getEjbName();
        this.out.println("\n==--- Step 1 ---==");
        this.out.println("\nAuto assigning the ejb-name as the deployment id for this bean.");
        this.out.print("\nDeployment ID: " + answer);
        return answer;
    }

    private String promptForContainerId(Bean bean) throws OpenEJBException {
        String answer = null;
        boolean replied = false;
        this.out.println("\n==--- Step 2 ---==");
        this.out.println("\nPlease specify which container the bean will run in.");
        this.out.println("Available containers are:");
        Container[] cs = this.getUsableContainers(bean);
        if (cs.length == 0) {
            this.out.println("!! There are no " + bean.getType() + " containers declared in " + this.configFile + " !!");
            this.out.println("A " + bean.getType() + " container must be declared and \nconfigured in your configuration file before this jar can\nbe deployed.");
            System.exit(-1);
        } else if (cs.length == 0) {
            // empty if block
        }
        this.listContainers(cs);
        int choice = 0;
        try {
            while (!replied) {
                this.out.println("\nType the number of the container\n-options to view the list again\nor -help for more information.");
                this.out.print("\nContainer: ");
                answer = this.in.readLine();
                if ("-help".equals(answer)) {
                    this.out.println("\nContainer ID ----- \n\nThe name of the container where this ejb should run. \nContainers are declared and configured in the openejb.conf\nfile.\n");
                    continue;
                }
                if ("-options".equals(answer)) {
                    this.listContainers(cs);
                    continue;
                }
                if (answer.length() <= 0) continue;
                try {
                    choice = Integer.parseInt(answer);
                }
                catch (NumberFormatException nfe) {
                    this.out.println("'" + answer + "' is not a numer.");
                    continue;
                }
                if (choice > cs.length || choice < 1) {
                    this.out.println(choice + " is not an option.");
                    continue;
                }
                replied = true;
            }
        }
        catch (Exception e) {
            throw new OpenEJBException(e.getMessage());
        }
        return cs[choice - 1].getId();
    }

    private String autoAssignContainerId(Bean bean) throws OpenEJBException {
        Object answer = null;
        boolean replied = false;
        this.out.println("\n==--- Step 2 ---==");
        this.out.println("\nAuto assigning the container the bean will run in.");
        Container[] cs = this.getUsableContainers(bean);
        if (cs.length == 0) {
            this.out.println("!! There are no " + bean.getType() + " containers declared in " + this.configFile + " !!");
            this.out.println("A " + bean.getType() + " container must be declared and \nconfigured in your configuration file before this jar can\nbe deployed.");
            System.exit(-1);
        }
        this.out.println("\nContainer: " + cs[0].getId());
        return cs[0].getId();
    }

    private void listContainers(Container[] containers) {
        this.out.println("\nNum \tType     \tID\n");
        for (int i = 0; i < containers.length; ++i) {
            this.out.print(i + 1 + "\t");
            this.out.print(containers[i].getCtype() + "\t");
            this.out.println(containers[i].getId());
        }
    }

    private ResourceLink resolveResourceRef(ResourceRef ref) throws OpenEJBException {
        String answer = null;
        boolean replied = false;
        this.out.println("\nPlease link reference: " + ref.getResRefName());
        if (this.resources.length == 0) {
            this.out.println("!! There are no resources declared in " + this.configFile + " !!");
            this.out.println("A resource connector must be declared and configured in \nyour configuration file before this jar can be deployed.");
            System.exit(-2);
        } else if (this.resources.length == 0) {
            // empty if block
        }
        int choice = 0;
        try {
            while (!replied) {
                this.out.println("\nType the number of the resource to link the bean's \nreference to, -options to view the list again, or -help\nfor more information.");
                this.out.print("\nResource: ");
                answer = this.in.readLine();
                if ("-help".equals(answer)) {
                    this.out.println("\nConnector ID ----- \n\nThe name of the connector or JDBC resource this resoure \nreference should be mapped to. Connectors and JDBC resources \nare declared and configured in the openejb.conf file.\n");
                    continue;
                }
                if ("-options".equals(answer)) {
                    this.listResources(this.resources);
                    continue;
                }
                if (answer.length() <= 0) continue;
                try {
                    choice = Integer.parseInt(answer);
                }
                catch (NumberFormatException nfe) {
                    this.out.println("'" + answer + "' is not a number.");
                    continue;
                }
                if (choice > this.resources.length || choice < 1) {
                    this.out.println(choice + " is not an option.");
                    continue;
                }
                replied = true;
            }
        }
        catch (Exception e) {
            throw new OpenEJBException(e.getMessage());
        }
        ResourceLink link = new ResourceLink();
        link.setResRefName(ref.getResRefName());
        link.setResId(this.resources[choice - 1].getId());
        return link;
    }

    private void listResources(Connector[] connectors) {
        this.out.println("\nNum \tID\n");
        for (int i = 0; i < connectors.length; ++i) {
            this.out.print(i + 1 + "\t");
            this.out.println(connectors[i].getId());
        }
    }

    private void saveChanges(String jarFile, OpenejbJar openejbJar) throws OpenEJBException {
        this.out.println("\n-----------------------------------------------------------");
        this.out.println("Done collecting deployment information!");
        this.out.print("Creating the openejb-jar.xml file...");
        ConfigUtils.writeOpenejbJar("META-INF/openejb-jar.xml", openejbJar);
        this.out.println("done");
        this.out.print("Writing openejb-jar.xml to the jar...");
        JarUtils.addFileToJar(jarFile, "META-INF/openejb-jar.xml");
        this.out.println("done");
        if (this.configChanged) {
            this.out.print("Updating your system config...");
            ConfigUtils.writeConfig(this.configFile, this.config);
            this.out.println("done");
        }
        this.out.println("\nCongratulations! Your jar is ready to use with OpenEJB.");
        this.out.println("\nIf the OpenEJB remote server is already running, you will\nneed to restart it in order for OpenEJB to recognize your bean.");
        this.out.println("\nNOTE: If you move or rename your jar file, you will have to\nupdate the path in this jar's deployment entry in your \nOpenEJB config file.");
    }

    private void logException(String m) throws OpenEJBException {
        System.out.println("[OpenEJB] " + m);
        throw new OpenEJBException(m);
    }

    private void logException(String m, Exception e) throws OpenEJBException {
        m = m + " : " + e.getMessage();
        System.out.println("[OpenEJB] " + m);
        throw new OpenEJBException(m);
    }

    public static void main(String[] args) {
        try {
            ClasspathUtils.addJarsToPath("lib");
            ClasspathUtils.addJarsToPath("dist");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Deploy d = new Deploy();
            if (args.length == 0) {
                Deploy.printHelp();
                return;
            }
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-a")) {
                    d.AUTO_ASSIGN = true;
                    d.GENERATE_DEPLOYMENT_ID = true;
                    continue;
                }
                if (args[i].equals("-m")) {
                    d.MOVE_JAR = true;
                    continue;
                }
                if (args[i].equals("-f")) {
                    d.FORCE_OVERWRITE_JAR = true;
                    continue;
                }
                if (args[i].equals("-c")) {
                    d.COPY_JAR = true;
                    continue;
                }
                if (args[i].equals("-C")) {
                    d.AUTO_ASSIGN = true;
                    continue;
                }
                if (args[i].equals("-D")) {
                    d.GENERATE_DEPLOYMENT_ID = true;
                    continue;
                }
                if (args[i].equals("-conf")) {
                    if (args.length <= i + 1) continue;
                    System.setProperty("openejb.configuration", args[++i]);
                    continue;
                }
                if (args[i].equals("-l")) {
                    if (args.length <= i + 1) continue;
                    System.setProperty("log4j.configuration", args[++i]);
                    continue;
                }
                if (args[i].equals("-d")) {
                    if (args.length <= i + 1) continue;
                    System.setProperty("openejb.home", args[++i]);
                    continue;
                }
                if (args[i].equals("-help")) {
                    Deploy.printHelp();
                    continue;
                }
                if (args[i].equals("-examples")) {
                    Deploy.printExamples();
                    continue;
                }
                if (args[i].equals("-version")) {
                    Deploy.printVersion();
                    continue;
                }
                d.init(null);
                while (i < args.length) {
                    try {
                        d.deploy(args[i]);
                    }
                    catch (Exception e) {
                        System.out.print("\nERROR in ");
                        System.out.println(args[i]);
                        System.out.println(e.getMessage());
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private static void printVersion() {
        Properties versionInfo = new Properties();
        try {
            JarUtils.setHandlerSystemProperty();
            versionInfo.load(new URL("resource:/openejb-version.properties").openConnection().getInputStream());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("OpenEJB Deploy Tool " + versionInfo.get("version") + "    build: " + versionInfo.get("date") + "-" + versionInfo.get("time"));
        System.out.println("" + versionInfo.get("url"));
    }

    private static void printHelp() {
        String header = "OpenEJB Deploy Tool ";
        try {
            JarUtils.setHandlerSystemProperty();
            Properties versionInfo = new Properties();
            versionInfo.load(new URL("resource:/openejb-version.properties").openConnection().getInputStream());
            header = header + versionInfo.get("version");
        }
        catch (IOException e) {
            // empty catch block
        }
        System.out.println(header);
        try {
            InputStream in = new URL("resource:/openejb/deploy.txt").openConnection().getInputStream();
            int b = in.read();
            while (b != -1) {
                System.out.write(b);
                b = in.read();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void printExamples() {
        String header = "OpenEJB Deploy Tool ";
        try {
            JarUtils.setHandlerSystemProperty();
            Properties versionInfo = new Properties();
            versionInfo.load(new URL("resource:/openejb-version.properties").openConnection().getInputStream());
            header = header + versionInfo.get("version");
        }
        catch (IOException e) {
            // empty catch block
        }
        System.out.println(header);
        try {
            InputStream in = new URL("resource:/openejb/deploy-examples.txt").openConnection().getInputStream();
            int b = in.read();
            while (b != -1) {
                System.out.write(b);
                b = in.read();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Bean[] getBeans(EjbJar jar) {
        return EjbJarUtils.getBeans(jar);
    }

    private String moveJar(String jar) throws OpenEJBException {
        return EjbJarUtils.moveJar(jar, this.FORCE_OVERWRITE_JAR);
    }

    private String copyJar(String jar) throws OpenEJBException {
        return EjbJarUtils.copyJar(jar, this.FORCE_OVERWRITE_JAR);
    }

    private Container[] getUsableContainers(Bean bean) {
        return EjbJarUtils.getUsableContainers(this.containers, bean);
    }

    private void addDeploymentEntryToConfig(String jarLocation) {
        this.configChanged = ConfigUtils.addDeploymentEntryToConfig(jarLocation, this.config);
    }
}

