/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.alt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.UnknownHostException;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.openejb.OpenEJBException;
import org.openejb.alt.config.Bean;
import org.openejb.alt.config.DTDResolver;
import org.openejb.alt.config.EntityBean;
import org.openejb.alt.config.SessionBean;
import org.openejb.alt.config.ejb11.EjbJar;
import org.openejb.alt.config.ejb11.EnterpriseBeansItem;
import org.openejb.alt.config.sys.Container;
import org.openejb.util.FileUtils;
import org.openejb.util.JarUtils;
import org.openejb.util.Messages;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class EjbJarUtils {
    protected static Messages _messages = new Messages("org.openejb.util.resources");
    private static DTDResolver resolver = new DTDResolver();

    public static EjbJar readEjbJar(String jarFile) throws OpenEJBException {
        JarFile jar = JarUtils.getJarFile(jarFile);
        JarEntry entry = jar.getJarEntry("META-INF/ejb-jar.xml");
        if (entry == null) {
            entry = jar.getJarEntry("ejb-jar.xml");
        }
        if (entry == null) {
            EjbJarUtils.handleException("conf.3900", jarFile, "no message");
        }
        InputStreamReader reader = null;
        InputStream stream = null;
        try {
            stream = jar.getInputStream(entry);
            reader = new InputStreamReader(stream);
        }
        catch (Exception e) {
            EjbJarUtils.handleException("conf.3110", jarFile, e.getLocalizedMessage());
        }
        EjbJar obj = null;
        try {
            obj = EjbJarUtils.unmarshalEjbJar(reader);
        }
        catch (MarshalException e) {
            if (e.getException() instanceof UnknownHostException) {
                EjbJarUtils.handleException("conf.3121", jarFile, e.getLocalizedMessage());
            } else if (e.getException() instanceof SAXException) {
                EjbJarUtils.handleException("conf.3140", jarFile, e.getLocalizedMessage());
            } else if (e.getException() instanceof IOException) {
                EjbJarUtils.handleException("conf.3110", jarFile, e.getLocalizedMessage());
            } else {
                EjbJarUtils.handleException("conf.3120", jarFile, e.getLocalizedMessage());
            }
        }
        catch (ValidationException e) {
            EjbJarUtils.handleException("conf.3130", jarFile, e.getLocalizedMessage());
        }
        try {
            stream.close();
            ((Reader)reader).close();
            jar.close();
        }
        catch (Exception e) {
            EjbJarUtils.handleException("file.0020", jarFile, e.getLocalizedMessage());
        }
        return obj;
    }

    private static EjbJar unmarshalEjbJar(Reader reader) throws MarshalException, ValidationException {
        Unmarshaller unmarshaller = new Unmarshaller(EjbJar.class);
        unmarshaller.setEntityResolver((EntityResolver)resolver);
        return (EjbJar)unmarshaller.unmarshal(reader);
    }

    public static void writeEjbJar(String xmlFile, EjbJar ejbJarObject) throws OpenEJBException {
        FileWriter writer = null;
        try {
            File file = new File(xmlFile);
            writer = new FileWriter(file);
            ejbJarObject.marshal(writer);
        }
        catch (IOException e) {
            EjbJarUtils.handleException("conf.3040", xmlFile, e.getLocalizedMessage());
        }
        catch (MarshalException e) {
            if (e.getException() instanceof IOException) {
                EjbJarUtils.handleException("conf.3040", xmlFile, e.getLocalizedMessage());
            } else {
                EjbJarUtils.handleException("conf.3050", xmlFile, e.getLocalizedMessage());
            }
        }
        catch (ValidationException e) {
            EjbJarUtils.handleException("conf.3060", xmlFile, e.getLocalizedMessage());
        }
        try {
            ((Writer)writer).close();
        }
        catch (Exception e) {
            EjbJarUtils.handleException("file.0020", xmlFile, e.getLocalizedMessage());
        }
    }

    public static String moveJar(String jar, boolean overwrite) throws OpenEJBException {
        File origFile = new File(jar);
        if (!origFile.exists()) {
            EjbJarUtils.handleException("deploy.m.010", origFile.getAbsolutePath());
        }
        if (origFile.isDirectory()) {
            EjbJarUtils.handleException("deploy.m.020", origFile.getAbsolutePath());
        }
        if (!origFile.isFile()) {
            EjbJarUtils.handleException("deploy.m.030", origFile.getAbsolutePath());
        }
        String jarName = origFile.getName();
        File beansDir = null;
        try {
            beansDir = FileUtils.getBase().getDirectory("beans");
        }
        catch (IOException ioe) {
            EjbJarUtils.handleException("deploy.m.040", origFile.getAbsolutePath(), ioe.getMessage());
        }
        File newFile = new File(beansDir, jarName);
        boolean moved = false;
        try {
            if (newFile.exists()) {
                if (overwrite) {
                    newFile.delete();
                } else {
                    throw new OpenEJBException(_messages.format("deploy.m.061", origFile.getAbsolutePath(), beansDir.getAbsolutePath()));
                }
            }
            moved = origFile.renameTo(newFile);
        }
        catch (SecurityException se) {
            EjbJarUtils.handleException("deploy.m.050", origFile.getAbsolutePath(), se.getMessage());
        }
        if (!moved) {
            EjbJarUtils.handleException("deploy.m.060", origFile.getAbsolutePath(), newFile.getAbsoluteFile());
        }
        return newFile.getAbsolutePath();
    }

    public static String copyJar(String jar, boolean overwrite) throws OpenEJBException {
        File origFile = new File(jar);
        if (!origFile.exists()) {
            EjbJarUtils.handleException("deploy.c.010", origFile.getAbsolutePath());
            return jar;
        }
        if (origFile.isDirectory()) {
            EjbJarUtils.handleException("deploy.c.020", origFile.getAbsolutePath());
            return jar;
        }
        if (!origFile.isFile()) {
            EjbJarUtils.handleException("deploy.c.030", origFile.getAbsolutePath());
            return jar;
        }
        String jarName = origFile.getName();
        File beansDir = null;
        try {
            beansDir = FileUtils.getBase().getDirectory("beans");
        }
        catch (IOException ioe) {
            EjbJarUtils.handleException("deploy.c.040", origFile.getAbsolutePath(), ioe.getMessage());
            return jar;
        }
        File newFile = new File(beansDir, jarName);
        try {
            if (newFile.exists()) {
                if (overwrite) {
                    newFile.delete();
                } else {
                    throw new OpenEJBException(_messages.format("deploy.c.061", origFile.getAbsolutePath(), beansDir.getAbsolutePath()));
                }
            }
            FileInputStream in = new FileInputStream(origFile);
            FileOutputStream out = new FileOutputStream(newFile);
            int b = in.read();
            while (b != -1) {
                out.write(b);
                b = in.read();
            }
            in.close();
            out.close();
        }
        catch (SecurityException e) {
            EjbJarUtils.handleException("deploy.c.050", origFile.getAbsolutePath(), beansDir.getAbsolutePath(), e.getMessage());
        }
        catch (IOException e) {
            EjbJarUtils.handleException("deploy.c.060", origFile.getAbsolutePath(), newFile.getAbsolutePath(), e.getClass().getName(), e.getMessage());
        }
        return newFile.getAbsolutePath();
    }

    public static Container[] getUsableContainers(Container[] containers, Bean bean) {
        Vector<Container> c = new Vector<Container>();
        for (int i = 0; i < containers.length; ++i) {
            if (!containers[i].getCtype().equals(bean.getType())) continue;
            c.add(containers[i]);
        }
        Object[] useableContainers = new Container[c.size()];
        c.copyInto(useableContainers);
        return useableContainers;
    }

    public static Bean[] getBeans(EjbJar jar) {
        EnterpriseBeansItem[] items = jar.getEnterpriseBeans().getEnterpriseBeansItem();
        Bean[] beans = new Bean[items.length];
        for (int i = 0; i < items.length; ++i) {
            beans[i] = items[i].getEntity() == null ? new SessionBean(items[i].getSession()) : new EntityBean(items[i].getEntity());
        }
        return beans;
    }

    public static void handleException(String errorCode, Object arg0, Object arg1, Object arg2, Object arg3) throws OpenEJBException {
        throw new OpenEJBException(_messages.format(errorCode, arg0, arg1, arg2, arg3));
    }

    public static void handleException(String errorCode, Object arg0, Object arg1, Object arg2) throws OpenEJBException {
        throw new OpenEJBException(_messages.format(errorCode, arg0, arg1, arg2));
    }

    public static void handleException(String errorCode, Object arg0, Object arg1) throws OpenEJBException {
        throw new OpenEJBException(_messages.format(errorCode, arg0, arg1));
    }

    public static void handleException(String errorCode, Object arg0) throws OpenEJBException {
        throw new OpenEJBException(_messages.format(errorCode, arg0));
    }

    public static void handleException(String errorCode) throws OpenEJBException {
        throw new OpenEJBException(_messages.message(errorCode));
    }
}

