/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.alt.config;

import java.util.Vector;
import org.openejb.alt.config.Bean;
import org.openejb.alt.config.EjbJarUtils;
import org.openejb.alt.config.ValidationError;
import org.openejb.alt.config.ValidationFailure;
import org.openejb.alt.config.ValidationWarning;
import org.openejb.alt.config.ejb11.EjbJar;

public class EjbSet {
    protected Vector failures = new Vector();
    protected Vector warnings = new Vector();
    protected Vector errors = new Vector();
    protected Bean[] beans;
    protected EjbJar jar;
    protected String jarPath;

    public EjbSet(String jarPath) {
        this.jarPath = jarPath;
    }

    public void setEjbJar(EjbJar jar) {
        this.jar = jar;
        this.beans = EjbJarUtils.getBeans(jar);
    }

    public void addWarning(ValidationWarning warning) {
        this.warnings.addElement(warning);
    }

    public void addFailure(ValidationFailure failure) {
        this.failures.addElement(failure);
    }

    public void addError(ValidationError error) {
        this.errors.addElement(error);
    }

    public ValidationFailure[] getFailures() {
        Object[] tmp = new ValidationFailure[this.failures.size()];
        this.failures.copyInto(tmp);
        return tmp;
    }

    public ValidationWarning[] getWarnings() {
        Object[] tmp = new ValidationWarning[this.warnings.size()];
        this.warnings.copyInto(tmp);
        return tmp;
    }

    public ValidationError[] getErrors() {
        Object[] tmp = new ValidationError[this.errors.size()];
        this.errors.copyInto(tmp);
        return tmp;
    }

    public boolean hasWarnings() {
        return this.warnings.size() > 0;
    }

    public boolean hasFailures() {
        return this.failures.size() > 0;
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public Bean[] getBeans() {
        return this.beans;
    }

    public EjbJar getEjbJar() {
        return this.jar;
    }

    public String getJarPath() {
        return this.jarPath;
    }
}

