/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.alt.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import org.openejb.OpenEJBException;
import org.openejb.alt.config.EjbJarUtils;
import org.openejb.alt.config.EjbSet;
import org.openejb.alt.config.ValidationError;
import org.openejb.alt.config.ValidationException;
import org.openejb.alt.config.ValidationRule;
import org.openejb.alt.config.ejb11.EjbJar;
import org.openejb.alt.config.rules.CheckClasses;
import org.openejb.alt.config.rules.CheckMethods;
import org.openejb.util.ClasspathUtils;
import org.openejb.util.JarUtils;
import org.openejb.util.Messages;

public class EjbValidator {
    protected static Messages _messages = new Messages("org.openejb.util.resources");
    int LEVEL = 2;
    boolean PRINT_DETAILS = false;
    boolean PRINT_XML = false;
    boolean PRINT_WARNINGS = true;
    boolean PRINT_COUNT = false;
    private Vector sets = new Vector();

    public EjbValidator() throws OpenEJBException {
        JarUtils.setHandlerSystemProperty();
    }

    public void addEjbSet(EjbSet set) {
        this.sets.add(set);
    }

    public EjbSet[] getEjbSets() {
        Object[] ejbSets = new EjbSet[this.sets.size()];
        this.sets.copyInto(ejbSets);
        return ejbSets;
    }

    public EjbSet validateJar(String jarLocation) {
        EjbSet set = new EjbSet(jarLocation);
        try {
            set.setEjbJar(EjbJarUtils.readEjbJar(jarLocation));
            this.validateJar(set);
        }
        catch (Throwable e) {
            e.printStackTrace(System.out);
            ValidationError err = new ValidationError("cannot.validate");
            err.setDetails(e.getMessage());
            set.addError(err);
        }
        return set;
    }

    public EjbSet validateJar(EjbJar ejbJar, String jarLocation) {
        EjbSet set = new EjbSet(jarLocation);
        set.setEjbJar(ejbJar);
        return this.validateJar(set);
    }

    public EjbSet validateJar(EjbSet set) {
        try {
            ValidationRule[] rules = this.getValidationRules();
            for (int i = 0; i < rules.length; ++i) {
                rules[i].validate(set);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            ValidationError err = new ValidationError("cannot.validate");
            err.setDetails(e.getMessage());
            set.addError(err);
        }
        return set;
    }

    protected ValidationRule[] getValidationRules() {
        ValidationRule[] rules = new ValidationRule[]{new CheckClasses(), new CheckMethods()};
        return rules;
    }

    public void printResults(EjbSet set) {
        if (!(set.hasErrors() || set.hasFailures() || this.PRINT_WARNINGS && set.hasWarnings())) {
            return;
        }
        System.out.println("------------------------------------------");
        System.out.println("JAR " + set.getJarPath());
        System.out.println("                                          ");
        this.printValidationExceptions(set.getErrors());
        this.printValidationExceptions(set.getFailures());
        if (this.PRINT_WARNINGS) {
            this.printValidationExceptions(set.getWarnings());
        }
    }

    protected void printValidationExceptions(ValidationException[] exceptions) {
        for (int i = 0; i < exceptions.length; ++i) {
            System.out.print(" ");
            System.out.print(exceptions[i].getPrefix());
            System.out.print(" ... ");
            if (!(exceptions[i] instanceof ValidationError)) {
                System.out.print(exceptions[i].getBean().getEjbName());
                System.out.print(": ");
            }
            if (this.LEVEL > 2) {
                System.out.println(exceptions[i].getMessage(1));
                System.out.println();
                System.out.print('\t');
                System.out.println(exceptions[i].getMessage(this.LEVEL));
                System.out.println();
                continue;
            }
            System.out.println(exceptions[i].getMessage(this.LEVEL));
        }
        if (this.PRINT_COUNT && exceptions.length > 0) {
            System.out.println();
            System.out.print(" " + exceptions.length + " ");
            System.out.println(exceptions[0].getCategory());
            System.out.println();
        }
    }

    public void printResultsXML(EjbSet set) {
        if (!(set.hasErrors() || set.hasFailures() || this.PRINT_WARNINGS && set.hasWarnings())) {
            return;
        }
        System.out.println("<jar>");
        System.out.print("  <path>");
        System.out.print(set.getJarPath());
        System.out.println("</path>");
        this.printValidationExceptionsXML(set.getErrors());
        this.printValidationExceptionsXML(set.getFailures());
        if (this.PRINT_WARNINGS) {
            this.printValidationExceptionsXML(set.getWarnings());
        }
        System.out.println("</jar>");
    }

    protected void printValidationExceptionsXML(ValidationException[] exceptions) {
        for (int i = 0; i < exceptions.length; ++i) {
            System.out.print("    <");
            System.out.print(exceptions[i].getPrefix());
            System.out.println(">");
            if (!(exceptions[i] instanceof ValidationError)) {
                System.out.print("      <ejb-name>");
                System.out.print(exceptions[i].getBean().getEjbName());
                System.out.println("</ejb-name>");
            }
            System.out.print("      <summary>");
            System.out.print(exceptions[i].getMessage(1));
            System.out.println("</summary>");
            System.out.println("      <description><![CDATA[");
            System.out.println(exceptions[i].getMessage(3));
            System.out.println("]]></description>");
            System.out.print("    </");
            System.out.print(exceptions[i].getPrefix());
            System.out.println(">");
        }
    }

    public void displayResults(EjbSet[] sets) {
        if (this.PRINT_XML) {
            System.out.println("<results>");
            for (int i = 0; i < sets.length; ++i) {
                this.printResultsXML(sets[i]);
            }
            System.out.println("</results>");
        } else {
            int i;
            for (i = 0; i < sets.length; ++i) {
                this.printResults(sets[i]);
            }
            for (i = 0; i < sets.length; ++i) {
                if (!sets[i].hasErrors() && !sets[i].hasFailures()) continue;
                if (this.LEVEL < 3) {
                    System.out.println();
                    System.out.println("For more details, use the -vvv option");
                }
                i = sets.length;
            }
        }
    }

    private static void printVersion() {
        Properties versionInfo = new Properties();
        try {
            JarUtils.setHandlerSystemProperty();
            versionInfo.load(new URL("resource:/openejb-version.properties").openConnection().getInputStream());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("OpenEJB EJB Validation Tool " + versionInfo.get("version") + "    build: " + versionInfo.get("date") + "-" + versionInfo.get("time"));
        System.out.println("" + versionInfo.get("url"));
    }

    private static void printHelp() {
        String header = "OpenEJB EJB Validation Tool ";
        try {
            JarUtils.setHandlerSystemProperty();
            Properties versionInfo = new Properties();
            versionInfo.load(new URL("resource:/openejb-version.properties").openConnection().getInputStream());
            header = header + versionInfo.get("version");
        }
        catch (IOException e) {
            // empty catch block
        }
        System.out.println(header);
        try {
            InputStream in = new URL("resource:/openejb/validate.txt").openConnection().getInputStream();
            int b = in.read();
            while (b != -1) {
                System.out.write(b);
                b = in.read();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void printExamples() {
        String header = "OpenEJB EJB Validation Tool ";
        try {
            JarUtils.setHandlerSystemProperty();
            Properties versionInfo = new Properties();
            versionInfo.load(new URL("resource:/openejb-version.properties").openConnection().getInputStream());
            header = header + versionInfo.get("version");
        }
        catch (IOException e) {
            // empty catch block
        }
        System.out.println(header);
        try {
            InputStream in = new URL("resource:/openejb/validate-examples.txt").openConnection().getInputStream();
            int b = in.read();
            while (b != -1) {
                System.out.write(b);
                b = in.read();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        try {
            ClasspathUtils.addJarsToPath("lib");
            ClasspathUtils.addJarsToPath("dist");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            EjbValidator v = new EjbValidator();
            if (args.length == 0) {
                EjbValidator.printHelp();
                return;
            }
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-v")) {
                    v.LEVEL = 1;
                    continue;
                }
                if (args[i].equals("-vv")) {
                    v.LEVEL = 2;
                    continue;
                }
                if (args[i].equals("-vvv")) {
                    v.LEVEL = 3;
                    continue;
                }
                if (args[i].equals("-nowarn")) {
                    v.PRINT_WARNINGS = false;
                    continue;
                }
                if (args[i].equals("-xml")) {
                    v.PRINT_XML = true;
                    continue;
                }
                if (args[i].equals("-help")) {
                    EjbValidator.printHelp();
                    continue;
                }
                if (args[i].equals("-examples")) {
                    EjbValidator.printExamples();
                    continue;
                }
                if (args[i].equals("-version")) {
                    EjbValidator.printVersion();
                    continue;
                }
                while (i < args.length) {
                    try {
                        EjbSet set = v.validateJar(args[i]);
                        v.addEjbSet(set);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
            EjbSet[] sets = v.getEjbSets();
            v.displayResults(sets);
            for (int i = 0; i < sets.length; ++i) {
                if (!sets[i].hasErrors() && !sets[i].hasFailures()) continue;
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

