/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.alt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.Writer;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.openejb.OpenEJBException;
import org.openejb.alt.config.ConfigUtils;
import org.openejb.alt.config.Service;
import org.openejb.alt.config.sys.ServiceProvider;
import org.openejb.alt.config.sys.ServicesJar;
import org.openejb.util.Logger;
import org.openejb.util.Messages;

public class ServiceUtils {
    public static String defaultProviderURL = "org.openejb";
    private static Map loadedServiceJars = new HashMap();
    private static Messages messages = new Messages("org.openejb.util.resources");
    private static Logger _logger = Logger.getInstance("OpenEJB", "org.openejb.util.resources");

    public static ServiceProvider getServiceProvider(Service service) throws OpenEJBException {
        return ServiceUtils.getServiceProvider(service.getProvider());
    }

    public static ServiceProvider getServiceProvider(String id) throws OpenEJBException {
        String providerName = null;
        String serviceName = null;
        if (id.indexOf("#") == -1) {
            providerName = defaultProviderURL;
            serviceName = id;
        } else {
            providerName = id.substring(0, id.indexOf("#"));
            serviceName = id.substring(id.indexOf("#") + 1);
        }
        ServiceProvider service = null;
        if (loadedServiceJars.get(providerName) == null) {
            ServicesJar sj = ServiceUtils.readServicesJar(providerName);
            ServiceProvider[] sp = sj.getServiceProvider();
            HashMap<String, ServiceProvider> services = new HashMap<String, ServiceProvider>(sj.getServiceProviderCount());
            for (int i = 0; i < sp.length; ++i) {
                services.put(sp[i].getId(), sp[i]);
            }
            loadedServiceJars.put(providerName, services);
            service = (ServiceProvider)services.get(serviceName);
        } else {
            Map provider = (Map)loadedServiceJars.get(providerName);
            service = (ServiceProvider)provider.get(serviceName);
        }
        if (service == null) {
            ServiceUtils.handleException("conf.4901", serviceName, providerName);
        }
        return service;
    }

    public static ServicesJar readServicesJar(String providerName) throws OpenEJBException {
        String servicejarPath = providerName.replace('.', '/');
        servicejarPath = "resource:/" + servicejarPath + "/service-jar.xml";
        InputStreamReader reader = null;
        InputStream stream = null;
        try {
            stream = new URL(servicejarPath).openConnection().getInputStream();
            reader = new InputStreamReader(stream);
        }
        catch (Exception e) {
            ServiceUtils.handleException("conf.4110", servicejarPath, e.getLocalizedMessage());
        }
        ServicesJar obj = null;
        try {
            Unmarshaller unmarshaller = new Unmarshaller(ServicesJar.class);
            unmarshaller.setWhitespacePreserve(true);
            obj = (ServicesJar)unmarshaller.unmarshal((Reader)reader);
        }
        catch (MarshalException e) {
            if (e.getException() instanceof IOException) {
                ServiceUtils.handleException("conf.4110", servicejarPath, e.getLocalizedMessage());
            } else if (e.getException() instanceof UnknownHostException) {
                ServiceUtils.handleException("conf.4121", servicejarPath, e.getLocalizedMessage());
            } else {
                ServiceUtils.handleException("conf.4120", providerName, e.getLocalizedMessage());
            }
        }
        catch (ValidationException e) {
            ServiceUtils.handleException("conf.4130", providerName, e.getLocalizedMessage());
        }
        try {
            stream.close();
            ((Reader)reader).close();
        }
        catch (Exception e) {
            ServiceUtils.handleException("file.0010", servicejarPath, e.getLocalizedMessage());
        }
        return obj;
    }

    public static void writeServicesJar(String xmlFile, ServicesJar servicesJarObject) throws OpenEJBException {
        FileWriter writer = null;
        try {
            File file = new File(xmlFile);
            writer = new FileWriter(file);
            servicesJarObject.marshal(writer);
        }
        catch (IOException e) {
            ServiceUtils.handleException("conf.4040", xmlFile, e.getLocalizedMessage());
        }
        catch (MarshalException e) {
            if (e.getException() instanceof IOException) {
                ServiceUtils.handleException("conf.4040", xmlFile, e.getLocalizedMessage());
            } else {
                ServiceUtils.handleException("conf.4050", xmlFile, e.getLocalizedMessage());
            }
        }
        catch (ValidationException e) {
            ServiceUtils.handleException("conf.4060", xmlFile, e.getLocalizedMessage());
        }
        try {
            ((Writer)writer).close();
        }
        catch (Exception e) {
            ServiceUtils.handleException("file.0020", xmlFile, e.getLocalizedMessage());
        }
    }

    public static Properties assemblePropertiesFor(String confItem, String itemId, String itemContent, String confFile, ServiceProvider service) throws OpenEJBException {
        StringBufferInputStream in;
        Properties props = new Properties();
        try {
            if (service.getPropertiesFile() != null) {
                props = ServiceUtils.loadProperties(service.getPropertiesFile().getFile());
            }
            if (service.getContent() != null) {
                in = new StringBufferInputStream(service.getContent());
                props = ServiceUtils.loadProperties(in, props);
            }
        }
        catch (OpenEJBException ex) {
            ConfigUtils.handleException("conf.0013", service.getId(), null, ex.getLocalizedMessage());
        }
        try {
            if (itemContent != null) {
                in = new StringBufferInputStream(itemContent);
                props = ServiceUtils.loadProperties(in, props);
            }
        }
        catch (OpenEJBException ex) {
            ConfigUtils.handleException("conf.0014", confItem, itemId, confFile, ex.getLocalizedMessage());
        }
        return props;
    }

    public static Properties loadProperties(String pFile) throws OpenEJBException {
        return ServiceUtils.loadProperties(pFile, new Properties());
    }

    public static Properties loadProperties(String propertiesFile, Properties defaults) throws OpenEJBException {
        try {
            File pfile = new File(propertiesFile);
            FileInputStream in = new FileInputStream(pfile);
            return ServiceUtils.loadProperties(in, defaults);
        }
        catch (FileNotFoundException ex) {
            ConfigUtils.handleException("conf.0006", propertiesFile, ex.getLocalizedMessage());
        }
        catch (IOException ex) {
            ConfigUtils.handleException("conf.0007", propertiesFile, ex.getLocalizedMessage());
        }
        catch (SecurityException ex) {
            ConfigUtils.handleException("conf.0005", propertiesFile, ex.getLocalizedMessage());
        }
        return defaults;
    }

    public static Properties loadProperties(InputStream in, Properties defaults) throws OpenEJBException {
        try {
            defaults.load(in);
        }
        catch (IOException ex) {
            ConfigUtils.handleException("conf.0012", ex.getLocalizedMessage());
        }
        return defaults;
    }

    public static void handleException(String errorCode, Object arg0, Object arg1, Object arg2, Object arg3) throws OpenEJBException {
        throw new OpenEJBException(messages.format(errorCode, arg0, arg1, arg2, arg3));
    }

    public static void handleException(String errorCode, Object arg0, Object arg1, Object arg2) throws OpenEJBException {
        throw new OpenEJBException(messages.format(errorCode, arg0, arg1, arg2));
    }

    public static void handleException(String errorCode, Object arg0, Object arg1) throws OpenEJBException {
        throw new OpenEJBException(messages.format(errorCode, arg0, arg1));
    }

    public static void handleException(String errorCode, Object arg0) throws OpenEJBException {
        throw new OpenEJBException(messages.format(errorCode, arg0));
    }

    public static void handleException(String errorCode) throws OpenEJBException {
        throw new OpenEJBException(messages.message(errorCode));
    }

    public static void logWarning(String errorCode, Object arg0, Object arg1, Object arg2, Object arg3) {
        ServiceUtils._logger.i18n.warning(errorCode, arg0, arg1, arg2, arg3);
    }

    public static void logWarning(String errorCode, Object arg0, Object arg1, Object arg2) {
        ServiceUtils._logger.i18n.warning(errorCode, arg0, arg1, arg2);
    }

    public static void logWarning(String errorCode, Object arg0, Object arg1) {
        ServiceUtils._logger.i18n.warning(errorCode, arg0, arg1);
    }

    public static void logWarning(String errorCode, Object arg0) {
        ServiceUtils._logger.i18n.warning(errorCode, arg0);
    }

    public static void logWarning(String errorCode) {
        ServiceUtils._logger.i18n.warning(errorCode);
    }
}

