/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.alt.config;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.openejb.util.ClasspathUtils;
import org.openejb.util.FileUtils;
import org.openejb.util.JarUtils;

public class ValidationTable {
    private static ValidationTable table;
    private final String _createTable = "CREATE TABLE validation ( jar_path CHAR(150) PRIMARY KEY, last_validated CHAR(13), validator_version CHAR(20))";
    private final String _selectValidated = "select last_validated, validator_version  from validation where jar_path = ?";
    private final String _updateValidated = "update  validation set last_validated = (?), validator_version = ? where jar_path = ?";
    private final String _insertValidated = "insert into validation (jar_path, last_validated, validator_version) values (?,?,?)";
    private final String jdbcDriver = "org.enhydra.instantdb.jdbc.idbDriver";
    private final String jdbcUrl = "jdbc:idb:conf/registry.properties";
    private final String userName = "system";
    private final String password = "system";
    private Connection conn;
    private String version = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidationTable() {
        try {
            ClassLoader cl = ClasspathUtils.getContextClassLoader();
            Class.forName("org.enhydra.instantdb.jdbc.idbDriver", true, cl);
            this.conn = this.getConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Statement stmt = this.conn.createStatement();
            stmt.execute("CREATE TABLE validation ( jar_path CHAR(150) PRIMARY KEY, last_validated CHAR(13), validator_version CHAR(20))");
        }
        catch (Exception e) {
        }
        finally {
            try {
                this.conn.close();
            }
            catch (Exception e) {}
        }
    }

    private Connection getConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:idb:conf/registry.properties", "system", "system");
    }

    public static ValidationTable getInstance() {
        if (table == null) {
            table = new ValidationTable();
        }
        return table;
    }

    public boolean isValidated(String jarFile) {
        try {
            File jar = FileUtils.getBase().getFile(jarFile);
            long lastModified = jar.lastModified();
            long lastValidated = this.getLastValidated(jar);
            return lastValidated > lastModified;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setValidated(String jarFile) {
        this.setLastValidated(jarFile, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastValidated(File jar) {
        long validated = 0L;
        try {
            String version;
            this.conn = this.getConnection();
            String jarFileURL = jar.toURL().toExternalForm();
            PreparedStatement stmt = this.conn.prepareStatement("select last_validated, validator_version  from validation where jar_path = ?");
            stmt.setString(1, jarFileURL);
            ResultSet results = stmt.executeQuery();
            if (results.next() && ((version = results.getString(2)) == null || version.equals(this.getVersion()))) {
                validated = results.getLong(1);
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                this.conn.close();
            }
            catch (Exception e) {}
        }
        return validated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long _getLastValidated(String jarFileURL) {
        long validated = 0L;
        try {
            this.conn = this.getConnection();
            PreparedStatement stmt = this.conn.prepareStatement("select last_validated, validator_version  from validation where jar_path = ?");
            stmt.setString(1, jarFileURL);
            ResultSet results = stmt.executeQuery();
            if (results.next()) {
                validated = results.getLong(1);
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                this.conn.close();
            }
            catch (Exception e) {}
        }
        return validated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastValidated(String jarFile, long timeValidated) {
        try {
            this.conn = this.getConnection();
            File jar = FileUtils.getBase().getFile(jarFile);
            String jarFileURL = jar.toURL().toExternalForm();
            PreparedStatement stmt = null;
            if (this._getLastValidated(jarFileURL) != 0L) {
                stmt = this.conn.prepareStatement("update  validation set last_validated = (?), validator_version = ? where jar_path = ?");
                stmt.setLong(1, timeValidated);
                stmt.setString(2, this.getVersion());
                stmt.setString(3, jarFileURL);
            } else {
                stmt = this.conn.prepareStatement("insert into validation (jar_path, last_validated, validator_version) values (?,?,?)");
                stmt.setString(1, jarFileURL);
                stmt.setLong(2, timeValidated);
                stmt.setString(3, this.getVersion());
            }
            stmt.executeUpdate();
        }
        catch (Exception e) {
        }
        finally {
            try {
                this.conn.close();
            }
            catch (Exception e) {}
        }
    }

    private String getVersion() {
        if (this.version == null) {
            Properties versionInfo = new Properties();
            try {
                JarUtils.setHandlerSystemProperty();
                versionInfo.load(new URL("resource:/openejb-version.properties").openConnection().getInputStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.version = (String)versionInfo.get("version");
        }
        return this.version;
    }
}

