/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.alt.config.rules;

import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import org.openejb.OpenEJBException;
import org.openejb.alt.config.Bean;
import org.openejb.alt.config.EjbSet;
import org.openejb.alt.config.EntityBean;
import org.openejb.alt.config.SessionBean;
import org.openejb.alt.config.ValidationFailure;
import org.openejb.alt.config.ValidationRule;
import org.openejb.util.SafeToolkit;

public class CheckClasses
implements ValidationRule {
    EjbSet set;

    public void validate(EjbSet set) {
        this.set = set;
        Bean[] beans = set.getBeans();
        Bean b = null;
        try {
            for (int i = 0; i < beans.length; ++i) {
                b = beans[i];
                this.check_hasEjbClass(b);
                this.check_isEjbClass(b);
                if (b.getHome() != null) {
                    this.check_hasHomeClass(b);
                    this.check_hasRemoteClass(b);
                    this.check_isHomeInterface(b);
                    this.check_isRemoteInterface(b);
                }
                if (b.getLocalHome() == null) continue;
                this.check_hasLocalHomeClass(b);
                this.check_hasLocalClass(b);
                this.check_isLocalHomeInterface(b);
                this.check_isLocalInterface(b);
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException(b.getEjbName(), e);
        }
        SafeToolkit.unloadTempCodebase(set.getJarPath());
    }

    private void check_hasLocalClass(Bean b) {
        this.lookForClass(b, b.getLocal(), "<local>");
    }

    private void check_hasLocalHomeClass(Bean b) {
        this.lookForClass(b, b.getLocalHome(), "<local-home>");
    }

    public void check_hasEjbClass(Bean b) {
        this.lookForClass(b, b.getEjbClass(), "<ejb-class>");
    }

    public void check_hasHomeClass(Bean b) {
        this.lookForClass(b, b.getHome(), "<home>");
    }

    public void check_hasRemoteClass(Bean b) {
        this.lookForClass(b, b.getRemote(), "<remote>");
    }

    public void check_isEjbClass(Bean b) {
        if (b instanceof SessionBean) {
            this.compareTypes(b, b.getEjbClass(), javax.ejb.SessionBean.class);
        } else if (b instanceof EntityBean) {
            this.compareTypes(b, b.getEjbClass(), javax.ejb.EntityBean.class);
        }
    }

    private void check_isLocalInterface(Bean b) {
        this.compareTypes(b, b.getLocal(), EJBLocalObject.class);
    }

    private void check_isLocalHomeInterface(Bean b) {
        this.compareTypes(b, b.getLocalHome(), EJBLocalHome.class);
    }

    public void check_isHomeInterface(Bean b) {
        this.compareTypes(b, b.getHome(), EJBHome.class);
    }

    public void check_isRemoteInterface(Bean b) {
        this.compareTypes(b, b.getRemote(), EJBObject.class);
    }

    private void lookForClass(Bean b, String clazz, String type) {
        try {
            SafeToolkit.loadTempClass(clazz, this.set.getJarPath());
        }
        catch (OpenEJBException e) {
            ValidationFailure failure = new ValidationFailure("missing.class");
            failure.setDetails(clazz, type, b.getEjbName());
            failure.setBean(b);
            this.set.addFailure(failure);
        }
        catch (NoClassDefFoundError e) {
            ValidationFailure failure = new ValidationFailure("misslocated.class");
            failure.setDetails(clazz, type, b.getEjbName(), e.getMessage());
            failure.setBean(b);
            this.set.addFailure(failure);
            throw e;
        }
    }

    private void compareTypes(Bean b, String clazz1, Class class2) {
        Class class1 = null;
        try {
            class1 = SafeToolkit.loadTempClass(clazz1, this.set.getJarPath());
        }
        catch (OpenEJBException e) {
            // empty catch block
        }
        if (class1 != null && !class2.isAssignableFrom(class1)) {
            ValidationFailure failure = new ValidationFailure("wrong.class.type");
            failure.setDetails(clazz1, class2.getName());
            failure.setBean(b);
            this.set.addFailure(failure);
        }
    }
}

