/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.alt.config.rules;

import java.lang.reflect.Method;
import org.openejb.OpenEJBException;
import org.openejb.alt.config.Bean;
import org.openejb.alt.config.EjbSet;
import org.openejb.alt.config.EntityBean;
import org.openejb.alt.config.SessionBean;
import org.openejb.alt.config.ValidationFailure;
import org.openejb.alt.config.ValidationRule;
import org.openejb.alt.config.ValidationWarning;
import org.openejb.util.SafeToolkit;

public class CheckMethods
implements ValidationRule {
    EjbSet set;
    static /* synthetic */ Class class$javax$ejb$EJBLocalObject;
    static /* synthetic */ Class class$javax$ejb$EJBObject;

    public void validate(EjbSet set) {
        this.set = set;
        Bean[] beans = set.getBeans();
        for (int i = 0; i < beans.length; ++i) {
            Bean b = beans[i];
            if (b.getHome() != null) {
                this.check_remoteInterfaceMethods(b);
                this.check_homeInterfaceMethods(b);
            }
            if (b.getLocalHome() == null) continue;
            this.check_localInterfaceMethods(b);
            this.check_localHomeInterfaceMethods(b);
        }
        SafeToolkit.unloadTempCodebase(set.getJarPath());
    }

    private void check_localHomeInterfaceMethods(Bean b) {
        Class home = null;
        Class bean = null;
        try {
            home = SafeToolkit.loadTempClass(b.getLocalHome(), this.set.getJarPath());
            bean = SafeToolkit.loadTempClass(b.getEjbClass(), this.set.getJarPath());
        }
        catch (OpenEJBException e) {
            return;
        }
        if (this.check_hasCreateMethod(b, bean, home)) {
            this.check_createMethodsAreImplemented(b, bean, home);
            this.check_postCreateMethodsAreImplemented(b, bean, home);
        }
        this.check_unusedCreateMethods(b, bean, home);
    }

    private void check_localInterfaceMethods(Bean b) {
        Class intrface = null;
        Class beanClass = null;
        try {
            intrface = SafeToolkit.loadTempClass(b.getLocal(), this.set.getJarPath());
            beanClass = SafeToolkit.loadTempClass(b.getEjbClass(), this.set.getJarPath());
        }
        catch (OpenEJBException e) {
            return;
        }
        Method[] interfaceMethods = intrface.getMethods();
        Method[] beanClassMethods = intrface.getMethods();
        for (int i = 0; i < interfaceMethods.length; ++i) {
            if (interfaceMethods[i].getDeclaringClass() == (class$javax$ejb$EJBLocalObject == null ? CheckMethods.class$("javax.ejb.EJBLocalObject") : class$javax$ejb$EJBLocalObject)) continue;
            try {
                String name = interfaceMethods[i].getName();
                Class<?>[] params = interfaceMethods[i].getParameterTypes();
                Method beanMethod = beanClass.getMethod(name, params);
                continue;
            }
            catch (NoSuchMethodException nsme) {
                ValidationFailure failure = new ValidationFailure("no.busines.method");
                failure.setDetails(interfaceMethods[i].getName(), interfaceMethods[i].toString(), "local", intrface.getName(), beanClass.getName());
                failure.setBean(b);
                this.set.addFailure(failure);
            }
        }
    }

    private void check_remoteInterfaceMethods(Bean b) {
        Class intrface = null;
        Class beanClass = null;
        try {
            intrface = SafeToolkit.loadTempClass(b.getRemote(), this.set.getJarPath());
            beanClass = SafeToolkit.loadTempClass(b.getEjbClass(), this.set.getJarPath());
        }
        catch (OpenEJBException e) {
            return;
        }
        Method[] interfaceMethods = intrface.getMethods();
        Method[] beanClassMethods = intrface.getMethods();
        for (int i = 0; i < interfaceMethods.length; ++i) {
            if (interfaceMethods[i].getDeclaringClass() == (class$javax$ejb$EJBObject == null ? CheckMethods.class$("javax.ejb.EJBObject") : class$javax$ejb$EJBObject)) continue;
            try {
                String name = interfaceMethods[i].getName();
                Class<?>[] params = interfaceMethods[i].getParameterTypes();
                Method beanMethod = beanClass.getMethod(name, params);
                continue;
            }
            catch (NoSuchMethodException nsme) {
                ValidationFailure failure = new ValidationFailure("no.busines.method");
                failure.setDetails(interfaceMethods[i].getName(), interfaceMethods[i].toString(), "remote", intrface.getName(), beanClass.getName());
                failure.setBean(b);
                this.set.addFailure(failure);
            }
        }
    }

    private void check_homeInterfaceMethods(Bean b) {
        Class home = null;
        Class bean = null;
        try {
            home = SafeToolkit.loadTempClass(b.getHome(), this.set.getJarPath());
            bean = SafeToolkit.loadTempClass(b.getEjbClass(), this.set.getJarPath());
        }
        catch (OpenEJBException e) {
            return;
        }
        if (this.check_hasCreateMethod(b, bean, home)) {
            this.check_createMethodsAreImplemented(b, bean, home);
            this.check_postCreateMethodsAreImplemented(b, bean, home);
        }
        this.check_unusedCreateMethods(b, bean, home);
    }

    public boolean check_hasCreateMethod(Bean b, Class bean, Class home) {
        Method[] homeMethods = home.getMethods();
        boolean hasCreateMethod = false;
        for (int i = 0; i < homeMethods.length && !hasCreateMethod; ++i) {
            hasCreateMethod = homeMethods[i].getName().equals("create");
        }
        if (!hasCreateMethod) {
            ValidationFailure failure = new ValidationFailure("no.home.create");
            failure.setDetails(b.getHome(), b.getRemote());
            failure.setBean(b);
            this.set.addFailure(failure);
        }
        return hasCreateMethod;
    }

    public boolean check_createMethodsAreImplemented(Bean b, Class bean, Class home) {
        boolean result = true;
        Method[] homeMethods = home.getMethods();
        Method[] beanMethods = bean.getMethods();
        for (int i = 0; i < homeMethods.length; ++i) {
            if (!homeMethods[i].getName().equals("create")) continue;
            Method create = homeMethods[i];
            Method ejbCreate = null;
            try {
                ejbCreate = bean.getMethod("ejbCreate", create.getParameterTypes());
                continue;
            }
            catch (NoSuchMethodException e) {
                result = false;
                String paramString = this.getParameters(create);
                if (b instanceof EntityBean) {
                    EntityBean entity = (EntityBean)b;
                    ValidationFailure failure = new ValidationFailure("entity.no.ejb.create");
                    failure.setDetails(b.getEjbClass(), entity.getPrimaryKey(), paramString);
                    failure.setBean(b);
                    this.set.addFailure(failure);
                    continue;
                }
                ValidationFailure failure = new ValidationFailure("session.no.ejb.create");
                failure.setDetails(b.getEjbClass(), paramString);
                failure.setBean(b);
                this.set.addFailure(failure);
            }
        }
        return result;
    }

    public boolean check_postCreateMethodsAreImplemented(Bean b, Class bean, Class home) {
        boolean result = true;
        if (b instanceof SessionBean) {
            return true;
        }
        Method[] homeMethods = home.getMethods();
        Method[] beanMethods = bean.getMethods();
        for (int i = 0; i < homeMethods.length; ++i) {
            if (!homeMethods[i].getName().equals("create")) continue;
            Method create = homeMethods[i];
            Method ejbCreate = null;
            try {
                ejbCreate = bean.getMethod("ejbPostCreate", create.getParameterTypes());
                continue;
            }
            catch (NoSuchMethodException e) {
                result = false;
                String paramString = this.getParameters(create);
                ValidationFailure failure = new ValidationFailure("no.ejb.post.create");
                failure.setDetails(b.getEjbClass(), paramString);
                failure.setBean(b);
                this.set.addFailure(failure);
            }
        }
        return result;
    }

    public boolean check_unusedCreateMethods(Bean b, Class bean, Class home) {
        boolean result = true;
        Method[] homeMethods = home.getMethods();
        Method[] beanMethods = bean.getMethods();
        for (int i = 0; i < homeMethods.length; ++i) {
            if (!beanMethods[i].getName().equals("ejbCreate")) continue;
            Method ejbCreate = beanMethods[i];
            Method create = null;
            try {
                create = home.getMethod("create", ejbCreate.getParameterTypes());
                continue;
            }
            catch (NoSuchMethodException e) {
                result = false;
                String paramString = this.getParameters(ejbCreate);
                ValidationWarning warning = new ValidationWarning("unused.ejb.create");
                warning.setDetails(b.getEjbClass(), paramString, home.getName());
                warning.setBean(b);
                this.set.addWarning(warning);
            }
        }
        return result;
    }

    private String getParameters(Method method) {
        Class<?>[] params = method.getParameterTypes();
        String paramString = "";
        if (params.length > 0) {
            paramString = params[0].getName();
        }
        for (int i = 1; i < params.length; ++i) {
            paramString = paramString + ", " + params[i];
        }
        return paramString;
    }
}

