/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.alt.containers.castor_cmp11;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ejb.EntityBean;
import org.exolab.castor.persist.spi.Complex;
import org.openejb.OpenEJBException;
import org.openejb.alt.containers.castor_cmp11.KeyGenerator;
import org.openejb.core.DeploymentInfo;
import org.openejb.util.Logger;

public abstract class KeyGeneratorFactory {
    protected static final Logger logger = Logger.getInstance("CastorCMP", "org.openejb.alt.util.resources");

    public static KeyGenerator createKeyGenerator(DeploymentInfo di) throws OpenEJBException {
        if (di.getPrimaryKeyField() != null) {
            return new PrimitiveKey(di);
        }
        return new ComplexKey(di);
    }

    private static class ComplexKey
    implements KeyGenerator {
        private final Class pkClass;
        private final Object[] cmFields;
        private final HashMap pkFieldMap;
        private final HashMap beanFieldMap;

        ComplexKey(DeploymentInfo di) throws OpenEJBException {
            this.pkClass = di.getPrimaryKeyClass();
            Class beanClass = di.getBeanClass();
            ArrayList<String> v = new ArrayList<String>();
            Field[] fields = this.pkClass.getFields();
            this.pkFieldMap = new HashMap();
            this.beanFieldMap = new HashMap();
            for (int i = 0; i < fields.length; ++i) {
                String fieldName = fields[i].getName();
                try {
                    this.beanFieldMap.put(fieldName, beanClass.getField(fieldName));
                    this.pkFieldMap.put(fieldName, fields[i]);
                    v.add(fieldName);
                    continue;
                }
                catch (NoSuchFieldException e) {
                    // empty catch block
                }
            }
            this.cmFields = new Object[v.size()];
            v.toArray(this.cmFields);
        }

        public Object getPrimaryKey(EntityBean bean) {
            try {
                Object pk = this.pkClass.newInstance();
                for (int i = 0; i < this.cmFields.length; ++i) {
                    Object fieldName = this.cmFields[i];
                    Object value = ((Field)this.beanFieldMap.get(fieldName)).get(bean);
                    ((Field)this.pkFieldMap.get(fieldName)).set(pk, value);
                }
                return pk;
            }
            catch (Exception e) {
                logger.error("getPrimaryKey() received exception " + e, e);
                throw new IllegalStateException();
            }
        }

        public Complex getJdoComplex(Object primaryKey) {
            int len = this.cmFields.length;
            Object[] args = new Object[len];
            try {
                for (int i = 0; i < len; ++i) {
                    args[i] = ((Field)this.pkFieldMap.get(this.cmFields[i])).get(primaryKey);
                }
                return new Complex(len, args);
            }
            catch (Exception e) {
                logger.error("getJdoComplex() received exception " + e, e);
                throw new IllegalStateException();
            }
        }

        public boolean isKeyComplex() {
            return true;
        }
    }

    private static class PrimitiveKey
    implements KeyGenerator {
        private final Field field;

        PrimitiveKey(DeploymentInfo di) throws OpenEJBException {
            this.field = di.getPrimaryKeyField();
        }

        public Object getPrimaryKey(EntityBean bean) {
            try {
                return this.field.get(bean);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalStateException("Don't have access to field " + this.field + ": received " + e);
            }
        }

        public Complex getJdoComplex(Object primaryKey) {
            throw new IllegalStateException("This method must not be called on primitive primary keys");
        }

        public boolean isKeyComplex() {
            return false;
        }
    }
}

