/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.client;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.openejb.client.Connection;
import org.openejb.client.ConnectionFactory;
import org.openejb.client.ServerMetaData;
import org.openejb.client.SocketConnectionFactory;

public class ConnectionManager {
    private static ConnectionFactory factory;
    private static Class defaultFactoryClass;
    private static String factoryName;

    public static Connection getConnection(ServerMetaData server) throws IOException {
        return factory.getConnection(server);
    }

    public static void setFactory(String factoryName) throws IOException {
        ConnectionManager.installFactory(factoryName);
    }

    public static ConnectionFactory getFactory() {
        return factory;
    }

    public static String getFactoryName() {
        return factoryName;
    }

    private static void installFactory(String factoryName) throws IOException {
        Class<?> factoryClass = null;
        ConnectionFactory factory = null;
        try {
            ClassLoader cl = ConnectionManager.getContextClassLoader();
            factoryClass = Class.forName(factoryName, true, cl);
        }
        catch (Exception e) {
            throw new IOException("No ConnectionFactory Can be installed. Unable to load the class " + factoryName);
        }
        try {
            factory = (ConnectionFactory)factoryClass.newInstance();
        }
        catch (Exception e) {
            throw new IOException("No ConnectionFactory Can be installed. Unable to instantiate the class " + factoryName);
        }
        try {
            factory.init(new Properties());
        }
        catch (Exception e) {
            throw new IOException("No ConnectionFactory Can be installed. Unable to initialize the class " + factoryName);
        }
        ConnectionManager.factory = factory;
        ConnectionManager.factoryName = factoryName;
    }

    public static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static {
        defaultFactoryClass = SocketConnectionFactory.class;
        try {
            ConnectionManager.installFactory(defaultFactoryClass.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

