/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import javax.ejb.HomeHandle;
import org.openejb.client.ClientMetaData;
import org.openejb.client.EJBHomeHandler;
import org.openejb.client.EJBHomeProxy;
import org.openejb.client.EJBMetaDataImpl;
import org.openejb.client.ServerMetaData;

public class EJBHomeHandle
implements Externalizable,
HomeHandle {
    protected transient EJBHomeProxy ejbHomeProxy;
    protected transient EJBHomeHandler handler;

    public EJBHomeHandle() {
    }

    public EJBHomeHandle(EJBHomeProxy proxy) {
        this.ejbHomeProxy = proxy;
        this.handler = this.ejbHomeProxy.getEJBHomeHandler();
    }

    protected void setEJBHomeProxy(EJBHomeProxy ejbHomeProxy) {
        this.ejbHomeProxy = ejbHomeProxy;
        this.handler = ejbHomeProxy.getEJBHomeHandler();
    }

    public EJBHome getEJBHome() throws RemoteException {
        return this.ejbHomeProxy;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.handler.client.writeExternal(out);
        EJBMetaDataImpl ejb = this.handler.ejb;
        out.writeObject(ejb.homeClass);
        out.writeObject(ejb.remoteClass);
        out.writeObject(ejb.keyClass);
        out.writeByte(ejb.type);
        out.writeUTF(ejb.deploymentID);
        out.writeShort(ejb.deploymentCode);
        this.handler.server.writeExternal(out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        ClientMetaData client = new ClientMetaData();
        EJBMetaDataImpl ejb = new EJBMetaDataImpl();
        ServerMetaData server = new ServerMetaData();
        client.readExternal(in);
        ejb.homeClass = (Class)in.readObject();
        ejb.remoteClass = (Class)in.readObject();
        ejb.keyClass = (Class)in.readObject();
        ejb.type = in.readByte();
        ejb.deploymentID = in.readUTF();
        ejb.deploymentCode = in.readShort();
        server.readExternal(in);
        this.handler = EJBHomeHandler.createEJBHomeHandler(ejb, server, client);
        this.ejbHomeProxy = this.handler.createEJBHomeProxy();
    }
}

