/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import javax.ejb.Handle;
import org.openejb.SystemException;
import org.openejb.client.ClientMetaData;
import org.openejb.client.EJBHomeHandle;
import org.openejb.client.EJBHomeProxy;
import org.openejb.client.EJBHomeProxyHandle;
import org.openejb.client.EJBInvocationHandler;
import org.openejb.client.EJBMetaDataImpl;
import org.openejb.client.EJBObjectHandler;
import org.openejb.client.EJBRequest;
import org.openejb.client.EJBResponse;
import org.openejb.client.EntityEJBHomeHandler;
import org.openejb.client.ServerMetaData;
import org.openejb.client.StatefulEJBHomeHandler;
import org.openejb.client.StatelessEJBHomeHandler;
import org.openejb.client.proxy.InvocationHandler;
import org.openejb.client.proxy.ProxyManager;

public abstract class EJBHomeHandler
extends EJBInvocationHandler
implements Externalizable {
    protected static final Method GETEJBMETADATA = EJBHomeHandler.getMethod(EJBHome.class, "getEJBMetaData", null);
    protected static final Method GETHOMEHANDLE = EJBHomeHandler.getMethod(EJBHome.class, "getHomeHandle", null);
    protected static final Method REMOVE_W_KEY = EJBHomeHandler.getMethod(EJBHome.class, "remove", new Class[]{Object.class});
    protected static final Method REMOVE_W_HAND = EJBHomeHandler.getMethod(EJBHome.class, "remove", new Class[]{Handle.class});
    protected static final Method GETHANDLER = EJBHomeHandler.getMethod(EJBHomeProxy.class, "getEJBHomeHandler", null);

    public EJBHomeHandler() {
    }

    public EJBHomeHandler(EJBMetaDataImpl ejb, ServerMetaData server, ClientMetaData client) {
        super(ejb, server, client);
    }

    public static EJBHomeHandler createEJBHomeHandler(EJBMetaDataImpl ejb, ServerMetaData server, ClientMetaData client) {
        switch (ejb.type) {
            case 8: 
            case 9: {
                return new EntityEJBHomeHandler(ejb, server, client);
            }
            case 6: {
                return new StatefulEJBHomeHandler(ejb, server, client);
            }
            case 7: {
                return new StatelessEJBHomeHandler(ejb, server, client);
            }
        }
        return null;
    }

    public EJBHomeProxy createEJBHomeProxy() {
        try {
            Class[] interfaces = new Class[]{EJBHomeProxy.class, this.ejb.homeClass};
            return (EJBHomeProxy)ProxyManager.newProxyInstance(interfaces, (InvocationHandler)this);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Object _invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        try {
            if (method.getDeclaringClass() == Object.class) {
                if (method.equals(TOSTRING)) {
                    return "proxy=" + this;
                }
                if (method.equals(EQUALS)) {
                    return Boolean.FALSE;
                }
                if (method.equals(HASHCODE)) {
                    return new Integer(this.hashCode());
                }
                throw new UnsupportedOperationException("Unkown method: " + method);
            }
            if (method.getDeclaringClass() == EJBHomeProxy.class) {
                if (method.equals(GETHANDLER)) {
                    return this;
                }
                if (methodName.equals("writeReplace")) {
                    return new EJBHomeProxyHandle(this);
                }
                if (methodName.equals("readResolve")) {
                    throw new UnsupportedOperationException("Unkown method: " + method);
                }
                throw new UnsupportedOperationException("Unkown method: " + method);
            }
            if (methodName.equals("create")) {
                return this.create(method, args, proxy);
            }
            if (methodName.startsWith("find")) {
                return this.findX(method, args, proxy);
            }
            if (method.equals(GETEJBMETADATA)) {
                return this.getEJBMetaData(method, args, proxy);
            }
            if (method.equals(GETHOMEHANDLE)) {
                return this.getHomeHandle(method, args, proxy);
            }
            if (method.equals(REMOVE_W_HAND)) {
                return this.removeWithHandle(method, args, proxy);
            }
            if (method.equals(REMOVE_W_KEY)) {
                return this.removeByPrimaryKey(method, args, proxy);
            }
            throw new UnsupportedOperationException("Unkown method: " + method);
        }
        catch (SystemException se) {
            this.invalidateReference();
            throw new RemoteException("Container has suffered a SystemException", se.getRootCause());
        }
    }

    protected Object create(Method method, Object[] args, Object proxy) throws Throwable {
        EJBRequest req = new EJBRequest(10);
        req.setClientIdentity(this.client.getClientIdentity());
        req.setDeploymentCode(this.ejb.deploymentCode);
        req.setDeploymentId(this.ejb.deploymentID);
        req.setMethodInstance(method);
        req.setMethodParameters(args);
        EJBResponse res = this.request(req);
        switch (res.getResponseCode()) {
            case 10: {
                throw (Throwable)res.getResult();
            }
            case 9: {
                throw (Throwable)res.getResult();
            }
            case 11: {
                throw (Throwable)res.getResult();
            }
            case 4: {
                Object primKey = res.getResult();
                EJBObjectHandler handler = EJBObjectHandler.createEJBObjectHandler(this.ejb, this.server, this.client, primKey);
                handler.setEJBHomeProxy((EJBHomeProxy)proxy);
                return handler.createEJBObjectProxy();
            }
        }
        throw new RemoteException("Received invalid response code from server: " + res.getResponseCode());
    }

    protected abstract Object findX(Method var1, Object[] var2, Object var3) throws Throwable;

    protected Object getEJBMetaData(Method method, Object[] args, Object proxy) throws Throwable {
        return this.ejb;
    }

    protected Object getHomeHandle(Method method, Object[] args, Object proxy) throws Throwable {
        return new EJBHomeHandle((EJBHomeProxy)proxy);
    }

    protected abstract Object removeWithHandle(Method var1, Object[] var2, Object var3) throws Throwable;

    protected abstract Object removeByPrimaryKey(Method var1, Object[] var2, Object var3) throws Throwable;

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }
}

