/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import org.openejb.client.ClientMetaData;
import org.openejb.client.EJBHomeHandler;
import org.openejb.client.EJBMetaDataImpl;
import org.openejb.client.ServerMetaData;

public class EJBHomeProxyHandle
implements Externalizable {
    EJBHomeHandler handler;

    public EJBHomeProxyHandle() {
    }

    public EJBHomeProxyHandle(EJBHomeHandler handler) {
        this.handler = handler;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.handler.client.writeExternal(out);
        EJBMetaDataImpl ejb = this.handler.ejb;
        out.writeObject(ejb.homeClass);
        out.writeObject(ejb.remoteClass);
        out.writeObject(ejb.keyClass);
        out.writeByte(ejb.type);
        out.writeUTF(ejb.deploymentID);
        out.writeShort(ejb.deploymentCode);
        this.handler.server.writeExternal(out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        ClientMetaData client = new ClientMetaData();
        EJBMetaDataImpl ejb = new EJBMetaDataImpl();
        ServerMetaData server = new ServerMetaData();
        client.readExternal(in);
        ejb.homeClass = (Class)in.readObject();
        ejb.remoteClass = (Class)in.readObject();
        ejb.keyClass = (Class)in.readObject();
        ejb.type = in.readByte();
        ejb.deploymentID = in.readUTF();
        ejb.deploymentCode = in.readShort();
        server.readExternal(in);
        this.handler = EJBHomeHandler.createEJBHomeHandler(ejb, server, client);
        this.handler.ejb.ejbHomeProxy = this.handler.createEJBHomeProxy();
    }

    private Object readResolve() throws ObjectStreamException {
        return this.handler.ejb.ejbHomeProxy;
    }
}

