/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import org.openejb.client.EJBHomeProxy;

public class EJBMetaDataImpl
implements EJBMetaData,
Externalizable {
    public static final byte STATEFUL = 6;
    public static final byte STATELESS = 7;
    public static final byte BMP_ENTITY = 8;
    public static final byte CMP_ENTITY = 9;
    protected transient byte type;
    protected transient String deploymentID;
    protected transient int deploymentCode;
    protected transient Class homeClass;
    protected transient Class remoteClass;
    protected transient Class keyClass;
    protected transient EJBHomeProxy ejbHomeProxy;

    public EJBMetaDataImpl() {
    }

    public EJBMetaDataImpl(Class homeInterface, Class remoteInterface, byte typeOfBean) {
        this.type = typeOfBean;
        this.homeClass = homeInterface;
        this.remoteClass = remoteInterface;
    }

    public EJBMetaDataImpl(Class homeInterface, Class remoteInterface, Class primaryKeyClass, byte typeOfBean) {
        this(homeInterface, remoteInterface, typeOfBean);
        if (this.type == 9 || this.type == 8) {
            this.keyClass = primaryKeyClass;
        }
    }

    public EJBMetaDataImpl(Class homeInterface, Class remoteInterface, Class primaryKeyClass, byte typeOfBean, String deploymentID) {
        this(homeInterface, remoteInterface, primaryKeyClass, typeOfBean);
        this.deploymentID = deploymentID;
    }

    public EJBMetaDataImpl(Class homeInterface, Class remoteInterface, Class primaryKeyClass, byte typeOfBean, String deploymentID, int deploymentCode) {
        this(homeInterface, remoteInterface, primaryKeyClass, typeOfBean, deploymentID);
        this.deploymentCode = deploymentCode;
    }

    public Class getPrimaryKeyClass() {
        if (this.type != 8 && this.type != 9) {
            throw new UnsupportedOperationException();
        }
        return this.keyClass;
    }

    public EJBHome getEJBHome() {
        return this.ejbHomeProxy;
    }

    public Class getHomeInterfaceClass() {
        return this.homeClass;
    }

    public boolean isStatelessSession() {
        return this.type == 7;
    }

    public Class getRemoteInterfaceClass() {
        return this.remoteClass;
    }

    public boolean isSession() {
        return this.type == 6 || this.type == 7;
    }

    protected void setEJBHomeProxy(EJBHomeProxy home) {
        this.ejbHomeProxy = home;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.homeClass);
        out.writeObject(this.remoteClass);
        out.writeObject(this.keyClass);
        out.writeObject(this.ejbHomeProxy);
        out.writeByte(this.type);
        out.writeUTF(this.deploymentID);
        out.writeShort((short)this.deploymentCode);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.homeClass = (Class)in.readObject();
        this.remoteClass = (Class)in.readObject();
        this.keyClass = (Class)in.readObject();
        this.ejbHomeProxy = (EJBHomeProxy)in.readObject();
        this.type = in.readByte();
        this.deploymentID = in.readUTF();
        this.deploymentCode = in.readShort();
    }
}

