/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.client;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.ejb.EJBObject;
import org.openejb.ApplicationException;
import org.openejb.InvalidateReferenceException;
import org.openejb.OpenEJBException;
import org.openejb.SystemException;
import org.openejb.client.ClientMetaData;
import org.openejb.client.EJBHomeHandler;
import org.openejb.client.EJBHomeProxy;
import org.openejb.client.EJBInvocationHandler;
import org.openejb.client.EJBMetaDataImpl;
import org.openejb.client.EJBObjectHandle;
import org.openejb.client.EJBObjectProxy;
import org.openejb.client.EJBObjectProxyHandle;
import org.openejb.client.EJBRequest;
import org.openejb.client.EJBResponse;
import org.openejb.client.EntityEJBObjectHandler;
import org.openejb.client.ServerMetaData;
import org.openejb.client.StatefulEJBObjectHandler;
import org.openejb.client.StatelessEJBObjectHandler;
import org.openejb.client.proxy.InvocationHandler;
import org.openejb.client.proxy.ProxyManager;

public abstract class EJBObjectHandler
extends EJBInvocationHandler {
    protected static final Method GETEJBHOME = EJBObjectHandler.getMethod(EJBObject.class, "getEJBHome", null);
    protected static final Method GETHANDLE = EJBObjectHandler.getMethod(EJBObject.class, "getHandle", null);
    protected static final Method GETPRIMARYKEY = EJBObjectHandler.getMethod(EJBObject.class, "getPrimaryKey", null);
    protected static final Method ISIDENTICAL = EJBObjectHandler.getMethod(EJBObject.class, "isIdentical", new Class[]{EJBObject.class});
    protected static final Method REMOVE = EJBObjectHandler.getMethod(EJBObject.class, "remove", null);
    protected static final Method GETHANDLER = EJBObjectHandler.getMethod(EJBObjectProxy.class, "getEJBObjectHandler", null);
    public Object registryId;
    EJBHomeProxy ejbHome = null;

    public EJBObjectHandler() {
    }

    public EJBObjectHandler(EJBMetaDataImpl ejb, ServerMetaData server, ClientMetaData client) {
        super(ejb, server, client);
    }

    public EJBObjectHandler(EJBMetaDataImpl ejb, ServerMetaData server, ClientMetaData client, Object primaryKey) {
        super(ejb, server, client, primaryKey);
    }

    protected void setEJBHomeProxy(EJBHomeProxy ejbHome) {
        this.ejbHome = ejbHome;
    }

    public static EJBObjectHandler createEJBObjectHandler(EJBMetaDataImpl ejb, ServerMetaData server, ClientMetaData client, Object primaryKey) {
        switch (ejb.type) {
            case 8: 
            case 9: {
                return new EntityEJBObjectHandler(ejb, server, client, primaryKey);
            }
            case 6: {
                return new StatefulEJBObjectHandler(ejb, server, client, primaryKey);
            }
            case 7: {
                return new StatelessEJBObjectHandler(ejb, server, client, primaryKey);
            }
        }
        return null;
    }

    public abstract Object getRegistryId();

    public EJBObjectProxy createEJBObjectProxy() {
        EJBObjectProxy ejbObject = null;
        try {
            Class[] interfaces = new Class[]{EJBObjectProxy.class, this.ejb.remoteClass};
            ejbObject = (EJBObjectProxy)ProxyManager.newProxyInstance(interfaces, (InvocationHandler)this);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return ejbObject;
    }

    public synchronized Object _invoke(Object p, Method m, Object[] a) throws Throwable {
        Object retValue;
        block20: {
            retValue = null;
            try {
                String methodName = m.getName();
                if (m.getDeclaringClass() == Object.class) {
                    if (m.equals(TOSTRING)) {
                        return "proxy=" + this;
                    }
                    if (m.equals(EQUALS)) {
                        return Boolean.FALSE;
                    }
                    if (m.equals(HASHCODE)) {
                        return new Integer(this.hashCode());
                    }
                    throw new UnsupportedOperationException("Unkown method: " + m);
                }
                if (m.getDeclaringClass() == EJBObjectProxy.class) {
                    if (m.equals(GETHANDLER)) {
                        return this;
                    }
                    if (methodName.equals("writeReplace")) {
                        return new EJBObjectProxyHandle(this);
                    }
                    if (!methodName.equals("readResolve")) {
                        throw new UnsupportedOperationException("Unkown method: " + m);
                    }
                    break block20;
                }
                if (m.getDeclaringClass() == EJBObject.class) {
                    if (m.equals(GETHANDLE)) {
                        retValue = this.getHandle(m, a, p);
                        break block20;
                    }
                    if (m.equals(GETPRIMARYKEY)) {
                        retValue = this.getPrimaryKey(m, a, p);
                        break block20;
                    }
                    if (m.equals(ISIDENTICAL)) {
                        retValue = this.isIdentical(m, a, p);
                        break block20;
                    }
                    if (m.equals(GETEJBHOME)) {
                        retValue = this.getEJBHome(m, a, p);
                        break block20;
                    }
                    if (m.equals(REMOVE)) {
                        retValue = this.remove(m, a, p);
                        break block20;
                    }
                    throw new UnsupportedOperationException("Unkown method: " + m);
                }
                if (m.getDeclaringClass() == this.ejb.remoteClass) {
                    retValue = this.businessMethod(m, a, p);
                    break block20;
                }
                throw new UnsupportedOperationException("Unkown method: " + m);
            }
            catch (InvalidateReferenceException ire) {
                EJBObjectHandler.invalidateAllHandlers(this.getRegistryId());
                return ire.getRootCause();
            }
            catch (ApplicationException ae) {
                throw ae.getRootCause();
            }
            catch (SystemException se) {
                this.invalidateReference();
                throw new RemoteException("Container has suffered a SystemException", se.getRootCause());
            }
            catch (OpenEJBException oe) {
                throw new RemoteException("Unknown Container Exception", oe.getRootCause());
            }
        }
        return retValue;
    }

    protected Object getEJBHome(Method method, Object[] args, Object proxy) throws Throwable {
        if (this.ejbHome == null) {
            this.ejbHome = EJBHomeHandler.createEJBHomeHandler(this.ejb, this.server, this.client).createEJBHomeProxy();
        }
        return this.ejbHome;
    }

    protected Object getHandle(Method method, Object[] args, Object proxy) throws Throwable {
        return new EJBObjectHandle((EJBObjectProxy)proxy);
    }

    protected abstract Object getPrimaryKey(Method var1, Object[] var2, Object var3) throws Throwable;

    protected abstract Object isIdentical(Method var1, Object[] var2, Object var3) throws Throwable;

    protected abstract Object remove(Method var1, Object[] var2, Object var3) throws Throwable;

    protected Object businessMethod(Method method, Object[] args, Object proxy) throws Throwable {
        EJBRequest req = new EJBRequest(23);
        req.setMethodParameters(args);
        req.setMethodInstance(method);
        req.setClientIdentity(this.client.getClientIdentity());
        req.setDeploymentCode(this.ejb.deploymentCode);
        req.setDeploymentId(this.ejb.deploymentID);
        req.setPrimaryKey(this.primaryKey);
        EJBResponse res = this.request(req);
        switch (res.getResponseCode()) {
            case 11: {
                throw (Throwable)res.getResult();
            }
            case 10: {
                throw (Throwable)res.getResult();
            }
            case 9: {
                throw (Throwable)res.getResult();
            }
            case 4: {
                return res.getResult();
            }
        }
        throw new RemoteException("Received invalid response code from server: " + res.getResponseCode());
    }
}

