/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.client;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import org.openejb.client.Request;

public class EJBRequest
implements Request {
    private transient int requestMethod;
    private transient int deploymentCode = 0;
    private transient Object clientIdentity;
    private transient Method methodInstance;
    private transient Class methodClass;
    private transient String methodName;
    private transient Class[] methodParamTypes;
    private transient Object[] methodParameters;
    private transient String deploymentId;
    private transient Object primaryKey;
    public static final int SESSION_BEAN_STATELESS = 6;
    public static final int SESSION_BEAN_STATEFUL = 7;
    public static final int ENTITY_BM_PERSISTENCE = 8;
    public static final int ENTITY_CM_PERSISTENCE = 9;
    static final Class[] noArgsC = new Class[0];
    static final Object[] noArgsO = new Object[0];
    private static final int I = 0;
    private static final int B = 1;
    private static final int J = 2;
    private static final int F = 3;
    private static final int D = 4;
    private static final int S = 5;
    private static final int C = 6;
    private static final int Z = 7;
    private static final int L = 8;
    private static final int A = 9;

    public EJBRequest() {
    }

    public EJBRequest(int requestMethod) {
        this.requestMethod = requestMethod;
    }

    public byte getRequestType() {
        return 0;
    }

    public int getRequestMethod() {
        return this.requestMethod;
    }

    public Object getClientIdentity() {
        return this.clientIdentity;
    }

    public Method getMethodInstance() {
        return this.methodInstance;
    }

    public Object[] getMethodParameters() {
        return this.methodParameters;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public int getDeploymentCode() {
        return this.deploymentCode;
    }

    public Object getPrimaryKey() {
        return this.primaryKey;
    }

    public Class getMethodClass() {
        return this.methodClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class[] getMethodParamTypes() {
        return this.methodParamTypes;
    }

    public void setRequestMethod(int requestMethod) {
        this.requestMethod = requestMethod;
    }

    public void setClientIdentity(Object clientIdentity) {
        this.clientIdentity = clientIdentity;
    }

    public void setMethodInstance(Method methodInstance) {
        this.methodInstance = methodInstance;
        this.methodClass = methodInstance.getDeclaringClass();
        this.methodName = methodInstance.getName();
        this.methodParamTypes = methodInstance.getParameterTypes();
    }

    public void setMethodParameters(Object[] methodParameters) {
        this.methodParameters = methodParameters;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public void setDeploymentCode(int deploymentCode) {
        this.deploymentCode = deploymentCode;
    }

    public void setPrimaryKey(Object primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String toString() {
        StringBuffer s = null;
        switch (this.requestMethod) {
            case 1: {
                s = new StringBuffer("EJB_HOME.GET_EJB_META_DATA");
                break;
            }
            case 2: {
                s = new StringBuffer("EJB_HOME.GET_HOME_HANDLE");
                break;
            }
            case 3: {
                s = new StringBuffer("EJB_HOME.REMOVE_BY_HANDLE");
                break;
            }
            case 4: {
                s = new StringBuffer("EJB_HOME.REMOVE_BY_PKEY");
                break;
            }
            case 9: {
                s = new StringBuffer("EJB_HOME.FIND");
                break;
            }
            case 10: {
                s = new StringBuffer("EJB_HOME.CREATE");
                break;
            }
            case 14: {
                s = new StringBuffer("EJB_OBJECT.GET_EJB_HOME");
                break;
            }
            case 15: {
                s = new StringBuffer("EJB_OBJECT.GET_HANDLE");
                break;
            }
            case 16: {
                s = new StringBuffer("EJB_OBJECT.GET_PRIMARY_KEY");
                break;
            }
            case 17: {
                s = new StringBuffer("EJB_OBJECT.IS_IDENTICAL");
                break;
            }
            case 18: {
                s = new StringBuffer("EJB_OBJECT.REMOVE");
                break;
            }
            case 23: {
                s = new StringBuffer("EJB_OBJECT.BUSINESS_METHOD");
            }
        }
        s.append(':').append(this.methodName);
        s.append(':').append(this.deploymentId);
        s.append(':').append(this.primaryKey);
        return s.toString();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        ClassNotFoundException result;
        block11: {
            block10: {
                result = null;
                this.requestMethod = -1;
                this.deploymentId = null;
                this.deploymentCode = -1;
                this.clientIdentity = null;
                this.primaryKey = null;
                this.methodClass = null;
                this.methodName = null;
                this.methodInstance = null;
                this.requestMethod = in.readByte();
                try {
                    this.deploymentId = (String)in.readObject();
                }
                catch (ClassNotFoundException cnfe) {
                    result = cnfe;
                }
                this.deploymentCode = in.readShort();
                try {
                    this.clientIdentity = in.readObject();
                    this.primaryKey = in.readObject();
                    this.methodClass = (Class)in.readObject();
                }
                catch (ClassNotFoundException cnfe) {
                    if (result != null) break block10;
                    result = cnfe;
                }
            }
            this.methodName = in.readUTF();
            try {
                this.readMethodParameters(in);
            }
            catch (ClassNotFoundException cnfe) {
                if (result != null) break block11;
                result = cnfe;
            }
        }
        if (this.methodClass != null) {
            try {
                this.methodInstance = this.methodClass.getDeclaredMethod(this.methodName, this.methodParamTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (result != null) {
            throw result;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.requestMethod);
        if (this.deploymentCode > 0) {
            out.writeObject(null);
        } else {
            out.writeObject(this.deploymentId);
        }
        out.writeShort(this.deploymentCode);
        out.writeObject(this.clientIdentity);
        out.writeObject(this.primaryKey);
        out.writeObject(this.methodClass);
        out.writeUTF(this.methodName);
        this.writeMethodParameters(out, this.methodParamTypes, this.methodParameters);
    }

    protected void writeMethodParameters(ObjectOutput out, Class[] types, Object[] args) throws IOException {
        out.writeByte(types.length);
        for (int i = 0; i < types.length; ++i) {
            Class type = types[i];
            Object obj = args[i];
            if (type.isPrimitive()) {
                if (type == Byte.TYPE) {
                    out.write(1);
                    byte bytevalue = (Byte)obj;
                    out.writeByte(bytevalue);
                    continue;
                }
                if (type == Character.TYPE) {
                    out.write(6);
                    char charvalue = ((Character)obj).charValue();
                    out.writeChar(charvalue);
                    continue;
                }
                if (type == Integer.TYPE) {
                    out.write(0);
                    int intvalue = (Integer)obj;
                    out.writeInt(intvalue);
                    continue;
                }
                if (type == Boolean.TYPE) {
                    out.write(7);
                    boolean booleanvalue = (Boolean)obj;
                    out.writeBoolean(booleanvalue);
                    continue;
                }
                if (type == Long.TYPE) {
                    out.write(2);
                    long longvalue = (Long)obj;
                    out.writeLong(longvalue);
                    continue;
                }
                if (type == Float.TYPE) {
                    out.write(3);
                    float fvalue = ((Float)obj).floatValue();
                    out.writeFloat(fvalue);
                    continue;
                }
                if (type == Double.TYPE) {
                    out.write(4);
                    double dvalue = (Double)obj;
                    out.writeDouble(dvalue);
                    continue;
                }
                if (type == Short.TYPE) {
                    out.write(5);
                    short shortvalue = (Short)obj;
                    out.writeShort(shortvalue);
                    continue;
                }
                throw new IOException("Unkown primitive type: " + type);
            }
            out.write(8);
            out.writeObject(type);
            out.writeObject(obj);
        }
    }

    protected void readMethodParameters(ObjectInput in) throws IOException, ClassNotFoundException {
        int length = in.read();
        if (length < 1) {
            this.methodParamTypes = noArgsC;
            this.methodParameters = noArgsO;
            return;
        }
        Class[] types = new Class[length];
        Object[] args = new Object[length];
        for (int i = 0; i < types.length; ++i) {
            Class clazz = null;
            Object obj = null;
            int type = in.read();
            switch (type) {
                case 1: {
                    clazz = Byte.TYPE;
                    obj = new Byte(in.readByte());
                    break;
                }
                case 6: {
                    clazz = Character.TYPE;
                    obj = new Character(in.readChar());
                    break;
                }
                case 0: {
                    clazz = Integer.TYPE;
                    obj = new Integer(in.readInt());
                    break;
                }
                case 7: {
                    clazz = Boolean.TYPE;
                    obj = new Boolean(in.readBoolean());
                    break;
                }
                case 2: {
                    clazz = Long.TYPE;
                    obj = new Long(in.readLong());
                    break;
                }
                case 3: {
                    clazz = Float.TYPE;
                    obj = new Float(in.readFloat());
                    break;
                }
                case 4: {
                    clazz = Double.TYPE;
                    obj = new Double(in.readDouble());
                    break;
                }
                case 5: {
                    clazz = Short.TYPE;
                    obj = new Short(in.readShort());
                    break;
                }
                case 8: {
                    clazz = (Class)in.readObject();
                    obj = in.readObject();
                    break;
                }
                default: {
                    throw new IOException("Unkown data type: " + type);
                }
            }
            types[i] = clazz;
            args[i] = obj;
        }
        this.methodParamTypes = types;
        this.methodParameters = args;
    }
}

