/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.client;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.InitialContextFactory;
import org.openejb.client.AuthenticationRequest;
import org.openejb.client.AuthenticationResponse;
import org.openejb.client.Client;
import org.openejb.client.ClientMetaData;
import org.openejb.client.EJBHomeHandler;
import org.openejb.client.EJBHomeProxy;
import org.openejb.client.EJBMetaDataImpl;
import org.openejb.client.JNDIRequest;
import org.openejb.client.JNDIResponse;
import org.openejb.client.RequestMethods;
import org.openejb.client.ResponseCodes;
import org.openejb.client.ServerMetaData;

public class JNDIContext
implements Serializable,
InitialContextFactory,
Context,
RequestMethods,
ResponseCodes {
    private transient String tail = "/";
    private transient ServerMetaData server;
    private transient ClientMetaData client;
    private transient Hashtable env;

    JNDIContext(Hashtable environment) throws NamingException {
        this.init(environment);
    }

    public JNDIContext() {
    }

    public JNDIContext(JNDIContext that) {
        this.tail = that.tail;
        this.server = that.server;
        this.client = that.client;
        this.env = (Hashtable)that.env.clone();
    }

    public void init(Hashtable environment) throws NamingException {
    }

    private JNDIResponse request(JNDIRequest req) throws Exception {
        return (JNDIResponse)Client.request(req, new JNDIResponse(), this.server);
    }

    public static void print(String s) {
    }

    public static void println(String s) {
    }

    protected AuthenticationResponse requestAuthorization(AuthenticationRequest req) throws RemoteException {
        return (AuthenticationResponse)Client.request(req, new AuthenticationResponse(), this.server);
    }

    /*
     * WARNING - void declaration
     */
    public Context getInitialContext(Hashtable environment) throws NamingException {
        URL url;
        if (environment == null) {
            throw new NamingException("Invalid Argument, hashtable cannot be null.");
        }
        this.env = (Hashtable)environment.clone();
        String userID = (String)this.env.get("java.naming.security.principal");
        String psswrd = (String)this.env.get("java.naming.security.credentials");
        Object serverURL = this.env.get("java.naming.provider.url");
        if (serverURL == null) {
            serverURL = "localhost:4201";
        }
        if (userID == null) {
            userID = "anonymous";
        }
        if (psswrd == null) {
            psswrd = "anon";
        }
        if (serverURL instanceof String) {
            try {
                url = new URL("http://" + serverURL);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ConfigurationException("Invalid provider URL: " + serverURL);
            }
        } else if (serverURL instanceof URL) {
            url = (URL)serverURL;
        } else {
            throw new ConfigurationException("Invalid provider URL: " + serverURL);
        }
        try {
            void var5_5;
            this.server = new ServerMetaData();
            this.server.address = InetAddress.getByName(var5_5.getHost());
            this.server.port = var5_5.getPort();
        }
        catch (UnknownHostException e) {
            throw new ConfigurationException("Invalid provider URL:" + serverURL + ": host unkown: " + e.getMessage());
        }
        this.authenticate(userID, psswrd);
        return this;
    }

    public void authenticate(String userID, String psswrd) throws AuthenticationException {
        AuthenticationRequest req = new AuthenticationRequest(userID, psswrd);
        AuthenticationResponse res = null;
        try {
            res = this.requestAuthorization(req);
        }
        catch (RemoteException e) {
            throw new AuthenticationException(e.getLocalizedMessage());
        }
        switch (res.getResponseCode()) {
            case 1: {
                this.client = res.getIdentity();
                break;
            }
            case 2: {
                this.client = res.getIdentity();
                this.server = res.getServer();
                break;
            }
            case 3: {
                throw new AuthenticationException("This principle is not authorized.");
            }
        }
    }

    public EJBHomeProxy createEJBHomeProxy(EJBMetaDataImpl ejbData) {
        EJBHomeProxy proxy;
        EJBHomeHandler handler = EJBHomeHandler.createEJBHomeHandler(ejbData, this.server, this.client);
        handler.ejb.ejbHomeProxy = proxy = handler.createEJBHomeProxy();
        return proxy;
    }

    public Object lookup(String name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("The name cannot be null");
        }
        if (name.equals("")) {
            return new JNDIContext(this);
        }
        if (!name.startsWith("/")) {
            name = this.tail + name;
        }
        JNDIRequest req = new JNDIRequest();
        req.setRequestMethod(27);
        req.setRequestString(name);
        JNDIResponse res = null;
        try {
            res = this.request(req);
        }
        catch (Exception e) {
            throw new NamingException("Cannot lookup " + name + ": Received error: " + e.getMessage());
        }
        switch (res.getResponseCode()) {
            case 13: {
                return this.createEJBHomeProxy((EJBMetaDataImpl)res.getResult());
            }
            case 12: {
                return res.getResult();
            }
            case 14: {
                JNDIContext subCtx = new JNDIContext(this);
                if (!name.endsWith("/")) {
                    name = name + '/';
                }
                subCtx.tail = name;
                return subCtx;
            }
            case 16: {
                throw new NameNotFoundException(name + " not found");
            }
            case 17: {
                throw (NamingException)res.getResult();
            }
            case 18: {
                throw (RuntimeException)res.getResult();
            }
            case 19: {
                throw (Error)res.getResult();
            }
        }
        throw new RuntimeException("Invalid response from server :" + res.getResponseCode());
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public NamingEnumeration list(String name) throws NamingException {
        throw new NamingException("TODO: Needs to be implemented");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        throw new NamingException("TODO: Needs to be implemented");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public NameParser getNameParser(String name) throws NamingException {
        throw new NamingException("TODO: Needs to be implemented");
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public String composeName(String name, String prefix) throws NamingException {
        throw new NamingException("TODO: Needs to be implemented");
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new NamingException("TODO: Needs to be implemented");
    }

    public Object addToEnvironment(String key, Object value) throws NamingException {
        return this.env.put(key, value);
    }

    public Object removeFromEnvironment(String key) throws NamingException {
        return this.env.remove(key);
    }

    public Hashtable getEnvironment() throws NamingException {
        return (Hashtable)this.env.clone();
    }

    public String getNameInNamespace() throws NamingException {
        return "";
    }

    public void close() throws NamingException {
    }

    public void bind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    public void unbind(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void rename(String oldname, String newname) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rename(Name oldname, Name newname) throws NamingException {
        this.rename(oldname.toString(), newname.toString());
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }
}

