/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ServerMetaData
implements Externalizable {
    transient int port;
    transient InetAddress address;

    public ServerMetaData() {
    }

    public ServerMetaData(String host, int port) throws UnknownHostException {
        this.address = InetAddress.getByName(host);
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        StringBuffer IP = new StringBuffer(15);
        IP.append(in.readByte()).append('.');
        IP.append(in.readByte()).append('.');
        IP.append(in.readByte()).append('.');
        IP.append(in.readByte());
        try {
            this.address = InetAddress.getByName(IP.toString());
        }
        catch (UnknownHostException e) {
            throw new IOException("Cannot read in the host address " + IP + ": The host is unknown");
        }
        this.port = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] addr = this.address.getAddress();
        out.writeByte(addr[0]);
        out.writeByte(addr[1]);
        out.writeByte(addr[2]);
        out.writeByte(addr[3]);
        out.writeInt(this.port);
    }
}

