/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.net.Socket;
import java.util.Properties;
import org.openejb.client.Connection;
import org.openejb.client.ConnectionFactory;
import org.openejb.client.ServerMetaData;

public class SocketConnectionFactory
implements ConnectionFactory {
    public void init(Properties props) {
    }

    public Connection getConnection(ServerMetaData server) throws IOException {
        SocketConnection conn = new SocketConnection();
        conn.open(server);
        return conn;
    }

    class SocketConnection
    implements Connection {
        Socket socket = null;
        OutputStream socketOut = null;
        InputStream socketIn = null;

        SocketConnection() {
        }

        protected void open(ServerMetaData server) throws IOException {
            try {
                this.socket = new Socket(server.address, server.port);
            }
            catch (IOException e) {
                throw new IOException("Cannot access server: " + server.address + ":" + server.port + " Exception: " + e.getClass().getName() + " : " + e.getMessage());
            }
            catch (SecurityException e) {
                throw new IOException("Cannot access server: " + server.address + ":" + server.port + " due to security restrictions in the current VM: " + e.getClass().getName() + " : " + e.getMessage());
            }
            catch (Throwable e) {
                throw new IOException("Cannot access server: " + server.address + ":" + server.port + " due to an unkown exception in the OpenEJB client: " + e.getClass().getName() + " : " + e.getMessage());
            }
        }

        public void close() throws IOException {
            try {
                if (this.socketOut != null) {
                    this.socketOut.close();
                }
                if (this.socketIn != null) {
                    this.socketIn.close();
                }
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (Throwable t) {
                throw new IOException("Error closing connection with server: " + t.getMessage());
            }
        }

        public InputStream getInputStream() throws IOException {
            try {
                this.socketIn = this.socket.getInputStream();
            }
            catch (StreamCorruptedException e) {
                throw new IOException("Cannot open input stream to server, the stream has been corrupted: " + e.getClass().getName() + " : " + e.getMessage());
            }
            catch (IOException e) {
                throw new IOException("Cannot open input stream to server: " + e.getClass().getName() + " : " + e.getMessage());
            }
            catch (Throwable e) {
                throw new IOException("Cannot open output stream to server: " + e.getClass().getName() + " : " + e.getMessage());
            }
            return this.socketIn;
        }

        public OutputStream getOuputStream() throws IOException {
            try {
                this.socketOut = this.socket.getOutputStream();
            }
            catch (IOException e) {
                throw new IOException("Cannot open output stream to server: " + e.getClass().getName() + " : " + e.getMessage());
            }
            catch (Throwable e) {
                throw new IOException("Cannot open output stream to server: " + e.getClass().getName() + " : " + e.getMessage());
            }
            return this.socketOut;
        }
    }
}

