/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.client;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import org.openejb.client.ClientMetaData;
import org.openejb.client.EJBHomeHandler;
import org.openejb.client.EJBMetaDataImpl;
import org.openejb.client.EJBObjectHandle;
import org.openejb.client.EJBObjectHandler;
import org.openejb.client.EJBRequest;
import org.openejb.client.EJBResponse;
import org.openejb.client.ServerMetaData;

public class StatefulEJBHomeHandler
extends EJBHomeHandler {
    public StatefulEJBHomeHandler() {
    }

    public StatefulEJBHomeHandler(EJBMetaDataImpl ejb, ServerMetaData server, ClientMetaData client) {
        super(ejb, server, client);
    }

    protected Object findX(Method method, Object[] args, Object proxy) throws Throwable {
        throw new UnsupportedOperationException("Stateful beans may not have find methods");
    }

    protected Object removeByPrimaryKey(Method method, Object[] args, Object proxy) throws Throwable {
        throw new RemoteException("Session objects are private resources and do not have primary keys");
    }

    protected Object removeWithHandle(Method method, Object[] args, Object proxy) throws Throwable {
        EJBObjectHandle handle = (EJBObjectHandle)args[0];
        if (handle == null) {
            throw new NullPointerException("The handle is null");
        }
        EJBObjectHandler handler = handle.handler;
        Object primKey = handler.primaryKey;
        if (!handler.ejb.deploymentID.equals(this.ejb.deploymentID)) {
            throw new IllegalArgumentException("The handle is not from the same deployment");
        }
        EJBRequest req = new EJBRequest(3);
        req.setClientIdentity(this.client.getClientIdentity());
        req.setDeploymentCode(handler.ejb.deploymentCode);
        req.setDeploymentId(handler.ejb.deploymentID);
        req.setMethodInstance(method);
        req.setMethodParameters(args);
        req.setPrimaryKey(primKey);
        EJBResponse res = this.request(req);
        if (res.getResponseCode() == 11) {
            throw (Throwable)res.getResult();
        }
        StatefulEJBHomeHandler.invalidateAllHandlers(handler.getRegistryId());
        handler.invalidateReference();
        return null;
    }
}

