/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.client;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import org.openejb.client.ClientMetaData;
import org.openejb.client.EJBMetaDataImpl;
import org.openejb.client.EJBObjectHandler;
import org.openejb.client.EJBObjectProxy;
import org.openejb.client.EJBRequest;
import org.openejb.client.EJBResponse;
import org.openejb.client.ServerMetaData;

public class StatefulEJBObjectHandler
extends EJBObjectHandler {
    public StatefulEJBObjectHandler() {
    }

    public StatefulEJBObjectHandler(EJBMetaDataImpl ejb, ServerMetaData server, ClientMetaData client) {
        super(ejb, server, client);
    }

    public StatefulEJBObjectHandler(EJBMetaDataImpl ejb, ServerMetaData server, ClientMetaData client, Object primaryKey) {
        super(ejb, server, client, primaryKey);
        StatefulEJBObjectHandler.registerHandler(primaryKey, this);
    }

    public Object getRegistryId() {
        return this.primaryKey;
    }

    protected Object getPrimaryKey(Method method, Object[] args, Object proxy) throws Throwable {
        throw new RemoteException("Session objects are private resources and do not have primary keys");
    }

    protected Object isIdentical(Method method, Object[] args, Object proxy) throws Throwable {
        if (args[0] == null) {
            return Boolean.FALSE;
        }
        EJBObjectProxy ejbObject = (EJBObjectProxy)args[0];
        EJBObjectHandler that = ejbObject.getEJBObjectHandler();
        return new Boolean(this.primaryKey.equals(that.primaryKey));
    }

    protected Object remove(Method method, Object[] args, Object proxy) throws Throwable {
        EJBRequest req = new EJBRequest(18);
        req.setClientIdentity(this.client.getClientIdentity());
        req.setDeploymentCode(this.ejb.deploymentCode);
        req.setDeploymentId(this.ejb.deploymentID);
        req.setMethodInstance(method);
        req.setMethodParameters(args);
        req.setPrimaryKey(this.primaryKey);
        EJBResponse res = this.request(req);
        if (res.getResponseCode() == 11) {
            throw (Throwable)res.getResult();
        }
        StatefulEJBObjectHandler.invalidateAllHandlers(this.getRegistryId());
        this.invalidateReference();
        return null;
    }
}

